/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class HugeEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private final E[] enums;
    private long[] bits;
    private int size;
    private static final int BIT_IN_LONG = 64;
    private int bitsIndex;
    private int elementInBits;
    private long oldBits;

    HugeEnumSet(Class<E> clazz) {
        super(clazz);
        this.enums = (Enum[])clazz.getEnumConstants();
        this.bits = new long[(this.enums.length + 64 - 1) / 64];
        Arrays.fill(this.bits, 0L);
    }

    @Override
    public boolean add(E e) {
        if (!this.isValidType(((Enum)e).getDeclaringClass())) {
            throw new ClassCastException();
        }
        this.calculateElementIndex(e);
        int n = this.bitsIndex;
        this.bits[n] = this.bits[n] | 1L << this.elementInBits;
        if (this.oldBits == this.bits[this.bitsIndex]) {
            return false;
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (0 == collection.size() || this == collection) {
            return false;
        }
        if (collection instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)collection;
            if (!this.isValidType(enumSet.elementClass)) {
                throw new ClassCastException();
            }
            HugeEnumSet hugeEnumSet = (HugeEnumSet)enumSet;
            boolean bl = false;
            for (int i = 0; i < this.bits.length; ++i) {
                this.oldBits = this.bits[i];
                int n = i;
                this.bits[n] = this.bits[n] | hugeEnumSet.bits[i];
                if (this.oldBits == this.bits[i]) continue;
                bl = true;
                this.size = this.size - Long.bitCount(this.oldBits) + Long.bitCount(this.bits[i]);
            }
            return bl;
        }
        return super.addAll(collection);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.bits, 0L);
        this.size = 0;
    }

    @Override
    protected void complement() {
        if (0 != this.enums.length) {
            this.bitsIndex = this.enums.length / 64;
            this.size = 0;
            int n = 0;
            for (int i = 0; i <= this.bitsIndex; ++i) {
                this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
                n = Long.bitCount(this.bits[i]);
                this.size += n;
            }
            int n2 = this.bitsIndex;
            this.bits[n2] = this.bits[n2] & -1L >>> 64 - this.enums.length % 64;
            this.size -= n;
            n = Long.bitCount(this.bits[this.bitsIndex]);
            this.size += n;
        }
    }

    @Override
    public boolean contains(Object object) {
        if (null == object) {
            return false;
        }
        if (!this.isValidType(object.getClass())) {
            return false;
        }
        this.calculateElementIndex((Enum)object);
        return (this.bits[this.bitsIndex] & 1L << this.elementInBits) != 0L;
    }

    @Override
    public HugeEnumSet<E> clone() {
        Object object = super.clone();
        if (null != object) {
            ((HugeEnumSet)object).bits = (long[])this.bits.clone();
            return (HugeEnumSet)object;
        }
        return null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.size() == 0) {
            return true;
        }
        if (collection instanceof HugeEnumSet) {
            HugeEnumSet hugeEnumSet = (HugeEnumSet)collection;
            if (this.isValidType(hugeEnumSet.elementClass)) {
                for (int i = 0; i < this.bits.length; ++i) {
                    if ((this.bits[i] & hugeEnumSet.bits[i]) == hugeEnumSet.bits[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return !(collection instanceof EnumSet) && super.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!this.isValidType(object.getClass())) {
            return super.equals(object);
        }
        return Arrays.equals(this.bits, ((HugeEnumSet)object).bits);
    }

    @Override
    public Iterator<E> iterator() {
        return new HugeEnumSetIterator();
    }

    @Override
    public boolean remove(Object object) {
        if (!this.contains(object)) {
            return false;
        }
        int n = this.bitsIndex;
        this.bits[n] = this.bits[n] - (1L << this.elementInBits);
        --this.size;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (0 == collection.size()) {
            return false;
        }
        if (collection instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)collection;
            if (!this.isValidType(enumSet.elementClass)) {
                return false;
            }
            boolean bl = false;
            long l = 0L;
            for (int i = 0; i < this.bits.length; ++i) {
                this.oldBits = this.bits[i];
                l = this.bits[i] & ((HugeEnumSet)enumSet).bits[i];
                if (l == 0L) continue;
                int n = i;
                this.bits[n] = this.bits[n] - l;
                this.size = this.size - Long.bitCount(this.oldBits) + Long.bitCount(this.bits[i]);
                bl = true;
            }
            return bl;
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)collection;
            if (!this.isValidType(enumSet.elementClass)) {
                this.clear();
                return true;
            }
            boolean bl = false;
            this.oldBits = 0L;
            for (int i = 0; i < this.bits.length; ++i) {
                this.oldBits = this.bits[i];
                int n = i;
                this.bits[n] = this.bits[n] & ((HugeEnumSet)enumSet).bits[i];
                if (this.oldBits == this.bits[i]) continue;
                this.size = this.size - Long.bitCount(this.oldBits) + Long.bitCount(this.bits[i]);
                bl = true;
            }
            return bl;
        }
        return super.retainAll(collection);
    }

    @Override
    void setRange(E e, E e2) {
        this.calculateElementIndex(e);
        int n = this.bitsIndex;
        int n2 = this.elementInBits;
        this.calculateElementIndex(e2);
        int n3 = this.bitsIndex;
        int n4 = this.elementInBits;
        long l = 0L;
        if (n == n3) {
            l = -1L >>> 64 - (n4 - n2 + 1) << n2;
            this.size -= Long.bitCount(this.bits[this.bitsIndex]);
            int n5 = this.bitsIndex;
            this.bits[n5] = this.bits[n5] | l;
            this.size += Long.bitCount(this.bits[this.bitsIndex]);
        } else {
            l = -1L >>> n2 << n2;
            this.size -= Long.bitCount(this.bits[n]);
            int n6 = n;
            this.bits[n6] = this.bits[n6] | l;
            this.size += Long.bitCount(this.bits[n]);
            l = -1L >>> 64 - (n4 + 1) << 63 - n4;
            this.size -= Long.bitCount(this.bits[n3]);
            int n7 = n3;
            this.bits[n7] = this.bits[n7] | l;
            this.size += Long.bitCount(this.bits[n3]);
            for (int i = n + 1; i <= n3 - 1; ++i) {
                this.size -= Long.bitCount(this.bits[i]);
                this.bits[i] = -1L;
                this.size += Long.bitCount(this.bits[i]);
            }
        }
    }

    private void calculateElementIndex(E e) {
        int n = ((Enum)e).ordinal();
        this.bitsIndex = n / 64;
        this.elementInBits = n % 64;
        this.oldBits = this.bits[this.bitsIndex];
    }

    private class HugeEnumSetIterator
    implements Iterator<E> {
        private long[] unProcessedBits;
        private int bitsPosition = 0;
        private long currentElementMask = 0L;
        boolean canProcess = true;

        private HugeEnumSetIterator() {
            this.unProcessedBits = new long[HugeEnumSet.this.bits.length];
            System.arraycopy(HugeEnumSet.this.bits, 0, this.unProcessedBits, 0, HugeEnumSet.this.bits.length);
            this.bitsPosition = this.unProcessedBits.length;
            this.findNextNoneZeroPosition(0);
            if (this.bitsPosition == this.unProcessedBits.length) {
                this.canProcess = false;
            }
        }

        private void findNextNoneZeroPosition(int n) {
            for (int i = n; i < this.unProcessedBits.length; ++i) {
                if (0L == HugeEnumSet.this.bits[i]) continue;
                this.bitsPosition = i;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.canProcess;
        }

        @Override
        public E next() {
            if (!this.canProcess) {
                throw new NoSuchElementException();
            }
            this.currentElementMask = this.unProcessedBits[this.bitsPosition] & -this.unProcessedBits[this.bitsPosition];
            int n = this.bitsPosition;
            this.unProcessedBits[n] = this.unProcessedBits[n] - this.currentElementMask;
            int n2 = Long.numberOfTrailingZeros(this.currentElementMask) % 64 + this.bitsPosition * 64;
            if (0L == this.unProcessedBits[this.bitsPosition]) {
                int n3 = this.bitsPosition;
                this.findNextNoneZeroPosition(this.bitsPosition + 1);
                if (this.bitsPosition == n3) {
                    this.canProcess = false;
                }
            }
            return HugeEnumSet.this.enums[n2];
        }

        @Override
        public void remove() {
            if (this.currentElementMask == 0L) {
                throw new IllegalStateException();
            }
            long[] lArray = HugeEnumSet.this.bits;
            int n = this.bitsPosition;
            lArray[n] = lArray[n] & (this.currentElementMask ^ 0xFFFFFFFFFFFFFFFFL);
            HugeEnumSet.this.size--;
            this.currentElementMask = 0L;
        }
    }
}

