/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 362498820763181265L;
    transient int elementCount;
    transient Entry<K, V>[] elementData;
    final float loadFactor;
    int threshold;
    transient int modCount = 0;
    private transient V[] cache;
    private static final int CACHE_BIT_SIZE = 15;
    private static final int DEFAULT_SIZE = 16;

    Entry<K, V>[] newElementArray(int n) {
        return new Entry[n];
    }

    public HashMap() {
        this(16);
    }

    public HashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        n = HashMap.calculateCapacity(n);
        this.elementCount = 0;
        this.elementData = this.newElementArray(n);
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    private static final int calculateCapacity(int n) {
        if (n >= 0x40000000) {
            return 0x40000000;
        }
        if (n == 0) {
            return 16;
        }
        if (n == 1) {
            return 2;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public HashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        n = HashMap.calculateCapacity(n);
        this.elementCount = 0;
        this.elementData = this.newElementArray(n == 0 ? 1 : n);
        this.loadFactor = f;
        this.computeMaxSize();
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        super.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
            this.cache = null;
        }
    }

    @Override
    public Object clone() {
        try {
            HashMap hashMap = (HashMap)super.clone();
            hashMap.elementCount = 0;
            hashMap.elementData = this.newElementArray(this.elementData.length);
            for (int i = 0; i < this.elementData.length; ++i) {
                Entry<K, V> entry = this.elementData[i];
                if (entry == null) continue;
                hashMap.putImpl(entry.getKey(), entry.getValue());
                while (entry.next != null) {
                    entry = entry.next;
                    hashMap.putImpl(entry.getKey(), entry.getValue());
                }
            }
            return hashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        return entry != null;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object != null) {
            int n = this.elementData.length;
            while (--n >= 0) {
                Entry<K, V> entry = this.elementData[n];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int n = this.elementData.length;
            while (--n >= 0) {
                Entry<K, V> entry = this.elementData[n];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new HashMapEntrySet(this);
    }

    @Override
    public V get(Object object) {
        int n;
        if (object != null && this.cache != null && object instanceof Integer && (n = ((Integer)object).intValue()) >> 15 == 0) {
            return this.cache[n];
        }
        Entry<K, V> entry = this.getEntry(object);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    final Entry<K, V> getEntry(Object object) {
        Entry<K, V> entry;
        if (object == null) {
            entry = this.findNullKeyEntry();
        } else {
            int n = object.hashCode();
            int n2 = n & this.elementData.length - 1;
            entry = this.findNonNullKeyEntry(object, n2, n);
        }
        return entry;
    }

    final Entry<K, V> findNonNullKeyEntry(Object object, int n, int n2) {
        Entry<K, V> entry = this.elementData[n];
        if (object instanceof Integer) {
            int n3 = n2 | 1;
            while (entry != null && entry.storedKeyHash != n3) {
                entry = entry.next;
            }
        } else {
            int n4 = n2 & 0xFFFFFFFE;
            while (!(entry == null || entry.storedKeyHash == n4 && object.equals(entry.key))) {
                entry = entry.next;
            }
        }
        return entry;
    }

    final Entry<K, V> findNullKeyEntry() {
        Entry<K, V> entry = this.elementData[0];
        while (entry != null && entry.key != null) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return HashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return HashMap.this.size();
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public boolean remove(Object object) {
                    Entry entry = HashMap.this.removeEntry(object);
                    return entry != null;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator(HashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public V put(K k, V v) {
        return this.putImpl(k, v);
    }

    V putImpl(K k, V v) {
        Entry<Object, V> entry;
        if (k == null) {
            entry = this.findNullKeyEntry();
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
                entry = this.createHashedEntry(null, 0, 0);
            }
        } else {
            int n = k.hashCode();
            int n2 = n & this.elementData.length - 1;
            entry = this.findNonNullKeyEntry(k, n2, n);
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    n2 = n & this.elementData.length - 1;
                }
                entry = this.createHashedEntry(k, n2, n);
            }
            if (this.cache != null && n >> 15 == 0 && k instanceof Integer) {
                this.cache[n] = v;
            }
        }
        Object object = entry.value;
        entry.value = v;
        return (V)object;
    }

    Entry<K, V> createEntry(K k, int n, V v) {
        Entry<K, V> entry = new Entry<K, V>(k, v);
        entry.next = this.elementData[n];
        this.elementData[n] = entry;
        return entry;
    }

    Entry<K, V> createHashedEntry(K k, int n, int n2) {
        Entry<K, int> entry = new Entry<K, int>(k, n2);
        entry.next = this.elementData[n];
        this.elementData[n] = entry;
        return entry;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.putAllImpl(map);
        }
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        int n = this.elementCount + map.size();
        if (n > this.threshold) {
            this.rehash(n);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    void rehash(int n) {
        int n2 = HashMap.calculateCapacity(n == 0 ? 1 : n << 1);
        Entry<K, V>[] entryArray = this.newElementArray(n2);
        for (int i = 0; i < this.elementData.length; ++i) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                int n3 = i & 1 | entry.storedKeyHash & 0xFFFFFFFE;
                int n4 = n3 & n2 - 1;
                Entry entry2 = entry.next;
                entry.next = entryArray[n4];
                entryArray[n4] = entry;
                entry = entry2;
            }
        }
        this.elementData = entryArray;
        this.computeMaxSize();
        if (this.cache == null && this.elementCount > 128) {
            this.analyzeMap();
        }
    }

    private void analyzeMap() {
        int n = 0;
        int n2 = this.elementCount - (this.elementCount >> 3);
        for (K object : this.keySet()) {
            if (!(object instanceof Integer) || (Integer)object >> 15 != 0) continue;
            ++n;
        }
        if (n >= n2) {
            this.cache = new Object[32768];
            for (Map.Entry entry : this.entrySet()) {
                if (!(entry.getKey() instanceof Integer) || (Integer)entry.getKey() >> 15 != 0) continue;
                this.cache[((Integer)entry.getKey()).intValue()] = entry.getValue();
            }
        }
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.removeEntry(object);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    final Entry<K, V> removeEntry(Object object) {
        Entry<K, V> entry;
        int n = 0;
        Entry<K, V> entry2 = null;
        if (object != null) {
            int n2 = object.hashCode();
            n = n2 & this.elementData.length - 1;
            entry = this.elementData[n];
            if (object instanceof Integer) {
                if (this.cache != null && n2 >> 15 == 0) {
                    this.cache[n2] = null;
                }
                int n3 = n2 | 1;
                while (entry != null && entry.storedKeyHash != n3) {
                    entry2 = entry;
                    entry = entry.next;
                }
            } else {
                int n4 = n2 & 0xFFFFFFFE;
                while (!(entry == null || entry.storedKeyHash == n4 && object.equals(entry.key))) {
                    entry2 = entry;
                    entry = entry.next;
                }
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && entry.key != null) {
                entry2 = entry;
                entry = entry.next;
            }
        }
        if (entry == null) {
            return null;
        }
        if (entry2 == null) {
            this.elementData[n] = entry.next;
        } else {
            entry2.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return HashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return HashMap.this.size();
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator(HashMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        objectOutputStream.writeInt(this.elementCount);
        for (Entry entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
            Entry entry2 = entry.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = this.newElementArray(n);
        int n2 = this.elementCount = objectInputStream.readInt();
        while (--n2 >= 0) {
            Object object = objectInputStream.readObject();
            int n3 = null == object ? 0 : object.hashCode() & n - 1;
            this.createEntry(object, n3, objectInputStream.readObject());
        }
    }

    static class HashMapEntrySet<KT, VT>
    extends AbstractSet<Map.Entry<KT, VT>> {
        private final HashMap<KT, VT> associatedMap;

        public HashMapEntrySet(HashMap<KT, VT> hashMap) {
            this.associatedMap = hashMap;
        }

        HashMap<KT, VT> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.elementCount;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            Map.Entry entry;
            Entry<KT, VT> entry2;
            if (object instanceof Map.Entry && HashMapEntrySet.valuesEq(entry2 = this.associatedMap.getEntry((entry = (Map.Entry)object).getKey()), entry)) {
                this.associatedMap.removeEntry(entry2.key);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Entry<KT, VT> entry2 = this.associatedMap.getEntry(entry.getKey());
                return HashMapEntrySet.valuesEq(entry2, entry);
            }
            return false;
        }

        private static boolean valuesEq(Entry<?, ?> entry, Map.Entry<?, ?> entry2) {
            return entry != null && (entry.value == null ? entry2.getValue() == null : entry.value.equals(entry2.getValue()));
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new EntryIterator<KT, VT>(this.associatedMap);
        }
    }

    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        ValueIterator(HashMap<K, V> hashMap) {
            super(hashMap);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        KeyIterator(HashMap<K, V> hashMap) {
            super(hashMap);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(HashMap<K, V> hashMap) {
            super(hashMap);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private static class AbstractMapIterator<K, V> {
        private int position = 0;
        int expectedModCount;
        Entry<K, V> futureEntry;
        Entry<K, V> currentEntry;
        Entry<K, V> prevEntry;
        final HashMap<K, V> associatedMap;

        AbstractMapIterator(HashMap<K, V> hashMap) {
            this.associatedMap = hashMap;
            this.expectedModCount = hashMap.modCount;
            this.futureEntry = null;
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            int n;
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            if (((HashMap)this.associatedMap).cache != null && this.currentEntry.key instanceof Integer && (n = ((Integer)this.currentEntry.key).intValue()) >> 15 == 0) {
                ((HashMap)this.associatedMap).cache[n] = null;
            }
            if (this.prevEntry == null) {
                n = this.currentEntry.storedKeyHash & this.associatedMap.elementData.length - 1;
                if (this.associatedMap.elementData[n &= 0xFFFFFFFE] == this.currentEntry) {
                    this.associatedMap.elementData[n] = this.associatedMap.elementData[n].next;
                } else {
                    this.associatedMap.elementData[n |= 1] = this.associatedMap.elementData[n].next;
                }
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }

    static class Entry<K, V>
    extends MapEntry<K, V> {
        final int storedKeyHash;
        Entry<K, V> next;

        Entry(K k, int n) {
            super(k, null);
            this.storedKeyHash = k instanceof Integer ? n | 1 : n & 0xFFFFFFFE;
        }

        Entry(K k, V v) {
            super(k, v);
            this.storedKeyHash = k == null ? 0 : (k instanceof Integer ? k.hashCode() | 1 : k.hashCode() & 0xFFFFFFFE);
        }

        @Override
        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }
    }
}

