/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractSequentialList<E>
extends AbstractList<E> {
    protected AbstractSequentialList() {
    }

    @Override
    public void add(int n, E e) {
        this.listIterator(n).add(e);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        ListIterator<E> listIterator = this.listIterator(n);
        Iterator<E> iterator = collection.iterator();
        int n2 = listIterator.nextIndex();
        while (iterator.hasNext()) {
            listIterator.add(iterator.next());
        }
        return n2 != listIterator.nextIndex();
    }

    @Override
    public E get(int n) {
        try {
            return this.listIterator(n).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public abstract ListIterator<E> listIterator(int var1);

    @Override
    public E remove(int n) {
        try {
            ListIterator<E> listIterator = this.listIterator(n);
            E e = listIterator.next();
            listIterator.remove();
            return e;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public E set(int n, E e) {
        ListIterator<E> listIterator = this.listIterator(n);
        if (!listIterator.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        E e2 = listIterator.next();
        listIterator.set(e);
        return e2;
    }
}

