/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbApReq;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.APRep;
import com.ibm.security.krb5.internal.EncAPRepPart;
import com.ibm.security.krb5.internal.KRBError;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.LocalSeqNumber;
import com.ibm.security.krb5.internal.SeqNumber;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class KrbApRep {
    private byte[] b;
    private EncAPRepPart c;
    private APRep d;

    public KrbApRep(KrbApReq krbApReq, boolean bl, boolean bl2) throws KrbException, IOException {
        EncryptionKey encryptionKey = bl2 ? new EncryptionKey(krbApReq.getCreds().getSessionKey()) : null;
        LocalSeqNumber localSeqNumber = new LocalSeqNumber();
        this.b(krbApReq, encryptionKey, localSeqNumber);
    }

    public KrbApRep(KrbApReq krbApReq, EncryptionKey encryptionKey, boolean bl) throws KrbException, IOException {
        LocalSeqNumber localSeqNumber = null;
        if (bl) {
            localSeqNumber = new LocalSeqNumber();
        }
        if (encryptionKey == null) {
            encryptionKey = krbApReq.getCreds().getSessionKey();
        }
        this.b(krbApReq, encryptionKey, localSeqNumber);
    }

    public KrbApRep(byte[] byArray, Credentials credentials, KrbApReq krbApReq) throws KrbException, IOException {
        this(byArray, credentials);
        this.b(krbApReq);
    }

    public KrbApRep(DerValue derValue, Credentials credentials, KrbApReq krbApReq) throws KrbException, IOException {
        this(derValue, credentials);
        this.b(krbApReq);
    }

    void b(KrbApReq krbApReq, EncryptionKey encryptionKey, SeqNumber seqNumber) throws KrbException, IOException {
        this.b(krbApReq.getCreds().e, krbApReq.c(), krbApReq.d(), encryptionKey, seqNumber);
        this.b = this.d.asn1Encode();
    }

    KrbApRep(byte[] byArray, Credentials credentials) throws KrbException, IOException {
        this(new DerValue(byArray), credentials);
    }

    KrbApRep(DerValue derValue, Credentials credentials) throws KrbException, IOException {
        APRep aPRep = null;
        try {
            aPRep = new APRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            aPRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.eText.charAt(kRBError.eText.length() - 1) == '\u0000' ? kRBError.eText.substring(0, kRBError.eText.length() - 1) : kRBError.eText;
            throw new KrbException(kRBError.errorCode, string, true);
        }
        byte[] byArray = null;
        if (aPRep.encPart.isDesEncType()) {
            byte[] byArray2 = aPRep.encPart.decrypt(credentials.e, 12);
            byArray = aPRep.encPart.reset(byArray2, true);
        } else if (aPRep.encPart.isAES128EncType()) {
            byte[] byArray3 = aPRep.encPart.decrypt(credentials.e, 12);
            byArray = aPRep.encPart.reset(byArray3, true);
        } else if (aPRep.encPart.isAES256EncType()) {
            byte[] byArray4 = aPRep.encPart.decrypt(credentials.e, 12);
            byArray = aPRep.encPart.reset(byArray4, true);
        } else {
            byArray = aPRep.encPart.decrypt(credentials.e, 12);
        }
        derValue = new DerValue(byArray);
        this.c = new EncAPRepPart(derValue);
    }

    void b(KrbApReq krbApReq) throws KrbException, IOException {
        if (this.c.getTime().getSeconds() != krbApReq.c().getSeconds() || this.c.getMicroSeconds() != krbApReq.c().getMicroSeconds()) {
            throw new KrbApErrException(46);
        }
    }

    public EncryptionKey getSubKey() {
        return this.c.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.c.getSeqNumber();
    }

    public byte[] getMessage() {
        return this.b;
    }

    private void b(EncryptionKey encryptionKey, KerberosTime kerberosTime, int n2, EncryptionKey encryptionKey2, SeqNumber seqNumber) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n3 = null;
        if (seqNumber != null) {
            n3 = new Integer(seqNumber.current());
        }
        this.c = new EncAPRepPart(kerberosTime, n2, encryptionKey2, n3);
        byte[] byArray = this.c.asn1Encode();
        EncryptedData encryptedData = null;
        encryptedData = EncryptedData.isDesEncType(encryptionKey.getEType()) ? new EncryptedData(encryptionKey, byArray, 12) : (EncryptedData.isAES128EncType(encryptionKey.getEType()) ? new EncryptedData(encryptionKey, byArray, 12) : (EncryptedData.isAES256EncType(encryptionKey.getEType()) ? new EncryptedData(encryptionKey, byArray, 12) : new EncryptedData(encryptionKey, byArray, 12)));
        this.d = new APRep(encryptedData);
    }
}

