/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.ccache.c;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;

public class HostAddresses
implements Cloneable {
    public HostAddress[] addresses;
    private static String[] a;

    public HostAddresses(HostAddress[] hostAddressArray) {
        this.addresses = hostAddressArray;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new HostAddress[1];
        this.addresses[0] = new HostAddress();
    }

    private HostAddresses(int n2) {
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException(a[6], null);
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            try {
                hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
                continue;
            }
            catch (Exception exception) {
                if (!Krb5Debug.on(9)) continue;
                Krb5Debug krb5Debug = new Krb5Debug(a[4] + Thread.currentThread().getName() + a[1]);
                krb5Debug.out(9, a[5]);
            }
        }
        this.addresses = hostAddressArray;
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new HostAddress[this.addresses.length];
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                hostAddresses.addresses[i2] = (HostAddress)this.addresses[i2].clone();
            }
        }
        return hostAddresses;
    }

    public boolean inList(HostAddress hostAddress) {
        if (this.addresses != null) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (!this.addresses[i2].equals(hostAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (this.addresses[i2].equals(hostAddresses.addresses[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector<HostAddress> vector = new Vector<HostAddress>();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new HostAddress(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new HostAddress[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                derOutputStream.write(this.addresses[i2].asn1Encode());
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }

    public void writeAddrs(c c2) throws IOException {
        c2.b(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            c2.c(this.addresses[i2].addrType);
            c2.b(this.addresses[i2].address.length);
            c2.write(this.addresses[i2].address, 0, this.addresses[i2].address.length);
        }
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            try {
                if (this.addresses[i2].addrType != 2 && this.addresses[i2].addrType != 23) continue;
                arrayList.add(this.addresses[i2].getInetAddress());
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        InetAddress[] inetAddressArray = new InetAddress[arrayList.size()];
        return arrayList.toArray(inetAddressArray);
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        Object object;
        String string = null;
        InetAddress[] inetAddressArray = null;
        HostAddresses hostAddresses = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
            HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
            for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
                hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
            }
            hostAddresses = new HostAddresses(hostAddressArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (Krb5Debug.on(9)) {
            object = new Krb5Debug(a[4] + Thread.currentThread().getName() + a[1]);
            ((Krb5Debug)object).out(9, a[2] + string + a[0]);
            for (int i3 = 0; i3 < inetAddressArray.length; ++i3) {
                ((Krb5Debug)object).out(9, a[3] + inetAddressArray[i3]);
            }
        }
        return hostAddresses;
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            this.addresses[i2] = new HostAddress(inetAddressArray[i2]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block153: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block152: {
                char[] cArray3;
                Object var0_2;
                block151: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    int n7;
                    block150: {
                        char[] cArray5;
                        Object var2;
                        block149: {
                            int n8;
                            int n9;
                            char[] cArray6;
                            block148: {
                                char[] cArray7;
                                block147: {
                                    int n10;
                                    int n11;
                                    char[] cArray8;
                                    block146: {
                                        char[] cArray9;
                                        block145: {
                                            int n12;
                                            int n13;
                                            char[] cArray10;
                                            block144: {
                                                char[] cArray11;
                                                block143: {
                                                    int n14;
                                                    int n15;
                                                    char[] cArray12;
                                                    block142: {
                                                        char[] cArray13;
                                                        block141: {
                                                            int n16;
                                                            int n17;
                                                            char[] cArray14;
                                                            block140: {
                                                                char[] cArray15;
                                                                block139: {
                                                                    int n18;
                                                                    int n19;
                                                                    char[] cArray16;
                                                                    block138: {
                                                                        char[] cArray17;
                                                                        block137: {
                                                                            int n20;
                                                                            int n21;
                                                                            char[] cArray18;
                                                                            block136: {
                                                                                char[] cArray19;
                                                                                block135: {
                                                                                    int n22;
                                                                                    int n23;
                                                                                    char[] cArray20;
                                                                                    block134: {
                                                                                        char[] cArray21;
                                                                                        block133: {
                                                                                            int n24;
                                                                                            int n25;
                                                                                            char[] cArray22;
                                                                                            block132: {
                                                                                                char[] cArray23;
                                                                                                block131: {
                                                                                                    int n26;
                                                                                                    int n27;
                                                                                                    char[] cArray24;
                                                                                                    block130: {
                                                                                                        char[] cArray25;
                                                                                                        block129: {
                                                                                                            int n28;
                                                                                                            int n29;
                                                                                                            char[] cArray26;
                                                                                                            block128: {
                                                                                                                char[] cArray27;
                                                                                                                block127: {
                                                                                                                    int n30;
                                                                                                                    int n31;
                                                                                                                    char[] cArray28;
                                                                                                                    block126: {
                                                                                                                        stringArray = new String[7];
                                                                                                                        var2 = null;
                                                                                                                        char[] cArray29 = "\u0010zo\u001d'\u0010".toCharArray();
                                                                                                                        n7 = 0;
                                                                                                                        int n32 = cArray29.length;
                                                                                                                        cArray28 = cArray29;
                                                                                                                        n31 = n32;
                                                                                                                        if (n32 <= 1) break block126;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n30 = n31;
                                                                                                                        if (n31 <= n7) break block127;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray30 = cArray28;
                                                                                                                        char[] cArray31 = cArray28;
                                                                                                                        int n33 = n7;
                                                                                                                        while (true) {
                                                                                                                            int n34;
                                                                                                                            char c2 = cArray30[n33];
                                                                                                                            switch (n7 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n34 = 114;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n34 = 96;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n34 = 119;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n34 = 30;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n34 = 1;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray30[n33] = (char)(c2 ^ n34);
                                                                                                                            ++n7;
                                                                                                                            cArray28 = cArray31;
                                                                                                                            n31 = n31;
                                                                                                                            if (n31 != 0) break;
                                                                                                                            cArray31 = cArray28;
                                                                                                                            n30 = n31;
                                                                                                                            n33 = n31;
                                                                                                                            cArray30 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n30 = n31;
                                                                                                                    } while (n31 > n7);
                                                                                                                }
                                                                                                                var0_2 = null;
                                                                                                                char[] cArray32 = new String(cArray27).intern().toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n35 = cArray32.length;
                                                                                                                cArray26 = cArray32;
                                                                                                                n29 = n35;
                                                                                                                if (n35 <= 1) break block128;
                                                                                                                cArray25 = cArray26;
                                                                                                                n28 = n29;
                                                                                                                if (n29 <= n4) break block129;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray33 = cArray26;
                                                                                                                char[] cArray34 = cArray26;
                                                                                                                int n36 = n4;
                                                                                                                while (true) {
                                                                                                                    int n37;
                                                                                                                    char c3 = cArray33[n36];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n37 = 66;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n37 = 123;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n37 = 106;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n37 = 102;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n37 = 28;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray33[n36] = (char)(c3 ^ n37);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray34;
                                                                                                                    n29 = n29;
                                                                                                                    if (n29 != 0) break;
                                                                                                                    cArray34 = cArray26;
                                                                                                                    n28 = n29;
                                                                                                                    n36 = n29;
                                                                                                                    cArray33 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n28 = n29;
                                                                                                            } while (n29 > n4);
                                                                                                        }
                                                                                                        stringArray[0] = new String(cArray25).intern();
                                                                                                        var2 = null;
                                                                                                        char[] cArray35 = "\n;".toCharArray();
                                                                                                        n7 = 0;
                                                                                                        int n38 = cArray35.length;
                                                                                                        cArray24 = cArray35;
                                                                                                        n27 = n38;
                                                                                                        if (n38 <= 1) break block130;
                                                                                                        cArray23 = cArray24;
                                                                                                        n26 = n27;
                                                                                                        if (n27 <= n7) break block131;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray36 = cArray24;
                                                                                                        char[] cArray37 = cArray24;
                                                                                                        int n39 = n7;
                                                                                                        while (true) {
                                                                                                            int n40;
                                                                                                            char c4 = cArray36[n39];
                                                                                                            switch (n7 % 5) {
                                                                                                                case 0: {
                                                                                                                    n40 = 114;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n40 = 96;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n40 = 119;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n40 = 30;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n40 = 1;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray36[n39] = (char)(c4 ^ n40);
                                                                                                            ++n7;
                                                                                                            cArray24 = cArray37;
                                                                                                            n27 = n27;
                                                                                                            if (n27 != 0) break;
                                                                                                            cArray37 = cArray24;
                                                                                                            n26 = n27;
                                                                                                            n39 = n27;
                                                                                                            cArray36 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n26 = n27;
                                                                                                    } while (n27 > n7);
                                                                                                }
                                                                                                var0_2 = null;
                                                                                                char[] cArray38 = new String(cArray23).intern().toCharArray();
                                                                                                n4 = 0;
                                                                                                int n41 = cArray38.length;
                                                                                                cArray22 = cArray38;
                                                                                                n25 = n41;
                                                                                                if (n41 <= 1) break block132;
                                                                                                cArray21 = cArray22;
                                                                                                n24 = n25;
                                                                                                if (n25 <= n4) break block133;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray39 = cArray22;
                                                                                                char[] cArray40 = cArray22;
                                                                                                int n42 = n4;
                                                                                                while (true) {
                                                                                                    int n43;
                                                                                                    char c5 = cArray39[n42];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n43 = 66;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n43 = 123;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n43 = 106;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n43 = 102;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n43 = 28;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray39[n42] = (char)(c5 ^ n43);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray40;
                                                                                                    n25 = n25;
                                                                                                    if (n25 != 0) break;
                                                                                                    cArray40 = cArray22;
                                                                                                    n24 = n25;
                                                                                                    n42 = n25;
                                                                                                    cArray39 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n24 = n25;
                                                                                            } while (n25 > n4);
                                                                                        }
                                                                                        stringArray[1] = new String(cArray21).intern();
                                                                                        var2 = null;
                                                                                        char[] cArray41 = "\u000e%#XVByV\u001c~b~lXq_x|\u0014=Q\u007fy\nxChx\u000b=VtoX".toCharArray();
                                                                                        n7 = 0;
                                                                                        int n44 = cArray41.length;
                                                                                        cArray20 = cArray41;
                                                                                        n23 = n44;
                                                                                        if (n44 <= 1) break block134;
                                                                                        cArray19 = cArray20;
                                                                                        n22 = n23;
                                                                                        if (n23 <= n7) break block135;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray42 = cArray20;
                                                                                        char[] cArray43 = cArray20;
                                                                                        int n45 = n7;
                                                                                        while (true) {
                                                                                            int n46;
                                                                                            char c6 = cArray42[n45];
                                                                                            switch (n7 % 5) {
                                                                                                case 0: {
                                                                                                    n46 = 114;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n46 = 96;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n46 = 119;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n46 = 30;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n46 = 1;
                                                                                                }
                                                                                            }
                                                                                            cArray42[n45] = (char)(c6 ^ n46);
                                                                                            ++n7;
                                                                                            cArray20 = cArray43;
                                                                                            n23 = n23;
                                                                                            if (n23 != 0) break;
                                                                                            cArray43 = cArray20;
                                                                                            n22 = n23;
                                                                                            n45 = n23;
                                                                                            cArray42 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n22 = n23;
                                                                                    } while (n23 > n7);
                                                                                }
                                                                                var0_2 = null;
                                                                                char[] cArray44 = new String(cArray19).intern().toCharArray();
                                                                                n4 = 0;
                                                                                int n47 = cArray44.length;
                                                                                cArray18 = cArray44;
                                                                                n21 = n47;
                                                                                if (n47 <= 1) break block136;
                                                                                cArray17 = cArray18;
                                                                                n20 = n21;
                                                                                if (n21 <= n4) break block137;
                                                                            }
                                                                            do {
                                                                                char[] cArray45 = cArray18;
                                                                                char[] cArray46 = cArray18;
                                                                                int n48 = n4;
                                                                                while (true) {
                                                                                    int n49;
                                                                                    char c7 = cArray45[n48];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n49 = 66;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n49 = 123;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n49 = 106;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n49 = 102;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n49 = 28;
                                                                                        }
                                                                                    }
                                                                                    cArray45[n48] = (char)(c7 ^ n49);
                                                                                    ++n4;
                                                                                    cArray18 = cArray46;
                                                                                    n21 = n21;
                                                                                    if (n21 != 0) break;
                                                                                    cArray46 = cArray18;
                                                                                    n20 = n21;
                                                                                    n48 = n21;
                                                                                    cArray45 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n20 = n21;
                                                                            } while (n21 > n4);
                                                                        }
                                                                        stringArray[2] = new String(cArray17).intern();
                                                                        var2 = null;
                                                                        char[] cArray47 = ":\u0012".toCharArray();
                                                                        n7 = 0;
                                                                        int n50 = cArray47.length;
                                                                        cArray16 = cArray47;
                                                                        n19 = n50;
                                                                        if (n50 <= 1) break block138;
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                        if (n19 <= n7) break block139;
                                                                    }
                                                                    do {
                                                                        char[] cArray48 = cArray16;
                                                                        char[] cArray49 = cArray16;
                                                                        int n51 = n7;
                                                                        while (true) {
                                                                            int n52;
                                                                            char c8 = cArray48[n51];
                                                                            switch (n7 % 5) {
                                                                                case 0: {
                                                                                    n52 = 114;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n52 = 96;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n52 = 119;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n52 = 30;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n52 = 1;
                                                                                }
                                                                            }
                                                                            cArray48[n51] = (char)(c8 ^ n52);
                                                                            ++n7;
                                                                            cArray16 = cArray49;
                                                                            n19 = n19;
                                                                            if (n19 != 0) break;
                                                                            cArray49 = cArray16;
                                                                            n18 = n19;
                                                                            n51 = n19;
                                                                            cArray48 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                    } while (n19 > n7);
                                                                }
                                                                var0_2 = null;
                                                                char[] cArray50 = new String(cArray15).intern().toCharArray();
                                                                n4 = 0;
                                                                int n53 = cArray50.length;
                                                                cArray14 = cArray50;
                                                                n17 = n53;
                                                                if (n53 <= 1) break block140;
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                                if (n17 <= n4) break block141;
                                                            }
                                                            do {
                                                                char[] cArray51 = cArray14;
                                                                char[] cArray52 = cArray14;
                                                                int n54 = n4;
                                                                while (true) {
                                                                    int n55;
                                                                    char c9 = cArray51[n54];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n55 = 66;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n55 = 123;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n55 = 106;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n55 = 102;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n55 = 28;
                                                                        }
                                                                    }
                                                                    cArray51[n54] = (char)(c9 ^ n55);
                                                                    ++n4;
                                                                    cArray14 = cArray52;
                                                                    n17 = n17;
                                                                    if (n17 != 0) break;
                                                                    cArray52 = cArray14;
                                                                    n16 = n17;
                                                                    n54 = n17;
                                                                    cArray51 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                            } while (n17 > n4);
                                                        }
                                                        stringArray[3] = new String(cArray13).intern();
                                                        var2 = null;
                                                        char[] cArray53 = "xtn\f\\T\u007fo\u001dnC~nB".toCharArray();
                                                        n7 = 0;
                                                        int n56 = cArray53.length;
                                                        cArray12 = cArray53;
                                                        n15 = n56;
                                                        if (n56 <= 1) break block142;
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                        if (n15 <= n7) break block143;
                                                    }
                                                    do {
                                                        char[] cArray54 = cArray12;
                                                        char[] cArray55 = cArray12;
                                                        int n57 = n7;
                                                        while (true) {
                                                            int n58;
                                                            char c10 = cArray54[n57];
                                                            switch (n7 % 5) {
                                                                case 0: {
                                                                    n58 = 114;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n58 = 96;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n58 = 119;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n58 = 30;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n58 = 1;
                                                                }
                                                            }
                                                            cArray54[n57] = (char)(c10 ^ n58);
                                                            ++n7;
                                                            cArray12 = cArray55;
                                                            n15 = n15;
                                                            if (n15 != 0) break;
                                                            cArray55 = cArray12;
                                                            n14 = n15;
                                                            n57 = n15;
                                                            cArray54 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                    } while (n15 > n7);
                                                }
                                                var0_2 = null;
                                                char[] cArray56 = new String(cArray11).intern().toCharArray();
                                                n4 = 0;
                                                int n59 = cArray56.length;
                                                cArray10 = cArray56;
                                                n13 = n59;
                                                if (n59 <= 1) break block144;
                                                cArray9 = cArray10;
                                                n12 = n13;
                                                if (n13 <= n4) break block145;
                                            }
                                            do {
                                                char[] cArray57 = cArray10;
                                                char[] cArray58 = cArray10;
                                                int n60 = n4;
                                                while (true) {
                                                    int n61;
                                                    char c11 = cArray57[n60];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n61 = 66;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n61 = 123;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n61 = 106;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n61 = 102;
                                                            break;
                                                        }
                                                        default: {
                                                            n61 = 28;
                                                        }
                                                    }
                                                    cArray57[n60] = (char)(c11 ^ n61);
                                                    ++n4;
                                                    cArray10 = cArray58;
                                                    n13 = n13;
                                                    if (n13 != 0) break;
                                                    cArray58 = cArray10;
                                                    n12 = n13;
                                                    n60 = n13;
                                                    cArray57 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n12 = n13;
                                            } while (n13 > n4);
                                        }
                                        stringArray[4] = new String(cArray9).intern();
                                        var2 = null;
                                        char[] cArray59 = "\u000e%#X^Qnz\u0010i\u0010v|\u0014{_ip\u001dy\u0010sr\u000bi\u0010zy\u001coUhn".toCharArray();
                                        n7 = 0;
                                        int n62 = cArray59.length;
                                        cArray8 = cArray59;
                                        n11 = n62;
                                        if (n62 <= 1) break block146;
                                        cArray7 = cArray8;
                                        n10 = n11;
                                        if (n11 <= n7) break block147;
                                    }
                                    do {
                                        char[] cArray60 = cArray8;
                                        char[] cArray61 = cArray8;
                                        int n63 = n7;
                                        while (true) {
                                            int n64;
                                            char c12 = cArray60[n63];
                                            switch (n7 % 5) {
                                                case 0: {
                                                    n64 = 114;
                                                    break;
                                                }
                                                case 1: {
                                                    n64 = 96;
                                                    break;
                                                }
                                                case 2: {
                                                    n64 = 119;
                                                    break;
                                                }
                                                case 3: {
                                                    n64 = 30;
                                                    break;
                                                }
                                                default: {
                                                    n64 = 1;
                                                }
                                            }
                                            cArray60[n63] = (char)(c12 ^ n64);
                                            ++n7;
                                            cArray8 = cArray61;
                                            n11 = n11;
                                            if (n11 != 0) break;
                                            cArray61 = cArray8;
                                            n10 = n11;
                                            n63 = n11;
                                            cArray60 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n10 = n11;
                                    } while (n11 > n7);
                                }
                                var0_2 = null;
                                char[] cArray62 = new String(cArray7).intern().toCharArray();
                                n4 = 0;
                                int n65 = cArray62.length;
                                cArray6 = cArray62;
                                n9 = n65;
                                if (n65 <= 1) break block148;
                                cArray5 = cArray6;
                                n8 = n9;
                                if (n9 <= n4) break block149;
                            }
                            do {
                                char[] cArray63 = cArray6;
                                char[] cArray64 = cArray6;
                                int n66 = n4;
                                while (true) {
                                    int n67;
                                    char c13 = cArray63[n66];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n67 = 66;
                                            break;
                                        }
                                        case 1: {
                                            n67 = 123;
                                            break;
                                        }
                                        case 2: {
                                            n67 = 106;
                                            break;
                                        }
                                        case 3: {
                                            n67 = 102;
                                            break;
                                        }
                                        default: {
                                            n67 = 28;
                                        }
                                    }
                                    cArray63[n66] = (char)(c13 ^ n67);
                                    ++n4;
                                    cArray6 = cArray64;
                                    n9 = n9;
                                    if (n9 != 0) break;
                                    cArray64 = cArray6;
                                    n8 = n9;
                                    n66 = n9;
                                    cArray63 = cArray6;
                                }
                                cArray5 = cArray6;
                                n8 = n9;
                            } while (n9 > n4);
                        }
                        stringArray[5] = new String(cArray5).intern();
                        var2 = null;
                        char[] cArray65 = "~ti+xBmt\u001bx~zp\u001d".toCharArray();
                        n7 = 0;
                        int n68 = cArray65.length;
                        cArray4 = cArray65;
                        n6 = n68;
                        if (n68 <= 1) break block150;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n7) break block151;
                    }
                    do {
                        char[] cArray66 = cArray4;
                        char[] cArray67 = cArray4;
                        int n69 = n7;
                        while (true) {
                            int n70;
                            char c14 = cArray66[n69];
                            switch (n7 % 5) {
                                case 0: {
                                    n70 = 114;
                                    break;
                                }
                                case 1: {
                                    n70 = 96;
                                    break;
                                }
                                case 2: {
                                    n70 = 119;
                                    break;
                                }
                                case 3: {
                                    n70 = 30;
                                    break;
                                }
                                default: {
                                    n70 = 1;
                                }
                            }
                            cArray66[n69] = (char)(c14 ^ n70);
                            ++n7;
                            cArray4 = cArray67;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray67 = cArray4;
                            n5 = n6;
                            n69 = n6;
                            cArray66 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n7);
                }
                var0_2 = null;
                char[] cArray68 = new String(cArray3).intern().toCharArray();
                n4 = 0;
                int n71 = cArray68.length;
                cArray2 = cArray68;
                n3 = n71;
                if (n71 <= 1) break block152;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block153;
            }
            do {
                char[] cArray69 = cArray2;
                char[] cArray70 = cArray2;
                int n72 = n4;
                while (true) {
                    int n73;
                    char c15 = cArray69[n72];
                    switch (n4 % 5) {
                        case 0: {
                            n73 = 66;
                            break;
                        }
                        case 1: {
                            n73 = 123;
                            break;
                        }
                        case 2: {
                            n73 = 106;
                            break;
                        }
                        case 3: {
                            n73 = 102;
                            break;
                        }
                        default: {
                            n73 = 28;
                        }
                    }
                    cArray69[n72] = (char)(c15 ^ n73);
                    ++n4;
                    cArray2 = cArray70;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray70 = cArray2;
                    n2 = n3;
                    n72 = n3;
                    cArray69 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[6] = new String(cArray).intern();
        a = stringArray;
    }
}

