/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    String comment;
    long csize = -1L;
    long crc = -1L;
    long size = -1L;
    long time = -1L;
    int method = -1;
    byte[] extra;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;

    public ZipEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        if (this.time != -1L) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(14, 0);
            int modDate = (int)this.time >> 16;
            int modTime = (int)this.time;
            cal.set(1980 + (modDate >> 9 & 0x7F), (modDate >> 5 & 0xF) - 1, modDate & 0x1F, modTime >> 11 & 0x1F, modTime >> 5 & 0x3F, (modTime & 0x1F) << 1);
            return cal.getTime().getTime();
        }
        return -1L;
    }

    public boolean isDirectory() {
        return this.name.charAt(this.name.length() - 1) == '/';
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public void setCompressedSize(long value) {
        this.csize = value;
    }

    public void setCrc(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.crc = value;
    }

    public void setExtra(byte[] data) {
        if (data != null && data.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = data;
    }

    public void setMethod(int value) {
        if (value != 0 && value != 8) {
            throw new IllegalArgumentException();
        }
        this.method = value;
    }

    public void setSize(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.size = value;
    }

    public void setTime(long value) {
        int modTime;
        int modDate;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(value));
        int year = cal.get(1);
        if (year < 1980) {
            modDate = 33;
            modTime = 0;
        } else {
            modDate = cal.get(5);
            modDate = cal.get(2) + 1 << 5 | modDate;
            modDate = cal.get(1) - 1980 << 9 | modDate;
            modTime = cal.get(13) >> 1;
            modTime = cal.get(12) << 5 | modTime;
            modTime = cal.get(11) << 11 | modTime;
        }
        this.time = modDate << 16 | modTime;
    }

    public String toString() {
        return this.name;
    }

    ZipEntry(String name, String comment, byte[] extra, long modTime, long size, long compressedSize, long crc, int compressionMethod, long modDate, long offset) {
        this.name = name;
        this.comment = comment;
        this.extra = extra;
        this.size = size;
        this.csize = compressedSize;
        this.method = compressionMethod;
        this.time = modTime;
        this.crc = crc;
    }

    public ZipEntry(ZipEntry ze) {
        this.name = ze.name;
        this.comment = ze.comment;
        this.size = ze.size;
        this.csize = ze.csize;
        this.method = ze.method;
        this.time = ze.time;
        this.crc = ze.crc;
        this.extra = ze.extra;
    }

    public Object clone() {
        return new ZipEntry(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

