/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.constExpr;

import com.ibm.idl.Util;
import com.ibm.idl.constExpr.EvaluationException;
import com.ibm.idl.constExpr.Expression;
import com.ibm.idl.constExpr.UnaryExpr;
import java.math.BigInteger;

public class Not
extends UnaryExpr {
    protected Not(Expression expression) {
        super("~", expression);
    }

    public Object evaluate() throws EvaluationException {
        try {
            Number number = (Number)this.operand().evaluate();
            if (number instanceof Float || number instanceof Double) {
                String[] stringArray = new String[]{Util.getMessage("EvaluationException.not"), this.operand().value().getClass().getName()};
                throw new EvaluationException(Util.getMessage("EvaluationException.2", stringArray));
            }
            BigInteger bigInteger = (BigInteger)this.coerceToTarget((BigInteger)number);
            if (this.type().equals("short") || this.type().equals("long") || this.type().equals("long long")) {
                this.value(bigInteger.add(one).multiply(negOne));
            } else if (this.type().equals("unsigned short")) {
                this.value(twoPow16.subtract(one).subtract(bigInteger));
            } else if (this.type().equals("unsigned long")) {
                this.value(twoPow32.subtract(one).subtract(bigInteger));
            } else if (this.type().equals("unsigned long long")) {
                this.value(twoPow64.subtract(one).subtract(bigInteger));
            } else {
                this.value(bigInteger.not());
            }
        }
        catch (ClassCastException classCastException) {
            String[] stringArray = new String[]{Util.getMessage("EvaluationException.not"), this.operand().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.2", stringArray));
        }
        return this.value();
    }
}

