/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import sun.util.ResourceBundleEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenListResourceBundle
extends ResourceBundle {
    private Map lookup = null;

    protected OpenListResourceBundle() {
    }

    @Override
    public Object handleGetObject(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.loadLookupTablesIfNecessary();
        return this.lookup.get(string);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle resourceBundle = this.parent;
        return new ResourceBundleEnumeration(this.handleGetKeys(), resourceBundle != null ? resourceBundle.getKeys() : null);
    }

    public Set<String> handleGetKeys() {
        this.loadLookupTablesIfNecessary();
        return this.lookup.keySet();
    }

    public OpenListResourceBundle getParent() {
        return (OpenListResourceBundle)this.parent;
    }

    protected abstract Object[][] getContents();

    void loadLookupTablesIfNecessary() {
        if (this.lookup == null) {
            this.loadLookup();
        }
    }

    private synchronized void loadLookup() {
        if (this.lookup != null) {
            return;
        }
        Object[][] objectArray = this.getContents();
        Map map = this.createMap(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i][0];
            Object object = objectArray[i][1];
            if (string == null || object == null) {
                throw new NullPointerException();
            }
            map.put(string, object);
        }
        this.lookup = map;
    }

    protected Map createMap(int n) {
        return new HashMap(n);
    }
}

