/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import sun.security.provider.PolicyParser;
import sun.security.tools.AWTPerm;
import sun.security.tools.AddEntryDoneButtonListener;
import sun.security.tools.AddPermButtonListener;
import sun.security.tools.AddPrinButtonListener;
import sun.security.tools.AllPerm;
import sun.security.tools.AudioPerm;
import sun.security.tools.AuthPerm;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.ChangeKeyStoreOKButtonListener;
import sun.security.tools.ChildWindowListener;
import sun.security.tools.ConfirmRemovePolicyEntryOKButtonListener;
import sun.security.tools.DelegationPerm;
import sun.security.tools.EditPermButtonListener;
import sun.security.tools.EditPrinButtonListener;
import sun.security.tools.FilePerm;
import sun.security.tools.LegacyList;
import sun.security.tools.LogPerm;
import sun.security.tools.MBeanPerm;
import sun.security.tools.MBeanSvrPerm;
import sun.security.tools.MBeanTrustPerm;
import sun.security.tools.MgmtPerm;
import sun.security.tools.NetPerm;
import sun.security.tools.NewPolicyPermOKButtonListener;
import sun.security.tools.NewPolicyPrinOKButtonListener;
import sun.security.tools.NoDisplayException;
import sun.security.tools.OverWriteFileOKButtonListener;
import sun.security.tools.Perm;
import sun.security.tools.PermissionActionsMenuListener;
import sun.security.tools.PermissionMenuListener;
import sun.security.tools.PermissionNameMenuListener;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.Prin;
import sun.security.tools.PrincipalTypeMenuListener;
import sun.security.tools.PrivCredPerm;
import sun.security.tools.PropPerm;
import sun.security.tools.ReflectPerm;
import sun.security.tools.RemovePermButtonListener;
import sun.security.tools.RemovePrinButtonListener;
import sun.security.tools.RuntimePerm;
import sun.security.tools.SQLPerm;
import sun.security.tools.SSLPerm;
import sun.security.tools.SecurityPerm;
import sun.security.tools.SerialPerm;
import sun.security.tools.ServicePerm;
import sun.security.tools.SocketPerm;
import sun.security.tools.SubjDelegPerm;
import sun.security.tools.ToolWindow;
import sun.security.tools.UserSaveCancelButtonListener;
import sun.security.tools.UserSaveNoButtonListener;
import sun.security.tools.UserSaveYesButtonListener;

class ToolDialog
extends JDialog {
    private static final long serialVersionUID = -372244357011301190L;
    public static final int NOACTION = 0;
    public static final int QUIT = 1;
    public static final int NEW = 2;
    public static final int OPEN = 3;
    public static final String ALL_PERM_CLASS = "java.security.AllPermission";
    public static final String FILE_PERM_CLASS = "java.io.FilePermission";
    public static final String X500_PRIN_CLASS = "javax.security.auth.x500.X500Principal";
    public static final String PERM = PolicyTool.rb.getString("Permission:                                                       ");
    public static final String PRIN_TYPE = PolicyTool.rb.getString("Principal Type:");
    public static final String PRIN_NAME = PolicyTool.rb.getString("Principal Name:");
    public static final String PERM_NAME = PolicyTool.rb.getString("Target Name:                                                    ");
    public static final String PERM_ACTIONS = PolicyTool.rb.getString("Actions:                                                             ");
    public static final int OW_LABEL = 0;
    public static final int OW_OK_BUTTON = 1;
    public static final int OW_CANCEL_BUTTON = 2;
    public static final int PE_CODEBASE_LABEL = 0;
    public static final int PE_CODEBASE_TEXTFIELD = 1;
    public static final int PE_SIGNEDBY_LABEL = 2;
    public static final int PE_SIGNEDBY_TEXTFIELD = 3;
    public static final int PE_PANEL0 = 4;
    public static final int PE_ADD_PRIN_BUTTON = 0;
    public static final int PE_EDIT_PRIN_BUTTON = 1;
    public static final int PE_REMOVE_PRIN_BUTTON = 2;
    public static final int PE_PRIN_LABEL = 5;
    public static final int PE_PRIN_LIST = 6;
    public static final int PE_PANEL1 = 7;
    public static final int PE_ADD_PERM_BUTTON = 0;
    public static final int PE_EDIT_PERM_BUTTON = 1;
    public static final int PE_REMOVE_PERM_BUTTON = 2;
    public static final int PE_PERM_LIST = 8;
    public static final int PE_PANEL2 = 9;
    public static final int PE_CANCEL_BUTTON = 1;
    public static final int PE_DONE_BUTTON = 0;
    public static final int PRD_DESC_LABEL = 0;
    public static final int PRD_PRIN_CHOICE = 1;
    public static final int PRD_PRIN_TEXTFIELD = 2;
    public static final int PRD_NAME_LABEL = 3;
    public static final int PRD_NAME_TEXTFIELD = 4;
    public static final int PRD_CANCEL_BUTTON = 6;
    public static final int PRD_OK_BUTTON = 5;
    public static final int PD_DESC_LABEL = 0;
    public static final int PD_PERM_CHOICE = 1;
    public static final int PD_PERM_TEXTFIELD = 2;
    public static final int PD_NAME_CHOICE = 3;
    public static final int PD_NAME_TEXTFIELD = 4;
    public static final int PD_ACTIONS_CHOICE = 5;
    public static final int PD_ACTIONS_TEXTFIELD = 6;
    public static final int PD_SIGNEDBY_LABEL = 7;
    public static final int PD_SIGNEDBY_TEXTFIELD = 8;
    public static final int PD_CANCEL_BUTTON = 10;
    public static final int PD_OK_BUTTON = 9;
    public static final int EDIT_KEYSTORE = 0;
    public static final int KSD_NAME_LABEL = 0;
    public static final int KSD_NAME_TEXTFIELD = 1;
    public static final int KSD_TYPE_LABEL = 2;
    public static final int KSD_TYPE_TEXTFIELD = 3;
    public static final int KSD_PROVIDER_LABEL = 4;
    public static final int KSD_PROVIDER_TEXTFIELD = 5;
    public static final int KSD_PWD_URL_LABEL = 6;
    public static final int KSD_PWD_URL_TEXTFIELD = 7;
    public static final int KSD_CANCEL_BUTTON = 9;
    public static final int KSD_OK_BUTTON = 8;
    public static final int USC_LABEL = 0;
    public static final int USC_PANEL = 1;
    public static final int USC_YES_BUTTON = 0;
    public static final int USC_NO_BUTTON = 1;
    public static final int USC_CANCEL_BUTTON = 2;
    public static final int CRPE_LABEL1 = 0;
    public static final int CRPE_LABEL2 = 1;
    public static final int CRPE_PANEL = 2;
    public static final int CRPE_PANEL_OK = 0;
    public static final int CRPE_PANEL_CANCEL = 1;
    public static ArrayList<Perm> PERM_ARRAY = new ArrayList();
    public static ArrayList<Prin> PRIN_ARRAY;
    PolicyTool tool;
    ToolWindow tw;

    ToolDialog(String string, PolicyTool policyTool, ToolWindow toolWindow, boolean bl) {
        super((Frame)toolWindow, bl);
        this.setTitle(string);
        this.tool = policyTool;
        this.tw = toolWindow;
        this.getRootPane().registerKeyboardAction(new CancelButtonListener(this), KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new ChildWindowListener(this));
    }

    static Perm getPerm(String string, boolean bl) {
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            Perm perm = PERM_ARRAY.get(i);
            if (!(bl ? perm.FULL_CLASS.equals(string) : perm.CLASS.equals(string))) continue;
            return perm;
        }
        return null;
    }

    static Prin getPrin(String string, boolean bl) {
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            Prin prin = PRIN_ARRAY.get(i);
            if (!(bl ? prin.FULL_CLASS.equals(string) : prin.CLASS.equals(string))) continue;
            return prin;
        }
        return null;
    }

    void displayOverWriteFileDialog(String string, int n) {
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 75, point.y + 100, 400, 150);
        this.setLayout(new GridBagLayout());
        MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("OK to overwrite existing file filename?"));
        Object[] objectArray = new Object[]{string};
        JLabel jLabel = new JLabel(messageFormat.format(objectArray));
        jLabel.getAccessibleContext().setAccessibleDescription(messageFormat.format(objectArray));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.TOP_PADDING);
        JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.setMnemonic(ToolWindow.getMnemonic("OK Mnemonic"));
        jButton.setToolTipText(PolicyTool.rb.getString("Done.description"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Done.description"));
        jButton.addActionListener(new OverWriteFileOKButtonListener(this.tool, this.tw, this, string, n));
        this.tw.addNewComponent(this.getContentPane(), jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        jButton = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Cancel Mnemonic"));
        jButton.setToolTipText(PolicyTool.rb.getString("Cancel.description"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Cancel.description"));
        jButton.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this.getContentPane(), jButton, 2, 1, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        this.pack();
        this.setVisible(true);
    }

    void displayPolicyEntryDialog(boolean bl) {
        Serializable serializable;
        Serializable serializable2;
        JComponent jComponent;
        int n = 0;
        PolicyEntry[] policyEntryArray = null;
        LegacyList legacyList = new LegacyList();
        legacyList.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Principal List"));
        legacyList.addActionListener(new EditPrinButtonListener(this.tw, this, bl));
        LegacyList legacyList2 = new LegacyList();
        legacyList2.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Permission List"));
        legacyList2.addActionListener(new EditPermButtonListener(this.tw, this, bl));
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 75, point.y + 200, 650, 500);
        this.setLayout(new GridBagLayout());
        this.getContentPane().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("PolicyDialog"));
        this.getContentPane().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PolicyDialog.description"));
        this.setResizable(true);
        if (bl) {
            Object object;
            policyEntryArray = this.tool.getEntry();
            jComponent = (LegacyList)this.tw.getContentPane().getComponent(3);
            n = ((LegacyList)jComponent).getSelectedIndex();
            serializable2 = policyEntryArray[n].getGrantEntry().principals;
            for (int i = 0; i < serializable2.size(); ++i) {
                Object var10_11 = null;
                object = (PolicyParser.PrincipalEntry)serializable2.get(i);
                legacyList.addTaggedItem(ToolDialog.PrincipalEntryToUserFriendlyString((PolicyParser.PrincipalEntry)object), object);
            }
            serializable = policyEntryArray[n].getGrantEntry().permissionEntries;
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                object = (PolicyParser.PermissionEntry)((Vector)serializable).elementAt(i);
                legacyList2.addTaggedItem(ToolDialog.PermissionEntryToUserFriendlyString((PolicyParser.PermissionEntry)object), object);
            }
        }
        jComponent = new JLabel(PolicyTool.rb.getString("CodeBase:"));
        ((JLabel)jComponent).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("CodeBase.description"));
        jComponent.setToolTipText(PolicyTool.rb.getString("CodeBase.description"));
        this.tw.addNewComponent(this.getContentPane(), jComponent, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        serializable2 = new JTextField(bl ? policyEntryArray[n].getGrantEntry().codeBase : "", 60);
        this.tw.addNewComponent(this.getContentPane(), (Component)serializable2, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        ((JLabel)jComponent).setLabelFor((Component)serializable2);
        jComponent = new JLabel(PolicyTool.rb.getString("SignedBy:"));
        ((JLabel)jComponent).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("SignedBy.description"));
        jComponent.setToolTipText(PolicyTool.rb.getString("SignedBy.description"));
        this.tw.addNewComponent(this.getContentPane(), jComponent, 2, 0, 1, 1, 1, 0.0, 0.0, 1);
        serializable2 = new JTextField(bl ? policyEntryArray[n].getGrantEntry().signedBy : "", 60);
        this.tw.addNewComponent(this.getContentPane(), (Component)serializable2, 3, 1, 1, 1, 1, 0.0, 0.0, 1);
        ((JLabel)jComponent).setLabelFor((Component)serializable2);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        JButton jButton = new JButton(PolicyTool.rb.getString("Add Principal"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("AddPrincipal.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("AddPrincipal.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Add Principal Mnemonic"));
        jButton.addActionListener(new AddPrinButtonListener(this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton(PolicyTool.rb.getString("Edit Principal"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("EditPrincipal.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Edit Principal Mnemonic"));
        jButton.setToolTipText(PolicyTool.rb.getString("EditPrincipal.description"));
        jButton.addActionListener(new EditPrinButtonListener(this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton(PolicyTool.rb.getString("Remove Principal"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("RemovePrincipal.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("RemovePrincipal.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Remove Principal Mnemonic"));
        jButton.addActionListener(new RemovePrinButtonListener(this.tw, this));
        this.tw.addNewComponent((Container)serializable, jButton, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this.getContentPane(), (Component)serializable, 4, 1, 2, 1, 1, 0.0, 0.0, 2);
        jComponent = new JLabel(PolicyTool.rb.getString("Principals:"));
        ((JLabel)jComponent).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Principals.description"));
        this.tw.addNewComponent(this.getContentPane(), jComponent, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        this.tw.addNewComponent(this.getContentPane(), legacyList, 6, 1, 3, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        ((JLabel)jComponent).setLabelFor(legacyList.getViewport().getView());
        serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        jButton = new JButton(PolicyTool.rb.getString("  Add Permission"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("AddPermission.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Add Permission Mnemonic"));
        jButton.setToolTipText(PolicyTool.rb.getString("AddPermission.description"));
        jButton.addActionListener(new AddPermButtonListener(this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton(PolicyTool.rb.getString("  Edit Permission"));
        jButton.addActionListener(new EditPermButtonListener(this.tw, this, bl));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("EditPermission.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("EditPermission.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Edit Permission Mnemonic"));
        this.tw.addNewComponent((Container)serializable, jButton, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        jButton = new JButton(PolicyTool.rb.getString("Remove Permission"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("RemovePermission.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Remove Permission Mnemonic"));
        jButton.setToolTipText(PolicyTool.rb.getString("RemovePermission.description"));
        jButton.addActionListener(new RemovePermButtonListener(this.tw, this));
        this.tw.addNewComponent((Container)serializable, jButton, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this.getContentPane(), (Component)serializable, 7, 0, 4, 2, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        this.tw.addNewComponent(this.getContentPane(), legacyList2, 8, 0, 5, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        legacyList2.getViewport().getView().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("PermissionList"));
        legacyList2.getViewport().getView().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PermissionList.description"));
        serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        jButton = new JButton(PolicyTool.rb.getString("Done"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Done.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("Done.description"));
        this.getRootPane().setDefaultButton(jButton);
        jButton.setMnemonic(ToolWindow.getMnemonic("Done Mnemonic"));
        jButton.addActionListener(new AddEntryDoneButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        jButton = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Cancel.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("Cancel.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Cancel Mnemonic"));
        jButton.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent((Container)serializable, jButton, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this.getContentPane(), (Component)serializable, 9, 0, 6, 2, 1, 0.0, 0.0, 3);
        this.setVisible(true);
    }

    PolicyEntry getPolicyEntryFromDialog() throws InvalidParameterException, MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, Exception {
        JTextField jTextField = (JTextField)this.getContentPane().getComponent(1);
        String string = null;
        if (!jTextField.getText().trim().equals("")) {
            string = new String(jTextField.getText().trim());
        }
        jTextField = (JTextField)this.getContentPane().getComponent(3);
        String string2 = null;
        if (!jTextField.getText().trim().equals("")) {
            string2 = new String(jTextField.getText().trim());
        }
        PolicyParser.GrantEntry grantEntry = new PolicyParser.GrantEntry(string2, string);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LegacyList legacyList = (LegacyList)this.getContentPane().getComponent(6);
        for (int i = 0; i < legacyList.getItems().length; ++i) {
            linkedList.add(legacyList.getObject(i));
        }
        grantEntry.principals = linkedList;
        Vector<Object> vector = new Vector<Object>();
        LegacyList legacyList2 = (LegacyList)this.getContentPane().getComponent(8);
        for (int i = 0; i < legacyList2.getItems().length; ++i) {
            vector.addElement(legacyList2.getObject(i));
        }
        grantEntry.permissionEntries = vector;
        PolicyEntry policyEntry = new PolicyEntry(this.tool, grantEntry);
        return policyEntry;
    }

    void keyStoreDialog() {
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 25, point.y + 100, 500, 300);
        this.setLayout(new GridBagLayout());
        this.getContentPane().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("KeyStoreDialog"));
        this.getContentPane().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("KeyStoreDialog.description"));
        JLabel jLabel = new JLabel(PolicyTool.rb.getString("New KeyStore URL:"));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("NewKeyStoreURL.description"));
        jLabel.setDisplayedMnemonic(ToolWindow.getMnemonic("KeyStore URL Mnemonic"));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        JTextField jTextField = new JTextField(this.tool.getKeyStoreName(), 30);
        jTextField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("KeyStore U R L:"));
        jTextField.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("NewKeyStoreU R L.description"));
        jTextField.setToolTipText(PolicyTool.rb.getString("NewKeyStoreURL.description"));
        this.tw.addNewComponent(this.getContentPane(), jTextField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jLabel.setLabelFor(jTextField);
        jLabel = new JLabel(PolicyTool.rb.getString("New Keystore type: "));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("NewKeyStoreType.description"));
        jLabel.setDisplayedMnemonic(ToolWindow.getMnemonic("KeyStore Type Mnemonic"));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jTextField = new JTextField(this.tool.getKeyStoreType(), 30);
        jTextField.setToolTipText(PolicyTool.rb.getString("NewKeyStoreType.description"));
        this.tw.addNewComponent(this.getContentPane(), jTextField, 3, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jLabel.setLabelFor(jTextField);
        jLabel = new JLabel(PolicyTool.rb.getString("Keystore provider: "));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("KeyStoreProvider.description"));
        jLabel.setDisplayedMnemonic(ToolWindow.getMnemonic("KeyStore Provider Mnemonic"));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 4, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jTextField = new JTextField(this.tool.getKeyStoreProvider(), 30);
        jTextField.setToolTipText(PolicyTool.rb.getString("KeyStoreProvider.description"));
        this.tw.addNewComponent(this.getContentPane(), jTextField, 5, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jLabel.setLabelFor(jTextField);
        jLabel = new JLabel(PolicyTool.rb.getString("KeyStore Password URL:"));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("KeystorePasswordURL.description"));
        jLabel.setDisplayedMnemonic(ToolWindow.getMnemonic("KeyStore Password Mnemonic"));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 6, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jTextField = new JTextField(this.tool.getKeyStorePwdURL(), 30);
        jLabel.setLabelFor(jTextField);
        jTextField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("KeyStore Password U R L:"));
        jTextField.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("KeystorePasswordU R L.description"));
        jTextField.setToolTipText(PolicyTool.rb.getString("KeystorePasswordURL.description"));
        this.tw.addNewComponent(this.getContentPane(), jTextField, 7, 1, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Done.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("Done.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("OK Mnemonic"));
        jButton.addActionListener(new ChangeKeyStoreOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(this.getContentPane(), jButton, 8, 0, 4, 1, 1, 0.0, 0.0, 3);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Cancel.description"));
        jButton2.setToolTipText(PolicyTool.rb.getString("Cancel.description"));
        jButton2.setMnemonic(ToolWindow.getMnemonic("Cancel Mnemonic"));
        jButton2.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this.getContentPane(), jButton2, 9, 1, 4, 1, 1, 0.0, 0.0, 3);
        this.setVisible(true);
    }

    void displayPrincipalDialog(boolean bl, boolean bl2) {
        Object object;
        PolicyParser.PrincipalEntry principalEntry = null;
        LegacyList legacyList = (LegacyList)this.getContentPane().getComponent(6);
        int n = legacyList.getSelectedIndex();
        if (bl2) {
            principalEntry = (PolicyParser.PrincipalEntry)legacyList.getObject(n);
        }
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Principals"), this.tool, this.tw, true);
        toolDialog.addWindowListener(new ChildWindowListener(toolDialog));
        toolDialog.getContentPane().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("PrincipalsDialog"));
        toolDialog.getContentPane().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PrincipalsDialog.description"));
        Point point = this.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 100, 650, 190);
        toolDialog.setLayout(new GridBagLayout());
        toolDialog.setResizable(true);
        JLabel jLabel = new JLabel(PolicyTool.rb.getString(bl2 ? "Edit Principal:" : "  Add New Principal:"));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString(bl2 ? "EditPrincipal.description" : "AddPrincipal.description"));
        this.tw.addNewComponent(toolDialog.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        JComboBox jComboBox = new JComboBox();
        jComboBox.addItem(PRIN_TYPE);
        jComboBox.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            object = PRIN_ARRAY.get(i);
            jComboBox.addItem(((Prin)object).CLASS);
        }
        jComboBox.addItemListener(new PrincipalTypeMenuListener(toolDialog));
        this.tw.addNewComponent(toolDialog.getContentPane(), jComboBox, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        JTextField jTextField = new JTextField(bl2 ? principalEntry.getDisplayClass() : "", 30);
        jTextField.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        jTextField.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Principalnametext.description"));
        jTextField.setToolTipText(PolicyTool.rb.getString("Principalnametext.description"));
        this.tw.addNewComponent(toolDialog.getContentPane(), jTextField, 2, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        jLabel = new JLabel(PRIN_NAME);
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Principalname.description"));
        jTextField = new JTextField(bl2 ? principalEntry.getDisplayName() : "", 40);
        jTextField.setToolTipText(PolicyTool.rb.getString("Principalname.description"));
        jLabel.setLabelFor(jTextField);
        this.tw.addNewComponent(toolDialog.getContentPane(), jLabel, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(toolDialog.getContentPane(), jTextField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        if (bl2) {
            if ("WILDCARD_PRINCIPAL_CLASS".equals(principalEntry.getPrincipalClass())) {
                jComboBox.setSelectedItem(PRIN_TYPE);
            } else {
                object = ToolDialog.getPrin(principalEntry.getPrincipalClass(), true);
                if (object != null) {
                    jComboBox.setSelectedItem(((Prin)object).CLASS);
                }
            }
        }
        object = new JButton(PolicyTool.rb.getString("OK"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Done.description"));
        ((JComponent)object).setToolTipText(PolicyTool.rb.getString("Done.description"));
        ((AbstractButton)object).setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
        ((AbstractButton)object).addActionListener(new NewPolicyPrinOKButtonListener(this.tool, this.tw, this, toolDialog, bl2));
        this.tw.addNewComponent(toolDialog.getContentPane(), (Component)object, 5, 0, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        JButton jButton = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Cancel.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("Cancel.description"));
        jButton.setMnemonic((Integer)PolicyTool.rb.getObject("Cancel Mnemonic"));
        jButton.addActionListener(new CancelButtonListener(toolDialog));
        this.tw.addNewComponent(toolDialog.getContentPane(), jButton, 6, 1, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    void displayPermissionDialog(boolean bl, boolean bl2) {
        Object object;
        Object object2;
        PolicyParser.PermissionEntry permissionEntry = null;
        LegacyList legacyList = (LegacyList)this.getContentPane().getComponent(8);
        int n = legacyList.getSelectedIndex();
        if (bl2) {
            permissionEntry = (PolicyParser.PermissionEntry)legacyList.getObject(n);
        }
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Permissions"), this.tool, this.tw, true);
        toolDialog.addWindowListener(new ChildWindowListener(toolDialog));
        toolDialog.getContentPane().getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("PermissionsDialog"));
        toolDialog.getContentPane().getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("PermissionsDialog.description"));
        Point point = this.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 100, 700, 250);
        toolDialog.getContentPane().setLayout(new GridBagLayout());
        toolDialog.setResizable(true);
        JLabel jLabel = new JLabel(PolicyTool.rb.getString(bl2 ? "Edit Permission:" : "  Add New Permission:"));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString(bl2 ? "EditPermission.description" : "AddPermission.description"));
        this.tw.addNewComponent(toolDialog.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        JComboBox jComboBox = new JComboBox();
        jLabel.setLabelFor(jComboBox);
        jComboBox.addItem(PERM);
        jComboBox.setPreferredSize(new Dimension(300, 25));
        jComboBox.getAccessibleContext().setAccessibleName(PERM);
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            object2 = PERM_ARRAY.get(i);
            jComboBox.addItem(((Perm)object2).CLASS);
        }
        jComboBox.addItemListener(new PermissionMenuListener(toolDialog));
        this.tw.addNewComponent(toolDialog.getContentPane(), jComboBox, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        JTextField jTextField = bl2 ? new JTextField(permissionEntry.permission, 30) : new JTextField(30);
        jTextField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Permissions"));
        jTextField.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Permissiontext.description"));
        jTextField.setToolTipText(PolicyTool.rb.getString("Permissiontext.description"));
        this.tw.addNewComponent(toolDialog.getContentPane(), jTextField, 2, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        object2 = new JComboBox();
        ((JComboBox)object2).addItem(PERM_NAME);
        ((JComponent)object2).setPreferredSize(new Dimension(300, 25));
        ((JComboBox)object2).getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Target Name"));
        ((JComboBox)object2).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Target.description"));
        ((JComboBox)object2).addItemListener(new PermissionNameMenuListener(toolDialog));
        jTextField = bl2 ? new JTextField(permissionEntry.name, 30) : new JTextField(30);
        jTextField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Target Name"));
        jTextField.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Target.description"));
        jTextField.setToolTipText(PolicyTool.rb.getString("Target.description"));
        this.tw.addNewComponent(toolDialog.getContentPane(), (Component)object2, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(toolDialog.getContentPane(), jTextField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        JComboBox jComboBox2 = new JComboBox();
        jComboBox2.addItem(PERM_ACTIONS);
        jComboBox2.setPreferredSize(new Dimension(300, 25));
        jComboBox2.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        jComboBox2.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Actionstext.description"));
        jComboBox2.addItemListener(new PermissionActionsMenuListener(toolDialog));
        jTextField = bl2 ? new JTextField(permissionEntry.action, 30) : new JTextField(30);
        jTextField.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        jTextField.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Actionstext.description"));
        jTextField.setToolTipText(PolicyTool.rb.getString("Actionstext.description"));
        this.tw.addNewComponent(toolDialog.getContentPane(), jComboBox2, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(toolDialog.getContentPane(), jTextField, 6, 1, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        jLabel = new JLabel(PolicyTool.rb.getString("Signed By:"));
        jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Signedby.description"));
        jLabel.setDisplayedMnemonic(ToolWindow.getMnemonic("Signed by Mnemonic"));
        this.tw.addNewComponent(toolDialog.getContentPane(), jLabel, 7, 0, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        JTextField jTextField2 = new JTextField(bl2 ? permissionEntry.signedBy : null, 30);
        jLabel.setLabelFor(jTextField2);
        jTextField.setToolTipText(PolicyTool.rb.getString("Signedby.description"));
        this.tw.addNewComponent(toolDialog.getContentPane(), jTextField2, 8, 1, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        if (bl2 && (object = ToolDialog.getPerm(permissionEntry.permission, true)) != null) {
            jComboBox.setSelectedItem(((Perm)object).CLASS);
        }
        if (bl2) {
            this.setPermissionNames(ToolDialog.getPerm(permissionEntry.permission, true), (JComboBox)object2, jTextField);
        }
        if (bl2) {
            this.setPermissionActions(ToolDialog.getPerm(permissionEntry.permission, true), jComboBox2, jTextField);
        }
        object = new JButton(PolicyTool.rb.getString("OK"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Done.description"));
        ((JComponent)object).setToolTipText(PolicyTool.rb.getString("Done.description"));
        ((AbstractButton)object).setMnemonic(ToolWindow.getMnemonic("OK Mnemonic"));
        this.getRootPane().setDefaultButton((JButton)object);
        ((AbstractButton)object).addActionListener(new NewPolicyPermOKButtonListener(this.tool, this.tw, this, toolDialog, bl2));
        this.tw.addNewComponent(toolDialog.getContentPane(), (Component)object, 9, 0, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        JButton jButton = new JButton(PolicyTool.rb.getString("Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Cancel.description"));
        jButton.setToolTipText(PolicyTool.rb.getString("Cancel.description"));
        jButton.setMnemonic(ToolWindow.getMnemonic("Cancel Mnemonic"));
        jButton.addActionListener(new CancelButtonListener(toolDialog));
        this.tw.addNewComponent(toolDialog.getContentPane(), jButton, 10, 1, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    PolicyParser.PrincipalEntry getPrinFromDialog() throws Exception {
        JTextField jTextField = (JTextField)this.getContentPane().getComponent(2);
        String string = new String(jTextField.getText().trim());
        jTextField = (JTextField)this.getContentPane().getComponent(4);
        String string2 = new String(jTextField.getText().trim());
        if (string.equals("*")) {
            string = "WILDCARD_PRINCIPAL_CLASS";
        }
        if (string2.equals("*")) {
            string2 = "WILDCARD_PRINCIPAL_NAME";
        }
        if (string.equals("WILDCARD_PRINCIPAL_CLASS") && !string2.equals("WILDCARD_PRINCIPAL_NAME")) {
            throw new Exception(PolicyTool.rb.getString("Cannot Specify Principal with a Wildcard Class without a Wildcard Name"));
        }
        if (string2.equals("")) {
            throw new Exception(PolicyTool.rb.getString("Cannot Specify Principal without a Name"));
        }
        if (string.equals("")) {
            string = "PolicyParser.REPLACE_NAME";
            this.tool.warnings.addElement("Warning: Principal name '" + string2 + "' specified without a Principal class.\n" + "\t'" + string2 + "' will be interpreted " + "as a key store alias.\n" + "\tThe final principal class will be " + X500_PRIN_CLASS + ".\n" + "\tThe final principal name will be " + "determined by the following:\n" + "\n" + "\tIf the key store entry identified by '" + string2 + "'\n" + "\tis a key entry, then the principal name will be\n" + "\tthe subject distinguished name from the first\n" + "\tcertificate in the entry's certificate chain.\n" + "\n" + "\tIf the key store entry identified by '" + string2 + "'\n" + "\tis a trusted certificate entry, then the\n" + "\tprincipal name will be the subject distinguished\n" + "\tname from the trusted public key certificate.");
            this.tw.displayStatusDialog(this, "'" + string2 + "' will be interpreted as a key " + "store alias.  View Warning Log for details.");
        }
        return new PolicyParser.PrincipalEntry(string, string2);
    }

    PolicyParser.PermissionEntry getPermFromDialog() {
        char c;
        JTextField jTextField = (JTextField)this.getContentPane().getComponent(2);
        String string = new String(jTextField.getText().trim());
        jTextField = (JTextField)this.getContentPane().getComponent(4);
        String string2 = null;
        if (!jTextField.getText().trim().equals("")) {
            string2 = new String(jTextField.getText().trim());
        }
        if (string.equals("") || !string.equals(ALL_PERM_CLASS) && string2 == null) {
            throw new InvalidParameterException(PolicyTool.rb.getString("Permission and Target Name must have a value"));
        }
        if (string.equals(FILE_PERM_CLASS) && string2.lastIndexOf("\\\\") > 0 && (c = this.tw.displayYesNoDialog(this, PolicyTool.rb.getString("Warning"), PolicyTool.rb.getString("Warning: File name may include escaped backslash characters. It is not necessary to escape backslash characters (the tool escapes characters as necessary when writing the policy contents to the persistent store).\n\nClick on Retain to retain the entered name, or click on Edit to edit the name."), PolicyTool.rb.getString("Retain"), PolicyTool.rb.getString("Edit"))) != 'Y') {
            throw new NoDisplayException();
        }
        jTextField = (JTextField)this.getContentPane().getComponent(6);
        String string3 = null;
        if (!jTextField.getText().trim().equals("")) {
            string3 = new String(jTextField.getText().trim());
        }
        jTextField = (JTextField)this.getContentPane().getComponent(8);
        String string4 = null;
        if (!jTextField.getText().trim().equals("")) {
            string4 = new String(jTextField.getText().trim());
        }
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(string, string2, string3);
        permissionEntry.signedBy = string4;
        if (string4 != null) {
            String[] stringArray = this.tool.parseSigners(permissionEntry.signedBy);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    PublicKey publicKey = this.tool.getPublicKeyAlias(stringArray[i]);
                    if (publicKey != null) continue;
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Warning: A public key for alias 'signers[i]' does not exist.  Make sure a KeyStore is properly configured."));
                    Object[] objectArray = new Object[]{stringArray[i]};
                    this.tool.warnings.addElement(messageFormat.format(objectArray));
                    this.tw.displayStatusDialog(this, messageFormat.format(objectArray));
                    continue;
                }
                catch (Exception exception) {
                    this.tw.displayErrorDialog((Window)this, exception);
                }
            }
        }
        return permissionEntry;
    }

    void displayConfirmRemovePolicyEntry() {
        Object object;
        Object object2;
        LegacyList legacyList = (LegacyList)this.tw.getContentPane().getComponent(3);
        int n = legacyList.getSelectedIndex();
        PolicyEntry[] policyEntryArray = this.tool.getEntry();
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 25, point.y + 100, 600, 400);
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(PolicyTool.rb.getString("Remove this Policy Entry?"));
        this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        jLabel = new JLabel(policyEntryArray[n].codebaseToString());
        this.tw.addNewComponent(this.getContentPane(), jLabel, 1, 0, 1, 2, 1, 0.0, 0.0, 1);
        jLabel = new JLabel(policyEntryArray[n].principalsToString().trim());
        this.tw.addNewComponent(this.getContentPane(), jLabel, 2, 0, 2, 2, 1, 0.0, 0.0, 1);
        Vector vector = policyEntryArray[n].getGrantEntry().permissionEntries;
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (PolicyParser.PermissionEntry)vector.elementAt(i);
            object = ToolDialog.PermissionEntryToUserFriendlyString((PolicyParser.PermissionEntry)object2);
            jLabel = new JLabel("    " + (String)object);
            if (i == vector.size() - 1) {
                this.tw.addNewComponent(this.getContentPane(), jLabel, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
                continue;
            }
            this.tw.addNewComponent(this.getContentPane(), jLabel, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        object2 = new JButton(PolicyTool.rb.getString("OK"));
        ((AbstractButton)object2).addActionListener(new ConfirmRemovePolicyEntryOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(jPanel, (Component)object2, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        ((AbstractButton)object2).setMnemonic(ToolWindow.getMnemonic("OK Mnemonic"));
        ((JButton)object2).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("OK.description"));
        ((JComponent)object2).setToolTipText(PolicyTool.rb.getString("OK.description"));
        object = new JButton(PolicyTool.rb.getString("Cancel"));
        ((AbstractButton)object).setMnemonic(ToolWindow.getMnemonic("Cancel Mnemonic"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Cancel.description"));
        ((JComponent)object).setToolTipText(PolicyTool.rb.getString("Cancel.description"));
        ((AbstractButton)object).addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(jPanel, (Component)object, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this.getContentPane(), jPanel, 3 + vector.size(), 0, 3 + vector.size(), 2, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        this.pack();
        this.setVisible(true);
    }

    void displaySaveAsDialog(int n) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(PolicyTool.rb.getString("Save As"));
        int n2 = jFileChooser.showSaveDialog(this.tw);
        if (jFileChooser.getSelectedFile() == null || jFileChooser.getSelectedFile().equals("") || n2 == 1) {
            return;
        }
        String string = jFileChooser.getSelectedFile().toString();
        File file = new File(string);
        if (file.exists()) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Overwrite File"), this.tool, this.tw, true);
            toolDialog.displayOverWriteFileDialog(string, n);
        } else {
            try {
                this.tool.savePolicy(string);
                MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Policy successfully written to filename"));
                Object[] objectArray = new Object[]{string};
                this.tw.displayStatusDialog(null, messageFormat.format(objectArray));
                JTextField jTextField = (JTextField)this.tw.getContentPane().getComponent(1);
                jTextField.setText(string);
                this.tw.setVisible(true);
                this.userSaveContinue(this.tool, this.tw, this, n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (string == null || string.equals("")) {
                    this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.rb.getString("null filename")));
                } else {
                    this.tw.displayErrorDialog(null, fileNotFoundException);
                }
            }
            catch (Exception exception) {
                this.tw.displayErrorDialog(null, exception);
            }
        }
    }

    void displayUserSave(int n) {
        if (this.tool.modified) {
            Point point = this.tw.getLocationOnScreen();
            this.setBounds(point.x + 75, point.y + 100, 400, 150);
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(PolicyTool.rb.getString("     Save changes?"));
            jLabel.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("     Save changes?"));
            this.tw.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 3, 1, 0.0, 0.0, 1, ToolWindow.L_TOP_BOTTOM_PADDING);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            JButton jButton = new JButton(PolicyTool.rb.getString("Yes"));
            jButton.setMnemonic(ToolWindow.getMnemonic("Yes Mnemonic"));
            jButton.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Done.description"));
            jButton.setToolTipText(PolicyTool.rb.getString("Done.description"));
            jButton.addActionListener(new UserSaveYesButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            JButton jButton2 = new JButton(PolicyTool.rb.getString("No"));
            jButton2.setMnemonic(ToolWindow.getMnemonic("No Mnemonic"));
            jButton2.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("Cancel.description"));
            jButton2.setToolTipText(PolicyTool.rb.getString("Cancel.description"));
            jButton2.addActionListener(new UserSaveNoButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(jPanel, jButton2, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            JButton jButton3 = new JButton(PolicyTool.rb.getString("Cancel"));
            jButton3.setMnemonic(ToolWindow.getMnemonic("Cancel Mnemonic"));
            jButton3.getAccessibleContext().setAccessibleDescription(PolicyTool.rb.getString("OK.description"));
            jButton3.setToolTipText(PolicyTool.rb.getString("OK.description"));
            jButton3.addActionListener(new UserSaveCancelButtonListener(this));
            this.tw.addNewComponent(jPanel, jButton3, 2, 2, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            this.tw.addNewComponent(this.getContentPane(), jPanel, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
            this.pack();
            this.setVisible(true);
        } else {
            this.userSaveContinue(this.tool, this.tw, this, n);
        }
    }

    void userSaveContinue(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, int n) {
        switch (n) {
            case 1: {
                toolWindow.setVisible(false);
                toolWindow.dispose();
                System.exit(0);
            }
            case 2: {
                try {
                    policyTool.openPolicy(null);
                }
                catch (Exception exception) {
                    policyTool.modified = false;
                    toolWindow.displayErrorDialog(null, exception);
                }
                LegacyList legacyList = new LegacyList();
                legacyList.addActionListener(new PolicyListListener(policyTool, toolWindow));
                toolWindow.replacePolicyList(legacyList);
                JTextField jTextField = (JTextField)toolWindow.getContentPane().getComponent(1);
                jTextField.setText("");
                toolWindow.setVisible(true);
                break;
            }
            case 3: {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(PolicyTool.rb.getString("Open"));
                jFileChooser.setVisible(true);
                int n2 = jFileChooser.showOpenDialog(toolWindow);
                if (jFileChooser.getSelectedFile() == null || jFileChooser.getSelectedFile().equals("") || n2 == 1) {
                    return;
                }
                String string = new String(jFileChooser.getSelectedFile().toString());
                try {
                    policyTool.openPolicy(string);
                    LegacyList legacyList = new LegacyList();
                    legacyList.addActionListener(new PolicyListListener(policyTool, toolWindow));
                    PolicyEntry[] policyEntryArray = policyTool.getEntry();
                    if (policyEntryArray != null) {
                        for (int i = 0; i < policyEntryArray.length; ++i) {
                            legacyList.addTaggedItem(policyEntryArray[i].headerToString(), policyEntryArray[i]);
                        }
                    }
                    toolWindow.replacePolicyList(legacyList);
                    policyTool.modified = false;
                    JTextField jTextField = (JTextField)toolWindow.getContentPane().getComponent(1);
                    jTextField.setText(string);
                    toolWindow.setVisible(true);
                    if (!policyTool.newWarning) break;
                    toolWindow.displayStatusDialog(null, PolicyTool.rb.getString("Errors have occurred while opening the policy configuration.  View the Warning Log for more information."));
                    break;
                }
                catch (Exception exception) {
                    LegacyList legacyList = new LegacyList();
                    legacyList.addActionListener(new PolicyListListener(policyTool, toolWindow));
                    toolWindow.replacePolicyList(legacyList);
                    policyTool.setPolicyFileName(null);
                    policyTool.modified = false;
                    JTextField jTextField = (JTextField)toolWindow.getContentPane().getComponent(1);
                    jTextField.setText("");
                    toolWindow.setVisible(true);
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Could not open policy file: policyFile: e.toString()"));
                    Object[] objectArray = new Object[]{string, exception.toString()};
                    toolWindow.displayErrorDialog(null, messageFormat.format(objectArray));
                }
            }
        }
    }

    void setPermissionNames(Perm perm, JComboBox jComboBox, JTextField jTextField) {
        jComboBox.removeAllItems();
        jComboBox.addItem(PERM_NAME);
        if (perm == null) {
            jTextField.setEditable(true);
        } else if (perm.TARGETS == null) {
            jTextField.setEditable(false);
        } else {
            jTextField.setEditable(true);
            for (int i = 0; i < perm.TARGETS.length; ++i) {
                jComboBox.addItem(perm.TARGETS[i]);
            }
        }
    }

    void setPermissionActions(Perm perm, JComboBox jComboBox, JTextField jTextField) {
        jComboBox.removeAllItems();
        jComboBox.addItem(PERM_ACTIONS);
        if (perm == null) {
            jTextField.setEditable(true);
        } else if (perm.ACTIONS == null) {
            jTextField.setEditable(false);
        } else {
            jTextField.setEditable(true);
            for (int i = 0; i < perm.ACTIONS.length; ++i) {
                jComboBox.addItem(perm.ACTIONS[i]);
            }
        }
    }

    static String PermissionEntryToUserFriendlyString(PolicyParser.PermissionEntry permissionEntry) {
        String string = permissionEntry.permission;
        if (permissionEntry.name != null) {
            string = string + " " + permissionEntry.name;
        }
        if (permissionEntry.action != null) {
            string = string + ", \"" + permissionEntry.action + "\"";
        }
        if (permissionEntry.signedBy != null) {
            string = string + ", signedBy " + permissionEntry.signedBy;
        }
        return string;
    }

    static String PrincipalEntryToUserFriendlyString(PolicyParser.PrincipalEntry principalEntry) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        principalEntry.write(printWriter);
        return stringWriter.toString();
    }

    static {
        PERM_ARRAY.add(new AllPerm());
        PERM_ARRAY.add(new AudioPerm());
        PERM_ARRAY.add(new AuthPerm());
        PERM_ARRAY.add(new AWTPerm());
        PERM_ARRAY.add(new DelegationPerm());
        PERM_ARRAY.add(new FilePerm());
        PERM_ARRAY.add(new LogPerm());
        PERM_ARRAY.add(new MgmtPerm());
        PERM_ARRAY.add(new MBeanPerm());
        PERM_ARRAY.add(new MBeanSvrPerm());
        PERM_ARRAY.add(new MBeanTrustPerm());
        PERM_ARRAY.add(new NetPerm());
        PERM_ARRAY.add(new PrivCredPerm());
        PERM_ARRAY.add(new PropPerm());
        PERM_ARRAY.add(new ReflectPerm());
        PERM_ARRAY.add(new RuntimePerm());
        PERM_ARRAY.add(new SecurityPerm());
        PERM_ARRAY.add(new SerialPerm());
        PERM_ARRAY.add(new ServicePerm());
        PERM_ARRAY.add(new SocketPerm());
        PERM_ARRAY.add(new SQLPerm());
        PERM_ARRAY.add(new SSLPerm());
        PERM_ARRAY.add(new SubjDelegPerm());
        PRIN_ARRAY = new ArrayList();
        PRIN_ARRAY.add(new Prin("KerberosPrincipal", "javax.security.auth.kerberos.KerberosPrincipal"));
        PRIN_ARRAY.add(new Prin("X500Principal", X500_PRIN_CLASS));
        PRIN_ARRAY.add(new Prin("UsernamePrincipal", "com.ibm.security.auth.UsernamePrincipal"));
        PRIN_ARRAY.add(new Prin("UserIDPrincipal", "com.ibm.security.auth.UserIDPrincipal"));
        PRIN_ARRAY.add(new Prin("GroupIDPrincipal", "com.ibm.security.auth.GroupIDPrincipal"));
        PRIN_ARRAY.add(new Prin("PrimaryGroupIDPrincipal", "com.ibm.security.auth.PrimaryGroupIDPrincipal"));
        PRIN_ARRAY.add(new Prin("DomainPrincipal", "com.ibm.security.auth.DomainPrincipal"));
        PRIN_ARRAY.add(new Prin("ServerPrincipal", "com.ibm.security.auth.ServerPrincipal"));
        PRIN_ARRAY.add(new Prin("WkstationPrincipal", "com.ibm.security.auth.WkstationPrincipal"));
        PRIN_ARRAY.add(new Prin("DomainIDPrincipal", "com.ibm.security.auth.DomainIDPrincipal"));
        PRIN_ARRAY.add(new Prin("NTDomainPrincipal", "com.ibm.security.auth.NTDomainPrincipal"));
        PRIN_ARRAY.add(new Prin("NTSidDomainPrincipal", "com.ibm.security.auth.NTSidDomainPrincipal"));
        PRIN_ARRAY.add(new Prin("NTSidGroupPrincipal", "com.ibm.security.auth.NTSidGroupPrincipal"));
        PRIN_ARRAY.add(new Prin("NTSidPrimaryGroupPrincipal", "com.ibm.security.auth.NTSidPrimaryGroupPrincipal"));
        PRIN_ARRAY.add(new Prin("NTSidUserPrincipal", "com.ibm.security.auth.NTSidUserPrincipal"));
        PRIN_ARRAY.add(new Prin("NTUserPrincipal", "com.ibm.security.auth.NTUserPrincipal"));
        PRIN_ARRAY.add(new Prin("AIXNumericGroupPrincipal", "com.ibm.security.auth.AIXNumericGroupPrincipal"));
        PRIN_ARRAY.add(new Prin("AIXNumericUserPrincipal", "com.ibm.security.auth.AIXNumericUserPrincipal"));
        PRIN_ARRAY.add(new Prin("AIXPrincipal", "com.ibm.security.auth.AIXPrincipal"));
        PRIN_ARRAY.add(new Prin("LinuxNumericGroupPrincipal", "com.ibm.security.auth.LinuxNumericGroupPrincipal"));
        PRIN_ARRAY.add(new Prin("LinuxNumericUserPrincipal", "com.ibm.security.auth.LinuxNumericUserPrincipal"));
        PRIN_ARRAY.add(new Prin("LinuxPrincipal", "com.ibm.security.auth.LinuxPrincipal"));
        PRIN_ARRAY.add(new Prin("OS390UserPrincipal", "com.ibm.security.auth.OS390UserPrincipal"));
    }
}

