/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.UnicodeDecoder;

abstract class UTF16_Decoder
extends UnicodeDecoder {
    private final int expectedByteOrder;
    private int currentByteOrder;
    private int defaultByteOrder = 1;
    private int byteOff;
    private int charOff;
    private int leftOverByte;
    private boolean leftOver = false;
    private boolean started = false;

    public UTF16_Decoder(Charset charset, int n) {
        super(charset, n);
        this.expectedByteOrder = this.currentByteOrder = n;
    }

    public UTF16_Decoder(Charset charset, int n, int n2) {
        this(charset, n);
        this.defaultByteOrder = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset();
        int n4 = charBuffer.position();
        int n5 = n3 + n4;
        int n6 = n3 + charBuffer.limit();
        this.byteOff = n;
        this.charOff = n5;
        int n7 = n;
        int n8 = n5;
        try {
            int n9;
            int n10;
            char c;
            int n11;
            int n12;
            if (n >= n2) {
                this.charOff = 0;
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            if (this.leftOver) {
                n12 = this.leftOverByte & 0xFF;
                this.leftOver = false;
            } else {
                n12 = byArray[n7++] & 0xFF;
            }
            if (!this.started && n7 < n2) {
                n11 = byArray[n7++] & 0xFF;
                c = (char)(n12 << 8 | n11);
                n10 = 0;
                if (c == '\ufeff') {
                    n10 = 1;
                } else if (c == '\ufffe') {
                    n10 = 2;
                } else if (this.currentByteOrder == 0) {
                    this.currentByteOrder = 1;
                }
                if (this.currentByteOrder == 0) {
                    this.currentByteOrder = n10;
                    if (n7 < n2) {
                        n12 = byArray[n7++] & 0xFF;
                    }
                } else if (n10 == 0) {
                    --n7;
                } else if (this.currentByteOrder == n10) {
                    if (n7 < n2) {
                        n12 = byArray[n7++] & 0xFF;
                    }
                } else {
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                this.started = true;
            }
            c = '\u0000';
            int n13 = n6 - n8 << 1;
            n10 = n2 - n7 + 1;
            if (n13 < n10) {
                c = '\u0001';
                n10 = n13;
            }
            if ((n10 & 1) != 0) {
                this.leftOverByte = byArray[n2 - 1];
                this.leftOver = true;
                this.byteOff = n2;
            }
            char c2 = '\u0000';
            if ((n10 >>= 1) > 0) {
                n11 = byArray[n7++] & 0xFF;
                c2 = this.currentByteOrder == 1 ? (char)(n12 << 8 | n11) : (char)(n11 << 8 | n12);
                if (c2 == '\ufffe') {
                    this.byteOff = n7 - 2;
                    this.charOff = n8;
                    this.leftOver = false;
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                cArray[n8] = c2;
            }
            if (this.currentByteOrder == 1) {
                for (n9 = 1; n9 < n10 && (c2 = (char)(byArray[n7] << 8 | byArray[n7 + 1] & 0xFF)) != '\ufffe'; ++n9) {
                    cArray[n8 + n9] = c2;
                    n7 += 2;
                }
            } else {
                while (n9 < n10 && (c2 = (char)(byArray[n7 + 1] << 8 | byArray[n7] & 0xFF)) != '\ufffe') {
                    cArray[n8 + n9] = c2;
                    n7 += 2;
                    ++n9;
                }
            }
            if (!this.leftOver) {
                this.byteOff = n7;
            }
            this.charOff = n8 + n9;
            if (c2 == '\ufffe') {
                this.leftOver = false;
                CoderResult coderResult = CoderResult.malformedForLength(2);
                return coderResult;
            }
            if (c != '\u0000') {
                this.charOff -= n3;
                CoderResult coderResult = CoderResult.OVERFLOW;
                return coderResult;
            }
            this.charOff = n4 + n10;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(this.byteOff);
            charBuffer.position(this.charOff);
        }
    }

    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
        this.leftOver = false;
        this.charOff = 0;
        this.byteOff = 0;
        this.started = false;
    }
}

