/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.security.AccessController;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class ByteToCharUTF8
extends ByteToCharConverter {
    private int state = 0;
    private int inputSize;
    private int value;
    public static final int[] States = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 1};
    public static final int[] StateMask = new int[]{0, 0, 31, 15, 7};
    private String bidiParms = bidiInit;
    private boolean bidiEnabled = false;
    private static String bidiInit;

    public ByteToCharUTF8() {
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException {
        if (this.state != 0) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    private void setException(int n, int n2) {
        this.badInputLength = 1 + this.state - n;
        this.byteOff -= this.state - n;
        if (this.byteOff < n2) {
            this.byteOff += 1 + this.state - n;
            this.badInputLength = 0;
        }
        this.state = 0;
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws MalformedInputException, ConversionBufferFullException {
        int n5;
        int n6 = 0;
        int n7 = n4;
        int n8 = n3;
        int n9 = n7 - n8;
        int n10 = n2;
        int n11 = n;
        int n12 = n10 - n11;
        int n13 = n9 < n12 ? n9 : n12;
        for (n5 = 0; n5 < n13 && (n6 = byArray[n11 + n5]) >= 0; ++n5) {
            cArray[n8 + n5] = (char)n6;
        }
        n8 += n5;
        if ((n11 += n5) >= n10) {
            if (this.bidiEnabled) {
                this.doBidi(cArray, n3, n8);
            }
            this.charOff = n8;
            this.byteOff = n11;
            return n8 - n3;
        }
        while (n11 < n10) {
            if (this.state == 0) {
                while ((n6 = byArray[n11]) >= 0) {
                    if (n8 >= n7) {
                        this.doBidi(cArray, n3, n8);
                        this.charOff = n8;
                        this.byteOff = n11;
                        throw new ConversionBufferFullException();
                    }
                    cArray[n8++] = (char)n6;
                    if (++n11 < n10) continue;
                    this.doBidi(cArray, n3, n8);
                    this.charOff = n8;
                    this.byteOff = n11;
                    return n8 - n3;
                }
                ++n11;
                this.state = States[(n6 & 0xFF) >> 3];
                this.inputSize = 1;
                this.value = n6 & StateMask[this.state];
                if (this.state != 1) continue;
                this.doBidi(cArray, n3, n8);
                this.badInputLength = 1;
                this.state = 0;
                this.charOff = n8;
                this.byteOff = n11;
                throw new MalformedInputException();
            }
            n6 = byArray[n11] & 0xFF;
            if ((n6 & 0xC0) != 128) {
                this.doBidi(cArray, n3, n8);
                this.charOff = n8;
                this.byteOff = n11;
                this.setException(this.inputSize, n);
                throw new MalformedInputException();
            }
            int n14 = this.value << 6 | n6 & 0x3F;
            if (this.inputSize + 1 >= this.state) {
                if (n14 < 65536) {
                    if (n8 >= n7) {
                        this.doBidi(cArray, n3, n8);
                        this.charOff = n8;
                        this.byteOff = n11;
                        throw new ConversionBufferFullException();
                    }
                    cArray[n8++] = (char)n14;
                } else {
                    if (n14 > 0x10FFFF) {
                        this.doBidi(cArray, n3, n8);
                        this.charOff = n8;
                        this.byteOff = n11;
                        this.setException(this.state, n);
                        throw new MalformedInputException();
                    }
                    if (n8 + 2 > n7) {
                        this.doBidi(cArray, n3, n8);
                        this.charOff = n8;
                        this.byteOff = n11;
                        throw new ConversionBufferFullException();
                    }
                    cArray[n8++] = (char)((n14 - 65536) / 1024 + 55296);
                    cArray[n8++] = (char)((n14 - 65536) % 1024 + 56320);
                }
                this.state = 0;
            } else {
                ++this.inputSize;
                this.value = n14;
            }
            ++n11;
        }
        this.doBidi(cArray, n3, n8);
        this.charOff = n8;
        this.byteOff = n11;
        return n8 - n3;
    }

    void doBidi(char[] cArray, int n, int n2) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n, n2, this.bidiParms, this.getCharacterEncoding())) {
            int n3 = n2 - n;
            char[] cArray2 = new char[n3];
            cArray2 = bidiConvert.toUnicode(cArray, n, n2, this.bidiParms, this.getCharacterEncoding());
            System.arraycopy(cArray2, 0, cArray, n, n3);
        }
    }

    public String getCharacterEncoding() {
        return "UTF8";
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.state = 0;
    }
}

