/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import sun.awt.SunToolkit;
import sun.awt.X11InputMethodDescriptor;
import sun.awt.im.InputMethodAdapter;

public abstract class X11InputMethod
extends InputMethodAdapter {
    private static final Logger log = Logger.getLogger("sun.awt.X11InputMethod");
    private static final int XIMReverse = 1;
    private static final int XIMUnderline = 2;
    private static final int XIMHighlight = 4;
    private static final int XIMPrimary = 32;
    private static final int XIMSecondary = 64;
    private static final int XIMTertiary = 128;
    private static final int XIMVisibleToForward = 256;
    private static final int XIMVisibleToBackward = 512;
    private static final int XIMVisibleCenter = 1024;
    private static final int XIMVisibleMask = 1792;
    private Locale locale = X11InputMethodDescriptor.getSupportedLocale();
    private static boolean isXIMOpened = false;
    protected Container clientComponentWindow = null;
    private Component awtFocussedComponent = null;
    private Component lastXICFocussedComponent = null;
    private boolean isLastXICActive = false;
    private boolean isActive = false;
    private boolean isActiveClient = false;
    private static Map[] highlightStyles;
    private boolean disposed = false;
    private boolean needResetXIC = false;
    private Component needResetXICClient = null;
    private boolean compositionEnableSupported = true;
    private boolean savedCompositionState = false;
    private String committedText = null;
    private StringBuffer composedText = null;
    private IntBuffer rawFeedbacks;
    private transient long pData = 0L;
    protected static X11InputMethod activatedInstance;
    private boolean forceReset = false;
    private static final int INITIAL_SIZE = 64;

    private static native void initIDs();

    public X11InputMethod() throws AWTException {
        if (!this.initXIM()) {
            throw new AWTException("Cannot open X Input Method");
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private synchronized boolean initXIM() {
        String string;
        String string2 = this.getNativeInputMethodInfo();
        if (string2 != null && string2.compareTo("SCIM") == 0) {
            this.forceReset = true;
        }
        if ((string = System.getenv("IBMJAVA_IM_FORCERESET")) != null) {
            char c;
            this.forceReset = true;
            if (string.length() > 0 && ((c = string.charAt(0)) == 'F' || c == 'f')) {
                this.forceReset = false;
            }
        }
        if (!isXIMOpened) {
            isXIMOpened = this.openXIM();
        }
        return isXIMOpened;
    }

    protected abstract boolean openXIM();

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected abstract void setXICFocus(ComponentPeer var1, boolean var2, boolean var3);

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
    }

    public boolean setLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return true;
        }
        return this.locale.equals(Locale.JAPAN) && locale.equals(Locale.JAPANESE) || this.locale.equals(Locale.KOREA) && locale.equals(Locale.KOREAN);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    protected final void resetXICifneeded() {
        if (this.needResetXIC && this.haveActiveClient() && this.getClientComponent() != this.needResetXICClient) {
            this.resetXIC();
            this.lastXICFocussedComponent = null;
            this.isLastXICActive = false;
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    private void resetCompositionState() {
        if (this.compositionEnableSupported && this.haveActiveClient()) {
            try {
                this.setCompositionEnabled(this.savedCompositionState);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.compositionEnableSupported = false;
            }
        }
    }

    private boolean getCompositionState() {
        boolean bl = false;
        if (this.compositionEnableSupported) {
            try {
                bl = this.isCompositionEnabled();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.compositionEnableSupported = false;
            }
        }
        return bl;
    }

    public synchronized void activate() {
        ComponentPeer componentPeer;
        activatedInstance = this;
        this.clientComponentWindow = this.getClientComponentWindow();
        if (this.clientComponentWindow == null) {
            return;
        }
        if (this.lastXICFocussedComponent != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "XICFocused {0}, AWTFocused {1}", new Object[]{this.lastXICFocussedComponent, this.awtFocussedComponent});
            }
            if (this.lastXICFocussedComponent != this.awtFocussedComponent && (componentPeer = this.getPeer(this.lastXICFocussedComponent)) != null) {
                if (this.forceReset) {
                    this.resetXIC();
                }
                this.setXICFocus(componentPeer, false, this.isLastXICActive);
            }
            this.lastXICFocussedComponent = null;
        }
        if (this.pData == 0L) {
            if (!this.createXIC()) {
                return;
            }
            this.disposed = false;
        }
        this.resetXICifneeded();
        componentPeer = this.getPeer(this.awtFocussedComponent);
        this.setStatusAreaVisible(true, this.pData);
        if (componentPeer != null) {
            this.setXICFocus(componentPeer, true, this.haveActiveClient());
        }
        this.lastXICFocussedComponent = this.awtFocussedComponent;
        this.isLastXICActive = this.haveActiveClient();
        this.isActive = true;
        if (this.savedCompositionState) {
            this.resetCompositionState();
        }
    }

    protected abstract boolean createXIC();

    public synchronized void deactivate(boolean bl) {
        boolean bl2 = this.haveActiveClient();
        activatedInstance = null;
        this.savedCompositionState = this.getCompositionState();
        if (bl) {
            this.turnoffStatusWindow();
            this.lastXICFocussedComponent = this.awtFocussedComponent;
        } else {
            ComponentPeer componentPeer;
            if (this.awtFocussedComponent != null && (componentPeer = this.getPeer(this.awtFocussedComponent)) != null) {
                if (this.forceReset) {
                    this.resetXIC();
                }
                this.setXICFocus(componentPeer, false, bl2);
            }
            this.lastXICFocussedComponent = null;
        }
        this.isLastXICActive = bl2;
        this.isActive = false;
        this.setStatusAreaVisible(false, this.pData);
    }

    public void disableInputMethod() {
        if (this.lastXICFocussedComponent != null) {
            if (this.forceReset) {
                this.resetXIC();
            }
            this.setXICFocus(this.getPeer(this.lastXICFocussedComponent), false, this.isLastXICActive);
            this.lastXICFocussedComponent = null;
            this.isLastXICActive = false;
        }
    }

    public void hideWindows() {
        if (this.pData != 0L) {
            this.setStatusAreaVisible(false, this.pData);
            this.turnoffStatusWindow();
        }
    }

    public static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n;
        int n2 = inputMethodHighlight.getState();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            n = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n;
        }
        return highlightStyles[n];
    }

    protected void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        if (this.isActive) {
            boolean bl = this.haveActiveClient();
            if (this.forceReset) {
                this.resetXIC();
            }
            this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, bl);
            this.setXICFocus(this.getPeer(component), true, bl);
        }
        this.awtFocussedComponent = component;
    }

    protected void stopListening() {
        this.endComposition();
        this.disableInputMethod();
        if (this.needResetXIC) {
            this.resetXIC();
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    private Window getClientComponentWindow() {
        Component component = this.getClientComponent();
        Container container = component instanceof Container ? (Container)component : this.getParent(component);
        while (container != null && !(container instanceof Window)) {
            container = this.getParent(container);
        }
        return (Window)container;
    }

    protected abstract Container getParent(Component var1);

    protected abstract ComponentPeer getPeer(Component var1);

    protected abstract void awtLock();

    protected abstract void awtUnlock();

    private void postInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2, long l) {
        Component component = this.getClientComponent();
        if (component != null) {
            InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n, l, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
            SunToolkit.postEvent(SunToolkit.targetToAppContext(component), inputMethodEvent);
        }
    }

    private void postInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this.postInputMethodEvent(n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2, EventQueue.getMostRecentEventTime());
    }

    void dispatchCommittedText(String string, long l) {
        if (string == null) {
            return;
        }
        if (this.composedText == null) {
            AttributedString attributedString = new AttributedString(string);
            this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null, l);
        } else {
            this.committedText = string;
        }
    }

    private void dispatchCommittedText(String string) {
        this.dispatchCommittedText(string, EventQueue.getMostRecentEventTime());
    }

    void dispatchComposedText(String string, int[] nArray, int n, int n2, int n3, long l) {
        int n4;
        AttributedString attributedString;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.disposed) {
            return;
        }
        if (string == null && nArray == null && n == 0 && n2 == 0 && n3 == 0 && this.composedText == null && this.committedText == null) {
            return;
        }
        if (this.composedText != null) {
            n8 = n;
            n7 = n2;
            n6 = 0;
            n5 = 0;
            while (n5 < n8) {
                if (n6 < this.composedText.length() && Character.charCount(this.composedText.codePointAt(n6)) == 2) {
                    ++n6;
                    ++n;
                }
                ++n5;
                ++n6;
            }
            n5 = 0;
            while (n5 < n7) {
                if (n6 < this.composedText.length() && Character.charCount(this.composedText.codePointAt(n6)) == 2) {
                    ++n6;
                    ++n2;
                }
                ++n5;
                ++n6;
            }
        }
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (n7 = 0; n7 < string.length(); ++n7) {
                n6 = string.charAt(n7);
                if (Character.isISOControl((char)n6)) {
                    n6 = 9633;
                }
                stringBuffer.append((char)n6);
            }
            string = new String(stringBuffer);
        }
        if (this.composedText == null) {
            this.composedText = new StringBuffer(64);
            this.rawFeedbacks = new IntBuffer(64);
        }
        if (n2 > 0) {
            if (string == null && nArray != null) {
                this.rawFeedbacks.replace(n, nArray);
            } else if (n2 == this.composedText.length()) {
                this.composedText = new StringBuffer(64);
                this.rawFeedbacks = new IntBuffer(64);
            } else if (this.composedText.length() > 0) {
                if (n + n2 < this.composedText.length()) {
                    String string2 = this.composedText.toString().substring(n + n2, this.composedText.length());
                    this.composedText.setLength(n);
                    this.composedText.append(string2);
                } else {
                    this.composedText.setLength(n);
                }
                this.rawFeedbacks.remove(n, n2);
            }
        }
        if (string != null) {
            this.composedText.insert(n, string);
            if (nArray != null) {
                if (string.length() > nArray.length) {
                    n8 = 0;
                    int[] nArray2 = new int[string.length()];
                    n6 = 0;
                    while (n6 < nArray.length) {
                        nArray2[n8] = nArray[n6];
                        if (n8 < string.length() && Character.charCount(string.codePointAt(n8)) == 2) {
                            nArray2[++n8] = nArray[n6];
                        }
                        ++n6;
                        ++n8;
                    }
                    nArray = nArray2;
                }
                this.rawFeedbacks.insert(n, nArray);
            }
        } else if (nArray != null) {
            n8 = 0;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                if (this.composedText.length() <= n + n7 + n8 || Character.charCount(this.composedText.codePointAt(n + n7 + n8)) != 2) continue;
                ++n8;
            }
            if (n8 > 0) {
                n7 = 0;
                int[] nArray3 = new int[nArray.length + n8];
                n5 = 0;
                while (n5 < nArray.length) {
                    nArray3[n7] = nArray[n5];
                    if (this.composedText.length() > n + n7 && Character.charCount(this.composedText.codePointAt(n + n7)) == 2) {
                        nArray3[++n7] = nArray[n5];
                    }
                    ++n5;
                    ++n7;
                }
                nArray = nArray3;
            }
            this.rawFeedbacks.replace(n, nArray);
        }
        if (this.composedText.length() == 0) {
            this.composedText = null;
            this.rawFeedbacks = null;
            if (this.committedText != null) {
                this.dispatchCommittedText(this.committedText, l);
                this.committedText = null;
                return;
            }
            this.postInputMethodEvent(1100, null, 0, null, null, l);
            return;
        }
        for (n8 = 0; n8 < n3; ++n8) {
            if (n8 >= this.composedText.length() || Character.charCount(this.composedText.codePointAt(n8)) != 2) continue;
            ++n3;
            ++n8;
        }
        if (this.committedText != null) {
            n8 = this.committedText.length();
            attributedString = new AttributedString(this.committedText + this.composedText);
            this.committedText = null;
        } else {
            n8 = 0;
            attributedString = new AttributedString(this.composedText.toString());
        }
        int n9 = 0;
        int n10 = 0;
        TextHitInfo textHitInfo = null;
        this.rawFeedbacks.rewind();
        n6 = this.rawFeedbacks.getNext();
        this.rawFeedbacks.unget();
        while ((n5 = this.rawFeedbacks.getNext()) != -1) {
            if (n10 == 0 && (n10 = n5 & 0x700) != 0) {
                int n11 = this.rawFeedbacks.getOffset() - 1;
                textHitInfo = n10 == 512 ? TextHitInfo.leading(n11) : TextHitInfo.trailing(n11);
            }
            if (n6 == (n5 &= 0xFFFFF8FF)) continue;
            this.rawFeedbacks.unget();
            n4 = this.rawFeedbacks.getOffset();
            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n6), n8 + n9, n8 + n4);
            n9 = n4;
            n6 = n5;
        }
        n4 = this.rawFeedbacks.getOffset();
        if (n4 >= 0) {
            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n6), n8 + n9, n8 + n4);
        }
        this.postInputMethodEvent(1100, attributedString.getIterator(), n8, TextHitInfo.leading(n3), textHitInfo, l);
    }

    void flushText() {
        String string;
        String string2 = string = this.committedText != null ? this.committedText : "";
        if (this.composedText != null) {
            string = string + this.composedText.toString();
        }
        if (!string.equals("")) {
            AttributedString attributedString = new AttributedString(string);
            this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null, EventQueue.getMostRecentEventTime());
            this.composedText = null;
            this.committedText = null;
        }
    }

    void clearComposedText() {
        this.composedText = null;
        this.postInputMethodEvent(1100, null, 0, null, null, EventQueue.getMostRecentEventTime());
        if (this.committedText != null && this.committedText.length() > 0) {
            this.dispatchCommittedText(this.committedText);
        }
        this.committedText = null;
        this.rawFeedbacks = null;
    }

    protected synchronized void disposeImpl() {
        this.disposeXIC();
        this.awtLock();
        this.clearComposedText();
        this.awtUnlock();
        this.awtFocussedComponent = null;
        this.lastXICFocussedComponent = null;
        this.needResetXIC = false;
        this.savedCompositionState = false;
        this.compositionEnableSupported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11InputMethod x11InputMethod = this;
            synchronized (x11InputMethod) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public Object getControlObject() {
        return null;
    }

    public synchronized void removeNotify() {
        this.dispose();
    }

    public void setCompositionEnabled(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCompositionState();
        if (this.setCompositionEnabledNative(bl)) {
            this.savedCompositionState = bl;
        }
        if (bl3 != (bl2 = this.getCompositionState()) && bl2 == bl) {
            if (!bl) {
                this.flushText();
            }
            if (this.awtFocussedComponent != null && this.isActive) {
                this.setXICFocus(this.getPeer(this.awtFocussedComponent), true, this.haveActiveClient());
            }
        }
    }

    public boolean isCompositionEnabled() {
        return this.isCompositionEnabledNative();
    }

    public void endComposition() {
        if (this.disposed) {
            return;
        }
        this.savedCompositionState = this.getCompositionState();
        boolean bl = this.haveActiveClient();
        if (bl && this.composedText == null && this.committedText == null) {
            this.needResetXIC = true;
            this.needResetXICClient = this.getClientComponent();
            return;
        }
        String string = this.resetXIC();
        if (bl) {
            this.needResetXIC = false;
        }
        this.awtLock();
        this.composedText = null;
        this.postInputMethodEvent(1100, null, 0, null, null);
        if (string != null && string.length() > 0) {
            this.dispatchCommittedText(string);
        }
        this.awtUnlock();
        if (this.savedCompositionState) {
            this.resetCompositionState();
        }
    }

    public String getNativeInputMethodInfo() {
        String string = System.getenv("XMODIFIERS");
        String string2 = null;
        if (string != null) {
            int n = string.indexOf("@im=");
            if (n != -1) {
                string2 = string.substring(n + 4);
            }
        } else if (System.getProperty("os.name").startsWith("SunOS")) {
            File file = new File(System.getProperty("user.home") + "/.dtprofile");
            String string3 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string4 = null;
                block2: while (string3 == null && (string4 = bufferedReader.readLine()) != null) {
                    if (!string4.contains("atok") && !string4.contains("wnn")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string4);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        if (!Pattern.matches("atok.*setup", string5) && !Pattern.matches("wnn.*setup", string5)) continue;
                        string3 = string5.substring(0, string5.indexOf("setup"));
                        continue block2;
                    }
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            string2 = "htt " + string3;
        }
        return string2;
    }

    private InputMethodHighlight convertVisualFeedbackToHighlight(int n) {
        InputMethodHighlight inputMethodHighlight;
        switch (n) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 0: 
            case 32: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 128: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return inputMethodHighlight;
    }

    protected native String resetXIC();

    private native void disposeXIC();

    private native boolean setCompositionEnabledNative(boolean var1);

    private native boolean isCompositionEnabledNative();

    private native void turnoffStatusWindow();

    private native void setStatusAreaVisible(boolean var1, long var2);

    static {
        activatedInstance = null;
        Map[] mapArray = new Map[4];
        HashMap<TextAttribute, Comparable<Float>> hashMap = new HashMap<TextAttribute, Comparable<Float>>(1);
        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        highlightStyles = mapArray;
        X11InputMethod.initIDs();
    }

    private final class IntBuffer {
        private int[] intArray;
        private int size;
        private int index;

        IntBuffer(int n) {
            this.intArray = new int[n];
            this.size = 0;
            this.index = 0;
        }

        void insert(int n, int[] nArray) {
            int n2 = this.size + nArray.length;
            if (this.intArray.length < n2) {
                int[] nArray2 = new int[n2 * 2];
                System.arraycopy(this.intArray, 0, nArray2, 0, this.size);
                this.intArray = nArray2;
            }
            System.arraycopy(this.intArray, n, this.intArray, n + nArray.length, this.size - n);
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
            this.size += nArray.length;
            if (this.index > n) {
                this.index = n;
            }
        }

        void remove(int n, int n2) {
            if (n + n2 != this.size) {
                System.arraycopy(this.intArray, n + n2, this.intArray, n, this.size - n - n2);
            }
            this.size -= n2;
            if (this.index > n) {
                this.index = n;
            }
        }

        void replace(int n, int[] nArray) {
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
        }

        void removeAll() {
            this.size = 0;
            this.index = 0;
        }

        void rewind() {
            this.index = 0;
        }

        int getNext() {
            if (this.index == this.size) {
                return -1;
            }
            return this.intArray[this.index++];
        }

        void unget() {
            if (this.index != 0) {
                --this.index;
            }
        }

        int getOffset() {
            return this.index;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.intArray[n++]);
                if (n >= this.size) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
    }
}

