/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;

public class DeflaterInputStream
extends FilterInputStream {
    protected final Deflater def;
    protected final byte[] buf;
    private byte[] rbuf = new byte[1];
    private boolean usesDefaultDeflater = false;
    private boolean reachEOF = false;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public DeflaterInputStream(InputStream inputStream) {
        this(inputStream, new Deflater());
        this.usesDefaultDeflater = true;
    }

    public DeflaterInputStream(InputStream inputStream, Deflater deflater) {
        this(inputStream, deflater, 512);
    }

    public DeflaterInputStream(InputStream inputStream, Deflater deflater, int n) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("Null input");
        }
        if (deflater == null) {
            throw new NullPointerException("Null deflater");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Buffer size < 1");
        }
        this.def = deflater;
        this.buf = new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                if (this.usesDefaultDeflater) {
                    this.def.end();
                }
                this.in.close();
                Object var2_1 = null;
                this.in = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.in = null;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        int n = this.read(this.rbuf, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.rbuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException("Null buffer for read");
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n2 > 0 && !this.def.finished()) {
            int n4;
            if (this.def.needsInput()) {
                n4 = this.in.read(this.buf, 0, this.buf.length);
                if (n4 < 0) {
                    this.def.finish();
                } else if (n4 > 0) {
                    this.def.setInput(this.buf, 0, n4);
                }
            }
            n4 = this.def.deflate(byArray, n, n2);
            n3 += n4;
            n += n4;
            n2 -= n4;
        }
        if (n3 == 0 && this.def.finished()) {
            this.reachEOF = true;
            n3 = -1;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        int n;
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        if (this.rbuf.length < 512) {
            this.rbuf = new byte[512];
        }
        long l2 = 0L;
        for (int i = (int)Math.min(l, Integer.MAX_VALUE); i > 0 && (n = this.read(this.rbuf, 0, i <= this.rbuf.length ? i : this.rbuf.length)) >= 0; i -= n) {
            l2 += (long)n;
        }
        return l2;
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

