/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class X509CRL
extends CRL
implements X509Extension {
    private transient X500Principal issuerPrincipal;

    protected X509CRL() {
        super("X.509");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRL)object).getEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            for (int i = 1; i < byArray.length; ++i) {
                n += byArray[i] * i;
            }
            return n;
        }
        catch (CRLException cRLException) {
            return n;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract int getVersion();

    public abstract Principal getIssuerDN();

    public X500Principal getIssuerX500Principal() {
        if (this.issuerPrincipal == null) {
            if (this.getIssuerDN() == null) {
                throw new IllegalStateException("issuer may not be null");
            }
            try {
                this.issuerPrincipal = new X500Principal(this.getIssuerDN().getName());
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException("unable to instantiate X500Principal");
                runtimeException.initCause(exception);
                throw runtimeException;
            }
        }
        return this.issuerPrincipal;
    }

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);

    public X509CRLEntry getRevokedCertificate(X509Certificate x509Certificate) {
        X500Principal x500Principal;
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        if (!x500Principal2.equals(x500Principal = this.getIssuerX500Principal())) {
            return null;
        }
        return this.getRevokedCertificate(x509Certificate.getSerialNumber());
    }

    public abstract Set<? extends X509CRLEntry> getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();
}

