/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.jvm.ClassLoaderDiagnosticsHelper;
import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.FactoryURLClassLoader;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassLoader
extends SecureClassLoader {
    URLClassPath ucp;
    private static final Object packageSyncronizer = new Object();
    private AccessControlContext acc;
    private SharedClassURLClasspathHelper sharedClassURLClasspathHelper;
    private SharedClassMetaDataCache sharedClassMetaDataCache;
    private static Vector showClassLoadingFor = null;
    private static boolean showLoadingMessages = false;
    private static final String showClassLoadingProperty = "ibm.cl.verbose";

    private boolean usingSharedClasses() {
        return this.sharedClassURLClasspathHelper != null;
    }

    private void initializeSharedClassesSupport(URL[] uRLArray) {
        SharedClassHelperFactory sharedClassHelperFactory = Shared.getSharedClassHelperFactory();
        if (sharedClassHelperFactory != null) {
            try {
                this.sharedClassURLClasspathHelper = sharedClassHelperFactory.getURLClasspathHelper((ClassLoader)this, uRLArray);
            }
            catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {
                helperAlreadyDefinedException.printStackTrace();
            }
            if (this.usingSharedClasses()) {
                this.sharedClassMetaDataCache = new SharedClassMetaDataCache(uRLArray.length);
            }
        }
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.ucp = new URLClassPath(uRLArray, null, this.sharedClassURLClasspathHelper);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.ucp = new URLClassPath(uRLArray, null, this.sharedClassURLClasspathHelper);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.ucp = new URLClassPath(uRLArray, uRLStreamHandlerFactory, this.sharedClassURLClasspathHelper);
        this.acc = AccessController.getContext();
    }

    protected void addURL(URL uRL) {
        this.ucp.addURL(uRL);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    private boolean showClassLoading(String string) {
        if (showLoadingMessages) {
            Enumeration enumeration = showClassLoadingFor.elements();
            while (enumeration.hasMoreElements()) {
                Pattern pattern = (Pattern)enumeration.nextElement();
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            int n;
            SharedClassMetaData sharedClassMetaData;
            Object object;
            Object object2;
            boolean bl = this.showClassLoading(string);
            if (bl) {
                ClassLoaderDiagnosticsHelper.attemptingToLoadClass(this, string);
            }
            if (this.usingSharedClasses() && (object2 = this.sharedClassURLClasspathHelper.findSharedClass(string, (SharedClassURLClasspathHelper.IndexHolder)(object = new SharedClassIndexHolder()))) != null && (sharedClassMetaData = this.sharedClassMetaDataCache.getSharedClassMetaData(n = ((SharedClassIndexHolder)object).index)) != null) {
                try {
                    Class clazz = this.defineClass(string, (byte[])object2, sharedClassMetaData.getCodeSource(), sharedClassMetaData.getManifest());
                    if (bl) {
                        ClassLoaderDiagnosticsHelper.loadedClass(this, string);
                    }
                    return clazz;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if ((object2 = (Object)((Class)AccessController.doPrivileged(object = new ClassFinder(string, this), this.acc))) == null) {
                if (bl) {
                    ClassLoaderDiagnosticsHelper.failedToLoadClass(this, string);
                }
                throw new ClassNotFoundException(string);
            }
            if (bl) {
                ClassLoaderDiagnosticsHelper.loadedClass(this, string);
            }
            return object2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Class<?> clazz = null;
        CodeSource codeSource = null;
        Manifest manifest = null;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object3 = string.substring(0, n);
            object2 = this.getPackage((String)object3);
            manifest = resource.getManifest();
            if (object2 == null) {
                object = packageSyncronizer;
                synchronized (object) {
                    object2 = this.getPackage((String)object3);
                    if (object2 == null) {
                        if (manifest != null) {
                            this.definePackage((String)object3, manifest, uRL);
                        } else {
                            this.definePackage((String)object3, null, null, null, null, null, null, null);
                        }
                    }
                }
            }
            if (object2 != null) {
                if (object2.isSealed()) {
                    if (!object2.isSealed(uRL)) {
                        throw new SecurityException("sealing violation: package " + (String)object3 + " is sealed");
                    }
                } else if (manifest != null && this.isSealed((String)object3, manifest)) {
                    throw new SecurityException("sealing violation: can't seal package " + (String)object3 + ": already loaded");
                }
            }
        }
        if ((object3 = resource.getByteBuffer()) != null) {
            object2 = resource.getCodeSigners();
            codeSource = new CodeSource(uRL, (CodeSigner[])object2);
            clazz = this.defineClass(string, (ByteBuffer)object3, codeSource);
        } else {
            object2 = resource.getBytes();
            object = resource.getCodeSigners();
            codeSource = new CodeSource(uRL, (CodeSigner[])object);
            clazz = this.defineClass(string, (byte[])object2, 0, ((CodeSigner[])object2).length, codeSource);
        }
        if (this.usingSharedClasses()) {
            int n2 = resource.getClasspathLoadIndex();
            object = this.sharedClassMetaDataCache.getSharedClassMetaData(n2);
            if (object == null) {
                object = new SharedClassMetaData(codeSource, manifest);
                this.sharedClassMetaDataCache.setSharedClassMetaData(n2, (SharedClassMetaData)object);
            }
            boolean bl = false;
            try {
                bl = this.sharedClassURLClasspathHelper.storeSharedClass(clazz, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class defineClass(String string, byte[] byArray, CodeSource codeSource, Manifest manifest) throws IOException {
        int n = string.lastIndexOf(46);
        URL uRL = codeSource.getLocation();
        if (n != -1) {
            String string2 = string.substring(0, n);
            Package package_ = this.getPackage(string2);
            if (package_ == null) {
                Object object = packageSyncronizer;
                synchronized (object) {
                    package_ = this.getPackage(string2);
                    if (package_ == null) {
                        if (manifest != null) {
                            this.definePackage(string2, manifest, uRL);
                        } else {
                            this.definePackage(string2, null, null, null, null, null, null, null);
                        }
                    }
                }
            }
            if (package_ != null) {
                if (package_.isSealed()) {
                    if (!package_.isSealed(uRL)) {
                        throw new SecurityException("sealing violation: package " + string2 + " is sealed");
                    }
                } else if (manifest != null && this.isSealed(string2, manifest)) {
                    throw new SecurityException("sealing violation: can't seal package " + string2 + ": already loaded");
                }
            }
        }
        return this.defineClass(string, byArray, 0, byArray.length, codeSource);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    @Override
    public URL findResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.ucp.findResource(string, true);
            }
        }, this.acc);
        return uRL != null ? this.ucp.checkURL(uRL) : null;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        final Enumeration enumeration = this.ucp.findResources(string, true);
        return new Enumeration<URL>(){
            private URL url = null;

            private boolean next() {
                URL uRL;
                if (this.url != null) {
                    return true;
                }
                while ((uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!enumeration.hasMoreElements()) {
                            return null;
                        }
                        return enumeration.nextElement();
                    }
                }, URLClassLoader.this.acc)) != null) {
                    this.url = URLClassLoader.this.ucp.checkURL(uRL);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Object object2;
        Permission permission;
        URLConnection uRLConnection;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            uRLConnection = uRL.openConnection();
            permission = uRLConnection.getPermission();
        }
        catch (IOException iOException) {
            permission = null;
            uRLConnection = null;
        }
        if (permission instanceof FilePermission) {
            object2 = permission.getName();
            if (((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
                permission = new FilePermission((String)object2, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object2 = uRL.getFile().replace('/', File.separatorChar);
            if (((String)(object2 = ParseUtil.decode((String)object2))).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
            }
            permission = new FilePermission((String)object2, "read");
        } else {
            object2 = uRL;
            if (uRLConnection instanceof JarURLConnection) {
                object2 = ((JarURLConnection)uRLConnection).getJarFileURL();
            }
            if ((object = ((URL)object2).getHost()) != null && ((String)object).length() > 0) {
                permission = new SocketPermission((String)object, "connect,accept");
            }
        }
        if (permission != null) {
            object2 = System.getSecurityManager();
            if (object2 != null) {
                object = permission;
                AccessController.doPrivileged(new PrivilegedAction((SecurityManager)object2, (Permission)object){
                    final /* synthetic */ SecurityManager val$sm;
                    final /* synthetic */ Permission val$fp;
                    {
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                }, this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray, classLoader);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    static {
        Vector<Pattern> vector = new Vector<Pattern>();
        String string = System.getProperty(showClassLoadingProperty);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.replaceAll("\\.", "\\.");
                string3 = string3.replaceAll("\\*", ".*");
                try {
                    Pattern pattern = Pattern.compile(string3);
                    vector.addElement(pattern);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    System.err.println("Illegal class matching expression \"" + string2 + "\" supplied by property " + showClassLoadingProperty);
                }
            }
        }
        if (!vector.isEmpty()) {
            showLoadingMessages = true;
        }
        showClassLoadingFor = vector;
    }

    final class ClassFinder
    implements PrivilegedExceptionAction {
        private String name;
        private ClassLoader classloader;

        public ClassFinder(String string, ClassLoader classLoader) {
            this.name = string;
            this.classloader = classLoader;
        }

        public Object run() throws ClassNotFoundException {
            String string = this.name.replace('.', '/').concat(".class");
            try {
                Resource resource = URLClassLoader.this.ucp.getResource(string, false, this.classloader, URLClassLoader.this.showClassLoading(this.name));
                if (resource != null) {
                    return URLClassLoader.this.defineClass(this.name, resource);
                }
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(this.name, iOException);
            }
            return null;
        }
    }

    private class SharedClassMetaDataCache {
        private static final int BLOCKSIZE = 10;
        private SharedClassMetaData[] store;

        public SharedClassMetaDataCache(int n) {
            this.store = new SharedClassMetaData[n];
        }

        public synchronized SharedClassMetaData getSharedClassMetaData(int n) {
            if (n < 0 || this.store.length < n + 1) {
                return null;
            }
            return this.store[n];
        }

        public synchronized void setSharedClassMetaData(int n, SharedClassMetaData sharedClassMetaData) {
            this.ensureSize(n);
            this.store[n] = sharedClassMetaData;
        }

        private synchronized void ensureSize(int n) {
            if (this.store.length < n + 1) {
                int n2 = n + 10;
                SharedClassMetaData[] sharedClassMetaDataArray = new SharedClassMetaData[n2];
                System.arraycopy(this.store, 0, sharedClassMetaDataArray, 0, this.store.length);
                this.store = sharedClassMetaDataArray;
            }
        }
    }

    private class SharedClassMetaData {
        private CodeSource codeSource;
        private Manifest manifest;

        SharedClassMetaData(CodeSource codeSource, Manifest manifest) {
            this.codeSource = codeSource;
            this.manifest = manifest;
        }

        public CodeSource getCodeSource() {
            return this.codeSource;
        }

        public Manifest getManifest() {
            return this.manifest;
        }
    }

    private class SharedClassIndexHolder
    implements SharedClassURLClasspathHelper.IndexHolder {
        int index;

        private SharedClassIndexHolder() {
        }

        public void setIndex(int n) {
            this.index = n;
        }
    }
}

