/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;

class ProcessInputStream
extends FilterInputStream
implements Runnable {
    ProcessPipedInputStream pipe;
    InputStream ins;
    PipedOutputStream outs = new PipedOutputStream();
    UNIXProcess p;

    ProcessInputStream(UNIXProcess uNIXProcess, InputStream inputStream, String string) throws IOException {
        super(inputStream);
        this.pipe = new ProcessPipedInputStream(this.outs);
        this.ins = inputStream;
        this.p = uNIXProcess;
        Thread thread = new Thread((Runnable)this, string);
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized int read() throws IOException {
        return this.pipe.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.pipe.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.pipe.read(byArray, n, n2);
    }

    public int available() throws IOException {
        return this.pipe.available();
    }

    public void close() throws IOException {
        this.insClose();
        this.pipe.close();
    }

    private synchronized void insClose() throws IOException {
        this.ins.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        byte[] byArray = new byte[512];
        try {
            int n;
            while ((n = this.ins.read(byArray)) >= 0) {
                this.pipe.receive(byArray, 0, n);
                ProcessPipedInputStream processPipedInputStream = this.pipe;
                synchronized (processPipedInputStream) {
                    this.pipe.notifyAll();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.outs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.insClose();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

