/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.SyncFailedException;

public final class FileDescriptor {
    private int fd;
    private int refCount = 0;
    public static final FileDescriptor in = new FileDescriptor(0);
    public static final FileDescriptor out = new FileDescriptor(1);
    public static final FileDescriptor err = new FileDescriptor(2);

    public FileDescriptor() {
        this.fd = -1;
    }

    private FileDescriptor(int n) {
        this.fd = n;
    }

    int read() throws IOException {
        return this.read(this.fd);
    }

    private native int read(long var1) throws IOException;

    public boolean valid() {
        return this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    synchronized void incRefCount() {
        ++this.refCount;
    }

    synchronized int decRefCount() {
        --this.refCount;
        return this.refCount;
    }

    private static native void initIDs();

    static {
        FileDescriptor.initIDs();
    }
}

