/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.XColors;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.swing.SwingUtilities2;

class Metacity
implements SynthConstants {
    static Metacity INSTANCE;
    private static final String[] themeNames;
    private static boolean errorLogged;
    private static DocumentBuilder documentBuilder;
    private static Document xmlDoc;
    private static String userHome;
    private Node frame_style_set;
    private Map<String, Object> frameGeometry;
    private Map<String, Map<String, Object>> frameGeometries;
    private LayoutManager titlePaneLayout = new TitlePaneLayout();
    private ColorizeImageFilter imageFilter = new ColorizeImageFilter();
    private URL themeDir = null;
    private SynthContext context;
    private String themeName;
    private ArithmeticExpressionEvaluator aee = new ArithmeticExpressionEvaluator();
    private Map<String, Integer> variables;
    private RoundRectClipShape roundedClipShape;
    private HashMap<String, Image> images = new HashMap();

    protected Metacity(String string) throws IOException, ParserConfigurationException, SAXException {
        Object object;
        String string2;
        Node node;
        int n;
        Object object2;
        this.themeName = string;
        this.themeDir = Metacity.getThemeDir(string);
        if (this.themeDir != null) {
            object2 = new URL(this.themeDir, "metacity-theme-1.xml");
            xmlDoc = Metacity.getXMLDoc((URL)object2);
            if (xmlDoc == null) {
                throw new IOException(((URL)object2).toString());
            }
        } else {
            throw new FileNotFoundException(string);
        }
        this.variables = new HashMap<String, Integer>();
        object2 = xmlDoc.getElementsByTagName("constant");
        int n2 = object2.getLength();
        for (n = 0; n < n2; ++n) {
            node = object2.item(n);
            string2 = this.getStringAttr(node, "name");
            if (string2 == null || (object = this.getStringAttr(node, "value")) == null) continue;
            try {
                this.variables.put(string2, Integer.parseInt((String)object));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                Metacity.logError(string, numberFormatException);
            }
        }
        this.frameGeometries = new HashMap<String, Map<String, Object>>();
        object2 = xmlDoc.getElementsByTagName("frame_geometry");
        n2 = object2.getLength();
        for (n = 0; n < n2; ++n) {
            node = object2.item(n);
            string2 = this.getStringAttr(node, "name");
            if (string2 == null) continue;
            object = new HashMap();
            this.frameGeometries.put(string2, (Map<String, Object>)object);
            String string3 = this.getStringAttr(node, "parent");
            if (string3 != null) {
                ((HashMap)object).putAll(this.frameGeometries.get(string3));
            }
            ((HashMap)object).put("has_title", this.getBooleanAttr(node, "has_title", true));
            ((HashMap)object).put("rounded_top_left", this.getBooleanAttr(node, "rounded_top_left", false));
            ((HashMap)object).put("rounded_top_right", this.getBooleanAttr(node, "rounded_top_right", false));
            ((HashMap)object).put("rounded_bottom_left", this.getBooleanAttr(node, "rounded_bottom_left", false));
            ((HashMap)object).put("rounded_bottom_right", this.getBooleanAttr(node, "rounded_bottom_right", false));
            NodeList nodeList = node.getChildNodes();
            int n3 = nodeList.getLength();
            for (int i = 0; i < n3; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                string2 = node2.getNodeName();
                Serializable serializable = null;
                if ("distance".equals(string2)) {
                    serializable = new Integer(this.getIntAttr(node2, "value", 0));
                } else if ("border".equals(string2)) {
                    serializable = new Insets(this.getIntAttr(node2, "top", 0), this.getIntAttr(node2, "left", 0), this.getIntAttr(node2, "bottom", 0), this.getIntAttr(node2, "right", 0));
                } else if ("aspect_ratio".equals(string2)) {
                    serializable = new Float(this.getFloatAttr(node2, "value", 1.0f));
                } else {
                    Metacity.logError(string, "Unknown Metacity frame geometry value type: " + string2);
                }
                String string4 = this.getStringAttr(node2, "name");
                if (string4 == null || serializable == null) continue;
                ((HashMap)object).put(string4, serializable);
            }
        }
        this.frameGeometry = this.frameGeometries.get("normal");
    }

    public static LayoutManager getTitlePaneLayout() {
        return Metacity.INSTANCE.titlePaneLayout;
    }

    private Shape getRoundedClipShape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.roundedClipShape == null) {
            this.roundedClipShape = new RoundRectClipShape();
        }
        this.roundedClipShape.setRoundedRect(n, n2, n3, n4, n5, n6, n7);
        return this.roundedClipShape;
    }

    void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Node node;
        JInternalFrame jInternalFrame;
        this.updateFrameGeometry(synthContext);
        this.context = synthContext;
        JButton jButton = (JButton)synthContext.getComponent();
        String string = jButton.getName();
        int n5 = synthContext.getComponentState();
        JComponent jComponent = (JComponent)jButton.getParent();
        Container container = jComponent.getParent();
        if (container instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)container;
        } else if (container instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)container).getInternalFrame();
        } else {
            return;
        }
        boolean bl = jInternalFrame.isSelected();
        jButton.setOpaque(false);
        String string2 = "normal";
        if ((n5 & 4) != 0) {
            string2 = "pressed";
        } else if ((n5 & 2) != 0) {
            string2 = "prelight";
        }
        String string3 = null;
        String string4 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == "InternalFrameTitlePane.menuButton") {
            string3 = "menu";
            string4 = "left_left";
            bl2 = true;
        } else if (string == "InternalFrameTitlePane.iconifyButton") {
            string3 = "minimize";
            int n6 = (jInternalFrame.isIconifiable() ? 1 : 0) + (jInternalFrame.isMaximizable() ? 1 : 0) + (jInternalFrame.isClosable() ? 1 : 0);
            bl3 = n6 == 1;
            switch (n6) {
                case 1: {
                    string4 = "right_right";
                    break;
                }
                case 2: {
                    string4 = "right_middle";
                    break;
                }
                case 3: {
                    string4 = "right_left";
                }
            }
        } else if (string == "InternalFrameTitlePane.maximizeButton") {
            string3 = "maximize";
            bl3 = !jInternalFrame.isClosable();
            string4 = jInternalFrame.isClosable() ? "right_middle" : "right_right";
        } else if (string == "InternalFrameTitlePane.closeButton") {
            string3 = "close";
            bl3 = true;
            string4 = "right_right";
        }
        Node node2 = this.getNode(this.frame_style_set, "frame", new String[]{"focus", bl ? "yes" : "no", "state", jInternalFrame.isMaximum() ? "maximized" : "normal"});
        if (string3 != null && node2 != null && (node = this.getNode("frame_style", new String[]{"name", this.getStringAttr(node2, "style")})) != null) {
            Shape shape = graphics.getClip();
            if (bl3 && this.getBoolean("rounded_top_right", false) || bl2 && this.getBoolean("rounded_top_left", false)) {
                Point point = jButton.getLocation();
                if (bl3) {
                    graphics.setClip(this.getRoundedClipShape(0, 0, n3, n4, 12, 12, 2));
                } else {
                    graphics.setClip(this.getRoundedClipShape(0, 0, n3, n4, 11, 11, 1));
                }
                Rectangle rectangle = shape.getBounds();
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.drawButton(node, string4 + "_background", string2, graphics, n3, n4, jInternalFrame);
            this.drawButton(node, string3, string2, graphics, n3, n4, jInternalFrame);
            graphics.setClip(shape);
        }
    }

    protected void drawButton(Node node, String string, String string2, Graphics graphics, int n, int n2, JInternalFrame jInternalFrame) {
        Node node2 = this.getNode(node, "button", new String[]{"function", string, "state", string2});
        if (node2 == null && !string2.equals("normal")) {
            node2 = this.getNode(node, "button", new String[]{"function", string, "state", "normal"});
        }
        if (node2 != null) {
            String string3 = this.getStringAttr(node2, "draw_ops");
            Node node3 = string3 != null ? this.getNode("draw_ops", new String[]{"name", string3}) : this.getNode(node2, "draw_ops", null);
            this.variables.put("width", n);
            this.variables.put("height", n2);
            this.draw(node3, graphics, jInternalFrame);
        }
    }

    void paintFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Node node;
        Node node2;
        this.updateFrameGeometry(synthContext);
        this.context = synthContext;
        JComponent jComponent = synthContext.getComponent();
        JComponent jComponent2 = Metacity.findChild(jComponent, "InternalFrame.northPane");
        if (jComponent2 == null) {
            return;
        }
        JInternalFrame jInternalFrame = null;
        if (jComponent instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)jComponent;
        } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame();
        } else {
            assert (false) : "component is not JInternalFrame or JInternalFrame.JDesktopIcon";
            return;
        }
        boolean bl = jInternalFrame.isSelected();
        Font font = graphics.getFont();
        graphics.setFont(jComponent2.getFont());
        graphics.translate(n, n2);
        Rectangle rectangle = this.calculateTitleArea(jInternalFrame);
        JComponent jComponent3 = Metacity.findChild(jComponent2, "InternalFrameTitlePane.menuButton");
        Icon icon = jInternalFrame.getFrameIcon();
        this.variables.put("mini_icon_width", icon != null ? icon.getIconWidth() : 0);
        this.variables.put("mini_icon_height", icon != null ? icon.getIconHeight() : 0);
        this.variables.put("title_width", this.calculateTitleTextWidth(graphics, jInternalFrame));
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jInternalFrame, graphics);
        this.variables.put("title_height", fontMetrics.getAscent() + fontMetrics.getDescent());
        this.variables.put("icon_width", 32);
        this.variables.put("icon_height", 32);
        if (this.frame_style_set != null && (node2 = this.getNode(this.frame_style_set, "frame", new String[]{"focus", bl ? "yes" : "no", "state", jInternalFrame.isMaximum() ? "maximized" : "normal"})) != null && (node = this.getNode("frame_style", new String[]{"name", this.getStringAttr(node2, "style")})) != null) {
            Shape shape = graphics.getClip();
            boolean bl2 = this.getBoolean("rounded_top_left", false);
            boolean bl3 = this.getBoolean("rounded_top_right", false);
            boolean bl4 = this.getBoolean("rounded_bottom_left", false);
            boolean bl5 = this.getBoolean("rounded_bottom_right", false);
            if (bl2 || bl3 || bl4 || bl5) {
                jInternalFrame.setOpaque(false);
                graphics.setClip(this.getRoundedClipShape(0, 0, n3, n4, 12, 12, (bl2 ? 1 : 0) | (bl3 ? 2 : 0) | (bl4 ? 4 : 0) | (bl5 ? 8 : 0)));
            }
            Rectangle rectangle2 = shape.getBounds();
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            int n5 = jComponent2.getHeight();
            boolean bl6 = jInternalFrame.isIcon();
            Insets insets = this.getBorderInsets(synthContext, null);
            int n6 = this.getInt("left_titlebar_edge");
            int n7 = this.getInt("right_titlebar_edge");
            int n8 = this.getInt("top_titlebar_edge");
            int n9 = this.getInt("bottom_titlebar_edge");
            if (!bl6) {
                this.drawPiece(node, graphics, "entire_background", 0, 0, n3, n4, jInternalFrame);
            }
            this.drawPiece(node, graphics, "titlebar", 0, 0, n3, n5, jInternalFrame);
            this.drawPiece(node, graphics, "titlebar_middle", n6, n8, n3 - n6 - n7, n5 - n8 - n9, jInternalFrame);
            this.drawPiece(node, graphics, "left_titlebar_edge", 0, 0, n6, n5, jInternalFrame);
            this.drawPiece(node, graphics, "right_titlebar_edge", n3 - n7, 0, n7, n5, jInternalFrame);
            this.drawPiece(node, graphics, "top_titlebar_edge", 0, 0, n3, n8, jInternalFrame);
            this.drawPiece(node, graphics, "bottom_titlebar_edge", 0, n5 - n9, n3, n9, jInternalFrame);
            this.drawPiece(node, graphics, "title", rectangle.x, rectangle.y, rectangle.width, rectangle.height, jInternalFrame);
            if (!bl6) {
                this.drawPiece(node, graphics, "left_edge", 0, n5, insets.left, n4 - n5, jInternalFrame);
                this.drawPiece(node, graphics, "right_edge", n3 - insets.right, n5, insets.right, n4 - n5, jInternalFrame);
                this.drawPiece(node, graphics, "bottom_edge", 0, n4 - insets.bottom, n3, insets.bottom, jInternalFrame);
                this.drawPiece(node, graphics, "overlay", 0, 0, n3, n4, jInternalFrame);
            }
            graphics.setClip(shape);
        }
        graphics.translate(-n, -n2);
        graphics.setFont(font);
    }

    private static URL getThemeDir(String string) {
        return (URL)new Privileged().doPrivileged(Privileged.GET_THEME_DIR, string);
    }

    private static String getUserTheme() {
        return (String)new Privileged().doPrivileged(Privileged.GET_USER_THEME, null);
    }

    protected void tileImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, float[] fArray) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        for (int i = n2; i < n2 + n4; i += n6) {
            int n7;
            n6 = Math.min(n6, n2 + n4 - i);
            for (int j = n; j < n + n3; j += n7) {
                float f = ((float)fArray.length - 1.0f) * (float)j / (float)(n + n3);
                int n8 = (int)f;
                f -= (float)((int)f);
                float f2 = (1.0f - f) * fArray[n8];
                if (n8 + 1 < fArray.length) {
                    f2 += f * fArray[n8 + 1];
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                n7 = Math.min(n5, n + n3 - j);
                graphics.drawImage(image, j, i, j + n7, i + n6, 0, 0, n7, n6, null);
            }
        }
        graphics2D.setComposite(composite);
    }

    protected Image getImage(String string, Color color) {
        Image image = this.images.get(string + "-" + color.getRGB());
        if (image == null && (image = this.imageFilter.colorize(this.getImage(string), color)) != null) {
            this.images.put(string + "-" + color.getRGB(), image);
        }
        return image;
    }

    protected Image getImage(String string) {
        Image image = this.images.get(string);
        if (image == null) {
            if (this.themeDir != null) {
                try {
                    URL uRL = new URL(this.themeDir, string);
                    image = (Image)new Privileged().doPrivileged(Privileged.GET_IMAGE, uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (image != null) {
                this.images.put(string, image);
            }
        }
        return image;
    }

    protected static JComponent findChild(JComponent jComponent, String string) {
        int n = jComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i);
            if (!string.equals(jComponent2.getName())) continue;
            return jComponent2;
        }
        return null;
    }

    protected Map getFrameGeometry() {
        return this.frameGeometry;
    }

    protected void setFrameGeometry(JComponent jComponent, Map map) {
        this.frameGeometry = map;
        if (this.getInt("top_height") == 0 && jComponent != null) {
            map.put("top_height", new Integer(jComponent.getHeight()));
        }
    }

    protected int getInt(String string) {
        Integer n = (Integer)this.frameGeometry.get(string);
        if (n == null) {
            n = this.variables.get(string);
        }
        return n != null ? n : 0;
    }

    protected boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.frameGeometry.get(string);
        return bl2 != null ? bl2 : bl;
    }

    protected void drawArc(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "start_angle"));
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "extent_angle"));
        boolean bl = this.getBooleanAttr(node, "filled", false);
        if (this.getInt("width") == -1) {
            n -= n3;
        }
        if (this.getInt("height") == -1) {
            n2 -= n4;
        }
        graphics.setColor(color);
        if (bl) {
            graphics.fillArc(n, n2, n3, n4, n5, n6);
        } else {
            graphics.drawArc(n, n2, n3, n4, n5, n6);
        }
    }

    protected void drawLine(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x1"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y1"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x2"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y2"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"), 1);
        graphics.setColor(color);
        if (n5 != 1) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n5));
            graphics2D.drawLine(n, n2, n3, n4);
            graphics2D.setStroke(stroke);
        } else {
            graphics.drawLine(n, n2, n3, n4);
        }
    }

    protected void drawRectangle(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        boolean bl = this.getBooleanAttr(node, "filled", false);
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        graphics.setColor(color);
        if (this.getInt("width") == -1) {
            n -= n3;
        }
        if (this.getInt("height") == -1) {
            n2 -= n4;
        }
        if (bl) {
            graphics.fillRect(n, n2, n3, n4);
        } else {
            graphics.drawRect(n, n2, n3, n4);
        }
    }

    protected void drawTile(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "tile_width"));
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "tile_height"));
        int n7 = this.getInt("width");
        int n8 = this.getInt("height");
        if (n7 == -1) {
            n -= n3;
        }
        if (n8 == -1) {
            n2 -= n4;
        }
        Shape shape = graphics.getClip();
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).clip(new Rectangle(n, n2, n3, n4));
        }
        this.variables.put("width", n5);
        this.variables.put("height", n6);
        Node node2 = this.getNode("draw_ops", new String[]{"name", this.getStringAttr(node, "name")});
        for (int i = n2; i < n2 + n4; i += n6) {
            for (int j = n; j < n + n3; j += n5) {
                graphics.translate(j, i);
                this.draw(node2, graphics, jInternalFrame);
                graphics.translate(-j, -i);
            }
        }
        this.variables.put("width", n7);
        this.variables.put("height", n8);
        graphics.setClip(shape);
    }

    protected void drawTint(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        float f = Float.parseFloat(this.getStringAttr(namedNodeMap, "alpha"));
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n -= n3;
        }
        if (this.getInt("height") == -1) {
            n2 -= n4;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawTitle(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "color");
        int n = string.indexOf("gtk:fg[");
        if (n > 0) {
            string = string.substring(0, n) + "gtk:text[" + string.substring(n + 7);
        }
        Color color = this.parseColor(string);
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        String string2 = jInternalFrame.getTitle();
        if (string2 != null) {
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jInternalFrame, graphics);
            if (jInternalFrame.getComponentOrientation().isLeftToRight()) {
                string2 = SwingUtilities2.clipStringIfNecessary(jInternalFrame, fontMetrics, string2, this.calculateTitleTextWidth(graphics, jInternalFrame));
            }
            graphics.setColor(color);
            SwingUtilities2.drawString((JComponent)jInternalFrame, graphics, string2, n2, n3 + fontMetrics.getAscent());
        }
    }

    protected Dimension calculateButtonSize(JComponent jComponent) {
        int n;
        int n2 = this.getInt("button_height");
        if (n2 == 0) {
            n2 = jComponent.getHeight();
            if (n2 == 0) {
                n2 = 13;
            } else {
                Insets insets = (Insets)this.frameGeometry.get("button_border");
                if (insets != null) {
                    n2 -= insets.top + insets.bottom;
                }
            }
        }
        if ((n = this.getInt("button_width")) == 0) {
            n = n2;
            Float f = (Float)this.frameGeometry.get("aspect_ratio");
            if (f != null) {
                n = (int)((float)n2 / f.floatValue());
            }
        }
        return new Dimension(n, n2);
    }

    protected Rectangle calculateTitleArea(JInternalFrame jInternalFrame) {
        JComponent jComponent = Metacity.findChild(jInternalFrame, "InternalFrame.northPane");
        Dimension dimension = this.calculateButtonSize(jComponent);
        Insets insets = (Insets)this.frameGeometry.get("title_border");
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.getInt("left_titlebar_edge") + dimension.width;
        rectangle.y = 0;
        rectangle.height = jComponent.getHeight();
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.height -= insets.top + insets.bottom;
        }
        rectangle.width = jComponent.getWidth() - rectangle.x - this.getInt("right_titlebar_edge");
        if (jInternalFrame.isClosable()) {
            rectangle.width -= dimension.width;
        }
        if (jInternalFrame.isMaximizable()) {
            rectangle.width -= dimension.width;
        }
        if (jInternalFrame.isIconifiable()) {
            rectangle.width -= dimension.width;
        }
        if (insets != null) {
            rectangle.width -= insets.right;
        }
        return rectangle;
    }

    protected int calculateTitleTextWidth(Graphics graphics, JInternalFrame jInternalFrame) {
        String string = jInternalFrame.getTitle();
        if (string != null) {
            Rectangle rectangle = this.calculateTitleArea(jInternalFrame);
            return Math.min(SwingUtilities2.stringWidth(jInternalFrame, SwingUtilities2.getFontMetrics((JComponent)jInternalFrame, graphics), string), rectangle.width);
        }
        return 0;
    }

    protected void setClip(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n -= n3;
        }
        if (this.getInt("height") == -1) {
            n2 -= n4;
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).clip(new Rectangle(n, n2, n3, n4));
        }
    }

    protected void drawGTKArrow(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "arrow");
        String string2 = this.getStringAttr(namedNodeMap, "shadow");
        String string3 = this.getStringAttr(namedNodeMap, "state").toUpperCase();
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n5 = -1;
        if ("NORMAL".equals(string3)) {
            n5 = 1;
        } else if ("SELECTED".equals(string3)) {
            n5 = 512;
        } else if ("INSENSITIVE".equals(string3)) {
            n5 = 8;
        } else if ("PRELIGHT".equals(string3)) {
            n5 = 2;
        }
        GTKConstants.ShadowType shadowType = null;
        if ("in".equals(string2)) {
            shadowType = GTKConstants.ShadowType.IN;
        } else if ("out".equals(string2)) {
            shadowType = GTKConstants.ShadowType.OUT;
        } else if ("etched_in".equals(string2)) {
            shadowType = GTKConstants.ShadowType.ETCHED_IN;
        } else if ("etched_out".equals(string2)) {
            shadowType = GTKConstants.ShadowType.ETCHED_OUT;
        } else if ("none".equals(string2)) {
            shadowType = GTKConstants.ShadowType.NONE;
        }
        GTKConstants.ArrowType arrowType = null;
        if ("up".equals(string)) {
            arrowType = GTKConstants.ArrowType.UP;
        } else if ("down".equals(string)) {
            arrowType = GTKConstants.ArrowType.DOWN;
        } else if ("left".equals(string)) {
            arrowType = GTKConstants.ArrowType.LEFT;
        } else if ("right".equals(string)) {
            arrowType = GTKConstants.ArrowType.RIGHT;
        }
        GTKPainter.INSTANCE.paintMetacityElement(this.context, graphics, n5, "metacity-arrow", n, n2, n3, n4, shadowType, arrowType);
    }

    protected void drawGTKBox(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "shadow");
        String string2 = this.getStringAttr(namedNodeMap, "state").toUpperCase();
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n5 = -1;
        if ("NORMAL".equals(string2)) {
            n5 = 1;
        } else if ("SELECTED".equals(string2)) {
            n5 = 512;
        } else if ("INSENSITIVE".equals(string2)) {
            n5 = 8;
        } else if ("PRELIGHT".equals(string2)) {
            n5 = 2;
        }
        GTKConstants.ShadowType shadowType = null;
        if ("in".equals(string)) {
            shadowType = GTKConstants.ShadowType.IN;
        } else if ("out".equals(string)) {
            shadowType = GTKConstants.ShadowType.OUT;
        } else if ("etched_in".equals(string)) {
            shadowType = GTKConstants.ShadowType.ETCHED_IN;
        } else if ("etched_out".equals(string)) {
            shadowType = GTKConstants.ShadowType.ETCHED_OUT;
        } else if ("none".equals(string)) {
            shadowType = GTKConstants.ShadowType.NONE;
        }
        GTKPainter.INSTANCE.paintMetacityElement(this.context, graphics, n5, "metacity-box", n, n2, n3, n4, shadowType, null);
    }

    protected void drawGTKVLine(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "state").toUpperCase();
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y1"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y2"));
        int n4 = -1;
        if ("NORMAL".equals(string)) {
            n4 = 1;
        } else if ("SELECTED".equals(string)) {
            n4 = 512;
        } else if ("INSENSITIVE".equals(string)) {
            n4 = 8;
        } else if ("PRELIGHT".equals(string)) {
            n4 = 2;
        }
        GTKPainter.INSTANCE.paintMetacityElement(this.context, graphics, n4, "metacity-vline", n, n2, 1, n3 - n2, null, null);
    }

    protected void drawGradient(Node node, Graphics graphics) {
        boolean bl;
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "type");
        float f = this.getFloatAttr(node, "alpha", -1.0f);
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n2 -= n4;
        }
        if (this.getInt("height") == -1) {
            n3 -= n5;
        }
        Node[] nodeArray = this.getNodesByName(node, "color");
        Color[] colorArray = new Color[nodeArray.length];
        for (n = 0; n < nodeArray.length; ++n) {
            colorArray[n] = this.parseColor(this.getStringAttr(nodeArray[n], "value"));
        }
        n = "diagonal".equals(string) || "horizontal".equals(string) ? 1 : 0;
        boolean bl2 = bl = "diagonal".equals(string) || "vertical".equals(string);
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            if (f >= 0.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            int n6 = colorArray.length - 1;
            for (int i = 0; i < n6; ++i) {
                graphics2D.setPaint(new GradientPaint(n2 + (n != 0 ? i * n4 / n6 : 0), n3 + (bl ? i * n5 / n6 : 0), colorArray[i], n2 + (n != 0 ? (i + 1) * n4 / n6 : 0), n3 + (bl ? (i + 1) * n5 / n6 : 0), colorArray[i + 1]));
                graphics2D.fillRect(n2 + (n != 0 ? i * n4 / n6 : 0), n3 + (bl ? i * n5 / n6 : 0), n != 0 ? n4 / n6 : n4, bl ? n5 / n6 : n5);
            }
            graphics2D.setComposite(composite);
        }
    }

    protected void drawImage(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "filename");
        String string2 = this.getStringAttr(namedNodeMap, "colorize");
        Color color = string2 != null ? this.parseColor(string2) : null;
        String string3 = this.getStringAttr(namedNodeMap, "alpha");
        Image image = color != null ? this.getImage(string, color) : this.getImage(string);
        this.variables.put("object_width", image.getWidth(null));
        this.variables.put("object_height", image.getHeight(null));
        String string4 = this.getStringAttr(namedNodeMap, "fill_type");
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n -= n3;
        }
        if (this.getInt("height") == -1) {
            n2 -= n4;
        }
        if (string3 != null) {
            if ("tile".equals(string4)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                float[] fArray = new float[stringTokenizer.countTokens()];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
                }
                this.tileImage(graphics, image, n, n2, n3, n4, fArray);
            } else {
                float f = Float.parseFloat(string3);
                if (graphics instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    graphics2D.drawImage(image, n, n2, n3, n4, null);
                    graphics2D.setComposite(composite);
                }
            }
        } else {
            graphics.drawImage(image, n, n2, n3, n4, null);
        }
    }

    protected void drawIcon(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        Icon icon = jInternalFrame.getFrameIcon();
        if (icon == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "alpha");
        int n = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n -= n3;
        }
        if (this.getInt("height") == -1) {
            n2 -= n4;
        }
        if (string != null) {
            float f = Float.parseFloat(string);
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                icon.paintIcon(jInternalFrame, graphics, n, n2);
                graphics2D.setComposite(composite);
            }
        } else {
            icon.paintIcon(jInternalFrame, graphics, n, n2);
        }
    }

    protected void drawInclude(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        int n = this.getInt("width");
        int n2 = this.getInt("height");
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"), 0);
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"), 0);
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"), -1);
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"), -1);
        if (n5 != -1) {
            this.variables.put("width", n5);
        }
        if (n6 != -1) {
            this.variables.put("height", n6);
        }
        Node node2 = this.getNode("draw_ops", new String[]{"name", this.getStringAttr(node, "name")});
        graphics.translate(n3, n4);
        this.draw(node2, graphics, jInternalFrame);
        graphics.translate(-n3, -n4);
        if (n5 != -1) {
            this.variables.put("width", n);
        }
        if (n6 != -1) {
            this.variables.put("height", n2);
        }
    }

    protected void draw(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()) != null) {
            Shape shape = graphics.getClip();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                try {
                    String string = node2.getNodeName();
                    if ("include".equals(string)) {
                        this.drawInclude(node2, graphics, jInternalFrame);
                        continue;
                    }
                    if ("arc".equals(string)) {
                        this.drawArc(node2, graphics);
                        continue;
                    }
                    if ("clip".equals(string)) {
                        this.setClip(node2, graphics);
                        continue;
                    }
                    if ("gradient".equals(string)) {
                        this.drawGradient(node2, graphics);
                        continue;
                    }
                    if ("gtk_arrow".equals(string)) {
                        this.drawGTKArrow(node2, graphics);
                        continue;
                    }
                    if ("gtk_box".equals(string)) {
                        this.drawGTKBox(node2, graphics);
                        continue;
                    }
                    if ("gtk_vline".equals(string)) {
                        this.drawGTKVLine(node2, graphics);
                        continue;
                    }
                    if ("image".equals(string)) {
                        this.drawImage(node2, graphics);
                        continue;
                    }
                    if ("icon".equals(string)) {
                        this.drawIcon(node2, graphics, jInternalFrame);
                        continue;
                    }
                    if ("line".equals(string)) {
                        this.drawLine(node2, graphics);
                        continue;
                    }
                    if ("rectangle".equals(string)) {
                        this.drawRectangle(node2, graphics);
                        continue;
                    }
                    if ("tint".equals(string)) {
                        this.drawTint(node2, graphics);
                        continue;
                    }
                    if ("tile".equals(string)) {
                        this.drawTile(node2, graphics, jInternalFrame);
                        continue;
                    }
                    if ("title".equals(string)) {
                        this.drawTitle(node2, graphics, jInternalFrame);
                        continue;
                    }
                    System.err.println("Unknown Metacity drawing op: " + node2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    Metacity.logError(this.themeName, numberFormatException);
                }
            }
            graphics.setClip(shape);
        }
    }

    protected void drawPiece(Node node, Graphics graphics, String string, int n, int n2, int n3, int n4, JInternalFrame jInternalFrame) {
        Node node2 = this.getNode(node, "piece", new String[]{"position", string});
        if (node2 != null) {
            String string2 = this.getStringAttr(node2, "draw_ops");
            Node node3 = string2 != null ? this.getNode("draw_ops", new String[]{"name", string2}) : this.getNode(node2, "draw_ops", null);
            this.variables.put("width", n3);
            this.variables.put("height", n4);
            graphics.translate(n, n2);
            this.draw(node3, graphics, jInternalFrame);
            graphics.translate(-n, -n2);
        }
    }

    Insets getBorderInsets(SynthContext synthContext, Insets insets) {
        this.updateFrameGeometry(synthContext);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = ((Insets)this.frameGeometry.get((Object)"title_border")).top;
        insets.bottom = this.getInt("bottom_height");
        insets.left = this.getInt("left_width");
        insets.right = this.getInt("right_width");
        return insets;
    }

    private void updateFrameGeometry(SynthContext synthContext) {
        Node node;
        Node node2;
        this.context = synthContext;
        JComponent jComponent = synthContext.getComponent();
        JComponent jComponent2 = Metacity.findChild(jComponent, "InternalFrame.northPane");
        JInternalFrame jInternalFrame = null;
        if (jComponent instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)jComponent;
        } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame();
        } else {
            assert (false) : "component is not JInternalFrame or JInternalFrame.JDesktopIcon";
            return;
        }
        if (this.frame_style_set == null) {
            node2 = this.getNode("window", new String[]{"type", "normal"});
            if (node2 != null) {
                this.frame_style_set = this.getNode("frame_style_set", new String[]{"name", this.getStringAttr(node2, "style_set")});
            }
            if (this.frame_style_set == null) {
                this.frame_style_set = this.getNode("frame_style_set", new String[]{"name", "normal"});
            }
        }
        if (this.frame_style_set != null && (node2 = this.getNode(this.frame_style_set, "frame", new String[]{"focus", jInternalFrame.isSelected() ? "yes" : "no", "state", jInternalFrame.isMaximum() ? "maximized" : "normal"})) != null && (node = this.getNode("frame_style", new String[]{"name", this.getStringAttr(node2, "style")})) != null) {
            Map<String, Object> map = this.frameGeometries.get(this.getStringAttr(node, "geometry"));
            this.setFrameGeometry(jComponent2, map);
        }
    }

    protected static void logError(String string, Exception exception) {
        Metacity.logError(string, exception.toString());
    }

    protected static void logError(String string, String string2) {
        if (!errorLogged) {
            System.err.println("Exception in Metacity for theme \"" + string + "\": " + string2);
            errorLogged = true;
        }
    }

    protected static Document getXMLDoc(final URL uRL) throws IOException, ParserConfigurationException, SAXException {
        if (documentBuilder == null) {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new BufferedInputStream(uRL.openStream());
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        });
        Document document = null;
        if (inputStream != null) {
            document = documentBuilder.parse(inputStream);
        }
        return document;
    }

    protected Node[] getNodesByName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    protected Node getNode(String string, String[] stringArray) {
        NodeList nodeList = xmlDoc.getElementsByTagName(string);
        return nodeList != null ? this.getNode(nodeList, string, stringArray) : null;
    }

    protected Node getNode(Node node, String string, String[] stringArray) {
        Node node2;
        String string2;
        Node node3 = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            node3 = this.getNode(nodeList, string, stringArray);
        }
        if (node3 == null && (string2 = this.getStringAttr(node, "parent")) != null && (node2 = this.getNode(node.getParentNode(), node.getNodeName(), new String[]{"name", string2})) != null) {
            node3 = this.getNode(node2, string, stringArray);
        }
        return node3;
    }

    protected Node getNode(NodeList nodeList, String string, String[] stringArray) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!string.equals(node.getNodeName())) continue;
            if (stringArray != null) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap == null) continue;
                boolean bl = true;
                int n2 = stringArray.length / 2;
                for (int j = 0; j < n2; ++j) {
                    String string2 = stringArray[j * 2];
                    String string3 = stringArray[j * 2 + 1];
                    Node node2 = namedNodeMap.getNamedItem(string2);
                    if (node2 != null && (string3 == null || string3.equals(node2.getNodeValue()))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return node;
            }
            return node;
        }
        return null;
    }

    protected String getStringAttr(Node node, String string) {
        Node node2;
        String string2;
        String string3 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (string3 = this.getStringAttr(namedNodeMap, string)) == null && (string2 = this.getStringAttr(namedNodeMap, "parent")) != null && (node2 = this.getNode(node.getParentNode(), node.getNodeName(), new String[]{"name", string2})) != null) {
            string3 = this.getStringAttr(node2, string);
        }
        return string3;
    }

    protected String getStringAttr(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        return node != null ? node.getNodeValue() : null;
    }

    protected boolean getBooleanAttr(Node node, String string, boolean bl) {
        String string2 = this.getStringAttr(node, string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    protected int getIntAttr(Node node, String string, int n) {
        String string2 = this.getStringAttr(node, string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Metacity.logError(this.themeName, numberFormatException);
            }
        }
        return n2;
    }

    protected float getFloatAttr(Node node, String string, float f) {
        String string2 = this.getStringAttr(node, string);
        float f2 = f;
        if (string2 != null) {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Metacity.logError(this.themeName, numberFormatException);
            }
        }
        return f2;
    }

    protected Color parseColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens();
        if (n > 1) {
            String string2 = stringTokenizer.nextToken();
            if ("shade".equals(string2)) {
                assert (n == 3);
                Color color = this.parseColor2(stringTokenizer.nextToken());
                float f = Float.parseFloat(stringTokenizer.nextToken());
                return GTKColorType.adjustColor(color, 1.0f, f, f);
            }
            if ("blend".equals(string2)) {
                assert (n == 4);
                Color color = this.parseColor2(stringTokenizer.nextToken());
                Color color2 = this.parseColor2(stringTokenizer.nextToken());
                float f = Float.parseFloat(stringTokenizer.nextToken());
                if (f > 1.0f) {
                    f = 1.0f / f;
                }
                return new Color((int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f));
            }
            System.err.println("Unknown Metacity color function=" + string);
            return null;
        }
        return this.parseColor2(string);
    }

    protected Color parseColor2(String string) {
        int n;
        Color color = null;
        if (string.startsWith("gtk:") && (n = string.indexOf(91)) > 3) {
            String string2 = string.substring(4, n).toLowerCase();
            int n2 = string.indexOf(93);
            if (n2 > n + 1) {
                String string3 = string.substring(n + 1, n2).toUpperCase();
                int n3 = -1;
                if ("ACTIVE".equals(string3)) {
                    n3 = 4;
                } else if ("INSENSITIVE".equals(string3)) {
                    n3 = 8;
                } else if ("NORMAL".equals(string3)) {
                    n3 = 1;
                } else if ("PRELIGHT".equals(string3)) {
                    n3 = 2;
                } else if ("SELECTED".equals(string3)) {
                    n3 = 512;
                }
                ColorType colorType = null;
                if ("fg".equals(string2)) {
                    colorType = GTKColorType.FOREGROUND;
                } else if ("bg".equals(string2)) {
                    colorType = GTKColorType.BACKGROUND;
                } else if ("base".equals(string2)) {
                    colorType = GTKColorType.TEXT_BACKGROUND;
                } else if ("text".equals(string2)) {
                    colorType = GTKColorType.TEXT_FOREGROUND;
                } else if ("dark".equals(string2)) {
                    colorType = GTKColorType.DARK;
                } else if ("light".equals(string2)) {
                    colorType = GTKColorType.LIGHT;
                }
                if (n3 >= 0 && colorType != null) {
                    color = ((GTKStyle)this.context.getStyle()).getGTKColor(this.context, n3, colorType);
                }
            }
        }
        if (color == null) {
            color = Metacity.parseColorString(string);
        }
        return color;
    }

    private static Color parseColorString(String string) {
        if (string.charAt(0) == '#') {
            int n;
            int n2;
            int n3;
            int n4 = (string = string.substring(1)).length();
            if (n4 < 3 || n4 > 12 || n4 % 3 != 0) {
                return null;
            }
            n4 /= 3;
            try {
                n3 = Integer.parseInt(string.substring(0, n4), 16);
                n2 = Integer.parseInt(string.substring(n4, n4 * 2), 16);
                n = Integer.parseInt(string.substring(n4 * 2, n4 * 3), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n4 == 4) {
                return new ColorUIResource((float)n3 / 65535.0f, (float)n2 / 65535.0f, (float)n / 65535.0f);
            }
            if (n4 == 1) {
                return new ColorUIResource((float)n3 / 15.0f, (float)n2 / 15.0f, (float)n / 15.0f);
            }
            if (n4 == 2) {
                return new ColorUIResource(n3, n2, n);
            }
            return new ColorUIResource((float)n3 / 4095.0f, (float)n2 / 4095.0f, (float)n / 4095.0f);
        }
        return XColors.lookupColor(string);
    }

    static {
        for (String string : themeNames = new String[]{Metacity.getUserTheme(), "blueprint", "Bluecurve", "Crux", "SwingFallbackTheme"}) {
            if (string != null) {
                try {
                    INSTANCE = new Metacity(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    Metacity.logError(string, iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    Metacity.logError(string, parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    Metacity.logError(string, sAXException);
                }
            }
            if (INSTANCE != null) break;
        }
        if (INSTANCE == null) {
            throw new Error("Could not find any installed metacity theme, and fallback failed");
        }
        errorLogged = false;
    }

    static class RoundRectClipShape
    extends RectangularShape {
        static final int TOP_LEFT = 1;
        static final int TOP_RIGHT = 2;
        static final int BOTTOM_LEFT = 4;
        static final int BOTTOM_RIGHT = 8;
        int x;
        int y;
        int width;
        int height;
        int arcwidth;
        int archeight;
        int corners;

        public RoundRectClipShape() {
        }

        public RoundRectClipShape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.setRoundedRect(n, n2, n3, n4, n5, n6, n7);
        }

        public void setRoundedRect(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.corners = n7;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.arcwidth = n5;
            this.archeight = n6;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public boolean isEmpty() {
            return false;
        }

        public Rectangle2D getBounds2D() {
            return null;
        }

        public int getCornerFlags() {
            return this.corners;
        }

        public void setFrame(double d, double d2, double d3, double d4) {
        }

        public boolean contains(double d, double d2) {
            return false;
        }

        private int classify(double d, double d2, double d3, double d4) {
            return 0;
        }

        public boolean intersects(double d, double d2, double d3, double d4) {
            return false;
        }

        public boolean contains(double d, double d2, double d3, double d4) {
            return false;
        }

        public PathIterator getPathIterator(AffineTransform affineTransform) {
            return new RoundishRectIterator(this, affineTransform);
        }

        static class RoundishRectIterator
        implements PathIterator {
            double x;
            double y;
            double w;
            double h;
            double aw;
            double ah;
            AffineTransform affine;
            int index;
            double[][] ctrlpts;
            int[] types;
            private static final double angle = 0.7853981633974483;
            private static final double a = 1.0 - Math.cos(0.7853981633974483);
            private static final double b = Math.tan(0.7853981633974483);
            private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
            private static final double cv = 1.3333333333333333 * a * b / c;
            private static final double acv = (1.0 - cv) / 2.0;
            private static final double[][] CtrlPtTemplate = new double[][]{{0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, 0.0, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
            private static final int[] CornerFlags = new int[]{4, 8, 2, 1};

            RoundishRectIterator(RoundRectClipShape roundRectClipShape, AffineTransform affineTransform) {
                this.x = roundRectClipShape.getX();
                this.y = roundRectClipShape.getY();
                this.w = roundRectClipShape.getWidth();
                this.h = roundRectClipShape.getHeight();
                this.aw = Math.min(this.w, Math.abs(roundRectClipShape.getArcWidth()));
                this.ah = Math.min(this.h, Math.abs(roundRectClipShape.getArcHeight()));
                this.affine = affineTransform;
                if (this.w < 0.0 || this.h < 0.0) {
                    this.ctrlpts = new double[0][];
                    this.types = new int[0];
                } else {
                    int n;
                    int n2 = roundRectClipShape.getCornerFlags();
                    int n3 = 5;
                    for (n = 1; n < 16; n <<= 1) {
                        if ((n2 & n) == 0) continue;
                        ++n3;
                    }
                    this.ctrlpts = new double[n3][];
                    this.types = new int[n3];
                    n = 0;
                    for (int i = 0; i < 4; ++i) {
                        this.types[n] = 1;
                        if ((n2 & CornerFlags[i]) == 0) {
                            this.ctrlpts[n++] = CtrlPtTemplate[i * 3 + 0];
                            continue;
                        }
                        this.ctrlpts[n++] = CtrlPtTemplate[i * 3 + 1];
                        this.types[n] = 3;
                        this.ctrlpts[n++] = CtrlPtTemplate[i * 3 + 2];
                    }
                    this.types[n] = 4;
                    this.ctrlpts[n++] = CtrlPtTemplate[12];
                    this.types[0] = 0;
                }
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.index >= this.ctrlpts.length;
            }

            public void next() {
                ++this.index;
            }

            public int currentSegment(float[] fArray) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                double[] dArray = this.ctrlpts[this.index];
                int n = 0;
                for (int i = 0; i < dArray.length; i += 4) {
                    fArray[n++] = (float)(this.x + dArray[i + 0] * this.w + dArray[i + 1] * this.aw);
                    fArray[n++] = (float)(this.y + dArray[i + 2] * this.h + dArray[i + 3] * this.ah);
                }
                if (this.affine != null) {
                    this.affine.transform(fArray, 0, fArray, 0, n / 2);
                }
                return this.types[this.index];
            }

            public int currentSegment(double[] dArray) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                double[] dArray2 = this.ctrlpts[this.index];
                int n = 0;
                for (int i = 0; i < dArray2.length; i += 4) {
                    dArray[n++] = this.x + dArray2[i + 0] * this.w + dArray2[i + 1] * this.aw;
                    dArray[n++] = this.y + dArray2[i + 2] * this.h + dArray2[i + 3] * this.ah;
                }
                if (this.affine != null) {
                    this.affine.transform(dArray, 0, dArray, 0, n / 2);
                }
                return this.types[this.index];
            }
        }
    }

    static class PeekableStringTokenizer
    extends StringTokenizer {
        String token = null;

        public PeekableStringTokenizer(String string, String string2, boolean bl) {
            super(string, string2, bl);
            this.peek();
        }

        public String peek() {
            if (this.token == null) {
                this.token = this.nextToken();
            }
            return this.token;
        }

        public boolean hasMoreTokens() {
            return this.token != null || super.hasMoreTokens();
        }

        public String nextToken() {
            if (this.token != null) {
                String string = this.token;
                this.token = null;
                if (this.hasMoreTokens()) {
                    this.peek();
                }
                return string;
            }
            String string = super.nextToken();
            while ((string.equals(" ") || string.equals("\t")) && this.hasMoreTokens()) {
                string = super.nextToken();
            }
            return string;
        }
    }

    class ArithmeticExpressionEvaluator {
        private PeekableStringTokenizer tokenizer;

        ArithmeticExpressionEvaluator() {
        }

        int evaluate(String string) {
            this.tokenizer = new PeekableStringTokenizer(string, " \t+-*/%()", true);
            return Math.round(this.expression());
        }

        int evaluate(String string, int n) {
            return string != null ? this.evaluate(string) : n;
        }

        public float expression() {
            float f = this.getTermValue();
            boolean bl = false;
            while (!bl && this.tokenizer.hasMoreTokens()) {
                String string = this.tokenizer.peek();
                if ("+".equals(string) || "-".equals(string) || "`max`".equals(string) || "`min`".equals(string)) {
                    this.tokenizer.nextToken();
                    float f2 = this.getTermValue();
                    if ("+".equals(string)) {
                        f += f2;
                        continue;
                    }
                    if ("-".equals(string)) {
                        f -= f2;
                        continue;
                    }
                    if ("`max`".equals(string)) {
                        f = Math.max(f, f2);
                        continue;
                    }
                    if (!"`min`".equals(string)) continue;
                    f = Math.min(f, f2);
                    continue;
                }
                bl = true;
            }
            return f;
        }

        public float getTermValue() {
            float f = this.getFactorValue();
            boolean bl = false;
            while (!bl && this.tokenizer.hasMoreTokens()) {
                String string = this.tokenizer.peek();
                if ("*".equals(string) || "/".equals(string) || "%".equals(string)) {
                    this.tokenizer.nextToken();
                    float f2 = this.getFactorValue();
                    if ("*".equals(string)) {
                        f *= f2;
                        continue;
                    }
                    if ("/".equals(string)) {
                        f /= f2;
                        continue;
                    }
                    f %= f2;
                    continue;
                }
                bl = true;
            }
            return f;
        }

        public float getFactorValue() {
            float f;
            if ("(".equals(this.tokenizer.peek())) {
                this.tokenizer.nextToken();
                f = this.expression();
                this.tokenizer.nextToken();
            } else {
                String string = this.tokenizer.nextToken();
                if (Character.isDigit(string.charAt(0))) {
                    f = Float.parseFloat(string);
                } else {
                    Integer n = (Integer)Metacity.this.variables.get(string);
                    if (n == null) {
                        n = (Integer)Metacity.this.getFrameGeometry().get(string);
                    }
                    if (n == null) {
                        Metacity.logError(Metacity.this.themeName, "Variable \"" + string + "\" not defined");
                        return 0.0f;
                    }
                    f = n != null ? (float)n.intValue() : 0.0f;
                }
            }
            return f;
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return null;
            }
            Dimension dimension = Metacity.this.calculateButtonSize(jComponent);
            Insets insets = (Insets)Metacity.this.getFrameGeometry().get("title_border");
            Insets insets2 = (Insets)Metacity.this.getFrameGeometry().get("button_border");
            int n3 = Metacity.this.getInt("left_titlebar_edge") + dimension.width + Metacity.this.getInt("right_titlebar_edge");
            if (insets != null) {
                n3 += insets.left + insets.right;
            }
            if (jInternalFrame.isClosable()) {
                n3 += dimension.width;
            }
            if (jInternalFrame.isMaximizable()) {
                n3 += dimension.width;
            }
            if (jInternalFrame.isIconifiable()) {
                n3 += dimension.width;
            }
            FontMetrics fontMetrics = jInternalFrame.getFontMetrics(jComponent.getFont());
            String string = jInternalFrame.getTitle();
            int n4 = string != null ? SwingUtilities2.stringWidth(jInternalFrame, fontMetrics, string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 3 ? (n3 += n4 < (n = SwingUtilities2.stringWidth(jInternalFrame, fontMetrics, string.substring(0, 3) + "...")) ? n4 : n) : (n3 += n4);
            n = fontMetrics.getHeight() + Metacity.this.getInt("title_vertical_pad");
            if (insets != null) {
                n += insets.top + insets.bottom;
            }
            int n6 = dimension.height;
            if (insets2 != null) {
                n6 += insets2.top + insets2.bottom;
            }
            int n7 = Math.max(n6, n);
            return new Dimension(n3, n7);
        }

        public void layoutContainer(Container container) {
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return;
            }
            Map map = Metacity.this.getFrameGeometry();
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            JComponent jComponent2 = Metacity.findChild(jComponent, "InternalFrameTitlePane.menuButton");
            JComponent jComponent3 = Metacity.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
            JComponent jComponent4 = Metacity.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
            JComponent jComponent5 = Metacity.findChild(jComponent, "InternalFrameTitlePane.closeButton");
            int n3 = 0;
            Insets insets = (Insets)map.get("button_border");
            Dimension dimension = Metacity.this.calculateButtonSize(jComponent);
            int n4 = Metacity.this.getInt("left_titlebar_edge");
            int n5 = insets != null ? insets.top : 0;
            jComponent2.setBounds(n4, n5, dimension.width, dimension.height);
            n4 = n - dimension.width - Metacity.this.getInt("right_titlebar_edge");
            if (insets != null) {
                n4 -= insets.right;
            }
            if (jInternalFrame.isClosable()) {
                jComponent5.setBounds(n4, n5, dimension.width, dimension.height);
                n4 -= dimension.width + n3;
            }
            if (jInternalFrame.isMaximizable()) {
                jComponent4.setBounds(n4, n5, dimension.width, dimension.height);
                n4 -= dimension.width + n3;
            }
            if (jInternalFrame.isIconifiable()) {
                jComponent3.setBounds(n4, n5, dimension.width, dimension.height);
            }
        }
    }

    private class ColorizeImageFilter
    extends RGBImageFilter {
        double cr;
        double cg;
        double cb;

        public ColorizeImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this.cr = (double)color.getRed() / 255.0;
            this.cg = (double)color.getGreen() / 255.0;
            this.cb = (double)color.getBlue() / 255.0;
        }

        public Image colorize(Image image, Color color) {
            this.setColor(color);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this);
            return new ImageIcon(Metacity.this.context.getComponent().createImage(filteredImageSource)).getImage();
        }

        public int filterRGB(int n, int n2, int n3) {
            double d;
            double d2;
            double d3;
            double d4 = (double)(2 * (n3 & 0xFF)) / 255.0;
            if (d4 <= 1.0) {
                d3 = this.cr * d4;
                d2 = this.cg * d4;
                d = this.cb * d4;
            } else {
                d3 = this.cr + (1.0 - this.cr) * (d4 -= 1.0);
                d2 = this.cg + (1.0 - this.cg) * d4;
                d = this.cb + (1.0 - this.cb) * d4;
            }
            return (n3 & 0xFF000000) + ((int)(d3 * 255.0) << 16) + ((int)(d2 * 255.0) << 8) + (int)(d * 255.0);
        }
    }

    private static class Privileged
    implements PrivilegedAction {
        private static int GET_THEME_DIR = 0;
        private static int GET_USER_THEME = 1;
        private static int GET_IMAGE = 2;
        private int type;
        private Object arg;

        private Privileged() {
        }

        public Object doPrivileged(int n, Object object) {
            this.type = n;
            this.arg = object;
            return AccessController.doPrivileged(this);
        }

        public Object run() {
            if (this.type == GET_THEME_DIR) {
                Serializable serializable;
                String string = File.separator;
                String[] stringArray = new String[]{userHome + string + ".themes", System.getProperty("swing.metacitythemedir"), "/usr/share/themes", "/usr/gnome/share/themes", "/opt/gnome2/share/themes"};
                URL uRL = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || !new File((File)(serializable = new File(stringArray[i] + string + this.arg + string + "metacity-1")), "metacity-theme-1.xml").canRead()) continue;
                    try {
                        uRL = ((File)serializable).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = null;
                    }
                    break;
                }
                if (uRL == null) {
                    String string2 = "resources/metacity/" + this.arg + "/metacity-1/metacity-theme-1.xml";
                    serializable = this.getClass().getResource(string2);
                    if (serializable != null) {
                        String string3 = ((URL)serializable).toString();
                        try {
                            uRL = new URL(string3.substring(0, string3.lastIndexOf(47)) + "/");
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                    }
                }
                return uRL;
            }
            if (this.type == GET_USER_THEME) {
                try {
                    String string;
                    int n;
                    int n2;
                    userHome = System.getProperty("user.home");
                    String string4 = System.getProperty("swing.metacitythemename");
                    if (string4 != null) {
                        return string4;
                    }
                    URL uRL = new URL(new File(userHome).toURL(), ".gconf/apps/metacity/general/%25gconf.xml");
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), "ISO-8859-1");
                    char[] cArray = new char[1024];
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n2 = inputStreamReader.read(cArray)) >= 0) {
                        stringBuffer.append(cArray, 0, n2);
                    }
                    ((Reader)inputStreamReader).close();
                    String string5 = stringBuffer.toString();
                    if (string5 != null && (n = (string = string5.toLowerCase()).indexOf("<entry name=\"theme\"")) >= 0 && (n = string.indexOf("<stringvalue>", n)) > 0) {
                        int n3 = string5.indexOf("<", n += "<stringvalue>".length());
                        return string5.substring(n, n3);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            if (this.type == GET_IMAGE) {
                return new ImageIcon((URL)this.arg).getImage();
            }
            return null;
        }
    }
}

