/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.presentation.rmi;

import com.sun.corba.se.impl.presentation.rmi.ExceptionHandler;
import com.sun.corba.se.impl.presentation.rmi.ExceptionHandlerImpl;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class DynamicMethodMarshallerImpl
implements DynamicMethodMarshaller {
    Method method;
    ExceptionHandler ehandler;
    boolean hasArguments = true;
    boolean hasVoidResult = true;
    boolean needsArgumentCopy;
    boolean needsResultCopy;
    ReaderWriter[] argRWs = null;
    ReaderWriter resultRW = null;
    private static ReaderWriter booleanRW = new ReaderWriterBase("boolean"){

        public java.lang.Object read(InputStream inputStream) {
            boolean bl = inputStream.read_boolean();
            return new Boolean(bl);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Boolean bl = (Boolean)object;
            outputStream.write_boolean(bl.booleanValue());
        }
    };
    private static ReaderWriter byteRW = new ReaderWriterBase("byte"){

        public java.lang.Object read(InputStream inputStream) {
            byte by = inputStream.read_octet();
            return new Byte(by);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Byte by = (Byte)object;
            outputStream.write_octet(by.byteValue());
        }
    };
    private static ReaderWriter charRW = new ReaderWriterBase("char"){

        public java.lang.Object read(InputStream inputStream) {
            char c = inputStream.read_wchar();
            return new Character(c);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Character c = (Character)object;
            outputStream.write_wchar(c.charValue());
        }
    };
    private static ReaderWriter shortRW = new ReaderWriterBase("short"){

        public java.lang.Object read(InputStream inputStream) {
            short s = inputStream.read_short();
            return new Short(s);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Short s = (Short)object;
            outputStream.write_short(s.shortValue());
        }
    };
    private static ReaderWriter intRW = new ReaderWriterBase("int"){

        public java.lang.Object read(InputStream inputStream) {
            int n = inputStream.read_long();
            return new Integer(n);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Integer n = (Integer)object;
            outputStream.write_long(n.intValue());
        }
    };
    private static ReaderWriter longRW = new ReaderWriterBase("long"){

        public java.lang.Object read(InputStream inputStream) {
            long l = inputStream.read_longlong();
            return new Long(l);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Long l = (Long)object;
            outputStream.write_longlong(l.longValue());
        }
    };
    private static ReaderWriter floatRW = new ReaderWriterBase("float"){

        public java.lang.Object read(InputStream inputStream) {
            float f = inputStream.read_float();
            return new Float(f);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Float f = (Float)object;
            outputStream.write_float(f.floatValue());
        }
    };
    private static ReaderWriter doubleRW = new ReaderWriterBase("double"){

        public java.lang.Object read(InputStream inputStream) {
            double d = inputStream.read_double();
            return new Double(d);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Double d = (Double)object;
            outputStream.write_double(d.doubleValue());
        }
    };
    private static ReaderWriter corbaObjectRW = new ReaderWriterBase("org.omg.CORBA.Object"){

        public java.lang.Object read(InputStream inputStream) {
            return inputStream.read_Object();
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            outputStream.write_Object((Object)object);
        }
    };
    private static ReaderWriter anyRW = new ReaderWriterBase("any"){

        public java.lang.Object read(InputStream inputStream) {
            return Util.readAny((org.omg.CORBA.portable.InputStream)inputStream);
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)outputStream, (java.lang.Object)object);
        }
    };
    private static ReaderWriter abstractInterfaceRW = new ReaderWriterBase("abstract_interface"){

        public java.lang.Object read(InputStream inputStream) {
            return inputStream.read_abstract_interface();
        }

        public void write(OutputStream outputStream, java.lang.Object object) {
            Util.writeAbstractObject((org.omg.CORBA.portable.OutputStream)outputStream, (java.lang.Object)object);
        }
    };

    private static boolean isAnyClass(Class clazz) {
        return clazz.equals(java.lang.Object.class) || clazz.equals(Serializable.class) || clazz.equals(Externalizable.class);
    }

    private static boolean isAbstractInterface(Class clazz) {
        if (IDLEntity.class.isAssignableFrom(clazz)) {
            return clazz.isInterface();
        }
        return clazz.isInterface() && DynamicMethodMarshallerImpl.allMethodsThrowRemoteException(clazz);
    }

    private static boolean allMethodsThrowRemoteException(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getDeclaringClass() == java.lang.Object.class || DynamicMethodMarshallerImpl.throwsRemote(method)) continue;
            return false;
        }
        return true;
    }

    private static boolean throwsRemote(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (!RemoteException.class.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static ReaderWriter makeReaderWriter(final Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return booleanRW;
        }
        if (clazz.equals(Byte.TYPE)) {
            return byteRW;
        }
        if (clazz.equals(Character.TYPE)) {
            return charRW;
        }
        if (clazz.equals(Short.TYPE)) {
            return shortRW;
        }
        if (clazz.equals(Integer.TYPE)) {
            return intRW;
        }
        if (clazz.equals(Long.TYPE)) {
            return longRW;
        }
        if (clazz.equals(Float.TYPE)) {
            return floatRW;
        }
        if (clazz.equals(Double.TYPE)) {
            return doubleRW;
        }
        if (Remote.class.isAssignableFrom(clazz)) {
            return new ReaderWriterBase("remote(" + clazz.getName() + ")"){

                public java.lang.Object read(InputStream inputStream) {
                    return PortableRemoteObject.narrow(inputStream.read_Object(), clazz);
                }

                public void write(OutputStream outputStream, java.lang.Object object) {
                    Util.writeRemoteObject((org.omg.CORBA.portable.OutputStream)outputStream, (java.lang.Object)object);
                }
            };
        }
        if (clazz.equals(Object.class)) {
            return corbaObjectRW;
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return new ReaderWriterBase("org.omg.CORBA.Object(" + clazz.getName() + ")"){

                public java.lang.Object read(InputStream inputStream) {
                    return inputStream.read_Object(clazz);
                }

                public void write(OutputStream outputStream, java.lang.Object object) {
                    outputStream.write_Object((Object)object);
                }
            };
        }
        if (DynamicMethodMarshallerImpl.isAnyClass(clazz)) {
            return anyRW;
        }
        if (DynamicMethodMarshallerImpl.isAbstractInterface(clazz)) {
            return abstractInterfaceRW;
        }
        return new ReaderWriterBase("value(" + clazz.getName() + ")"){

            public java.lang.Object read(InputStream inputStream) {
                return inputStream.read_value(clazz);
            }

            public void write(OutputStream outputStream, java.lang.Object object) {
                outputStream.write_value((Serializable)object, clazz);
            }
        };
    }

    public DynamicMethodMarshallerImpl(Method method) {
        this.method = method;
        this.ehandler = new ExceptionHandlerImpl(method.getExceptionTypes());
        this.needsArgumentCopy = false;
        Class<?>[] classArray = method.getParameterTypes();
        boolean bl = this.hasArguments = classArray.length > 0;
        if (this.hasArguments) {
            this.argRWs = new ReaderWriter[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isPrimitive()) {
                    this.needsArgumentCopy = true;
                }
                this.argRWs[i] = DynamicMethodMarshallerImpl.makeReaderWriter(classArray[i]);
            }
        }
        Class<?> clazz = method.getReturnType();
        this.needsResultCopy = false;
        this.hasVoidResult = clazz.equals(Void.TYPE);
        if (!this.hasVoidResult) {
            this.needsResultCopy = !clazz.isPrimitive();
            this.resultRW = DynamicMethodMarshallerImpl.makeReaderWriter(clazz);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public java.lang.Object[] copyArguments(java.lang.Object[] objectArray, ORB oRB) throws RemoteException {
        if (this.needsArgumentCopy) {
            return Util.copyObjects((java.lang.Object[])objectArray, (org.omg.CORBA.ORB)oRB);
        }
        return objectArray;
    }

    public java.lang.Object[] readArguments(InputStream inputStream) {
        java.lang.Object[] objectArray = null;
        if (this.hasArguments) {
            objectArray = new java.lang.Object[this.argRWs.length];
            for (int i = 0; i < this.argRWs.length; ++i) {
                objectArray[i] = this.argRWs[i].read(inputStream);
            }
        }
        return objectArray;
    }

    public void writeArguments(OutputStream outputStream, java.lang.Object[] objectArray) {
        if (this.hasArguments) {
            if (objectArray.length != this.argRWs.length) {
                throw new IllegalArgumentException("Expected " + this.argRWs.length + " arguments, but got " + objectArray.length + " arguments.");
            }
            for (int i = 0; i < this.argRWs.length; ++i) {
                this.argRWs[i].write(outputStream, objectArray[i]);
            }
        }
    }

    public java.lang.Object copyResult(java.lang.Object object, ORB oRB) throws RemoteException {
        if (this.needsResultCopy) {
            return Util.copyObject((java.lang.Object)object, (org.omg.CORBA.ORB)oRB);
        }
        return object;
    }

    public java.lang.Object readResult(InputStream inputStream) {
        if (this.hasVoidResult) {
            return null;
        }
        return this.resultRW.read(inputStream);
    }

    public void writeResult(OutputStream outputStream, java.lang.Object object) {
        if (!this.hasVoidResult) {
            this.resultRW.write(outputStream, object);
        }
    }

    public boolean isDeclaredException(Throwable throwable) {
        return this.ehandler.isDeclaredException(throwable.getClass());
    }

    public void writeException(OutputStream outputStream, Exception exception) {
        this.ehandler.writeException(outputStream, exception);
    }

    public Exception readException(ApplicationException applicationException) {
        return this.ehandler.readException(applicationException);
    }

    static abstract class ReaderWriterBase
    implements ReaderWriter {
        String name;

        public ReaderWriterBase(String string) {
            this.name = string;
        }

        public String toString() {
            return "ReaderWriter[" + this.name + "]";
        }
    }

    public static interface ReaderWriter {
        public java.lang.Object read(InputStream var1);

        public void write(OutputStream var1, java.lang.Object var2);
    }
}

