/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import com.ibm.security.bootstrap.DigestBase;

public final class SHA
extends DigestBase {
    private final int[] W;
    private final int[] state;
    private final byte[] bits;
    private final int[] intBits;
    private static final int round1_kt = 1518500249;
    private static final int round2_kt = 1859775393;
    private static final int round3_kt = -1894007588;
    private static final int round4_kt = -899497514;

    public SHA() {
        super("SHA-1", 20, 64);
        this.state = new int[5];
        this.W = new int[80];
        this.bits = new byte[8];
        this.intBits = new int[2];
        this.implReset();
    }

    private SHA(SHA sHA) {
        super(sHA);
        this.state = (int[])sHA.state.clone();
        this.W = new int[80];
        this.bits = new byte[8];
        this.intBits = new int[2];
    }

    public Object clone() {
        return new SHA(this);
    }

    void implReset() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
    }

    void implDigest(byte[] byArray, int n) {
        long l = this.bytesProcessed << 3;
        int n2 = (int)this.bytesProcessed & 0x3F;
        int n3 = n2 < 56 ? 56 - n2 : 120 - n2;
        this.engineUpdate(padding, 0, n3);
        this.intBits[1] = (int)l;
        this.intBits[0] = (int)(l >> 32);
        SHA.i2bBig(this.intBits, 0, this.bits, 0, 8);
        this.engineUpdate(this.bits, 0, this.bits.length);
        SHA.i2bBig(this.state, 0, byArray, n, 20);
    }

    void implCompress(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        SHA.b2iBig(byArray, n, this.W, 0, 64);
        for (n5 = 16; n5 <= 79; ++n5) {
            n4 = this.W[n5 - 3] ^ this.W[n5 - 8] ^ this.W[n5 - 14] ^ this.W[n5 - 16];
            this.W[n5] = n4 << 1 | n4 >>> 31;
        }
        n5 = this.state[0];
        n4 = this.state[1];
        int n6 = this.state[2];
        int n7 = this.state[3];
        int n8 = this.state[4];
        for (n3 = 0; n3 < 20; ++n3) {
            n2 = (n5 << 5 | n5 >>> 27) + (n4 & n6 | ~n4 & n7) + n8 + this.W[n3] + 1518500249;
            n8 = n7;
            n7 = n6;
            n6 = n4 << 30 | n4 >>> 2;
            n4 = n5;
            n5 = n2;
        }
        for (n3 = 20; n3 < 40; ++n3) {
            n2 = (n5 << 5 | n5 >>> 27) + (n4 ^ n6 ^ n7) + n8 + this.W[n3] + 1859775393;
            n8 = n7;
            n7 = n6;
            n6 = n4 << 30 | n4 >>> 2;
            n4 = n5;
            n5 = n2;
        }
        for (n3 = 40; n3 < 60; ++n3) {
            n2 = (n5 << 5 | n5 >>> 27) + (n4 & n6 | n4 & n7 | n6 & n7) + n8 + this.W[n3] + -1894007588;
            n8 = n7;
            n7 = n6;
            n6 = n4 << 30 | n4 >>> 2;
            n4 = n5;
            n5 = n2;
        }
        for (n3 = 60; n3 < 80; ++n3) {
            n2 = (n5 << 5 | n5 >>> 27) + (n4 ^ n6 ^ n7) + n8 + this.W[n3] + -899497514;
            n8 = n7;
            n7 = n6;
            n6 = n4 << 30 | n4 >>> 2;
            n4 = n5;
            n5 = n2;
        }
        this.state[0] = this.state[0] + n5;
        this.state[1] = this.state[1] + n4;
        this.state[2] = this.state[2] + n6;
        this.state[3] = this.state[3] + n7;
        this.state[4] = this.state[4] + n8;
    }
}

