/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.module;

import com.ibm.security.auth.LinuxNumericGroupPrincipal;
import com.ibm.security.auth.LinuxNumericUserPrincipal;
import com.ibm.security.auth.LinuxPrincipal;
import com.ibm.security.auth.module.LinuxSystem;
import java.security.Principal;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = true;
    private LinuxSystem system;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private LinuxPrincipal userPrincipal;
    private LinuxNumericUserPrincipal uidPrincipal;
    private LinuxNumericGroupPrincipal gidPrincipal;
    private LinkedList supplementaryGroups = new LinkedList();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        int n;
        long[] lArray = null;
        this.succeeded = false;
        this.system = new LinuxSystem();
        if (this.system == null) {
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule] Failed in Linux login");
            }
            throw new FailedLoginException("Failed in attempt to import the underlying Linux system identity information");
        }
        if (this.debug) {
            System.out.println("\t\t[LinuxLoginModule]: succeeded importing info: ");
            System.out.println("\t\t\tuser     = " + this.system.getUsername());
            System.out.println("\t\t\tuser id  = " + this.system.getUid());
            System.out.println("\t\t\tgroup id = " + this.system.getGid());
            lArray = this.system.getGroups();
            for (n = 0; n < lArray.length; ++n) {
                System.out.println("\t\t\tsupp gid = " + lArray[n]);
            }
        }
        this.userPrincipal = new LinuxPrincipal(this.system.getUsername());
        this.uidPrincipal = new LinuxNumericUserPrincipal(this.system.getUid());
        this.gidPrincipal = new LinuxNumericGroupPrincipal(this.system.getGid(), true);
        if (this.system.getGroups() != null && this.system.getGroups().length > 0) {
            lArray = this.system.getGroups();
        }
        for (n = 0; n < lArray.length; ++n) {
            LinuxNumericGroupPrincipal linuxNumericGroupPrincipal = new LinuxNumericGroupPrincipal(lArray[n], false);
            if (linuxNumericGroupPrincipal.getName().equals(this.gidPrincipal.getName())) continue;
            this.supplementaryGroups.add(linuxNumericGroupPrincipal);
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.userPrincipal)) {
            set.add(this.userPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule]: added LinuxPrincipal");
            }
        }
        if (!set.contains(this.uidPrincipal)) {
            set.add(this.uidPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule]: added LinuxNumericUserPrincipal");
            }
        }
        if (!set.contains(this.gidPrincipal)) {
            set.add(this.gidPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LinuxLoginModule]: added LinuxNumericGroupPrincipal");
            }
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (set.contains((LinuxNumericGroupPrincipal)this.supplementaryGroups.get(i))) continue;
            set.add((LinuxNumericGroupPrincipal)this.supplementaryGroups.get(i));
            if (!this.debug) continue;
            System.out.println("\t\t[LinuxLoginModule]: added LinuxNumericGroupPrincipal");
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[LinuxLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.system = null;
            this.succeeded = false;
            this.userPrincipal = null;
            this.uidPrincipal = null;
            this.gidPrincipal = null;
            this.supplementaryGroups = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        set.remove(this.userPrincipal);
        set.remove(this.uidPrincipal);
        set.remove(this.gidPrincipal);
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            set.remove((LinuxNumericGroupPrincipal)this.supplementaryGroups.get(i));
        }
        this.system = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.uidPrincipal = null;
        this.gidPrincipal = null;
        this.supplementaryGroups = null;
        if (this.debug) {
            System.out.println("\t\t[LinuxLoginModule]: logged out Subject");
        }
        return true;
    }
}

