/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth;

import java.io.Serializable;
import java.security.Principal;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public final class LdapPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 6820120005580754861L;
    private final String nameString;
    private final LdapName name;

    public LdapPrincipal(String string) throws InvalidNameException {
        if (string == null) {
            throw new NullPointerException("null name is illegal");
        }
        this.name = this.getLdapName(string);
        this.nameString = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LdapPrincipal) {
            try {
                return this.name.equals(this.getLdapName(((LdapPrincipal)object).getName()));
            }
            catch (InvalidNameException invalidNameException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.nameString;
    }

    public String toString() {
        return this.name.toString();
    }

    private LdapName getLdapName(String string) throws InvalidNameException {
        return new LdapName(string);
    }
}

