/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.misc.Resources;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Pattern;

public class CheckClassPath {
    private static final boolean debugOn;
    private static final boolean checkOn;
    private static final String javaHome;
    private static String javaHomeCanonical;

    public static void checkClassPathEntries(File[] fileArray, String string, PrintStream printStream) {
        if (checkOn) {
            CheckClassPath.checkCPLocations(fileArray, string, printStream);
        }
    }

    private static void checkCPLocations(File[] fileArray, String string, PrintStream printStream) {
        String string2 = null;
        string2 = "sun.boot.class.path".equals(string) ? "the boot class path" : string;
        if (debugOn) {
            printStream.println("XCPC - For " + string2 + ", the Files in the Path are:-");
            for (File file : fileArray) {
                printStream.println(".......... \"" + file.getPath() + "\"");
            }
        }
        for (File file : fileArray) {
            if (debugOn) {
                printStream.println("File to check = \"" + file.getPath() + "\"");
            }
            try {
                File file2 = file.getCanonicalFile();
                String string3 = file2.getPath();
                String string4 = file.getPath();
                String string5 = "\".";
                if (string4 != null && !string4.equals(string3)) {
                    string5 = "\" [\"" + string3 + "\"].";
                }
                if (!file2.exists()) {
                    if (new File(javaHomeCanonical + File.separator + ".." + File.separator + "classes").getCanonicalFile().equals(file2)) continue;
                    printStream.println(Resources.getText("classpath.warning1", string2, string4, string5));
                    continue;
                }
                if (file2.canRead()) continue;
                printStream.println(Resources.getText("classpath.warning2", string2, string4, string5));
            }
            catch (IOException iOException) {
                printStream.println(Resources.getText("classpath.warning3", string2, file.getPath()));
            }
        }
    }

    public static void checkClassPathEntries(String[] stringArray, String string, PrintStream printStream) {
        if (checkOn) {
            CheckClassPath.checkCPEntries(stringArray, string, printStream);
        }
    }

    private static void checkCPEntries(String[] stringArray, String string, PrintStream printStream) {
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        CheckClassPath.checkCPLocations(fileArray, string, printStream);
    }

    public static void checkClassPath(String string, String string2, PrintStream printStream) {
        if (checkOn) {
            CheckClassPath.checkCP(string, string2, printStream);
        }
    }

    private static void checkCP(String string, String string2, PrintStream printStream) {
        String[] stringArray = string.split(Pattern.quote(File.pathSeparator));
        CheckClassPath.checkCPEntries(stringArray, string2, printStream);
    }

    public static void checkClassPathProperty(String string, PrintStream printStream) {
        if (checkOn) {
            CheckClassPath.checkCPProperty(string, printStream);
        }
    }

    private static void checkCPProperty(String string, PrintStream printStream) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            CheckClassPath.checkCP(string2, string, printStream);
        }
    }

    public static void main(String[] stringArray) {
        File[] fileArray = new File[]{new File("c:\test"), new File(".")};
        System.out.println("XCPC - main... About to call checkClassPathEntries()");
        CheckClassPath.checkClassPathEntries(fileArray, "testClassPath", System.out);
        System.out.println("XCPC - main... Done call checkClassPathEntries()");
    }

    static {
        javaHome = System.getProperty("java.home");
        String string = System.getProperty("com.ibm.jcl.checkClassPath");
        String string2 = System.getProperty("com.ibm.jcl.debugClassPath");
        checkOn = "true".equalsIgnoreCase(string);
        debugOn = "true".equalsIgnoreCase(string2);
        try {
            if (checkOn) {
                javaHomeCanonical = new File(javaHome).getCanonicalPath();
                CheckClassPath.checkCPProperty("sun.boot.class.path", System.err);
                CheckClassPath.checkCPProperty("java.endorsed.dirs", System.err);
            }
        }
        catch (Throwable throwable) {
            RuntimeException runtimeException = new RuntimeException("Unexpected exception occurred during boot classpath checking.", throwable);
            runtimeException.printStackTrace();
        }
    }
}

