/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.QMTreeException;
import java.util.ArrayList;
import java.util.Collection;

class TreeElt {
    private Collection children = new ArrayList();
    private TreeElt parent = null;
    private Object element = null;

    public TreeElt() {
        this(null, null);
    }

    public TreeElt(TreeElt parent) {
        this(parent, null);
    }

    public TreeElt(TreeElt parent, Object element) {
        this.parent = parent;
        this.element = element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(TreeElt child) throws QMTreeException {
        Collection collection = this.children;
        synchronized (collection) {
            if (child == null) {
                throw new QMTreeException();
            }
            this.children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(TreeElt child) throws QMTreeException {
        Collection collection = this.children;
        synchronized (collection) {
            if (this.isExternal() && !this.isRoot()) {
                throw new QMTreeException("no children");
            }
            if (!this.children.contains(child)) {
                throw new QMTreeException();
            }
            this.children.remove(child);
        }
    }

    public Collection children() {
        return this.children;
    }

    public TreeElt getParent() {
        return this.parent;
    }

    void setParent(TreeElt parent) {
        this.parent = parent;
    }

    public Object getElement() {
        return this.element;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int depth() {
        int depth = 0;
        Collection collection = this.children;
        synchronized (collection) {
            TreeElt elt = this;
            while (!elt.isRoot()) {
                ++depth;
                elt = elt.getParent();
            }
        }
        return depth;
    }

    public boolean isEmpty() {
        return this.element == null;
    }

    public boolean isInternal() {
        return this.parent != null && this.children.size() != 0;
    }

    public boolean isExternal() {
        return !this.isInternal();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        boolean isEqual = false;
        Collection collection = this.children;
        synchronized (collection) {
            TreeElt t;
            if (o instanceof TreeElt && (t = (TreeElt)o).getParent() == this.parent && t.getElement() == this.element && t.children() == this.children) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public String toString() {
        return this.element != null ? this.element.toString() : "null element";
    }
}

