/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionEventListener;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSimpleConnectionManager;
import com.ibm.mq.ManagedConnectionStore;
import com.ibm.mq.Pint;
import com.ibm.mq.PoolScavenger;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.handles.Phconn;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

class StoredManagedConnection
extends JmqiObject
implements MQConnectionEventListener {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/StoredManagedConnection.java, java.classes, k700, k700-L080529 1.31.1.1 08/06/01 09:03:41";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    MQManagedConnectionJ11 mqManCon;
    ManagedConnectionStore pool;
    PoolScavenger scavenger;
    MQManagedConnectionFactory mqMcf;
    MQSimpleConnectionManager owner;
    ConnectionRequestInfo cxReqInf;
    boolean inuse = false;
    boolean poolActive = false;
    boolean destroyMark = false;

    StoredManagedConnection(MQManagedConnectionFactory mqMcf, ConnectionRequestInfo cxReqInf, ManagedConnectionStore pool, PoolScavenger scavenger, MQSimpleConnectionManager owner) throws ResourceException {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 488;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 488, new Object[]{mqMcf, cxReqInf, pool, scavenger, owner});
        }
        this.pool = pool;
        this.scavenger = scavenger;
        this.mqMcf = mqMcf;
        this.cxReqInf = cxReqInf;
        this.owner = owner;
        this.mqManCon = mqMcf.createManagedConnection(cxReqInf);
        this.inuse = true;
        this.mqManCon.addMQConnectionEventListener(this);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 488);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean use() {
        int traceContext = 0;
        int fid = 489;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 489);
        }
        StoredManagedConnection storedManagedConnection = this;
        synchronized (storedManagedConnection) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 489, "use - owns synclock", (Object)"");
            }
            if (!this.inuse) {
                this.inuse = true;
                this.pool.deregister(this);
                this.scavenger.deregister(this);
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 489, (Object)true, 1);
                }
                return true;
            }
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 489, (Object)false, 2);
            }
            return false;
        }
    }

    void initializePoolActive(boolean active) {
        int traceContext = 0;
        int fid = 490;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 490, new Object[]{active});
        }
        this.poolActive = active;
        this.owner.addStoredManagedConnection(this);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 490);
        }
    }

    synchronized void poolActive(boolean active) {
        int traceContext = 0;
        int fid = 491;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 491, new Object[]{active});
        }
        this.poolActive = active;
        if (!active && !this.inuse) {
            this.destroyMark = true;
            this.pool.deregister(this);
            this.scavenger.deregister(this);
            this.inuse = true;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 491);
        }
    }

    void destroyIfMarked() {
        int traceContext = 0;
        int fid = 492;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 492);
        }
        if (this.destroyMark) {
            this.destroy();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 492);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trigger() {
        int traceContext = 0;
        int fid = 493;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 493);
        }
        boolean act = false;
        StoredManagedConnection storedManagedConnection = this;
        synchronized (storedManagedConnection) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 493, "trigger owns synclock", (Object)"");
            }
            if (!this.inuse) {
                act = true;
                this.pool.deregister(this);
                this.scavenger.deregister(this);
                this.inuse = true;
            }
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 493, "trigger releasing synclock", (Object)"");
            }
        }
        if (act) {
            this.destroy();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 493);
        }
    }

    void quiesce() throws MQException {
        int traceContext;
        block6: {
            traceContext = 0;
            int fid = 494;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 494);
            }
            MQManagedConnectionJ11 mqManCon = this.mqManCon;
            this.owner.removeStoredManagedConnection(this);
            mqManCon.removeMQConnectionEventListener(this);
            try {
                mqManCon.destroy();
            }
            catch (ResourceException re) {
                Exception e;
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 494, (Throwable)re);
                }
                if (!((e = re.getLinkedException()) instanceof MQException)) break block6;
                mqManCon.addMQConnectionEventListener(this);
                this.owner.addStoredManagedConnection(this);
                MQException traceRet1 = (MQException)((Object)e);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 494, (Throwable)traceRet1);
                }
                throw traceRet1;
            }
        }
        this.mqManCon = null;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 494);
        }
    }

    void destroy() {
        MQManagedConnectionJ11 mqManCon;
        int traceContext = 0;
        int fid = 495;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 495);
        }
        if ((mqManCon = this.mqManCon) != null) {
            block5: {
                this.owner.removeStoredManagedConnection(this);
                mqManCon.removeMQConnectionEventListener(this);
                try {
                    mqManCon.destroy();
                }
                catch (ResourceException re) {
                    if (!this.trace.isOn) break block5;
                    this.trace.catchBlock((Object)this, COMP_JN, 495, (Throwable)re);
                }
            }
            this.mqManCon = null;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 495);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(MQManagedConnectionJ11 mqManCon, MQQueueManager qm) {
        int traceContext;
        block25: {
            traceContext = 0;
            int fid = 496;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 496, new Object[]{mqManCon, qm});
            }
            qm.setExceptionForDisconnect(null);
            boolean alreadyQuiesced = false;
            try {
                MQSESSION session = mqManCon.getMQSESSION();
                Phconn hConn = mqManCon.getHConn();
                Pint cc = new Pint();
                Pint rc = new Pint();
                session.MQCMIT(hConn.getHconn(), cc, rc);
                if (cc.x == 2 && rc.x == 2012) {
                    cc.x = 0;
                    rc.x = 0;
                }
                if (cc.x == 2) {
                    MQException traceRet1 = new MQException(cc.x, rc.x, (Object)this, session.getLastJmqiException());
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 496, (Throwable)traceRet1, 1);
                    }
                    throw traceRet1;
                }
                mqManCon.cleanup();
                StoredManagedConnection traceRet1 = this;
                synchronized (traceRet1) {
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 496, "connectionClosed owns synclock", (Object)"");
                    }
                    if (this.poolActive) {
                        this.inuse = false;
                        this.pool.register(this);
                        this.scavenger.register(this);
                    } else {
                        this.quiesce();
                        alreadyQuiesced = true;
                    }
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 496, "connectionClosed releasing synclock", (Object)"");
                    }
                }
                if (cc.x == 1) {
                    MQException traceRet2 = new MQException(cc.x, rc.x, (Object)this, session.getLastJmqiException());
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 496, (Throwable)traceRet2, 2);
                    }
                    throw traceRet2;
                }
            }
            catch (ResourceException re) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 496, (Throwable)re, 1);
                }
                try {
                    this.quiesce();
                }
                catch (MQException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 496, (Throwable)e, 2);
                    }
                    qm.setExceptionForDisconnect(e);
                }
            }
            catch (MQException mqe) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 496, (Throwable)mqe, 3);
                }
                qm.setExceptionForDisconnect(mqe);
                try {
                    if (!alreadyQuiesced) {
                        this.quiesce();
                    }
                }
                catch (MQException mqe2) {
                    if (!this.trace.isOn) break block25;
                    this.trace.catchBlock((Object)this, COMP_JN, 496, (Throwable)mqe2, 4);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 496);
        }
    }

    public synchronized void connectionErrorOccurred(MQManagedConnectionJ11 mqManCon, MQQueueManager qm, Exception ex) {
        int traceContext = 0;
        int fid = 497;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 497, new Object[]{mqManCon, qm, ex});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 497);
        }
    }
}

