/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.JmqiTraceHandlerAdapter;
import java.io.IOException;

class MQS390FloatSupport
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQS390FloatSupport.java, java.classes, k700, k700-L080529 1.32.1.1 08/06/01 09:00:25";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQS90FloatSupport";
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_MANTISSA_MSB_MASK = 0x10000000000000L;
    private static final long DOUBLE_BIAS = 1022L;
    private static final int S390_DOUBLE_BIAS = 64;
    private static final long S390_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long S390_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;
    private static JmqiEnvironment jmqiEnv = MQSESSION.getJmqiEnv();
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int FLOAT_BIAS = 126;
    private static final int S390_FLOAT_BIAS = 64;
    private static final int S390_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int S390_FLOAT_MANTISSA_MASK = 0xFFFFFF;

    public MQS390FloatSupport() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 385;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 385);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 385);
        }
    }

    protected static final long doubleToS390LongBits(double ieeeDouble, JmqiTraceHandlerAdapter trace) throws IOException {
        long quotient;
        boolean positive;
        int traceContext = 0;
        int fid = 386;
        if (trace.isOn) {
            traceContext = trace.entry_OO(COMP_JN, 386, new Object[]{new Double(ieeeDouble), trace});
        }
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)"sccsid = @(#) com.ibm.mq/src/com/ibm/mq/MQS390FloatSupport.java, java.classes, k700, k700-L080529 1.32.1.1 08/06/01 09:00:25");
        }
        long ieeeLongBits = Double.doubleToLongBits(ieeeDouble);
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("IEEE double bit pattern= " + Long.toString(ieeeLongBits, 16)));
        }
        boolean bl = positive = (ieeeLongBits & Long.MIN_VALUE) == 0L;
        if ((ieeeLongBits & Long.MAX_VALUE) == 0L) {
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 386, (Object)new Long(ieeeLongBits), 1);
            }
            return ieeeLongBits;
        }
        long exponent = ieeeLongBits & 0x7FF0000000000000L;
        exponent >>>= 52;
        long mantissa = ieeeLongBits & 0xFFFFFFFFFFFFFL;
        long remainder = Math.abs(exponent -= 1022L) % 4L;
        long s390Exponent = quotient = Math.abs(exponent) / 4L;
        if (exponent > 0L && remainder != 0L) {
            ++s390Exponent;
        }
        if (exponent < 0L) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64L;
        long s390Mantissa = mantissa;
        s390Mantissa = exponent > -1022L ? (s390Mantissa |= 0x10000000000000L) : (s390Mantissa <<= 1);
        s390Mantissa <<= 3;
        if (remainder > 0L) {
            if (exponent > 0L) {
                int shift_places = (int)(4L - remainder);
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -1022L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                s390Mantissa >>>= (int)remainder;
            }
        }
        if (exponent == -1022L) {
            while (s390Mantissa != 0L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        if (s390Exponent > 127L) {
            if (trace.isOn) {
                trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("Exponent = " + s390Exponent));
            }
            IOException traceRet1 = new IOException("Number outside of range for double precision S/390 Float");
            if (trace.isOn) {
                trace.throwing(COMP_JN, 386, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (s390Exponent < 0L) {
            if (trace.isOn) {
                trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)"Number too small to represent, rounding to zero");
            }
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 386, (Object)new Long(0L), 2);
            }
            return 0L;
        }
        long s390Double = 0L;
        long s390ExponentBits = s390Exponent & 0x7FL;
        s390Double = s390ExponentBits << 56;
        if (!positive) {
            s390Double |= Long.MIN_VALUE;
        }
        s390Double |= s390Mantissa;
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("S390 bit pattern = " + Long.toString(s390Double, 16)));
        }
        if (trace.isOn) {
            trace.exit(traceContext, COMP_JN, 386, (Object)new Long(s390Double), 3);
        }
        return s390Double;
    }

    protected static final double longS390BitsToDouble(long doubleBits, JmqiTraceHandlerAdapter trace) throws IOException {
        boolean positive;
        int traceContext = 0;
        int fid = 387;
        if (trace.isOn) {
            traceContext = trace.entry_OO(COMP_JN, 387, new Object[]{new Long(doubleBits), trace});
        }
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)"sccsid=@(#) com.ibm.mq/src/com/ibm/mq/MQS390FloatSupport.java, java.classes, k700, k700-L080529 1.32.1.1 08/06/01 09:00:25");
        }
        trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("S390 bit pattern = " + Long.toString(doubleBits, 16)));
        boolean bl = positive = (doubleBits & Long.MIN_VALUE) == 0L;
        if ((doubleBits & Long.MAX_VALUE) == 0L) {
            if (positive) {
                if (trace.isOn) {
                    trace.exit(traceContext, COMP_JN, 387, (Object)new Double(0.0), 1);
                }
                return 0.0;
            }
            double traceRet1 = -0.0;
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 387, (Object)new Double(traceRet1), 2);
            }
            return traceRet1;
        }
        long mantissa = doubleBits & 0xFFFFFFFFFFFFFFL;
        long exponent = doubleBits & 0x7F00000000000000L;
        exponent >>= 56;
        long ieeeExponent = (exponent -= 64L) * 4L;
        long ieeeMantissa = mantissa;
        ieeeMantissa >>= 3;
        if (ieeeExponent <= -1022L) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -1022L) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0L && (ieeeMantissa & 0x10000000000000L) == 0L && ieeeExponent > -1022L) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -1045L) {
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 387, (Object)new Double(0.0), 3);
            }
            return 0.0;
        }
        if (ieeeExponent > 1024L) {
            if (positive) {
                if (trace.isOn) {
                    trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)"overflow - returning +INFINITY");
                }
                double traceRet2 = Double.POSITIVE_INFINITY;
                if (trace.isOn) {
                    trace.exit(traceContext, COMP_JN, 387, (Object)new Double(traceRet2), 4);
                }
                return traceRet2;
            }
            if (trace.isOn) {
                trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)"overflow - returning -INFINITY");
            }
            double traceRet3 = Double.NEGATIVE_INFINITY;
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 387, (Object)new Double(traceRet3), 5);
            }
            return traceRet3;
        }
        long ieeeBits = 0L;
        if (!positive) {
            ieeeBits |= Long.MIN_VALUE;
        }
        ieeeExponent += 1022L;
        ieeeBits |= (ieeeExponent <<= 52);
        ieeeBits |= (ieeeMantissa &= 0xFFFFFFFFFFFFFL);
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("IEEE bit pattern = " + Long.toString(ieeeBits, 16)));
        }
        double traceRet4 = Double.longBitsToDouble(ieeeBits);
        if (trace.isOn) {
            trace.exit(traceContext, COMP_JN, 387, (Object)new Double(traceRet4), 6);
        }
        return traceRet4;
    }

    protected static final int floatToS390IntBits(float ieeeFloat, JmqiTraceHandlerAdapter trace) throws IOException {
        int quotient;
        boolean positive;
        int traceContext = 0;
        int fid = 388;
        if (trace.isOn) {
            traceContext = trace.entry_OO(COMP_JN, 388, new Object[]{new Float(ieeeFloat), trace});
        }
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)"sccsid = @(#) com.ibm.mq/src/com/ibm/mq/MQS390FloatSupport.java, java.classes, k700, k700-L080529 1.32.1.1 08/06/01 09:00:25");
        }
        int ieeeIntBits = Float.floatToIntBits(ieeeFloat);
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("IEEE bit pattern = " + Integer.toString(ieeeIntBits, 16)));
        }
        boolean bl = positive = (ieeeIntBits & Integer.MIN_VALUE) == 0;
        if ((ieeeIntBits & Integer.MAX_VALUE) == 0) {
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 388, (Object)new Integer(ieeeIntBits), 1);
            }
            return ieeeIntBits;
        }
        int exponent = ieeeIntBits & 0x7F800000;
        exponent >>>= 23;
        int mantissa = ieeeIntBits & 0x7FFFFF;
        if ((exponent -= 126) > -126) {
            mantissa |= 0x800000;
        }
        int remainder = Math.abs(exponent) % 4;
        int s390Exponent = quotient = Math.abs(exponent) / 4;
        if (exponent > 0 && remainder != 0) {
            ++s390Exponent;
        }
        if (exponent < 0) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64;
        int s390Mantissa = mantissa;
        if (remainder > 0) {
            int shift_places;
            if (exponent > 0) {
                shift_places = 4 - remainder;
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -126 && (s390Mantissa & 0xF00000) == 0) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                shift_places = remainder;
                s390Mantissa >>>= shift_places;
            }
        }
        if (exponent == -126) {
            s390Mantissa <<= 1;
            while (s390Mantissa != 0 && (s390Mantissa & 0xF00000) == 0) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        int s390Float = 0;
        int s390ExponentBits = s390Exponent & 0x7F;
        s390Float = s390ExponentBits << 24;
        if (!positive) {
            s390Float |= Integer.MIN_VALUE;
        }
        s390Float |= s390Mantissa;
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("S390 Bit pattern = " + Integer.toString(s390Float, 16)));
        }
        if (trace.isOn) {
            trace.exit(traceContext, COMP_JN, 388, (Object)new Integer(s390Float), 2);
        }
        return s390Float;
    }

    protected static final float intS390BitsToFloat(int floatBits, JmqiTraceHandlerAdapter trace) throws IOException {
        boolean positive;
        int traceContext = 0;
        int fid = 389;
        if (trace.isOn) {
            traceContext = trace.entry_OO(COMP_JN, 389, new Object[]{new Integer(floatBits), trace});
        }
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)"sccsid = @(#) com.ibm.mq/src/com/ibm/mq/MQS390FloatSupport.java, java.classes, k700, k700-L080529 1.32.1.1 08/06/01 09:00:25");
        }
        trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("S390 Bit pattern = " + Integer.toString(floatBits, 16)));
        boolean bl = positive = (floatBits & Integer.MIN_VALUE) == 0;
        if ((floatBits & Integer.MAX_VALUE) == 0) {
            if (positive) {
                if (trace.isOn) {
                    trace.exit(traceContext, COMP_JN, 389, (Object)new Float(0.0f), 1);
                }
                return 0.0f;
            }
            float traceRet1 = -0.0f;
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 389, (Object)new Float(traceRet1), 2);
            }
            return traceRet1;
        }
        int mantissa = floatBits & 0xFFFFFF;
        int exponent = floatBits & 0x7F000000;
        exponent >>= 24;
        int ieeeExponent = (exponent -= 64) * 4;
        int ieeeMantissa = mantissa;
        if (ieeeExponent <= -126) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -126) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0 && (ieeeMantissa & 0x800000) == 0 && ieeeExponent > -126) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -149) {
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 389, (Object)new Float(0.0f), 3);
            }
            return 0.0f;
        }
        if (ieeeExponent > 128) {
            if (positive) {
                float traceRet2 = Float.POSITIVE_INFINITY;
                if (trace.isOn) {
                    trace.exit(traceContext, COMP_JN, 389, (Object)new Float(traceRet2), 4);
                }
                return traceRet2;
            }
            float traceRet3 = Float.NEGATIVE_INFINITY;
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 389, (Object)new Float(traceRet3), 5);
            }
            return traceRet3;
        }
        int ieeeBits = 0;
        if (!positive) {
            ieeeBits |= Integer.MIN_VALUE;
        }
        ieeeExponent += 126;
        ieeeBits |= (ieeeExponent <<= 23);
        ieeeBits |= (ieeeMantissa &= 0x7FFFFF);
        if (trace.isOn) {
            trace.dataFmt(jmqiEnv, COMP_JN, 0, clsName, (Object)("IEEE Bit pattern = " + Integer.toString(ieeeBits, 16)));
        }
        float traceRet4 = Float.intBitsToFloat(ieeeBits);
        if (trace.isOn) {
            trace.exit(traceContext, COMP_JN, 389, (Object)new Float(traceRet4), 6);
        }
        return traceRet4;
    }
}

