/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x501;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.DerInputStream;
import org.apache.harmony.security.x501.DirectoryString;
import org.apache.harmony.security.x509.Utils;

public class AttributeValue {
    public final boolean wasEncoded;
    public String escapedString;
    private String hexString;
    private int tag = -1;
    public byte[] encoded;
    public byte[] bytes;
    public boolean hasQE;
    public String rawString;

    public AttributeValue(String string, boolean bl) {
        this.wasEncoded = false;
        this.hasQE = bl;
        this.rawString = string;
        this.escapedString = this.makeEscaped(this.rawString);
    }

    public AttributeValue(String string, byte[] byArray) {
        this.wasEncoded = true;
        this.hexString = string;
        this.encoded = byArray;
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            this.tag = derInputStream.tag;
            if (DirectoryString.ASN1.checkTag(this.tag)) {
                this.rawString = (String)DirectoryString.ASN1.decode(derInputStream);
                this.escapedString = this.makeEscaped(this.rawString);
            } else {
                this.rawString = string;
                this.escapedString = string;
            }
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
    }

    public AttributeValue(String string, byte[] byArray, int n) {
        this.wasEncoded = true;
        this.encoded = byArray;
        this.tag = n;
        if (string == null) {
            this.rawString = this.getHexString();
            this.escapedString = this.hexString;
        } else {
            this.rawString = string;
            this.escapedString = this.makeEscaped(string);
        }
    }

    public int getTag() {
        if (this.tag == -1) {
            this.tag = Utils.isPrintableString(this.rawString) ? ASN1StringType.PRINTABLESTRING.id : ASN1StringType.UTF8STRING.id;
        }
        return this.tag;
    }

    public String getHexString() {
        if (this.hexString == null) {
            if (!this.wasEncoded) {
                this.encoded = Utils.isPrintableString(this.rawString) ? ASN1StringType.PRINTABLESTRING.encode(this.rawString) : ASN1StringType.UTF8STRING.encode(this.rawString);
            }
            StringBuffer stringBuffer = new StringBuffer(this.encoded.length * 2 + 1);
            stringBuffer.append('#');
            for (int i = 0; i < this.encoded.length; ++i) {
                int n = this.encoded[i] >> 4 & 0xF;
                if (n < 10) {
                    stringBuffer.append((char)(n + 48));
                } else {
                    stringBuffer.append((char)(n + 87));
                }
                n = this.encoded[i] & 0xF;
                if (n < 10) {
                    stringBuffer.append((char)(n + 48));
                    continue;
                }
                stringBuffer.append((char)(n + 87));
            }
            this.hexString = stringBuffer.toString();
        }
        return this.hexString;
    }

    public void appendQEString(StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        if (this.hasQE) {
            for (int i = 0; i < this.rawString.length(); ++i) {
                char c = this.rawString.charAt(i);
                if (c == '\"' || c == '\\') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
        } else {
            stringBuffer.append(this.rawString);
        }
        stringBuffer.append('\"');
    }

    private String makeEscaped(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || i == n - 1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block5;
                }
                case '\"': 
                case '\\': {
                    this.hasQE = true;
                }
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    stringBuffer.append('\\');
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String makeCanonical() {
        int n;
        int n2 = this.rawString.length();
        if (n2 == 0) {
            return this.rawString;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = 0;
        if (this.rawString.charAt(0) == '#') {
            stringBuffer.append('\\');
            stringBuffer.append('#');
            ++n3;
        }
        while (n3 < n2) {
            char c = this.rawString.charAt(n3);
            switch (c) {
                case ' ': {
                    n = stringBuffer.length();
                    if (n == 0 || stringBuffer.charAt(n - 1) == ' ') break;
                    stringBuffer.append(' ');
                    break;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '\\': {
                    stringBuffer.append('\\');
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        for (n = stringBuffer.length() - 1; n > -1 && stringBuffer.charAt(n) == ' '; --n) {
        }
        stringBuffer.setLength(n + 1);
        return stringBuffer.toString();
    }
}

