/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class DigestOutputStream
extends FilterOutputStream {
    protected MessageDigest digest;
    private boolean isOn = true;

    public DigestOutputStream(OutputStream outputStream, MessageDigest messageDigest) {
        super(outputStream);
        this.digest = messageDigest;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.isOn) {
            this.digest.update((byte)n);
        }
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isOn) {
            this.digest.update(byArray, n, n2);
        }
        this.out.write(byArray, n, n2);
    }

    public void on(boolean bl) {
        this.isOn = bl;
    }

    public String toString() {
        return super.toString() + ", " + this.digest.toString() + (this.isOn ? ", is on" : ", is off");
    }
}

