/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.util.Arrays;

public class Extension {
    protected ObjectIdentifier extensionId = null;
    protected boolean critical = false;
    protected byte[] extensionValue = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.Extension";

    protected Extension() {
        if (debug != null) {
            debug.entry(16384L, className, "Extension");
            debug.exit(16384L, className, "Extension");
        }
    }

    public Extension(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Extension", derVal);
        }
        DerInputStream in = derVal.toDerInputStream();
        this.extensionId = in.getOID();
        DerValue val = in.getDerValue();
        if (val.getTag() == 1) {
            this.critical = val.getBoolean();
            val = in.getDerValue();
            this.extensionValue = val.getOctetString();
        } else {
            this.critical = false;
            this.extensionValue = val.getOctetString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "Extension");
        }
    }

    public Extension(ObjectIdentifier extensionId, boolean critical, byte[] extensionValue) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{extensionId, new Boolean(critical), extensionValue};
            debug.entry(16384L, (Object)className, "Extension", parms);
        }
        this.extensionId = extensionId;
        this.critical = critical;
        DerValue inDerVal = new DerValue(extensionValue);
        this.extensionValue = inDerVal.getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "Extension");
        }
    }

    public Extension(Extension ext) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Extension", ext);
        }
        this.extensionId = ext.extensionId;
        this.critical = ext.critical;
        this.extensionValue = ext.extensionValue != null ? (byte[])ext.extensionValue.clone() : ext.extensionValue;
        if (debug != null) {
            debug.exit(16384L, className, "Extension");
        }
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.extensionId == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Null OID to encode for the extension!");
            }
            throw new IOException("Null OID to encode for the extension!");
        }
        if (this.extensionValue == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "No value to encode for the extension!");
            }
            throw new IOException("No value to encode for the extension!");
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(this.extensionId);
        if (this.critical) {
            dos.putBoolean(this.critical);
        }
        dos.putOctetString(this.extensionValue);
        out.write((byte)48, dos);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean isCritical() {
        if (debug != null) {
            debug.entry(16384L, className, "isCritical");
            debug.exit(16384L, (Object)className, "isCritical", this.critical);
        }
        return this.critical;
    }

    public ObjectIdentifier getExtensionId() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtensionId");
            debug.exit(16384L, (Object)className, "getExtensionId", this.extensionId);
        }
        return this.extensionId;
    }

    public byte[] getExtensionValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtensionValue");
        }
        if (this.extensionValue == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
            }
            return null;
        }
        byte[] dup = new byte[this.extensionValue.length];
        System.arraycopy(this.extensionValue, 0, dup, 0, dup.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getExtensionValue_2", dup);
        }
        return dup;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = "ObjectId: " + this.extensionId.toString();
        s = this.critical ? s + " Criticality=true\n" : s + " Criticality=false\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        byte[] val = this.getExtensionValue();
        int len = val.length;
        int h = 0;
        while (len > 0) {
            h += len-- * val[len];
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", h);
        }
        return h;
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (this == other) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof Extension)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        Extension otherExt = (Extension)other;
        if (this.critical != otherExt.critical) {
            return false;
        }
        if (!this.extensionId.equals(otherExt.extensionId)) {
            return false;
        }
        byte[] val = this.getExtensionValue();
        byte[] otherVal = ((Extension)other).getExtensionValue();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", Arrays.equals(val, otherVal));
        }
        return Arrays.equals(val, otherVal);
    }
}

