/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.validator.Validator;
import com.ibm.security.validator.ValidatorException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class PKIXValidator
extends Validator {
    private static final boolean TRY_VALIDATOR = true;
    private final Set trustedCerts;
    private final PKIXBuilderParameters parameterTemplate;
    private int certPathLength = -1;
    private Map trustedSubjects;
    private CertificateFactory factory;
    private boolean plugin = false;

    PKIXValidator(String variant, Collection trustedCerts) {
        super("PKIX", variant);
        this.trustedCerts = trustedCerts instanceof Set ? (Set)trustedCerts : new HashSet(trustedCerts);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : trustedCerts) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        try {
            this.parameterTemplate = new PKIXBuilderParameters(trustAnchors, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Unexpected error: " + e.toString(), e);
        }
        this.setDefaultParameters(variant);
        this.initCommon();
    }

    PKIXValidator(String variant, PKIXBuilderParameters params) {
        super("PKIX", variant);
        this.trustedCerts = new HashSet();
        for (TrustAnchor anchor : params.getTrustAnchors()) {
            X509Certificate cert = anchor.getTrustedCert();
            if (cert == null) continue;
            this.trustedCerts.add(cert);
        }
        this.parameterTemplate = params;
        this.initCommon();
    }

    private void initCommon() {
        this.trustedSubjects = new HashMap();
        for (X509Certificate cert : this.trustedCerts) {
            this.trustedSubjects.put(cert.getSubjectX500Principal(), cert);
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Internal error", e);
        }
        this.plugin = this.variant.equals("plugin code signing");
    }

    @Override
    public Collection getTrustedCertificates() {
        return this.trustedCerts;
    }

    public int getCertPathLength() {
        return this.certPathLength;
    }

    private void setDefaultParameters(String variant) {
        this.parameterTemplate.setRevocationEnabled(false);
    }

    public PKIXBuilderParameters getParameters() {
        return this.parameterTemplate;
    }

    @Override
    X509Certificate[] engineValidate(X509Certificate[] chain, Collection otherCerts, Object parameter) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        for (int i = 0; i < chain.length; ++i) {
            if (!this.trustedCerts.contains(chain[i])) continue;
            if (i == 0) {
                return new X509Certificate[]{chain[0]};
            }
            X509Certificate[] newChain = new X509Certificate[i];
            System.arraycopy(chain, 0, newChain, 0, i);
            return this.doValidate(newChain);
        }
        X509Certificate last = chain[chain.length - 1];
        X500Principal issuer = last.getIssuerX500Principal();
        X500Principal subject = last.getSubjectX500Principal();
        if (this.trustedSubjects.containsKey(issuer) && !issuer.equals(subject) && this.isSignatureValid((X509Certificate)this.trustedSubjects.get(issuer), last)) {
            return this.doValidate(chain);
        }
        if (this.plugin) {
            if (chain.length > 1) {
                X509Certificate[] newChain = new X509Certificate[chain.length - 1];
                System.arraycopy(chain, 0, newChain, 0, newChain.length);
                PKIXBuilderParameters params = (PKIXBuilderParameters)this.parameterTemplate.clone();
                try {
                    params.setTrustAnchors(Collections.singleton(new TrustAnchor(chain[chain.length - 1], null)));
                }
                catch (InvalidAlgorithmParameterException iape) {
                    throw new CertificateException(iape);
                }
                this.doValidate(newChain, params);
            }
            throw new ValidatorException(ValidatorException.T_NO_TRUST_ANCHOR);
        }
        return this.doBuild(chain, otherCerts);
    }

    private boolean isSignatureValid(X509Certificate iss, X509Certificate sub) {
        if (this.plugin) {
            try {
                sub.verify(iss.getPublicKey());
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return true;
    }

    private static X509Certificate[] toArray(CertPath path, TrustAnchor anchor) throws CertificateException {
        List<? extends Certificate> list = path.getCertificates();
        X509Certificate[] chain = new X509Certificate[list.size() + 1];
        list.toArray(chain);
        X509Certificate trustedCert = anchor.getTrustedCert();
        if (trustedCert == null) {
            throw new ValidatorException("TrustAnchor must be specified as certificate");
        }
        chain[chain.length - 1] = trustedCert;
        return chain;
    }

    private void setDate(PKIXBuilderParameters params) {
        Date date = this.validationDate;
        if (date != null) {
            params.setDate(date);
        }
    }

    private X509Certificate[] doValidate(X509Certificate[] chain) throws CertificateException {
        PKIXBuilderParameters params = (PKIXBuilderParameters)this.parameterTemplate.clone();
        return this.doValidate(chain, params);
    }

    private X509Certificate[] doValidate(X509Certificate[] chain, PKIXBuilderParameters params) throws CertificateException {
        try {
            this.setDate(params);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            CertPath path = this.factory.generateCertPath(Arrays.asList(chain));
            this.certPathLength = chain.length;
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)validator.validate(path, params);
            return PKIXValidator.toArray(path, result.getTrustAnchor());
        }
        catch (GeneralSecurityException e) {
            throw new ValidatorException("PKIX path validation failed: " + e.toString(), e);
        }
    }

    private X509Certificate[] doBuild(X509Certificate[] chain, Collection otherCerts) throws CertificateException {
        try {
            PKIXBuilderParameters params = (PKIXBuilderParameters)this.parameterTemplate.clone();
            this.setDate(params);
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(chain[0]);
            params.setTargetCertConstraints(selector);
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.addAll(Arrays.asList(chain));
            if (otherCerts != null) {
                certs.addAll(otherCerts);
            }
            CertStore store = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certs));
            params.addCertStore(store);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(params);
            return PKIXValidator.toArray(result.getCertPath(), result.getTrustAnchor());
        }
        catch (GeneralSecurityException e) {
            throw new ValidatorException("PKIX path building failed: " + e.toString(), e);
        }
    }
}

