

// global variable for storing the current language
var language;

// global variable for storing the current language ID
var langID;

// global variable for storing NLS array
var arrayID;

// variables to store language IDs
// if the script finds this string in the URL, it chooses the language associated.
var eng = "?eng";
var por = "?por";
var pol = "?pol";
var ita = "?ita";
var esp = "?esp";
var fra = "?fra";
var ger = "?ger";
var chi = "?chi";
var tch = "?tch";
var jap = "?jap";
var kor = "?kor";
var czn = "?czn";
var tur = "?tur";
var cat = "?cat";
var hun = "?hun";
var rus = "?rus";
var slk = "?slk";
var slv = "?slv";

//the following arrays contain the names of the guides
var arrayGuideName = new Array("SDK and Runtime Environment Guide", "Java Security Guide", "Readmefirst", 
									"RMI-IIOP Guide", "Information for Japanese Users", "License", "Copyright", "Notices");

//the following function chooses the language in which to display the guides, based on the choice the user made in the
//startHere.htm page - the language is selected depending on the URL of the container page (index.en.html?language)
function chooseLanguage() {
    
    loc = parent.location.href; // get URL of the container page, index.en.html
    
    var langPath = new Array;

    //the following if..else block check which language the guides should be displayed in, and sets the variables
    // language, langId, and arrayID to the appropriate values
    if(loc.indexOf(eng) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="en";
        langPath[1]="en";
    }
    else if(loc.indexOf(por) != -1){
        arrayID = arrayGuideName;
        langPath[0]="pt";
        langPath[1]="pt";
    }
    else if(loc.indexOf(ita) != -1){
        arrayID = arrayGuideName;
        langPath[0]="it";
        langPath[1]="it";
    }
    else if(loc.indexOf(esp) != -1){
        arrayID = arrayGuideName;
        langPath[0]="es";
        langPath[1]="es";
    }
    else if(loc.indexOf(fra) != -1){
        arrayID = arrayGuideName;
        langPath[0]="fr";
        langPath[1]="fr";
    }
    else if(loc.indexOf(ger) != -1){
        arrayID = arrayGuideName;
        langPath[0]="de";
        langPath[1]="de";
    }
    else if(loc.indexOf(chi) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="zh_Hans";
        langPath[1]="zh_Hans";
    }
    else if(loc.indexOf(tch) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="zh_Hant";
        langPath[1]="zh_Hant";
    }
    else if(loc.indexOf(jap) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="ja";
        langPath[1]="ja";
    }
    else if(loc.indexOf(kor) != -1){
        arrayID = arrayGuideName;
        langPath[0]="ko";
        langPath[1]="ko";
    }
    else if(loc.indexOf(czn) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; // normal guides not translated
        langPath[1]="cs";
    }
    else if(loc.indexOf(tur) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="tr";
    }
    else if(loc.indexOf(pol) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="pl";
    }
    else if(loc.indexOf(cat) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="ca";
    }
    else if(loc.indexOf(hun) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="hu";
    }
    else if(loc.indexOf(rus) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="ru";
    }
    else if(loc.indexOf(slk) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="sk";
    }
    else if(loc.indexOf(slv) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="sl";
    }
    
return langPath;

}
    
function createAssocArray(guidesArray) {
    chooseLanguage();
    var twoDimArray = new Array;
    for(i=0; i<guidesArray.length; i++) {
        
        if(guidesArray[i].indexOf("sdkandruntime") != -1) {
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[0];
        }                  
        else if (guidesArray[i].indexOf("securityguide") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[1];
        }
        else if (guidesArray[i].indexOf("readmefirst") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[2];
        }
        else if (guidesArray[i].indexOf("rmi") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[3];
        }
        else if (guidesArray[i].indexOf("japanese") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[4];
        }   
        else if (guidesArray[i].indexOf("license") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[5];
        }   
        else if (guidesArray[i].indexOf("COPYRIGHT") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[6];
        }   
        else if (guidesArray[i].indexOf("otices") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[7];
        }   
    }
    //alert("The chosen language is: " + language + "\nLanguage ID: " + langId + "\narrayId: " + arrayID);
    return twoDimArray;
}

//the following function writes the TOC in the toc.htm file
//first it calls the function createAssocArray() on an array that has a list of the
//file paths to the various user guides. this results in a 2-dimensional array that has the
//path of the user guide and the name to display in the browser. 
//after writing the opening <UL> tag, this function iterates through the 2-dimensional array to
//create the links to the various user guides
function writeToc(arrayGuidePaths) {
    var twoDim = createAssocArray(arrayGuidePaths); // create 2-dimensional array from array containing user guide paths
    document.write("<UL>"); // write opening <UL> tag
    
    //iterate through 2-dim array and write links in toc.htm file  
    for (i=0; i<twoDim.length; i++){
        document.write("<LI><A href='" + twoDim[i][0] + "' target='Content'>" + twoDim[i][1] + "</A></LI>");
    }
    
    document.write("</UL>"); // write closing </UL> tag

}
        


// SIG // Begin signature block
// SIG // MIIWFgYJKoZIhvcNAQcCoIIWBzCCFgMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFCPXffISkKcE
// SIG // aHE6M6OfSrCezNkboIIRnTCCA8QwggMtoAMCAQICEEe/
// SIG // GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIwMzIz
// SIG // NTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZl
// SIG // cmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2lnbiBU
// SIG // aW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzNIK8K
// SIG // fYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+jNtr
// SIG // 3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g99bbV
// SIG // XV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN3j/H
// SIG // tN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkSud5o
// SIG // L6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyfhOpU
// SIG // wQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvEs0dD
// SIG // mhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2ru66
// SIG // DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQGCCsG
// SIG // AQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDovL29j
// SIG // c3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYBAf8C
// SIG // AQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2NybC52
// SIG // ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5nQ0Eu
// SIG // Y3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB
// SIG // /wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UEAxMM
// SIG // VFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GBAEpr
// SIG // +epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17IypMT
// SIG // 5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGLOIez
// SIG // 6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuFPrWd
// SIG // tdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIID/zCC
// SIG // AuegAwIBAgIQDekr8NTYKYgYMgUJXpp2iDANBgkqhkiG
// SIG // 9w0BAQUFADBTMQswCQYDVQQGEwJVUzEXMBUGA1UEChMO
// SIG // VmVyaVNpZ24sIEluYy4xKzApBgNVBAMTIlZlcmlTaWdu
// SIG // IFRpbWUgU3RhbXBpbmcgU2VydmljZXMgQ0EwHhcNMDMx
// SIG // MjA0MDAwMDAwWhcNMDgxMjAzMjM1OTU5WjBXMQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // LzAtBgNVBAMTJlZlcmlTaWduIFRpbWUgU3RhbXBpbmcg
// SIG // U2VydmljZXMgU2lnbmVyMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAslAoSN3TaHqEGERmdV1+xLif
// SIG // Yyb/PUOcfBE4ECVVc9l1J2n9TrkgXNMK+aAbKu1VViFh
// SIG // 2B7b5Lwza8fv3aM3ZY4bkwy2Ux5cfGY1XwWKRf52Tt9T
// SIG // gKKBIJ2uiFyiCPflMPnuIjdMQgrO38YfxNZV6YE/tVKj
// SIG // LKoBevKiqo01/p/mXWoFnz1r47+WwP7MYPlA5wegROuB
// SIG // UW6lKvK2ihAo7Y/cBqCGUJp7SggNMB3KEJ5r9+lYrgSp
// SIG // QJmyKOiPFqw841NvS9M1nbVvZB2zliy7Ped56216+Rbm
// SIG // Jq2v75lTt0Aslbh5qv7UUqspdH5C7DkeomoW5lm7JGjY
// SIG // AIBDEIeAawIDAQABo4HKMIHHMDQGCCsGAQUFBwEBBCgw
// SIG // JjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNp
// SIG // Z24uY29tMAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAo
// SIG // oCagJIYiaHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNz
// SIG // LWNhLmNybDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAO
// SIG // BgNVHQ8BAf8EBAMCBsAwJAYDVR0RBB0wG6QZMBcxFTAT
// SIG // BgNVBAMTDFRTQTIwNDgtMS01NDANBgkqhkiG9w0BAQUF
// SIG // AAOCAQEAh3hw2k5SASBb4HnJgjDE/bkZlr2RAMO9zc3G
// SIG // 9A7Y//lNwDNiMBHF9XQb1JLeX5wgE7F8Rb5QzYPngBeD
// SIG // pyeTZxNG+8q4mEEDzJtRWwWLf6hv8xtQGyQu8mmNbCL3
// SIG // u8oWle0MdMBod9nrmWKHwXOQ+Il0eiOro5h7l7H3jylx
// SIG // TS51G0hB2vC1DSBU1negl4Jjaf0Jz4rwdbsJm9n5EVUm
// SIG // mmEyvnoCsHuGvqLDiyIseNE1drySc1z5ueZMFQojzOTS
// SIG // 1DQuSUAVPA9geiTGpWbvls9w6z7n9A1+3NF8o3ZxacGc
// SIG // T0cwNSGxoq8aYjwr2Y6qKgd72BizXHvinaVv/jyJrTCC
// SIG // BL8wggQooAMCAQICEFdkbitVACPUkFNKVT6rDQowDQYJ
// SIG // KoZIhvcNAQEFBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNV
// SIG // BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
// SIG // cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24g
// SIG // QXV0aG9yaXR5MB4XDTA0MDcxNjAwMDAwMFoXDTA5MDcx
// SIG // NTIzNTk1OVowgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC+vO68fu+D
// SIG // 6+A3T/sDEDi+CNKMfZ36kn8ZDMJr7kJSjN7THEgTJerB
// SIG // Y3r5UWXu06o79fCUnCv78mbUJNr39Z9uGTk2vNCjdgge
// SIG // IickbDiRJ+KESa4biqH9JYIsEDDocaso6HdKUfHszfjw
// SIG // VNRvwONtCo/Z2GSNY7ItTif2hQ7+beMpmeKFR3wthn/o
// SIG // V4+tZ8IzMpETIPypIxSabcKES3ZoBNVxLF0h+ogNJv0f
// SIG // LZEr5wFVTfJtNSiC39lrXLbW2aqB/V/Ng7pjndAi/Kk7
// SIG // Qmmyjjq1vLSeD17E6iyCiyj9UwiW3bUBINH5pRjnwO5R
// SIG // cDfhtgVIUkhvOOrD6Gx7RIS7AgMBAAGjggGgMIIBnDAS
// SIG // BgNVHRMBAf8ECDAGAQH/AgEAMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAxBgNVHR8EKjAo
// SIG // MCagJKAihiBodHRwOi8vY3JsLnZlcmlzaWduLmNvbS9w
// SIG // Y2EzLmNybDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYB
// SIG // BQUHAwMwDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIB
// SIG // AQQEAwIAATApBgNVHREEIjAgpB4wHDEaMBgGA1UEAxMR
// SIG // Q2xhc3MzQ0EyMDQ4LTEtNDMwHQYDVR0OBBYEFAj1Uej7
// SIG // /j09ZDZ8aM9beKjfucU3MIGABgNVHSMEeTB3oWOkYTBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCEHC6
// SIG // 5B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQEFBQADgYEA
// SIG // mmX12NfhpNBd3th9e8PuxAjCVtCM3O2sIo3nUAYNByyg
// SIG // pGmVzJnfzGMxz7DB5JbLOM4h+3znWAojIQcskJer2JYE
// SIG // k1RTujoQSHINhewbCkElzH1srHsD8fd4PPKoQNBVctu+
// SIG // Cyi1yMcF/tPgtSHcvEC3vrxg9bjj2F47Zd1mVl8wggUL
// SIG // MIID86ADAgECAhBFHZsUsAqV8mqZNiJVXOLvMA0GCSqG
// SIG // SIb3DQEBBQUAMIG0MQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
// SIG // aWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1z
// SIG // IG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5j
// SIG // b20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJpU2lnbiBD
// SIG // bGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENBMB4XDTA1
// SIG // MDcxMjAwMDAwMFoXDTA2MDgxMTIzNTk1OVowgc4xCzAJ
// SIG // BgNVBAYTAkdCMRIwEAYDVQQIEwlIYW1wc2hpcmUxEDAO
// SIG // BgNVBAcTB0h1cnNsZXkxEzARBgNVBAoUCklCTSBVSyBM
// SIG // dGQxPjA8BgNVBAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAt
// SIG // IE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYy
// SIG // MS8wLQYDVQQLFCZlLWJ1c2luZXNzIEluZnJhc3RydWN0
// SIG // dXJlIFRlY2hub2xvZ2llczETMBEGA1UEAxQKSUJNIFVL
// SIG // IEx0ZDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA
// SIG // sTCUBpc8rnfwFm9cI/mDdK29odFQx8XanQ5/LVI0s/cF
// SIG // 3Di8VX2UNHJohhDfoe2Uz/YSwBr3KCkIowRChRbM8llc
// SIG // GLHzVDZaWhwKq7OVqp9sICu5oKJInulblqPgPw86Xj8B
// SIG // N1+ogN2KKvKOda46RIJHTn0l1503CKKnleWVFG0CAwEA
// SIG // AaOCAX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQD
// SIG // AgeAMEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0Mz
// SIG // LTIwMDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQu
// SIG // Y3JsMEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAo
// SIG // BggrBgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24u
// SIG // Y29tL3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1Bggr
// SIG // BgEFBQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
// SIG // Y3NwLnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0
// SIG // cDovL0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NT
// SIG // QzMtMjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7
// SIG // /j09ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIE
// SIG // EDAWBgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEArekCXqnORyusQQmf1NHgoRav5BqE
// SIG // mJy7eUljZQzEdIQa6yoP881X8KlRzJum5+oYet4EAJwU
// SIG // pZz8uF9sjbCYlqPS7doWVOuw4rh9GLG1VI+KfIau3B3/
// SIG // urKx+jU7JFdKdAc5OMnw/P3sAw/Zin/3Q1tBE+u1oWp3
// SIG // SaZNPsGZXu9o9IsZ0DDbiVCGpx0BgoKsyo+MlIPujtCw
// SIG // ijy0Xt5J9k2V7iGvIYciKsTaQoSwvV2OKAf72N8S6eRI
// SIG // J9kDBtQxYvnwZPVgzeEK3eeVLISvZtxuiEoNx0ZhqE4/
// SIG // 2NWIxhiMfUYtVZclcvVkkGgWpjsMZUCRz7QucieC5LyK
// SIG // U6HhsjGCA+UwggPhAgEBMIHJMIG0MQswCQYDVQQGEwJV
// SIG // UzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNV
// SIG // BAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNV
// SIG // BAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52
// SIG // ZXJpc2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVW
// SIG // ZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0
// SIG // IENBAhBFHZsUsAqV8mqZNiJVXOLvMAkGBSsOAwIaBQCg
// SIG // cDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUbrKKb/su
// SIG // M9wZhdptQYWamTw+5+4wDQYJKoZIhvcNAQEBBQAEgYBk
// SIG // RRiKzcB8C849ZajghMfiuwlqf5+9sTvwdwNc8ZExzSeu
// SIG // Yo083xTOADSiG+UVWo7Gh470dfF5GHb10hhTN07UI/G2
// SIG // Y+lNhYuUQ5thS4pxPFGoMLX7HUpkDCpXRk96THykoEmJ
// SIG // BSeUCMeS7h0eQ+zy7IY2GlgX2+ibyNtQ9+QZQaGCAf8w
// SIG // ggH7BgkqhkiG9w0BCQYxggHsMIIB6AIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQDekr8NTYKYgYMgUJXpp2iDAM
// SIG // BggqhkiG9w0CBQUAoFkwGAYJKoZIhvcNAQkDMQsGCSqG
// SIG // SIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMDYwNTExMTMw
// SIG // NjIxWjAfBgkqhkiG9w0BCQQxEgQQlCPQewRzXEVwIbEJ
// SIG // pyzxdDANBgkqhkiG9w0BAQEFAASCAQBaJn32bhxaKN94
// SIG // kftu1ia9DyIG761pJgcpUCnqEdh3SbQ0J7qtScN8Zbdo
// SIG // vMFBz9EJJAMRlGQHcN/QLV2XrZsHirdvxAbeyWEju3JX
// SIG // b4GcNgmMB5wgNftImTMFa9WeAQODIGbZFFwzeFq/bush
// SIG // 60+cMAExYwbHPcp6QP1Xwyz/B7GFZN9PbEEnl5NNkK+e
// SIG // Q6jjJTxB4yVmbNhs9yRdk1bgfZ6vHpFR44HKswWnSk8+
// SIG // 5Q9RkVF9SfZVX+ntnwIzgOvjDewGKMfqxaXrtMT6a+FU
// SIG // 1C3nr14n2WSVs/LRAdaMa/xApDPLeSHcMp4fzp7rZZoz
// SIG // TSfL83VOf701K8EDH87s
// SIG // End signature block
