/*
 * @(#)src/tools/pfm/java_md.c, tool, an32dev, 20060331 1.2.1.31
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */





/*
 * ===========================================================================
 * Change activity:
 *
 * Reason   Date   Origin   Description
 * ------   ----   ------   ----------------------------------------------------
 * 005827   250100 hdece:   Registry key should be 1.3
 * 006553   030300 hdmkv:   Use /DRELEASE for dot release determination
 * 033324   180601 hdajc:   Use full version release for registry key
 * 041302   040302 kwb      Globalize the java launcher
 * 055562   260902 kwb      Map zh_HK and zh_MO to zh_TW
 * 057944.1 270103 smithwil Map default console.encoding to Cp850 ascii
 * 057204   150103 websterm Sidecar launcher
 * 060769   010503 corbin   Fix up ConverterMap for other languages
 * 066874.1 291203 corbin   Change default convertermap
 * 067672   140104 corbin   Improve change made by 66874.1
 * 067741   100502 mbluemel PCR616 - PD Build support
 * 071326   230604 pratunga Produce correct -X usage text for J9
 * 088734   180505 nichanir Rename the launcher's java*.properties files to
 *                          launcher*.properties
 * 088699   281204 kaaruna  Upgrade to 5.0 Launcher
 * 088706   170505 kaaruna   Support applets in SWT browser
 * 089157   030605 andyt    WARN: 'stricmp' inconsistent dll linkage warning - java_md.h
 * 076310   210705 bygravec Remove J9J2SE ifdefs
 * 095208   051005 andyt    SVT: CAT- Fail to run 'Command : java -version:InvalidVersion'
 * 97210    261005 kaaruna  Backout changes of feature 88706
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Platform dependent routines for java tool
 *
 * ===========================================================================
 */


#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <jni.h>
#include "java.h"
#include "version_comp.h"											  /*ibm@88699*/

#if defined(IBM_BUILD_TYPE_dev)                                       /*ibm.49*/
  #define JVM_DLL "jvm.dll"                                           /*ibm@67741*/
  #define JAVA_DLL "java.dll"                                         /*ibm@67741*/
#elif defined(IBM_BUILD_TYPE_col)                                     /*ibm.49*/
  #define JVM_DLL "jvm_g.dll"
  #define JAVA_DLL "java_g.dll"
#else                                                                 /*ibm.49*/
  #define JVM_DLL "jvm.dll"
  #define JAVA_DLL "java.dll"
#endif                                                                /*ibm.49*/

/*
 * Prototypes.
 */
static jboolean
GetPublicJREHome(char *path, jint pathsize);
void __cdecl _setargv(void);                                        /*ibm@1369*/

/* start ibm@1369
 * Expand any wildcards in the command line
 */
void
ExpandCommandLineArgs(void)
{
    _setargv();
}
/* end ibm@1369 */


typedef struct {
    unsigned short  cpID;
    char *  encName;
} convmap_t;

static convmap_t converterMap[] = {
    874,  "MS874",    // Thai
    932,  "MS932",    // Japanese
    936,  "MS936",    // Chinese (Simplified)
    949,  "MS949",    // Korean
    950,  "MS950",    // Chinese (Traditional)
    54936,"GB18030",  // Chinese (GB18030)
    65001,"UTF8",     // Unicode
    852,  "Cp852",    // Czech, Hungarian, Slovakian  //ibm.60769
    857,  "Cp857",    // Turkey                       //ibm.60769
    866,  "Cp866",    // Russian                      //ibm.60769
    0,    "Cp%d",    // Default  ibm@57944.1         //ibm.67672
};

/*
 * Add the console.encoding option
 */
void SetConsoleEncoding(void) {
    char opt [64], *op;
    int  cp;
    convmap_t * tp;

    strcpy(opt, "-Dconsole.encoding=");
    op = opt+strlen(opt);
    cp = GetConsoleCP();
    if (cp==0) {   //ibm.67672
        cp=850;    //ibm.67672
    }              //ibm.67672
    tp = converterMap;
    while (tp->cpID) {
        if (tp->cpID==cp)
            break;
        tp++;
    }
    sprintf(op, tp->encName, cp);
    AddOption(strdup(opt), NULL);
}


/*
 * Load JVM of "jvmtype", and intialize the invocation functions.  Notice that
 * if jvmtype is NULL, we try to load hotspot VM as the default.  Maybe we
 * need an environment variable that dictates the choice of default VM.
 */
jboolean
LoadJavaVM(char *jvmtype, InvocationFunctions *ifn)
{
    char home[MAXPATHLEN], javadll[MAXPATHLEN], jvmdll[MAXPATHLEN];
    HINSTANCE handle;
    struct stat s;
    char *pdOrNot;
    
    /* Is JRE co-located with the application? */
    if (GetApplicationHome(home, sizeof(home))) {
        sprintf(javadll, "%s\\bin\\" JAVA_DLL, home);
        if (stat(javadll, &s) == 0)
            goto jrefound;
    }

    /* Does this app ship a private JRE in <apphome>\jre directory? */
    sprintf(javadll, "%s\\jre\\bin\\" JAVA_DLL, home);
    if (stat(javadll, &s) == 0) {
        strcat(home, "\\jre");
        goto jrefound;
    }

    /* Look for a public JRE on this machine. */
    if (!GetPublicJREHome(home, sizeof(home))) {
        showMessage(stderr, "No.public.JRE", NULL, NULL, 0);
        return JNI_FALSE;
    }

    /* Now we know where JRE is -- the value in the "home" variable. */
jrefound:

    /*ibm@67741 starts*/
    if (strcmp(jvmtype,"sovPd") == 0) {
        pdOrNot = "\\pd";
        jvmtype = "classic";
    } else {
        pdOrNot = "";
    }
    /*ibm67741 ends*/

    /* Try to load J9 JVM. */
    /* actually, jvmtype is always set by caller, so we look for J9 or classic */
    /*ibm@57204*/
    if (jvmtype != NULL) {
        sprintf(jvmdll, "%s%s\\bin\\%s\\" JVM_DLL, home, pdOrNot, jvmtype);   /*ibm@67741 */
        if (0 != stat(jvmdll, &s))
            jvmtype = NULL;
    }

    /* Determine if Hotspot VM is installed. */
    if (jvmtype == NULL) {
        sprintf(jvmdll, "%s%s\\bin\\classic\\" JVM_DLL, home, pdOrNot);       /*ibm@67741*/
        if (!stat(jvmdll, &s))
            jvmtype = "classic";
    }

    /* We now know what jvmtype should be */
    if (jvmtype)
        sprintf(jvmdll, "%s%s\\bin\\%s\\" JVM_DLL, home, pdOrNot, jvmtype);
    else
        sprintf(jvmdll, "%s%s\\bin\\" JVM_DLL, home, pdOrNot);
    if (_launcher_debug) {													/*ibm@88699*/
        printf("Path to JVM is %s\n", jvmdll);
    }

    /* Load the Java VM DLL */
    if ((handle = LoadLibrary(jvmdll)) == 0) {
        showMessage(stderr, "Error.loading", c2jc(jvmdll), NULL, 0);
        return JNI_FALSE;
    }

    /* Now get the function addresses */
    ifn->CreateJavaVM =
        (void *)GetProcAddress(handle, "JNI_CreateJavaVM");
    ifn->GetDefaultJavaVMInitArgs =
        (void *)GetProcAddress(handle, "JNI_GetDefaultJavaVMInitArgs");
/*ibm@76310..*/
    ifn->GetXUsage =
        (void *)GetProcAddress(handle, "GetXUsage");
/*..ibm@76310*/
    if (ifn->CreateJavaVM == 0 ||
        ifn->GetDefaultJavaVMInitArgs == 0) {
        showMessage(stderr, "JNI.interfaces.not.found", c2jc(jvmdll), NULL, 0);
        return JNI_FALSE;
    }

#ifndef JAVAW
    /*
     * Set the encoding to use for the console.  Do not do this for the
     * javaw which will run in the ANSI codepage.
     */
    SetConsoleEncoding();
#endif

    return JNI_TRUE;
}

/*
 * Get the path to the file that has the usage message for -X options.
 */
void
GetXUsagePath(char *buf, jint bufsize)
{
    GetModuleFileName(GetModuleHandle(JVM_DLL), buf, bufsize);
    *(strrchr(buf, '\\')) = '\0';
    strcat(buf, "\\Xusage.txt");
}

/*
 * If app is "c:\foo\bin\javac", then put "c:\foo" into buf.
 */
jboolean
GetApplicationHome(char *buf, jint bufsize)
{
    char *cp;
    GetModuleFileName(0, buf, bufsize);
    *strrchr(buf, '\\') = '\0'; /* remove .exe file name */
    if ((cp = strrchr(buf, '\\')) == 0) {
        /* This happens if the application is in a drive root, and
         * there is no bin directory. */
        buf[0] = '\0';
        return JNI_FALSE;
    }
    *cp = '\0';  /* remove the bin\ part */
    return JNI_TRUE;
}

#ifdef JAVAW
__declspec(dllimport) char **__initenv;

int WINAPI
WinMain(HINSTANCE inst, HINSTANCE previnst, LPSTR cmdline, int cmdshow)
{
    __initenv = _environ;
    return main(__argc, __argv);
}
#endif

/*
 * Helpers to look in the registry for a public JRE.
 */
#define JRE_KEY     "Software\\IBM\\Java2 Runtime Environment"       /*ibm@613*/

static jboolean
GetStringFromRegistry(HKEY key, const char *name, char *buf, jint bufsize)
{
    DWORD type, size;

    if (RegQueryValueEx(key, name, 0, &type, 0, &size) == 0
        && type == REG_SZ
        && (size < (unsigned int)bufsize)) {
        if (RegQueryValueEx(key, name, 0, 0, buf, &size) == 0) {
            return JNI_TRUE;
        }
    }
    return JNI_FALSE;
}

static jboolean
GetPublicJREHome(char *buf, jint bufsize)
{
    HKEY key, subkey;
    char version[MAXPATHLEN];
    char dotrelease[MAXPATHLEN];                                    /*ibm@6553*/

    /*
     * Determine our current version & releaase from the RELEASE macro  ibm@6553
     * defined at build time. We want <version>.<release> eg 1.3        ibm@6553
     */

    strcpy(dotrelease,RELEASE);       /* Initialise string            ibm@6553*/

    /* Find the current version of the JRE */
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, JRE_KEY, 0, KEY_READ, &key) != 0) {
        if (_launcher_debug) {										/*ibm@88699*/
            fprintf(stderr, "Error opening registry key '" JRE_KEY "'\n");
        }
        return JNI_FALSE;
    }

    if (!GetStringFromRegistry(key, "CurrentVersion",
                               version, sizeof(version))) {
        if (_launcher_debug) {										/*ibm@88699*/
            fprintf(stderr, "Failed reading value of registry key:\n\t"
                JRE_KEY "\\CurrentVersion\n");
        }
        RegCloseKey(key);
        return JNI_FALSE;
    }

    if (strcmp(version, dotrelease) != 0) {                         /*ibm@6553*/
        if (_launcher_debug) {										/*ibm@88699*/
            fprintf(stderr, "Registry key '" JRE_KEY "\\CurrentVersion'\nhas "
            "value '%s', but '%s' is required.\n",version,dotrelease); /*ibm@6553*/
        }
        RegCloseKey(key);
        return JNI_FALSE;
    }

    /* Find directory where the current version is installed. */
    if (RegOpenKeyEx(key, version, 0, KEY_READ, &subkey) != 0) {
        if (_launcher_debug) {										/*ibm@88699*/
            fprintf(stderr, "Error opening registry key '"
               JRE_KEY "\\%s'\n", version);
        }
        RegCloseKey(key);
        return JNI_FALSE;
    }

    if (!GetStringFromRegistry(subkey, "JavaHome", buf, bufsize)) {
        if (_launcher_debug) {										/*ibm@88699*/
            fprintf(stderr, "Failed reading value of registry key:\n\t"
                JRE_KEY "\\%s\\JavaHome\n", version);
        }
        RegCloseKey(key);
        RegCloseKey(subkey);
        return JNI_FALSE;
    }

    if (_launcher_debug) {										/*ibm@88699*/
        char micro[MAXPATHLEN];
        if (!GetStringFromRegistry(subkey, "MicroVersion", micro,
                                   sizeof(micro))) {
            printf("Warning: Can't read MicroVersion\n");
            micro[0] = '\0';
        }
        printf("Version major.minor.micro = %s.%s\n", version, micro);
    }

    RegCloseKey(key);
    RegCloseKey(subkey);
    return JNI_TRUE;
}

/*
 * Support for doing cheap, accurate interval timing.
 */
static jboolean counterAvailable = JNI_FALSE;
static jboolean counterInitialized = JNI_FALSE;
static LARGE_INTEGER counterFrequency;

jlong CounterGet()
{
    LARGE_INTEGER count;

    if (!counterInitialized) {
        counterAvailable = QueryPerformanceFrequency(&counterFrequency);
        counterInitialized = JNI_TRUE;
    }
    if (!counterAvailable) {
        return 0;
    }
    QueryPerformanceCounter(&count);
    return (jlong)(count.QuadPart);
}

jlong Counter2Micros(jlong counts)
{
    if (!counterAvailable || !counterInitialized) {
        return 0;
    }
    return (counts * 1000 * 1000)/counterFrequency.QuadPart;
}

/*
 * Get the full platform name for the specified file
 */
char * PlatformName(char * in, char * * cpath) {
    *cpath = ".";
    if (in[0]=='\\' || in[0]=='/' || (*in && in[1]==':')) {
        char nbuf[512];
        char * nptr;
        if (GetFullPathName(in, 512, nbuf, &nptr)) {
            char * out = strdup(nbuf);
            out[nptr-nbuf-1] = 0;
            *cpath = out;
            return out+(nptr-nbuf);
        }
    }
    return in;
}


/*
 * Show a Unicode string in the console encoding.
 */
void ShowUnicode(FILE * f, jchar * str, int len) {
    char * buf;

    buf = malloc(len*3);
    len = WideCharToMultiByte(GetConsoleCP(), 0, (LPCWSTR)str, len,
         (LPSTR)buf, len*3, NULL, NULL);
    fwrite(buf, len, 1, f);
    free(buf);
}


/*
 * Get the message file for this locale
 */
char * GetMessageFile(char *buf, int bufsize) {
    char * cp;
    LCID   lcid;
    char   langname[4];    /* allow for 3 char language */
    char   ctryname[4];
    HMODULE jvm_handle;                                                    /*ibm@95208*/

    /* Get the directory one up from that containing the jvm.dll */
    GetModuleFileName(jvm_handle=GetModuleHandle(JVM_DLL), buf, bufsize);  /*ibm@95208*/
    *(strrchr(buf, '\\')) = 0;      /* Get path name          */
    cp = strrchr(buf, '\\');        /* Get previous directory */
    if (!cp) return NULL;
    if (!strcmp(cp, "\\bin"))
        cp += 4;
    /*ibm@95208...*/
    if (jvm_handle == 0) {
        /* GetModuleFileName gave us the name of the executable rather than jvm.dll */
        struct stat s;
        cp[0] = '\0';
        /* no adjustment needed if the executable is in jre\bin */
        strcat(buf, "\\launcher.properties");
        if (stat(buf, &s) != 0) {
            cp[0] = '\0';
            /* test if the executable is in sdk\bin */
            cp = strrchr(buf, '\\');
            if (!cp) return NULL;
            cp[0] = '\0';
            strcat(buf, "\\jre\\bin\\launcher.properties");
            if (stat(buf, &s) == 0) {
                strcpy(cp, "\\jre\\bin");
                cp = buf+strlen(buf);
            } else {
                /* not in sdk\bin or sdk\jre\bin */
                return NULL;
            }
        }
    }
    /*...ibm@95208*/
    strcpy(cp, "\\launcher_");      /*ibm@88734*/
    cp += 10;                       /*ibm@88734*/
    if ((bufsize - (cp-buf)) < 24 ) /* Make sure we have space */
        return NULL;

    /* Get the lang and country strings (this does not work on Win95) */
    lcid = GetThreadLocale();
    GetLocaleInfo(lcid, LOCALE_SISO639LANGNAME,  langname, 4);
    GetLocaleInfo(lcid, LOCALE_SISO3166CTRYNAME, ctryname, 4);

    /* Try for launcher_ll_CC.properties */     /*ibm@88734*/
    if (*ctryname) {
        strcpy(cp, langname);
        strcat(cp, "_");
        strcat(cp, ctryname);
        strcat(cp, ".properties");
//      printf("try 1: %s\n", buf); fflush(stdout);
        if (!access(buf, 4))
            return buf;
    }

    //ibm.55562  begin
    /* Special case to map traditional chinese */
    if (!strcmp(langname, "zh") &&
        (!strcmp(ctryname, "HK") || !strcmp(ctryname, "MO"))) {
        strcpy(cp, "zh_TW.properties");
        if (!access(buf, 4))
            return buf;
    }
    //ibm.55562  end

    /* Try for launcher_ll.properties */      /*ibm@88734*/
    if (*langname) {
        strcpy(cp, langname);
        strcat(cp, ".properties");
//      printf("try 2: %s\n", buf); fflush(stdout);
        if (!access(buf, 4))
            return buf;
    }

    /* Try for launcher.properties */         /*ibm@88734*/
    strcpy(cp-1, ".properties");
//  printf("try 3: %s\n", buf); fflush(stdout);
    if (!access(buf, 4))
        return buf;

    return 0;
}

/* ibm@88699 start
 * Determine if there is an acceptable JRE in the registry directory top_key.
 * Upon locating the "best" one, return a fully qualified path to it.
 * "Best" is defined as the most advanced JRE meeting the constraints
 * contained in the manifest_info. If no JRE in this directory meets the
 * constraints, return NULL.
 *
 * It doesn't matter if we get an error reading the registry, or we just
 * don't find anything interesting in the directory.  We just return NULL
 * in either case.
 */
static char *
ProcessDir(manifest_info* info, HKEY top_key) {
    DWORD   index = 0;
    HKEY    ver_key;
    char    name[MAXNAMELEN];
    int	    len;
    char    *best = NULL;

    /*
     * Enumerate "<top_key>/SOFTWARE/JavaSoft/Java Runtime Environment"
     * searching for the best available version.
     */
    while (RegEnumKey(top_key, index, name, MAXNAMELEN) == ERROR_SUCCESS) {   
	index++;
	if (acceptable_release(name, info->jre_version))
	    if ((best == NULL) || (exact_version_id(name, best) > 0)) {
		if (best != NULL)
		    free(best);
		best = strdup(name);
	    }
    }

    /*
     * Extract "JavaHome" from the "best" registry directory and return
     * that path.  If no appropriate version was located, or there is an
     * error in extracting the "JavaHome" string, return null.
     */
    if (best == NULL)
	return (NULL);
    else { 
	if (RegOpenKeyEx(top_key, best, 0, KEY_READ, &ver_key)
	  != ERROR_SUCCESS) {
	    free(best);
	    if (ver_key != NULL)
		RegCloseKey(ver_key);
	    return (NULL);
	}
	free(best);
	len = MAXNAMELEN;
	if (RegQueryValueEx(ver_key, "JavaHome", NULL, NULL, (LPBYTE)name, &len)
	  != ERROR_SUCCESS) {
	    if (ver_key != NULL)
		RegCloseKey(ver_key);
	    return (NULL);
	}
	if (ver_key != NULL)
	    RegCloseKey(ver_key);
	return (strdup(name));
    }
}

/*
 * This is the global entry point. It examines the host for the optimal
 * JRE to be used by scanning a set of registry entries.  This set of entries
 * is hardwired on Windows as "Software\JavaSoft\Java Runtime Environment"
 * under the set of roots "{ HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE }".
 *  
 * This routine simply opens each of these registry directories before passing
 * control onto ProcessDir().
 */
char *
LocateJRE(manifest_info* info) {
    HKEY    key = NULL;
    char    *path;
    int	    key_index;
    HKEY    root_keys[2] = { HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE };

    for (key_index = 0; key_index <= 1; key_index++) {
	if (RegOpenKeyEx(root_keys[key_index], JRE_KEY, 0, KEY_READ, &key)
	  == ERROR_SUCCESS)
	    if ((path = ProcessDir(info, key)) != NULL) {
		if (key != NULL)
		    RegCloseKey(key);
		return (path);
	    }
	if (key != NULL)
	    RegCloseKey(key);
    }
    return NULL;
}

/*
 * Given a path to a jre to execute, this routine checks if this process
 * is indeed that jre.  If not, it exec's that jre.
 *
 * We want to actually check the paths rather than just the version string
 * built into the executable, so that given version specification will yield
 * the exact same Java environment, regardless of the version of the arbitrary
 * launcher we start with.
 */
void
ExecJRE(char *jre, char **argv) {
    char    *progname;															
    char    path[MAXPATHLEN];

    /*
     * Resolve the real path to the currently running launcher.
     */
    if (GetModuleFileName(NULL, path, MAXPATHLEN) == 0) {
	ReportErrorMessage("Unable to resolve path to current executable",
	  JNI_TRUE);
	exit(1);
    }

    /*
     * If the path to the selected JRE directory is a match to the initial
     * portion of the path to the currently executing JRE, we have a winner!
     * If so, just return. (strnicmp() is the Windows equiv. of strncasecmp().)
     */
    if (strnicmp(jre, path, strlen(jre)) == 0)
	return;			/* I am the droid you were looking for */

    /*
     * Determine the executable we are building (or in the rare case, running).
     */
#ifdef JAVA_ARGS  /* javac, jar and friends. */
    progname = "java";
#else             /* java, oldjava, javaw and friends */
#ifdef PROGNAME
    progname = PROGNAME;
#else
	{
		char *s;															/*ibm@88699*/
		progname = *argv;
		if ((s = strrchr(progname, FILE_SEPARATOR)) != 0) {
		progname = s + 1;
		}
	}
#endif /* PROGNAME */
#endif /* JAVA_ARGS */
    
    /*
     * If this isn't the selected version, exec the selected version.
     */
    (void)strcat(strcat(strcpy(path, jre), "\\bin\\"), progname);
    argv[0] = progname;
    if (_launcher_debug) {
	int i;
	printf("execv(\"%s\"", path);
	for (i = 0; argv[i] != NULL; i++)
	    printf(", \"%s\"", argv[i]);
	printf(")\n");
    }

    /*
     * Although Windows has an execv() entrypoint, it really doesn't
     * know how to overlay a process: it can only create a new
     * process.  This sounds well and good except that any processes
     * waiting on the process wake up and they shouldn't.  Hence we need
     * to keep a chain of pseudo-zombie processes around just to
     * maintain the proper wait semantics. Fortunately the image size
     * of the launcher isn't too large at this time.
     *
     * In a more reasonable world, the code below would be ...
     *
     *     execv(path, argv);
     *     ReportErrorMessage2("Exec of %s failed\n", path, JNI_TRUE);
     *     exit(1);
     *
     * Also note that typecast from the output of spawn to the parameter
     * of exit shouldn't be required.  Whatever type these are, they should
     * match.  However, in Visual C++ .NET, spawn is declared to be of
     * type intptr_t while the parameter to exit remains type int.  Hence,
     * on the IA64 environment where an int is 32 bits and an intptr_t is
     * 64 bits, this is a narrowing cast which is reported as an error if
     * not explicit.
     */
    exit((int)spawnv(_P_WAIT, path, argv));
}

/*
 * Wrapper for platform dependent unsetenv function.
 */
int
UnsetEnv(char *name)
{
    int ret;
    char *buf = MemAlloc(strlen(name) + 2);
    buf = strcat(strcpy(buf, name), "=");
    ret = _putenv(buf);
    free(buf);
    return (ret);
}

/*
 * The following just map the common UNIX name to the Windows API name,
 * so that the common UNIX name can be used in shared code.
 */
/*ibm@89157...
int
strcasecmp(const char *s1, const char *s2)
{
    return (stricmp(s1, s2));
}
...ibm@89157*/

int
strncasecmp(const char *s1, const char *s2, size_t n)
{
    return (strnicmp(s1, s2, n));
}

void ReportErrorMessage(char * message, jboolean always) {
#ifdef JAVAW
  if (message != NULL) {
    MessageBox(NULL, message, "Java Virtual Machine Launcher",
	       (MB_OK|MB_ICONSTOP|MB_APPLMODAL)); 
  }
#else
  if (always) {
    fprintf(stderr, "%s\n", message);
  }
#endif
}

void ReportErrorMessage2(char * format, char * string, jboolean always) { 
  /*
   * The format argument must be a printf format string with one %s
   * argument, which is passed the string argument.
   */
#ifdef JAVAW
  size_t size;
  char * message;
  size = strlen(format) + strlen(string);
  message = (char*)MemAlloc(size*sizeof(char));
  sprintf(message, (const char *)format, string);
  
  if (message != NULL) {
    MessageBox(NULL, message, "Java Virtual Machine Launcher",
	       (MB_OK|MB_ICONSTOP|MB_APPLMODAL)); 
  }
#else
  if (always) {
    fprintf(stderr, (const char *)format, string);
    fprintf(stderr, "\n");
  }
#endif
}

/*
 * Return JNI_TRUE for an option string that has no effect but should
 * _not_ be passed on to the vm; return JNI_FALSE otherwise. On
 * windows, there are no options that should be screened in this
 * manner.
 */
jboolean RemovableMachineDependentOption(char * option) {
  return JNI_FALSE;
}

void PrintMachineDependentOptions() {
  return;
}

void  ReportExceptionDescription(JNIEnv * env) {
#ifdef JAVAW
  /*
   * This code should be replaced by code which opens a window with
   * the exception detail message.
   */
  (*env)->ExceptionDescribe(env);
#else
  (*env)->ExceptionDescribe(env);
#endif
}
/*ibm@88699 end*/
