/*
 * @(#)src/classes/sov/javax/swing/plaf/basic/BasicRootPaneUI.java, swing, asdev, 20060428 1.18
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 57093  130103 chenerys  Add Shift+F10 key binding to post contextual menus
 * 65306  301003 chenerys  Add AltProcessor for other LAFs
 * 68351  020204 chenerys  AltProcessor should handle components with no rootpane
 * 74904  071004 chenerys  Upgrade to 5.0 Swing 
 * 81995  040305 corbin    Back out piece of 57093
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)BasicRootPaneUI.java	1.15 03/12/19
 *
 */

package javax.swing.plaf.basic;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;/*ibm@57093*/
import java.awt.event.KeyEvent;  /*ibm@57093*/
import java.awt.event.MouseEvent;/*ibm@57093*/
import java.awt.Dimension;       /*ibm@57093*/
import java.awt.KeyboardFocusManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.KeyEventPostProcessor;/*ibm@65306*/
import java.awt.Window;               /*ibm@65306*/
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.*;
import javax.swing.plaf.*;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

/**
 * Basic implementation of RootPaneUI, there is one shared between all
 * JRootPane instances.
 *
 * @version 1.15 12/19/03
 * @author Scott Violet
 */
public class BasicRootPaneUI extends RootPaneUI implements
                  PropertyChangeListener {
    private static RootPaneUI rootPaneUI = new BasicRootPaneUI();

    private static final AltProcessor altProcessor = new AltProcessor(); /*ibm@65306*/

    public static ComponentUI createUI(JComponent c) {
        return rootPaneUI;
    }

    public void installUI(JComponent c) { 
        installDefaults((JRootPane)c);
        installComponents((JRootPane)c);
        installListeners((JRootPane)c);
        installKeyboardActions((JRootPane)c);
    }

    
    public void uninstallUI(JComponent c) { 
        uninstallDefaults((JRootPane)c);
        uninstallComponents((JRootPane)c);
        uninstallListeners((JRootPane)c);
        uninstallKeyboardActions((JRootPane)c);
    }

    protected void installDefaults(JRootPane c){
        LookAndFeel.installProperty(c, "opaque", Boolean.FALSE);
    }

    protected void installComponents(JRootPane root) {
    }

    protected void installListeners(JRootPane root) {
	root.addPropertyChangeListener(this);
        if (UIManager.get("altProcessor")==null){                     /*ibm@65306*/
            KeyboardFocusManager.getCurrentKeyboardFocusManager().    /*ibm@65306*/
                addKeyEventPostProcessor(altProcessor);               /*ibm@65306*/        
            UIManager.put("altProcessor", altProcessor);              /*ibm@65306*/
        }                                                             /*ibm@65306*/
    }

    protected void installKeyboardActions(JRootPane root) {
	InputMap km = getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW, root);
	SwingUtilities.replaceUIInputMap(root,
                JComponent.WHEN_IN_FOCUSED_WINDOW, km);
        km = getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT,
                root);
        SwingUtilities.replaceUIInputMap(root,
                JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT, km);

        LazyActionMap.installLazyActionMap(root, BasicRootPaneUI.class,
                "RootPane.actionMap");
	updateDefaultButtonBindings(root);
    }

    protected void uninstallDefaults(JRootPane root) {
    }

    protected void uninstallComponents(JRootPane root) {
    }

    protected void uninstallListeners(JRootPane root) {
	root.removePropertyChangeListener(this);      
	KeyboardFocusManager.getCurrentKeyboardFocusManager().    /*ibm@65306*/ 
            removeKeyEventPostProcessor(altProcessor);            /*ibm@65306*/  
	if(UIManager.get("altProcessor")==altProcessor){          /*ibm@65306*/  
	    UIManager.put("altProcessor", null);                  /*ibm@65306*/ 
	}                                                         /*ibm@65306*/ 
    }

    protected void uninstallKeyboardActions(JRootPane root) {
	SwingUtilities.replaceUIInputMap(root, JComponent.
				       WHEN_IN_FOCUSED_WINDOW, null);
	SwingUtilities.replaceUIActionMap(root, null);
    }

    InputMap getInputMap(int condition, JComponent c) {
        if (condition == JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT) {
            return (InputMap)DefaultLookup.get(c, this,
                                       "RootPane.ancestorInputMap");
        }

	if (condition == JComponent.WHEN_IN_FOCUSED_WINDOW) {
	    return createInputMap(condition, c);
	}
	return null;
    }

    ComponentInputMap createInputMap(int condition, JComponent c) {
	return new RootPaneInputMap(c);
    }

    static void loadActionMap(LazyActionMap map) {
	map.put(new Actions(Actions.PRESS));
	map.put(new Actions(Actions.RELEASE));
	map.put(new Actions(Actions.POST_POPUP));
    }

    /**
     * Invoked when the default button property has changed. This reloads
     * the bindings from the defaults table with name
     * <code>RootPane.defaultButtonWindowKeyBindings</code>.
     */
    void updateDefaultButtonBindings(JRootPane root) {
	InputMap km = SwingUtilities.getUIInputMap(root, JComponent.
					       WHEN_IN_FOCUSED_WINDOW);
	while (km != null && !(km instanceof RootPaneInputMap)) {
	    km = km.getParent();
	}
	if (km != null) {
	    km.clear();
	    if (root.getDefaultButton() != null) {
		Object[] bindings = (Object[])DefaultLookup.get(root, this,
                           "RootPane.defaultButtonWindowKeyBindings");
		if (bindings != null) {
		    LookAndFeel.loadKeyBindings(km, bindings);
		}
	    }
	}
    }

    /**
     * Invoked when a property changes on the root pane. If the event
     * indicates the <code>defaultButton</code> has changed, this will
     * reinstall the keyboard actions.
     */
    public void propertyChange(PropertyChangeEvent e) {
	if(e.getPropertyName().equals("defaultButton")) {
	    JRootPane rootpane = (JRootPane)e.getSource();
	    updateDefaultButtonBindings(rootpane);
	    if (rootpane.getClientProperty("temporaryDefaultButton") == null) {
		rootpane.putClientProperty("initialDefaultButton", e.getNewValue());
	    }
	}
    }


    static class Actions extends UIAction {
        public static final String PRESS = "press";
        public static final String RELEASE = "release";
        public static final String POST_POPUP = "postPopup";

        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            JRootPane root = (JRootPane)evt.getSource();
	    JButton owner = root.getDefaultButton();
            String key = getName();

            if (key == POST_POPUP) { // Action to post popup
                Component c = KeyboardFocusManager
                        .getCurrentKeyboardFocusManager()
                         .getFocusOwner();

                if(c instanceof JComponent) {
                    JComponent src = (JComponent) c;
                    JPopupMenu jpm = src.getComponentPopupMenu();
                    if(jpm != null) {
                        Point pt = src.getPopupLocation(null);
                        if(pt == null) {
                            Rectangle vis = src.getVisibleRect();
                            pt = new Point(vis.x+vis.width/2,
                                           vis.y+vis.height/2);
                        }
                        jpm.show(c, pt.x, pt.y);
			/*ibm@57093 start*/  
		    }else{
			Dimension s=src.getSize();
			MouseEvent mpe=new MouseEvent(src,MouseEvent.MOUSE_PRESSED,
						      System.currentTimeMillis(),0,s.width/2,s.height/2,1,true);
			src.dispatchEvent(mpe);
			MouseEvent mre=new MouseEvent(src,MouseEvent.MOUSE_RELEASED,
						      System.currentTimeMillis(),0,s.width/2,s.height/2,1,true);
			src.dispatchEvent(mre);
			MouseEvent mce=new MouseEvent(src,MouseEvent.MOUSE_CLICKED,
						      System.currentTimeMillis(),0,s.width/2,s.height/2,1,true);
			src.dispatchEvent(mce);	
			/*ibm@57093 end*/  
                    }
                }
            }
            else if (owner != null
                     && SwingUtilities.getRootPane(owner) == root) {
                if (key == PRESS) {
                    owner.doClick(20);
                }
            }
        }

        public boolean isEnabled(Object sender) {
            String key = getName();
            if(key == POST_POPUP) {
                MenuElement[] elems = MenuSelectionManager
                        .defaultManager()
                        .getSelectedPath();
                if(elems != null && elems.length != 0) {
                    return false;
                    // We shall not interfere with already opened menu
                }

                Component c = KeyboardFocusManager
                       .getCurrentKeyboardFocusManager()
                        .getFocusOwner();
                if(c instanceof JComponent) {
                    JComponent src = (JComponent) c;
                    return src.getComponentPopupMenu() != null;  //ibm.81995
                }
		
                return false;
            }
                
            if (sender != null && sender instanceof JRootPane) {
	        JButton owner = ((JRootPane)sender).getDefaultButton();
                return (owner != null && owner.getModel().isEnabled());
            }
            return true;
        }
    }

    private static class RootPaneInputMap extends ComponentInputMapUIResource {
	public RootPaneInputMap(JComponent c) {
	    super(c);
	}
    }

    /*ibm@65306 start*/  
    private static class AltProcessor implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;
        private static JMenuBar mbar = null;  
        
        
        void altPressed(KeyEvent ev) {
            MenuSelectionManager msm =
                MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length > 0 && ! (path[0] instanceof ComboPopup)) {
                msm.clearSelectedPath();
                menuCanceledOnPress = true;
                ev.consume();
            } else if(path.length > 0) { // We are in ComboBox
                menuCanceledOnPress = false;
                ev.consume();
            } else {
                menuCanceledOnPress = false;
                JMenu menu = mbar != null ? mbar.getMenu(0) : null;
                if(menu != null) {
                    ev.consume();
                }
            }
        }
        
        void altReleased(KeyEvent ev) {
            if (menuCanceledOnPress) {
                return;
            }
            
            MenuSelectionManager msm =
                MenuSelectionManager.defaultManager();
            if (msm.getSelectedPath().length == 0) {
                // if no menu is active, we try activating the menubar
                JMenu menu = mbar != null ? mbar.getMenu(0) : null;
                
                if (menu != null) {
                    MenuElement[] path = new MenuElement[3];
                    JPopupMenu popup = menu.getPopupMenu();
                    path[0] = mbar;
                    path[1] = menu;
                    path[2] = popup;
                    msm.setSelectedPath(path);
                }
            } 
        }
        
        public boolean postProcessKeyEvent(KeyEvent ev) {
            if (ev.getKeyCode() == KeyEvent.VK_ALT) {
                root = SwingUtilities.getRootPane(ev.getComponent());
		if(root==null) return false; /*ibm@68351*/
                winAncestor = SwingUtilities.getWindowAncestor(root);
                mbar=getJMenuBar(root);  
                
                if (ev.getID() == KeyEvent.KEY_PRESSED) {
                    if (!altKeyPressed) {
                        altPressed(ev);
                    }
                    altKeyPressed = true;
                    return true;
                } else if (ev.getID() == KeyEvent.KEY_RELEASED) {
                    if (altKeyPressed) {
                        altReleased(ev);
                    } else {
                        MenuSelectionManager msm =
                            MenuSelectionManager.defaultManager();
                        MenuElement[] path = msm.getSelectedPath();
                    }
                    altKeyPressed = false;
                }
            } else {
                altKeyPressed = false;
            }
            return false;
        }
        
        private JMenuBar getJMenuBar(JRootPane rp){
            JMenuBar mb = rp != null ? rp.getJMenuBar() : null;
            /*
             * If JMenuBar was not set on the content pane using setJMenuBar then
             * search through the children of root for the closest JMenuBar.
             */
            if(rp!=null && mb==null){ 
                mb=getTopJMenuBar(rp);
                /*
                 * If root is in a JInternalFrame which doesn't contain a
                 * JMenuBar then try searching the rootpane of its containing 
                 * window.
                 */
                if((mb==null) && (rp.getParent() instanceof JInternalFrame)){
                    java.awt.Window parentWindow=SwingUtilities.
                        windowForComponent(rp.getParent());
                    if((parentWindow!=null) && (parentWindow instanceof RootPaneContainer)){
                        rp=((RootPaneContainer)parentWindow).getRootPane();
                        mb=getTopJMenuBar(rp);
                    }
                }
            }
            return mb;
        }
        
        private int topTier=0;
        private JMenuBar topMBar=null;
        
        /*
         * Returns highest JMenuBar from this JRootPane's content pane's 
         * descendants.
         */
        private JMenuBar getTopJMenuBar(JRootPane rp){
            topTier=0;
            topMBar=null;
            if(rp!=null){             
                java.awt.Container cp=rp.getContentPane();
                searchChildren(cp,0);
            }                              
            return topMBar;
        }
        
        /*
         * Searches down through descendants of Container c looking for 
         * the highest JMenuBar within the heirarchy. Returns true if one
         * of c's direct children is a JMenuBar.
         */
        private boolean searchChildren(java.awt.Container c, int tier){
            if(c!=null){                              
                tier++;
                if((topTier!=0) && (tier>=topTier)){
                    return false;
                }
                Component[] children=c.getComponents();
                for(int i=0;i<children.length;i++){
                    Component child=children[i];
                    if(child instanceof JMenuBar){
                        if((topTier==0) ||(tier<topTier)){
                            topTier=tier;
                            topMBar=(JMenuBar)child;
                            return true;
                        }
                    } else if(child instanceof java.awt.Container){
                        if(searchChildren((java.awt.Container)child,tier)){
                            break;
                        }
                    }
                }
            }               
            return false;
        }
    }
    /*ibm@65306 end*/
}
