/*
 * @(#)src/classes/sov/javax/swing/ComboBoxModel.java, swing, asdev, 20060428 1.14
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74904  071004 chenerys  Upgrade to 5.0 Swing 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)ComboBoxModel.java	1.15 03/12/19
 *
 */
package javax.swing;

/**
 * A data model for a combo box. This interface extends <code>ListDataModel</code>
 * and adds the concept of a <i>selected item</i>. The selected item is generally
 * the item which is visible in the combo box display area.
 * <p>
 * The selected item may not necessarily be managed by the underlying 
 * <code>ListModel</code>. This disjoint behavior allows for the temporary 
 * storage and retrieval of a selected item in the model.
 *
 * @version 1.15 12/19/03
 * @author Arnaud Weber
 */
public interface ComboBoxModel extends ListModel {

  /** 
   * Set the selected item. The implementation of this  method should notify 
   * all registered <code>ListDataListener</code>s that the contents 
   * have changed. 
   * 
   * @param anItem the list object to select or <code>null</code> 
   *        to clear the selection
   */
  void setSelectedItem(Object anItem);

  /** 
   * Returns the selected item 
   * @return The selected item or <code>null</code> if there is no selection
   */
  Object getSelectedItem();
}

