/*
 * @(#)src/classes/sov/javax/sound/midi/spi/SoundbankReader.java, audio, asdev, 20060428 1.16
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74919   220704  karagate  5.0 codemerge 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)SoundbankReader.java	1.18 03/12/19
 *
 */

package javax.sound.midi.spi;

import java.io.InputStream;
import java.io.IOException;
import java.io.File;

import java.net.URL;

import javax.sound.midi.Soundbank;
import javax.sound.midi.InvalidMidiDataException;


/**
 * A <code>SoundbankReader</code> supplies soundbank file-reading services.
 * Concrete subclasses of <code>SoundbankReader</code> parse a given
 * soundbank file, producing a {@link javax.sound.midi.Soundbank}
 * object that can be loaded into a {@link javax.sound.midi.Synthesizer}.
 *
 * @since 1.3
 * @version 1.18 03/12/19
 * @author Kara Kytle
 */
public abstract class SoundbankReader {


    /**
     * Obtains a soundbank object from the URL provided.
     * @param url URL representing the soundbank.
     * @return soundbank object
     * @throws InvalidMidiDataException if the URL does not point to
     * valid MIDI soundbank data recognized by this soundbank reader
     * @throws IOException if an I/O error occurs
     */
    public abstract Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException;


    /**
     * Obtains a soundbank object from the <code>InputStream</code> provided.
     * @param stream <code>InputStream</code> representing the soundbank
     * @return soundbank object
     * @throws InvalidMidiDataException if the stream does not point to
     * valid MIDI soundbank data recognized by this soundbank reader
     * @throws IOException if an I/O error occurs
     */
    public abstract Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException;


    /**
     * Obtains a soundbank object from the <code>File</code> provided.
     * @param file the <code>File</code> representing the soundbank
     * @return soundbank object
     * @throws InvalidMidiDataException if the file does not point to
     * valid MIDI soundbank data recognized by this soundbank reader
     * @throws IOException if an I/O error occurs
     */
    public abstract Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException;



}
