/*
 * @(#)src/classes/sov/javax/naming/MalformedLinkException.java, jndi, asdev, 20060428 1.9
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */



package javax.naming;

/**
  * This exception is thrown when a malformed link was encountered while
  * resolving or constructing a link.
  * <p>
  * Synchronization and serialization issues that apply to LinkException
  * apply directly here.
  *
  * @author Rosanna Lee
  * @author Scott Seligman
  * @version 1.7 03/12/19
  *
  * @see LinkRef#getLinkName
  * @see LinkRef
  * @since 1.3
  */

public class MalformedLinkException extends LinkException {
    /**
      * Constructs a new instance of MalformedLinkException with an explanation
      * All the other fields are initialized to null.
      * @param	explanation	A possibly null string containing additional
      *				detail about this exception.
      */
    public MalformedLinkException(String explanation) {
	super(explanation);
    }


    /**
      * Constructs a new instance of Malformed LinkException.
      * All fields are initialized to null.
      */
    public MalformedLinkException() {
	super();
    }

    /**
     * Use serialVersionUID from JNDI 1.1.1 for interoperability
     */
    private static final long serialVersionUID = -3066740437737830242L;
}
