/*
 * @(#)src/classes/sov/java/nio/DirectFloatBufferRS.java, nio, asdev, 20060428 1.8
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)Direct-X-Buffer.java	1.47 03/12/19
 *
 */

// -- This file was mechanically generated: Do not edit! -- //

package java.nio;

import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileChannelImpl;


class DirectFloatBufferRS



    extends DirectFloatBufferS

    implements DirectBuffer
{






















































































































    // For duplicates and slices
    //
    DirectFloatBufferRS(DirectBuffer db,	        // package-private
			       int mark, int pos, int lim, int cap,
			       int off)
    {








	super(db, mark, pos, lim, cap, off);

    }

    public FloatBuffer slice() {
	int pos = this.position();
	int lim = this.limit();
	assert (pos <= lim);
	int rem = (pos <= lim ? lim - pos : 0);
	int off = (pos << 2);
	return new DirectFloatBufferRS(this, -1, 0, rem, rem, off);
    }

    public FloatBuffer duplicate() {
	return new DirectFloatBufferRS(this,
					      this.markValue(),
					      this.position(),
					      this.limit(),
					      this.capacity(),
					      0);
    }

    public FloatBuffer asReadOnlyBuffer() {








	return duplicate();

    }


















































    public FloatBuffer put(float x) {




	throw new ReadOnlyBufferException();

    }

    public FloatBuffer put(int i, float x) {




	throw new ReadOnlyBufferException();

    }

    public FloatBuffer put(FloatBuffer src) {




































	throw new ReadOnlyBufferException();

    }

    public FloatBuffer put(float[] src, int offset, int length) {






















	throw new ReadOnlyBufferException();

    }
    
    public FloatBuffer compact() {











	throw new ReadOnlyBufferException();

    }

    public boolean isDirect() {
	return true;
    }

    public boolean isReadOnly() {
	return true;
    }












































    public ByteOrder order() {

	return ((ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN)
		? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);





    }


























}
