/*
 * @(#)src/classes/sov/java/net/URLEncoder.java, net, asdev, 20060428 1.19
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */




/*
 * Change activity:
 *
 * Reason  Date   Origin   Description
 * ------  ----   ------   ----------------------------------------------------
 * 004235  310100 hdmaw    EBCDIC
 * 041015  110202 kwb      Remove 4235 optimization
 * 056111  301002 stalleyj Merge 1.4.1 changes 
 * 064147  211003 riclau   1.4.2 merge
 * 064147  061103 riclau   BufferedWriters needed because IBM use IO converters
 * 079049  251004 stalleyj Merge to 5.0
 * 097626  151205 riclau   Reduce creation of temporary objects
 * 099010  100106 riclau   Throw correct exception for null charsets
 *
 */

package java.net;

import java.io.ByteArrayOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
/*ibm@97626 starts*/
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
/*ibm@97626 ends*/

/**
 * Utility class for HTML form encoding. This class contains static methods
 * for converting a String to the <CODE>application/x-www-form-urlencoded</CODE> MIME
 * format. For more information about HTML form encoding, consult the HTML
 * <A HREF="http://www.w3.org/TR/html4/">specification</A>.
 *
 * <p>
 * When encoding a String, the following rules apply:
 *
 * <p>
 * <ul>
 * <li>The alphanumeric characters &quot;<code>a</code>&quot; through
 *     &quot;<code>z</code>&quot;, &quot;<code>A</code>&quot; through
 *     &quot;<code>Z</code>&quot; and &quot;<code>0</code>&quot;
 *     through &quot;<code>9</code>&quot; remain the same.
 * <li>The special characters &quot;<code>.</code>&quot;,
 *     &quot;<code>-</code>&quot;, &quot;<code>*</code>&quot;, and
 *     &quot;<code>_</code>&quot; remain the same.
 * <li>The space character &quot;<code>&nbsp;</code>&quot; is
 *     converted into a plus sign &quot;<code>+</code>&quot;.
 * <li>All other characters are unsafe and are first converted into
 *     one or more bytes using some encoding scheme. Then each byte is
 *     represented by the 3-character string
 *     &quot;<code>%<i>xy</i></code>&quot;, where <i>xy</i> is the
 *     two-digit hexadecimal representation of the byte.
 *     The recommended encoding scheme to use is UTF-8. However,
 *     for compatibility reasons, if an encoding is not specified,
 *     then the default encoding of the platform is used.
 * </ul>
 *
 * <p>
 * For example using UTF-8 as the encoding scheme the string &quot;The
 * string &#252;@foo-bar&quot; would get converted to
 * &quot;The+string+%C3%BC%40foo-bar&quot; because in UTF-8 the character
 * &#252; is encoded as two bytes C3 (hex) and BC (hex), and the
 * character @ is encoded as one byte 40 (hex).
 *
 * @author  Herb Jellinek
 * @version 1.30, 05/18/04
 * @since   JDK1.0
 */
public class URLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = ('a' - 'A');
    static final String hexStr = "0123456789ABCDEF";                 //ibm.41015
    static String dfltEncName = null;

    static {

        /* The list of characters that are not encoded has been
         * determined as follows:
         *
         * RFC 2396 states:
         * -----
         * Data characters that are allowed in a URI but do not have a
         * reserved purpose are called unreserved.  These include upper
         * and lower case letters, decimal digits, and a limited set of
         * punctuation marks and symbols.
         *
         * unreserved  = alphanum | mark
         *
         * mark        = "-" | "_" | "." | "!" | "~" | "*" | "'" | "(" | ")"
         *
         * Unreserved characters can be escaped without changing the
         * semantics of the URI, but this should not be done unless the
         * URI is being used in a context that does not allow the
         * unescaped character to appear.
         * -----
         *
         * It appears that both Netscape and Internet Explorer escape
         * all special characters from this list with the exception
         * of "-", "_", ".", "*". While it is not clear why they are
         * escaping the other characters, perhaps it is safest to
         * assume that there might be contexts in which the others
         * are unsafe if not escaped. Therefore, we will use the same
         * list. It is also noteworthy that this is consistent with
         * O'Reilly's "HTML: The Definitive Guide" (page 164).
         *
         * As a last note, Intenet Explorer does not encode the "@"
         * character which is clearly not unreserved according to the
         * RFC. We are being consistent with the RFC in this matter,
         * as is Netscape.
         *
         */

        dontNeedEncoding = new BitSet(256);
        int i;
        for (i = 'a'; i <= 'z'; i++) {
            dontNeedEncoding.set(i);
        }
        for (i = 'A'; i <= 'Z'; i++) {
            dontNeedEncoding.set(i);
        }
        for (i = '0'; i <= '9'; i++) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(' '); /* encoding a space to a + is done
                                    * in the encode() method */
        dontNeedEncoding.set('-');
        dontNeedEncoding.set('_');
        dontNeedEncoding.set('.');
        dontNeedEncoding.set('*');

        dfltEncName = (String)AccessController.doPrivileged (
            new GetPropertyAction("file.encoding")
        );
    }

    /**
     * You can't call the constructor.
     */
    private URLEncoder() { }

    /**
     * Translates a string into <code>x-www-form-urlencoded</code>
     * format. This method uses the platform's default encoding
     * as the encoding scheme to obtain the bytes for unsafe characters.
     *
     * @param   s   <code>String</code> to be translated.
     * @deprecated The resulting string may vary depending on the platform's
     *             default encoding. Instead, use the encode(String,String)
     *             method to specify the encoding.
     * @return  the translated <code>String</code>.
     */
    @Deprecated
    public static String encode(String s) {

        String str = null;

        try {
            str = encode(s, dfltEncName);
        } catch (UnsupportedEncodingException e) {
            // The system should always have the platform default
        }

        return str;
    }

    /**
     * Translates a string into <code>application/x-www-form-urlencoded</code>
     * format using a specific encoding scheme. This method uses the
     * supplied encoding scheme to obtain the bytes for unsafe
     * characters.
     * <p>
     * <em><strong>Note:</strong> The <a href=
     * "http://www.w3.org/TR/html40/appendix/notes.html#non-ascii-chars">
     * World Wide Web Consortium Recommendation</a> states that
     * UTF-8 should be used. Not doing so may introduce
     * incompatibilites.</em>
     *
     * @param   s   <code>String</code> to be translated.
     * @param   enc   The name of a supported
     *    <a href="../lang/package-summary.html#charenc">character
     *    encoding</a>.
     * @return  the translated <code>String</code>.
     * @exception  UnsupportedEncodingException
     *             If the named encoding is not supported
     * @see URLDecoder#decode(java.lang.String, java.lang.String)
     * @since 1.4     
     */
    public static String encode(String s, String enc)
        throws UnsupportedEncodingException {

        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10; // rather arbitrary limit, but safe for now
        StringBuffer out = new StringBuffer(s.length()*3/2);       /*ibm@97626*/
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);

        ResettableBufferedOutputStreamWriter writer = 
            new ResettableBufferedOutputStreamWriter(buf, enc);    /*ibm@97626*/

        for (int i = 0; i < s.length(); i++) {
            int c = (int) s.charAt(i);
            //System.out.println("Examining character: " + c);
            if (dontNeedEncoding.get(c)) {
                if (c == ' ') {
                    c = '+';
                    needToChange = true;
                }
                //System.out.println("Storing: " + c);
                out.append((char)c);
                wroteUnencodedChar = true;
            } else {
                // convert to external encoding before hex conversion
                try {
                    if (wroteUnencodedChar) { // Fix for 4407610
                        writer.reset();                            /*ibm@97626*/
                        wroteUnencodedChar = false;
                    }
                    writer.write(c);
                    /*
                     * If this character represents the start of a Unicode
                     * surrogate pair, then pass in two characters. It's not
                     * clear what should be done if a bytes reserved in the
                     * surrogate pairs range occurs outside of a legal
                     * surrogate pair. For now, just treat it as if it were
                     * any other character.
                     */
                    if (c >= 0xD800 && c <= 0xDBFF) {
                        /*
                          System.out.println(Integer.toHexString(c)
                          + " is high surrogate");
                        */
                        if ( (i+1) < s.length()) {
                            int d = (int) s.charAt(i+1);
                            /*
                              System.out.println("\tExamining "
                              + Integer.toHexString(d));
                            */
                            if (d >= 0xDC00 && d <= 0xDFFF) {
                                /*
                                  System.out.println("\t"
                                  + Integer.toHexString(d)
                                  + " is low surrogate");
                                */
                                writer.write(d);
                                i++;
                            }
                        }
                    }
                    writer.flush();
                } catch(IOException e) {
                    buf.reset();
                    continue;
                }
                byte[] ba = buf.toByteArray();

                for (int j = 0; j < ba.length; j++) {
                    out.append('%');
                    out.append(hexStr.charAt((ba[j] >> 4) & 0x0f));  //ibm.41015
                    out.append(hexStr.charAt(ba[j]&0x0f));           //ibm.41015
                }
                buf.reset();
                needToChange = true;
            }
        }

        return (needToChange? out.toString() : s);
    }

    /**
     *ibm@97626
     * Helper class for the two argument encode() method that allows the 
     * underlying character convertor to be reset. As this class is not for
     * general purpose use, it performs no synchronization (i.e. the intent
     * is objects of this class are only used in a single thread).
     */
    private static class ResettableBufferedOutputStreamWriter {
        private static final int DEFAULT_BUFFER_SIZE = 2;
        private OutputStream out;       /* the destination OutputStream */
        private CharsetEncoder encoder; /* Character to byte encoder */
        private CharBuffer charbuf;     /* input buffer */
        private ByteBuffer bytebuf;     /* output buffer */

        /**
         * Create a ResettableBufferedOutputStreamWriter that uses the 
         * given charset.
         * 
         * @param out An output 
         * @param charsetName A charset
         */
        public ResettableBufferedOutputStreamWriter(OutputStream out, 
                String charsetName) 
            throws UnsupportedEncodingException 
        {
            this.out = out;
            Charset cs;
            try {
                cs = Charset.forName(charsetName);
            } catch (IllegalCharsetNameException icne) {
                throw (UnsupportedEncodingException)
                    (new UnsupportedEncodingException()).initCause(icne);
            } catch (UnsupportedCharsetException uce) {
                throw (UnsupportedEncodingException)
                    (new UnsupportedEncodingException()).initCause(uce);
            /*ibm@99010 starts*/
            } catch (IllegalArgumentException iae) {
                throw (UnsupportedEncodingException)
                    (new UnsupportedEncodingException()).initCause(iae);
            /*ibm@99010 ends*/
            }
            encoder = cs.newEncoder()
                        .onMalformedInput(CodingErrorAction.REPLACE)
                        .onUnmappableCharacter(CodingErrorAction.REPLACE);
            charbuf = CharBuffer.allocate(DEFAULT_BUFFER_SIZE);
            bytebuf = ByteBuffer.allocate(DEFAULT_BUFFER_SIZE * (int)encoder.maxBytesPerChar());
        }

        /**
         * Flush the encoded output buffer to the underlying character stream, 
         * without flushing the stream itself.
         */
        private void flushBuffer() throws IOException {
            if (charbuf.position() == 0) {
                /* nothing to do */
                return;
            }
            charbuf.flip();
            bytebuf.clear();
            for (;;) {
                CoderResult cr = encoder.encode(charbuf, bytebuf, true);
                if (cr.isUnderflow()) {
                    /* no more input */
                    break;
                } else if (cr.isOverflow()) {
                    /* larger output buffer is required */
                    int newSize = bytebuf.capacity() * 2;
                    ByteBuffer newBytebuf = ByteBuffer.allocate(newSize);
                    bytebuf.flip();
                    newBytebuf.put(bytebuf);
                    bytebuf = newBytebuf;
                    continue;
                }
                cr.throwException();
            }
            /* write the output to the destination OutputStream */
            bytebuf.flip();
            out.write(bytebuf.array(), 0, bytebuf.limit());
            /* reset buffer position to 0 and limit to capacity */
            charbuf.clear();
        }

        /**
         * Write a single character. The character to be written is contained 
         * in the 16 low-order bits of the given integer value; the 16 
         * high-order bits are ignored.
         *
         * @param c int specifying the character to be written
         * @exception IOException If an I/O error occurs
         */
        public void write(int c) throws IOException {
            if (!charbuf.hasRemaining()) {
                flushBuffer();
            }
            charbuf.put((char) c);
        }

        /**
         * Resets the internal state of this object. 
         */
        public void reset() throws IOException {
            flushBuffer();
            encoder.reset();
        }

        /**
         * Flush the stream.
         *
         * @exception  IOException  If an I/O error occurs
         */
        public void flush() throws IOException {
            flushBuffer();
            out.flush();
        }
    }
}
