/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.NativeThreadContext;
import com.ibm.jvm.j9.dump.systemdump.Register;
import com.ibm.jvm.j9.dump.systemdump.StackFrame;
import java.util.Iterator;
import java.util.Vector;

public class GenericThread {
    protected String threadId;
    protected String javaLangThreadObjectAddress;
    protected String threadDetails;
    protected String threadName;
    protected String state;
    protected String monitorId;
    boolean isJavaThread;
    long stackstart = 0L;
    int stacksize = 0;
    int rva = 0;
    Vector registers = new Vector();
    Vector nativeFrames = new Vector();
    protected NativeThreadContext context = null;

    public GenericThread(GenericThread genericThread) {
        this.threadId = genericThread.getThreadId();
        this.javaLangThreadObjectAddress = genericThread.javaLangThreadObjectAddress();
        this.state = genericThread.getState();
        this.monitorId = genericThread.getMonitorId();
        this.isJavaThread = true;
    }

    public GenericThread(String string, long l, int n, int n2) {
        this.threadId = string;
        this.stackstart = l;
        this.stacksize = n;
        this.rva = n2;
        this.state = "Unknown";
        this.isJavaThread = false;
        J9JVMConsole.addThread(this);
    }

    public GenericThread(String string, String string2, String string3, String string4) {
        this.threadId = string;
        this.javaLangThreadObjectAddress = string2;
        this.state = string3;
        this.monitorId = string4;
        this.isJavaThread = true;
        J9JVMConsole.addThread(this);
    }

    public String javaLangThreadObjectAddress() {
        return this.javaLangThreadObjectAddress;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getState() {
        return this.state;
    }

    public String getThreadName() {
        if (null == this.threadName) {
            return " Un-established";
        }
        return this.threadName;
    }

    public boolean isJavaThread() {
        return false;
    }

    public void addRegister(Register register) {
        this.registers.add(register);
    }

    public void addNativeFrame(StackFrame stackFrame) {
        this.nativeFrames.add(stackFrame);
    }

    public Register getNamedRegister(String string) {
        String string2 = string.toUpperCase();
        Iterator iterator = this.getRegisters();
        while (iterator.hasNext()) {
            Register register = (Register)iterator.next();
            if (!register.name.toUpperCase().equals(string2)) continue;
            return register;
        }
        return null;
    }

    public Iterator getRegisters() {
        return this.registers.iterator();
    }

    public Iterator getNativeFrames() {
        return this.nativeFrames.iterator();
    }

    public int getStacksize() {
        return this.stacksize;
    }

    public long getStackstart() {
        return this.stackstart;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printHeader(stringBuffer);
        stringBuffer.append(" System thread\n");
        stringBuffer.append("  Id      : " + this.threadId + "\n");
        stringBuffer.append("  State   : " + this.state);
        this.printNativeFrames(stringBuffer);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void printHeader(StringBuffer stringBuffer) {
        stringBuffer.append("Info for system thread - " + this.threadId + "\n====================================\n");
    }

    public void printNativeFrames(StringBuffer stringBuffer) {
        if (0 != this.nativeFrames.size()) {
            stringBuffer.append("\n\tStack:\n");
            for (int i = 0; i < this.nativeFrames.size(); ++i) {
                StackFrame stackFrame = (StackFrame)this.nativeFrames.get(i);
                if (null == stackFrame) continue;
                stringBuffer.append("\t\t" + stackFrame.toString() + "\n");
            }
        } else {
            stringBuffer.append("\n\t No Stack available");
        }
    }

    public NativeThreadContext getContext() {
        return this.context;
    }

    public void setContext(NativeThreadContext nativeThreadContext) {
        this.context = nativeThreadContext;
    }

    public String getJavaLangThreadObjectAddress() {
        return this.javaLangThreadObjectAddress;
    }

    public void setStacksize(int n) {
        this.stacksize = n;
    }

    public void setStackstart(long l) {
        this.stackstart = l;
    }

    public boolean matchIdOrName(String string) {
        if ("*".equals(string)) {
            return true;
        }
        String string2 = this.getThreadId();
        String string3 = this.getThreadName();
        if (string2.equals(string) || string2.toUpperCase().equals(string.toUpperCase()) || string2.equals("0x" + string) || string2.toUpperCase().equals(("0x" + string).toUpperCase())) {
            return true;
        }
        if (null != string3 && (string3.equals(string) || string3.toUpperCase().equals(string.toUpperCase()) || string3.startsWith(string) || string3.toUpperCase().startsWith(string.toUpperCase()))) {
            return true;
        }
        String string4 = new String(string);
        if (string4.toUpperCase().startsWith("0x")) {
            string4 = string4.substring(2);
        }
        while (string4.startsWith("0")) {
            string4 = string4.substring(1);
        }
        string4 = "0x" + string4;
        string4 = string4.toUpperCase();
        return string2.toUpperCase().equals(string4);
    }
}

