/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Vector;

public class Aixdump
extends Dump {
    static boolean verbose = false;
    private static MemoryRange[] memoryRanges;
    private static int numberOfMemoryRanges;
    private static Aixdump selfref;
    private static Vector debugFiles;
    private static Vector loadedModules;
    static final int S64BIT = 1;
    static final int NGPRS = 32;
    static final int NFPRS = 32;
    static final int RLIM_NLIMITS = 8;
    static final int NSIG = 64;
    static final int NSIG64 = 256;
    static final int MAXCOMLEN = 32;
    private static CoreHeader header;

    public Aixdump(String string) throws FileNotFoundException {
        super(string, "r");
        this.setSystemType(4);
        Aixdump.setLittleEndian(false);
        selfref = this;
        try {
            this.seek(1276L);
            int n = this.readInt();
            this.bIs32Bit = (n & 1) == 0;
            this.seek(0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        header = new CoreHeader(this, 0L, true);
        this.fillMemoryRanges();
        this.addressSpaces = new J9AddressSpace[1];
        this.addressSpaces[0] = new J9AddressSpace("AIXAS", this, 0);
        J9Process j9Process = new J9Process("AIXProc", 0);
        this.addressSpaces[0].addProcess(j9Process);
        if (loadedModules.size() != 0) {
            for (int i = 0; i < loadedModules.size(); ++i) {
                AIXLdInfo aIXLdInfo = (AIXLdInfo)loadedModules.get(i);
                j9Process.addModule(loadedModules.size(), i, aIXLdInfo.filename, aIXLdInfo.textorg, aIXLdInfo.textsize);
            }
        }
    }

    public static Vector findDebugFiles(String string, Dump dump, boolean bl) {
        return debugFiles;
    }

    public static boolean isSupportedDump(RandomAccessFile randomAccessFile) {
        boolean bl = false;
        header = new CoreHeader(randomAccessFile, 0L, false);
        try {
            long l = randomAccessFile.length();
            if (Aixdump.header.c_fdsinfox > 0L && Aixdump.header.c_loader > 0L && Aixdump.header.c_loader > Aixdump.header.c_fdsinfox && Aixdump.header.c_fdsinfox < l && Aixdump.header.c_loader < l) {
                if (verbose) {
                    System.err.println("isSupportedDump: Whoopee looks like its an aix core file");
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private int fillLoaderRegions(MemoryRange[] memoryRangeArray, int n) {
        int n2 = 0;
        long l = Aixdump.header.c_loader;
        boolean bl = false;
        try {
            while (!bl) {
                long l2;
                this.seek(l);
                int n3 = this.readInt();
                if (!this.bIs32Bit) {
                    this.readInt();
                }
                if ((l2 = this.readPtr()) == 0L) {
                    l += (long)n3;
                }
                if (l2 == 0L) continue;
                if (memoryRangeArray != null) {
                    long l3 = this.readPtr();
                    long l4 = this.readPtr();
                    long l5 = this.readPtr();
                    long l6 = this.readPtr();
                    String string = this.readString();
                    if (debugFiles == null) {
                        debugFiles = new Vector();
                    }
                    AIXLdInfo aIXLdInfo = new AIXLdInfo(l, l3, l4, l5, l6, string);
                    loadedModules.add(aIXLdInfo);
                    debugFiles.add(string);
                    memoryRangeArray[n + n2] = new MemoryRange(l5, l2, l6, string);
                    if (verbose) {
                        System.err.println("fillLoaderRegions: found " + string);
                    }
                }
                l += (long)n3;
                ++n2;
                if (n3 != 0) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            boolean bl2 = true;
        }
        return n2;
    }

    private void fillMemoryRanges() {
        int n;
        if (Aixdump.header.c_data != 0L) {
            ++numberOfMemoryRanges;
        }
        if (Aixdump.header.c_stack != 0L) {
            ++numberOfMemoryRanges;
        }
        numberOfMemoryRanges = (int)((long)numberOfMemoryRanges + Aixdump.header.c_vmregions);
        numberOfMemoryRanges = (int)((long)numberOfMemoryRanges + Aixdump.header.c_segs);
        MemoryRange[] memoryRangeArray = new MemoryRange[numberOfMemoryRanges += this.fillLoaderRegions(null, 0)];
        int n2 = 0;
        if (Aixdump.header.c_data != 0L) {
            memoryRangeArray[n2] = new MemoryRange(Aixdump.header.c_dataorg, Aixdump.header.c_data, Aixdump.header.c_datasize, "User data");
            ++n2;
        }
        try {
            this.seek(Aixdump.header.c_vmm);
            n = 0;
            while ((long)n < Aixdump.header.c_vmregions) {
                long l = this.readLong();
                long l2 = this.readLong();
                long l3 = this.readLong();
                memoryRangeArray[n2] = new MemoryRange(l, l3, l2, "anonymously mapped area");
                ++n2;
                ++n;
            }
            this.seek(Aixdump.header.c_segregion);
            int n3 = 0;
            while ((long)n3 < Aixdump.header.c_segs) {
                long l = this.readLong();
                long l4 = this.readLong();
                long l5 = this.readLong();
                int n4 = this.readInt();
                int n5 = this.readInt();
                StringBuffer stringBuffer = new StringBuffer();
                if ((n4 & 0) != 0) {
                    stringBuffer.append("SEG_AVAIL");
                }
                if ((n4 & 1) != 0) {
                    stringBuffer.append("SEG_SHARED");
                }
                if ((n4 & 2) != 0) {
                    stringBuffer.append("SEG_MAPPED");
                }
                if ((n4 & 4) != 0) {
                    stringBuffer.append("SEG_MRDWR");
                }
                if ((n4 & 8) != 0) {
                    stringBuffer.append("SEG_DEFER");
                }
                if ((n4 & 0x10) != 0) {
                    stringBuffer.append("SEG_MMAP");
                }
                if ((n4 & 0x20) != 0) {
                    stringBuffer.append("SEG_WORKING");
                }
                if ((n4 & 0x40) != 0) {
                    stringBuffer.append("SEG_RMMAP");
                }
                if ((n4 & 0x80) != 0) {
                    stringBuffer.append("SEG_OTHER");
                }
                if ((n4 & 0x100) != 0) {
                    stringBuffer.append("SEG_EXTSHM");
                }
                if ((n4 & 0x200) != 0) {
                    stringBuffer.append("SEG_TEXT ");
                }
                if (0L != l5) {
                    memoryRangeArray[n2] = new MemoryRange(l, l5, l4, "anonymously mapped area");
                    ++n2;
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Aixdump.header.c_stack != 0L) {
            memoryRangeArray[n2] = new MemoryRange(Aixdump.header.c_stackorg, Aixdump.header.c_stack, Aixdump.header.c_size, "Stack");
            ++n2;
        }
        if ((n2 += this.fillLoaderRegions(memoryRangeArray, n2)) < numberOfMemoryRanges) {
            memoryRanges = new MemoryRange[n2];
            for (n = 0; n < n2; ++n) {
                Aixdump.memoryRanges[n] = memoryRangeArray[n];
            }
        } else {
            memoryRanges = memoryRangeArray;
        }
    }

    protected MemoryRange[] getRawMemoryRanges() {
        return memoryRanges;
    }

    public static void main(String[] stringArray) {
    }

    static {
        loadedModules = new Vector();
        Dump.registerDumpSupport(Aixdump.class);
    }

    class AIXLdInfo {
        long core_offset;
        long textorg;
        long textsize;
        long dataorg;
        long datasize;
        String filename;

        public AIXLdInfo(long l, long l2, long l3, long l4, long l5, String string) {
            this.core_offset = l;
            this.textorg = l2;
            this.textsize = l3;
            this.dataorg = l4;
            this.datasize = l5;
            this.filename = string;
        }
    }

    static class Userx {
        private static final int S64BIT = 1;
        long pi_pid;
        long pi_ppid;
        long pi_sid;
        long pi_pgrp;
        long pi_uid;
        long pi_suid;
        long pi_ttyp;
        long pi_ttyd;
        long pi_ttympx;
        long pi_nice;
        long pi_state;
        long pi_flags;
        long pi_flags2;
        long pi_thcount;
        long pi_cpu;
        long pi_pri;
        long pi_adspace;
        long pi_majflt;
        long pi_minflt;
        long pi_repage;
        long pi_size;
        long pi_r1;
        long pi_utime;
        long pi_r2;
        long pi_stime;
        long cr_ref;
        long cr_ruid;
        long cr_uid;
        long cr_suid;
        long cr_luid;
        long cr_acctid;
        long cr_gid;
        long cr_rgid;
        long cr_sgid;
        long cr_ngrps;
        long cr_caps;
        long[] un_groups = new long[32];
        long[] cr_mpriv = new long[2];
        long[] cr_ipriv = new long[2];
        long[] cr_epriv = new long[2];
        long[] cr_bpriv = new long[2];
        long cr_pag;
        long pi_ru_utime_sec;
        long pi_ru_utime_usec;
        long pi_ru_stime_sec;
        long pi_ru_stime_usec;
        long pi_ru_maxrss;
        long pi_ru_ixrss;
        long pi_ru_idrss;
        long pi_ru_isrss;
        long pi_ru_minflt;
        long pi_ru_majflt;
        long pi_ru_nswap;
        long pi_ru_inblock;
        long pi_ru_oublock;
        long pi_ru_msgsnd;
        long pi_ru_msgrcv;
        long pi_ru_nsignals;
        long pi_ru_nvcsw;
        long pi_ru_nivcsw;
        long pi_cru_utime_sec;
        long pi_cru_utime_usec;
        long pi_cru_stime_sec;
        long pi_cru_stime_usec;
        long pi_cru_maxrss;
        long pi_cru_ixrss;
        long pi_cru_idrss;
        long pi_cru_isrss;
        long pi_cru_minflt;
        long pi_cru_majflt;
        long pi_cru_nswap;
        long pi_cru_inblock;
        long pi_cru_oublock;
        long pi_cru_msgsnd;
        long pi_cru_msgrcv;
        long pi_cru_nsignals;
        long pi_cru_nvcsw;
        long pi_cru_nivcsw;
        long pi_ioch;
        long pi_irss;
        long pi_start;
        long[] rlim_cur = new long[8];
        long[] rlim_max = new long[8];
        long pi_cmask;
        long pi_cdir;
        long pi_rdir;
        long pi_maxofile;
        byte[] pi_comm = new byte[33];
        byte[] pi_pad = new byte[7];
        long pi_drss;
        long pi_trss;
        long pi_dvm;
        long pi_prm;
        long pi_tsize;
        long pi_dsize;
        long pi_sdsize;
        long[] pi_signal = new long[64];
        long[] pi_sigflags = new long[64];
        long[] pi_signal64 = new long[256];
        long[] pi_sigflags64 = new long[256];
        long[] pi_ss64 = new long[4];
        long pi_sig_loset;
        long pi_sig_highset;
        long[] pi_resvd = new long[8];
        long pi_chk_utime;
        long pi_chk_stime;

        public Userx(RandomAccessFile randomAccessFile, long l) {
        }

        private void populate32Bit() throws IOException {
            int n;
            this.pi_pid = selfref.readInt();
            this.pi_ppid = selfref.readInt();
            this.pi_sid = selfref.readInt();
            this.pi_pgrp = selfref.readInt();
            this.pi_uid = selfref.readInt();
            this.pi_suid = selfref.readInt();
            this.pi_ttyp = selfref.readInt();
            this.pi_ttyd = selfref.readInt();
            this.pi_ttympx = selfref.readInt();
            this.pi_nice = selfref.readInt();
            this.pi_state = selfref.readInt();
            this.pi_flags = selfref.readInt();
            this.pi_flags2 = selfref.readInt();
            this.pi_thcount = selfref.readInt();
            this.pi_cpu = selfref.readInt();
            this.pi_pri = selfref.readInt();
            this.pi_adspace = selfref.readInt();
            selfref.readInt();
            this.pi_majflt = selfref.readLong();
            this.pi_minflt = selfref.readLong();
            this.pi_repage = selfref.readLong();
            this.pi_size = selfref.readLong();
            this.pi_r1 = selfref.readInt();
            this.pi_utime = selfref.readInt();
            this.pi_r2 = selfref.readInt();
            this.pi_stime = selfref.readInt();
            this.cr_ref = selfref.readInt();
            this.cr_ruid = selfref.readInt();
            this.cr_uid = selfref.readInt();
            this.cr_suid = selfref.readInt();
            this.cr_luid = selfref.readInt();
            this.cr_acctid = selfref.readInt();
            this.cr_gid = selfref.readInt();
            this.cr_rgid = selfref.readInt();
            this.cr_sgid = selfref.readInt();
            this.cr_ngrps = selfref.readShort();
            this.cr_caps = selfref.readShort();
            for (n = 0; n < this.un_groups.length; ++n) {
                this.un_groups[n] = selfref.readInt();
            }
            for (n = 0; n < this.cr_mpriv.length; ++n) {
                this.cr_mpriv[n] = selfref.readInt();
            }
            for (n = 0; n < this.cr_ipriv.length; ++n) {
                this.cr_ipriv[n] = selfref.readInt();
            }
            for (n = 0; n < this.cr_epriv.length; ++n) {
                this.cr_epriv[n] = selfref.readInt();
            }
            for (n = 0; n < this.cr_bpriv.length; ++n) {
                this.cr_bpriv[n] = selfref.readInt();
            }
            this.cr_pag = selfref.readInt();
            selfref.readInt();
            this.pi_ru_utime_sec = selfref.readInt();
            this.pi_ru_utime_usec = selfref.readInt();
            this.pi_ru_stime_sec = selfref.readInt();
            this.pi_ru_stime_usec = selfref.readInt();
            this.pi_ru_maxrss = selfref.readLong();
            this.pi_ru_ixrss = selfref.readLong();
            this.pi_ru_isrss = selfref.readLong();
            this.pi_ru_minflt = selfref.readLong();
            this.pi_ru_majflt = selfref.readLong();
            this.pi_ru_nswap = selfref.readLong();
            this.pi_ru_inblock = selfref.readLong();
            this.pi_ru_oublock = selfref.readLong();
            this.pi_ru_msgsnd = selfref.readLong();
            this.pi_ru_msgrcv = selfref.readLong();
            this.pi_ru_nsignals = selfref.readLong();
            this.pi_ru_nvcsw = selfref.readLong();
            this.pi_ru_nivcsw = selfref.readLong();
            this.pi_cru_utime_sec = selfref.readInt();
            this.pi_cru_utime_usec = selfref.readInt();
            this.pi_cru_stime_sec = selfref.readInt();
            this.pi_cru_stime_usec = selfref.readInt();
            this.pi_cru_maxrss = selfref.readLong();
            this.pi_cru_ixrss = selfref.readLong();
            this.pi_cru_idrss = selfref.readLong();
            this.pi_cru_isrss = selfref.readLong();
            this.pi_cru_minflt = selfref.readLong();
            this.pi_cru_majflt = selfref.readLong();
            this.pi_cru_nswap = selfref.readLong();
            this.pi_cru_inblock = selfref.readLong();
            this.pi_cru_oublock = selfref.readLong();
            this.pi_cru_msgsnd = selfref.readLong();
            this.pi_cru_msgrcv = selfref.readLong();
            this.pi_cru_nsignals = selfref.readLong();
            this.pi_cru_nvcsw = selfref.readLong();
            this.pi_cru_nivcsw = selfref.readLong();
            this.pi_ioch = selfref.readLong();
            this.pi_irss = selfref.readLong();
            this.pi_start = selfref.readLong();
            for (n = 0; n < 8; ++n) {
                this.rlim_cur[n] = selfref.readLong();
                this.rlim_max[n] = selfref.readLong();
            }
            this.pi_cmask = selfref.readShort();
            selfref.readByte();
            selfref.readByte();
            this.pi_cdir = selfref.readInt();
            this.pi_rdir = selfref.readInt();
            this.pi_maxofile = selfref.readInt();
            selfref.read(this.pi_comm);
            selfref.read(this.pi_pad);
            this.pi_drss = selfref.readLong();
            this.pi_trss = selfref.readLong();
            this.pi_dvm = selfref.readLong();
            this.pi_prm = selfref.readLong();
            this.pi_tsize = selfref.readLong();
            this.pi_dsize = selfref.readLong();
            this.pi_sdsize = selfref.readLong();
            for (n = 0; n < 64; ++n) {
                this.pi_signal[n] = selfref.readLong();
            }
            for (n = 0; n < 64; ++n) {
                this.pi_sigflags[n] = selfref.readByte();
            }
            this.pi_sig_loset = selfref.readInt();
            this.pi_sig_highset = selfref.readInt();
            selfref.read(new byte[72]);
            for (n = 0; n < this.pi_resvd.length; ++n) {
                this.pi_resvd[n] = selfref.readInt();
            }
        }

        void populate64Bit() throws IOException {
            int n;
            this.pi_pid = selfref.readLong();
            this.pi_ppid = selfref.readLong();
            this.pi_sid = selfref.readLong();
            this.pi_pgrp = selfref.readLong();
            this.pi_uid = selfref.readLong();
            this.pi_suid = selfref.readLong();
            this.pi_ttyp = selfref.readLong();
            selfref.readLong();
            this.pi_ttyd = selfref.readLong();
            this.pi_ttympx = selfref.readLong();
            this.pi_nice = selfref.readLong();
            this.pi_state = selfref.readLong();
            this.pi_flags = selfref.readLong();
            this.pi_flags2 = selfref.readLong();
            this.pi_thcount = selfref.readLong();
            this.pi_cpu = selfref.readLong();
            this.pi_pri = selfref.readLong();
            this.pi_maxofile = selfref.readLong();
            this.pi_cdir = selfref.readLong();
            this.pi_rdir = selfref.readLong();
            this.pi_cmask = selfref.readShort();
            selfref.readShort();
            selfref.read(this.pi_comm);
            this.pi_adspace = selfref.readLong();
            this.pi_majflt = selfref.readLong();
            this.pi_minflt = selfref.readLong();
            this.pi_repage = selfref.readLong();
            this.pi_size = selfref.readLong();
            this.pi_utime = selfref.readLong();
            this.pi_stime = selfref.readLong();
            selfref.read(new byte[1024]);
            this.pi_ru_utime_sec = selfref.readLong();
            this.pi_ru_utime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_ru_stime_sec = selfref.readLong();
            this.pi_ru_stime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_ru_maxrss = selfref.readLong();
            this.pi_ru_ixrss = selfref.readLong();
            this.pi_ru_idrss = selfref.readLong();
            this.pi_ru_isrss = selfref.readLong();
            this.pi_ru_minflt = selfref.readLong();
            this.pi_ru_majflt = selfref.readLong();
            this.pi_ru_nswap = selfref.readLong();
            this.pi_ru_inblock = selfref.readLong();
            this.pi_ru_oublock = selfref.readLong();
            this.pi_ru_msgsnd = selfref.readLong();
            this.pi_ru_msgrcv = selfref.readLong();
            this.pi_ru_nsignals = selfref.readLong();
            this.pi_ru_nvcsw = selfref.readLong();
            this.pi_ru_nivcsw = selfref.readLong();
            this.pi_cru_utime_sec = selfref.readLong();
            this.pi_cru_utime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_cru_stime_sec = selfref.readLong();
            this.pi_cru_stime_usec = selfref.readLong();
            selfref.readLong();
            this.pi_cru_maxrss = selfref.readLong();
            this.pi_cru_ixrss = selfref.readLong();
            this.pi_cru_idrss = selfref.readLong();
            this.pi_cru_isrss = selfref.readLong();
            this.pi_cru_minflt = selfref.readLong();
            this.pi_cru_majflt = selfref.readLong();
            this.pi_cru_nswap = selfref.readLong();
            this.pi_cru_inblock = selfref.readLong();
            this.pi_cru_oublock = selfref.readLong();
            this.pi_cru_msgsnd = selfref.readLong();
            this.pi_cru_msgrcv = selfref.readLong();
            this.pi_cru_nsignals = selfref.readLong();
            this.pi_cru_nvcsw = selfref.readLong();
            this.pi_cru_nivcsw = selfref.readLong();
            this.pi_ioch = selfref.readLong();
            this.pi_irss = selfref.readLong();
            this.pi_start = selfref.readLong();
            for (n = 0; n < 8; ++n) {
                this.rlim_cur[n] = selfref.readLong();
                this.rlim_max[n] = selfref.readLong();
            }
            this.pi_drss = selfref.readLong();
            this.pi_trss = selfref.readLong();
            this.pi_dvm = selfref.readLong();
            this.pi_prm = selfref.readLong();
            this.pi_tsize = selfref.readLong();
            this.pi_dsize = selfref.readLong();
            this.pi_sdsize = selfref.readLong();
            for (n = 0; n < 256; ++n) {
                this.pi_signal64[n] = selfref.readLong();
            }
            for (n = 0; n < 256; ++n) {
                this.pi_sigflags64[n] = selfref.readLong();
            }
            for (n = 0; n < 4; ++n) {
                this.pi_ss64[n] = selfref.readLong();
            }
            selfref.read(new byte[72]);
            this.pi_chk_utime = selfref.readLong();
            this.pi_chk_stime = selfref.readLong();
            this.pi_resvd[4] = selfref.readLong();
        }
    }

    static class Thrdctx {
        long ti_tid;
        long ti_pid;
        long ti_pri;
        long ti_policy;
        long ti_state;
        long ti_flag;
        long ti_scount;
        long ti_wtype;
        long ti_wchan;
        long ti_cpu;
        long ti_cpuid;
        long ti_affinity;
        long ti_sigmask_loset;
        long ti_sigmask_hiset;
        long[] ti_sigmask64 = new long[4];
        long ti_sig_loset;
        long ti_sig_hiset;
        long[] ti_sig64 = new long[4];
        long ti_code;
        long ti_scp;
        long ti_cursig;
        byte[] ti_pad = new byte[7];
        long ti_oldmask_loset;
        long ti_oldmask_hiset;
        long[] ti_oldmask64 = new long[4];
        long ti_stkb;
        long ti_ucontext;
        long ti_sigsp;
        long ti_sigssz;
        long ti_userdata;
        long ti_errnopp;
        long ti_ustk;
        long ti_ticks;
        long ti_dispct;
        long ti_fpuct;
        long ti_watch;
        long[] ti_resvd = new long[7];
        long[] ti_64bit_resvd = new long[8];
        long prev;
        long kjmpbuf;
        long stackfix;
        long intpri;
        long backt;
        byte[] rsvd = new byte[2];
        long curid;
        long excp_type;
        long mq;
        long tid;
        long fpscr;
        long fpeu;
        long fpinfo;
        byte[] pad = new byte[2];
        long[] except = new long[5];
        byte[] pad1 = new byte[4];
        long o_iar;
        long o_toc;
        long o_arg1;
        long excbranch;
        long fpscrx;
        long o_vaddr;
        long[] cachealign = new long[7];
        long alloc;
        long[] srval = new long[16];
        long ti_ru_utime_sec;
        long ti_ru_utime_usec;
        long ti_ru_stime_sec;
        long ti_ru_stime_usec;
        long ti_ru_maxrss;
        long ti_ru_ixrss;
        long ti_ru_idrss;
        long ti_ru_isrss;
        long ti_ru_minflt;
        long ti_ru_majflt;
        long ti_ru_nswap;
        long ti_ru_inblock;
        long ti_ru_oublock;
        long ti_ru_msgsnd;
        long ti_ru_msgrcv;
        long ti_ru_nsignals;
        long ti_ru_nvcsw;
        long ti_ru_nivcsw;
        Vector gpr = new Vector(32);
        Vector fpr = new Vector(32);
        HashMap specials = new HashMap();

        public Thrdctx(RandomAccessFile randomAccessFile, long l) {
            try {
                if (selfref.bIs32Bit) {
                    this.populate32BitThread();
                } else {
                    this.populate64BitThread();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void populate64BitThread() throws IOException {
            int n;
            this.ti_tid = selfref.readLong();
            this.ti_pid = selfref.readLong();
            this.ti_pri = selfref.readLong();
            this.ti_policy = selfref.readLong();
            this.ti_state = selfref.readLong();
            this.ti_flag = selfref.readLong();
            this.ti_scount = selfref.readLong();
            this.ti_wtype = selfref.readLong();
            this.ti_cpu = selfref.readLong();
            this.ti_cpuid = selfref.readInt();
            this.ti_affinity = selfref.readInt();
            selfref.readLong();
            this.ti_wchan = selfref.readLong();
            for (n = 0; n < this.ti_sigmask64.length; ++n) {
                this.ti_sigmask64[n] = selfref.readLong();
            }
            for (n = 0; n < this.ti_sig64.length; ++n) {
                this.ti_sig64[n] = selfref.readLong();
            }
            this.ti_code = selfref.readLong();
            this.ti_scp = selfref.readLong();
            this.ti_cursig = selfref.readByte();
            selfref.read(this.ti_pad);
            for (n = 0; n < this.ti_oldmask64.length; ++n) {
                this.ti_oldmask64[n] = selfref.readLong();
            }
            this.ti_stkb = selfref.readLong();
            this.ti_ucontext = selfref.readLong();
            this.ti_sigsp = selfref.readLong();
            this.ti_sigssz = selfref.readLong();
            this.ti_userdata = selfref.readLong();
            this.ti_errnopp = selfref.readLong();
            this.ti_ustk = selfref.readLong();
            this.ti_ticks = selfref.readLong();
            this.ti_dispct = selfref.readLong();
            this.ti_fpuct = selfref.readLong();
            this.ti_watch = selfref.readLong();
            this.ti_ru_utime_sec = selfref.readLong();
            this.ti_ru_utime_usec = selfref.readLong();
            selfref.readLong();
            this.ti_ru_stime_sec = selfref.readLong();
            this.ti_ru_stime_usec = selfref.readLong();
            selfref.readLong();
            this.ti_ru_maxrss = selfref.readLong();
            this.ti_ru_ixrss = selfref.readLong();
            this.ti_ru_idrss = selfref.readLong();
            this.ti_ru_isrss = selfref.readLong();
            this.ti_ru_minflt = selfref.readLong();
            this.ti_ru_majflt = selfref.readLong();
            this.ti_ru_nswap = selfref.readLong();
            this.ti_ru_inblock = selfref.readLong();
            this.ti_ru_oublock = selfref.readLong();
            this.ti_ru_msgsnd = selfref.readLong();
            this.ti_ru_msgrcv = selfref.readLong();
            this.ti_ru_nsignals = selfref.readLong();
            this.ti_ru_nvcsw = selfref.readLong();
            this.ti_ru_nivcsw = selfref.readLong();
            for (n = 0; n < this.ti_64bit_resvd.length; ++n) {
                this.ti_64bit_resvd[n] = selfref.readLong();
            }
            for (n = 0; n < 32; ++n) {
                this.gpr.add(new Long(selfref.readLong()));
            }
            this.specials.put("msr", new Long(selfref.readLong()));
            this.specials.put("iar", new Long(selfref.readLong()));
            this.specials.put("lr", new Long(selfref.readLong()));
            this.specials.put("ctr", new Long(selfref.readLong()));
            this.specials.put("cr", new Long(selfref.readLong()));
            this.specials.put("xer", new Long(selfref.readLong()));
            this.fpscr = selfref.readLong();
            this.fpscrx = selfref.readLong();
            this.except[1] = selfref.readLong();
            for (n = 0; n < 32; ++n) {
                this.fpr.add(new Long(selfref.readLong()));
            }
            this.fpeu = selfref.readByte();
            this.fpinfo = selfref.readByte();
            selfref.readByte();
            selfref.readByte();
            this.excp_type = selfref.readLong();
        }

        private void populate32BitThread() throws IOException {
            int n;
            this.tid = this.ti_tid = (long)selfref.readInt();
            this.ti_pid = selfref.readInt();
            this.ti_pri = selfref.readInt();
            this.ti_policy = selfref.readInt();
            this.ti_state = selfref.readInt();
            this.ti_flag = selfref.readInt();
            this.ti_scount = selfref.readInt();
            this.ti_wtype = selfref.readInt();
            this.ti_wchan = selfref.readLong();
            this.ti_cpu = selfref.readInt();
            this.ti_cpuid = selfref.readShort();
            this.ti_affinity = selfref.readShort();
            this.ti_sigmask_loset = selfref.readInt();
            this.ti_sigmask_hiset = selfref.readInt();
            this.ti_sig_loset = selfref.readInt();
            this.ti_sig_hiset = selfref.readInt();
            this.ti_code = selfref.readLong();
            this.ti_scp = selfref.readLong();
            this.ti_cursig = selfref.readByte();
            selfref.read(this.ti_pad);
            this.ti_oldmask_loset = selfref.readInt();
            this.ti_oldmask_hiset = selfref.readInt();
            this.ti_stkb = selfref.readLong();
            this.ti_ucontext = selfref.readLong();
            this.ti_sigsp = selfref.readLong();
            this.ti_sigssz = selfref.readLong();
            this.ti_userdata = selfref.readLong();
            this.ti_errnopp = selfref.readLong();
            this.ti_ustk = selfref.readLong();
            this.ti_ticks = selfref.readInt();
            this.ti_dispct = selfref.readInt();
            this.ti_fpuct = selfref.readInt();
            this.ti_watch = selfref.readInt();
            for (n = 0; n < this.ti_resvd.length; ++n) {
                this.ti_resvd[n] = selfref.readInt();
            }
            selfref.readInt();
            this.prev = selfref.readInt();
            this.kjmpbuf = selfref.readInt();
            this.stackfix = selfref.readInt();
            this.intpri = selfref.readByte();
            this.backt = selfref.readByte();
            selfref.read(this.rsvd);
            this.curid = selfref.readInt();
            this.excp_type = selfref.readInt();
            this.specials.put("iar", new Long(selfref.readInt()));
            this.specials.put("msr", new Long(selfref.readInt()));
            this.specials.put("cr", new Long(selfref.readInt()));
            this.specials.put("lr", new Long(selfref.readInt()));
            this.specials.put("ctr", new Long(selfref.readInt()));
            this.specials.put("xer", new Long(selfref.readInt()));
            this.mq = selfref.readInt();
            this.tid = selfref.readInt();
            this.fpscr = selfref.readInt();
            this.fpeu = selfref.readByte();
            this.fpinfo = selfref.readByte();
            selfref.read(this.pad);
            for (n = 0; n < this.except.length; ++n) {
                this.except[n] = selfref.readInt();
            }
            selfref.read(this.pad1);
            this.o_iar = selfref.readInt();
            this.o_toc = selfref.readInt();
            this.o_arg1 = selfref.readInt();
            this.excbranch = selfref.readInt();
            this.fpscrx = selfref.readInt();
            this.o_vaddr = selfref.readInt();
            for (n = 0; n < this.cachealign.length; ++n) {
                this.cachealign[n] = selfref.readInt();
            }
            this.alloc = selfref.readInt();
            for (n = 0; n < 16; ++n) {
                this.srval[n] = selfref.readInt();
            }
            for (n = 0; n < 32; ++n) {
                this.gpr.add(new Long(selfref.readInt()));
            }
            for (n = 0; n < 32; ++n) {
                this.fpr.add(new Long(selfref.readLong()));
            }
        }
    }

    static class CoreHeader {
        static final long FULL_CORE = 1L;
        static final long CORE_VERSION_1 = 2L;
        static final long MSTS_VALID = 4L;
        static final long CORE_BIGDATA = 8L;
        static final long UBLOCK_VALID = 16L;
        static final long USTACK_VALID = 32L;
        static final long LE_VALID = 64L;
        static final long CORE_TRUNC = 128L;
        static final int POWER_RS1 = 1;
        static final int POWER_RSC = 2;
        static final int POWER_RS2 = 4;
        static final int POWER_601 = 8;
        static final int POWER_603 = 32;
        static final int POWER_604 = 16;
        static final int POWER_620 = 64;
        static final int POWER_630 = 128;
        static final int POWER_A35 = 256;
        static final int POWER_RS64II = 512;
        static final int POWER_RS64III = 1024;
        static final int POWER_4 = 2048;
        static final int POWER_MPC7450 = 4096;
        public byte c_signo;
        public byte c_flag;
        public short c_entries;
        public int c_version;
        public long c_fdsinfox;
        public long c_loader;
        public long c_lsize;
        public int c_n_thr;
        public int c_reserved0;
        public long c_thr;
        public long c_segs;
        public long c_segregion;
        public long c_stack;
        public long c_stackorg;
        public long c_size;
        public long c_data;
        public long c_dataorg;
        public long c_datasize;
        public long c_sdorg;
        public long c_sdsize;
        public long c_vmregions;
        public long c_vmm;
        public int c_impl;
        public int c_pad;
        public long c_cprs;
        public long[] c_reserved = new long[7];
        public Thrdctx c_flt;
        public Userx c_u;
        Vector threadVector;

        public CoreHeader(RandomAccessFile randomAccessFile, long l, boolean bl) {
            try {
                randomAccessFile.seek(l);
                this.c_signo = randomAccessFile.readByte();
                this.c_flag = randomAccessFile.readByte();
                if (((long)this.c_flag & 0x80L) != 0L) {
                    System.out.println("Core file is truncated\n***This dump will NOT be adequate for problem determination.***");
                }
                this.c_entries = randomAccessFile.readShort();
                this.c_version = randomAccessFile.readInt();
                this.c_fdsinfox = randomAccessFile.readLong();
                this.c_loader = randomAccessFile.readLong();
                this.c_lsize = randomAccessFile.readLong();
                this.c_n_thr = randomAccessFile.readInt();
                this.c_reserved0 = randomAccessFile.readInt();
                this.c_thr = randomAccessFile.readLong();
                this.c_segs = randomAccessFile.readLong();
                this.c_segregion = randomAccessFile.readLong();
                this.c_stack = randomAccessFile.readLong();
                this.c_stackorg = randomAccessFile.readLong();
                this.c_size = randomAccessFile.readLong();
                this.c_data = randomAccessFile.readLong();
                this.c_dataorg = randomAccessFile.readLong();
                this.c_datasize = randomAccessFile.readLong();
                this.c_sdorg = randomAccessFile.readLong();
                this.c_sdsize = randomAccessFile.readLong();
                this.c_vmregions = randomAccessFile.readLong();
                this.c_vmm = randomAccessFile.readLong();
                this.c_impl = randomAccessFile.readInt();
                this.c_pad = randomAccessFile.readInt();
                this.c_cprs = randomAccessFile.readLong();
                for (int i = 0; i < this.c_reserved.length; ++i) {
                    this.c_reserved[i] = randomAccessFile.readLong();
                }
                if (bl) {
                    this.c_flt = new Thrdctx(randomAccessFile, randomAccessFile.getFilePointer());
                    this.c_u = new Userx(randomAccessFile, randomAccessFile.getFilePointer());
                    Vector<Thrdctx> vector = new Vector<Thrdctx>();
                    vector.add(this.c_flt);
                    if (this.c_n_thr > 0) {
                        this.getThreadData(randomAccessFile, vector);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void getThreadData(RandomAccessFile randomAccessFile, Vector vector) throws IOException {
            randomAccessFile.seek(this.c_thr);
            for (int i = 0; i < this.c_n_thr; ++i) {
            }
        }
    }
}

