/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.command.DumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.trace.J9JVMBaseTraceCommands;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.DvNamesIndexFile;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9XMLHandler;
import com.ibm.jvm.j9.dump.saxhandler.GenericSaxHandler;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.J9Method;
import com.ibm.jvm.j9.dump.systemdump.J9Monitor;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.SAXException;

public class J9JVMBaseCmds
extends CommandPlugin {
    private boolean JUSTATEST = false;
    private Observer observer;
    private J9JVMBaseCmds mySelf = this;
    private Command[] myCommands;
    private Command[] commandsPostSetMetadata;
    private static boolean allocBitsDone;
    private static boolean setMetaDataDone;
    private static J9JVMBaseTraceCommands traceProcessor;

    public J9JVMBaseCmds() {
        int n = 1;
        this.myCommands = new Command[n];
        this.myCommands[0] = new Command("set", "metadata", this.mySelf, true, true, false, "Identifies xml metadata file - rarely needed)");
        n = 9;
        this.commandsPostSetMetadata = new Command[n];
        this.commandsPostSetMetadata[0] = new Command("dis", "class", this.mySelf, true, true, false, "display details for a  class (fields,methods,statics)");
        this.commandsPostSetMetadata[1] = new Command("dis", "object", this.mySelf, true, true, true, "display details of an object instance");
        this.commandsPostSetMetadata[2] = new Command("dis", "cls", this.mySelf, true, true, false, "display class summary ");
        this.commandsPostSetMetadata[3] = new Command("dis", "os", this.mySelf, true, true, false, "identify and record all objects in known heaps");
        this.commandsPostSetMetadata[4] = new Command("dis", "ls", this.mySelf, true, true, false, "display a summary of all the locks");
        this.commandsPostSetMetadata[5] = new Command("dis", "lo", this.mySelf, true, true, false, "display locked objects");
        this.commandsPostSetMetadata[6] = new Command("deadlock", "*", this.mySelf, true, true, true, "analyse locks to detect deadlock");
        this.commandsPostSetMetadata[7] = new Command("trace", "*", this.mySelf, true, true, false, "trace commands - use \"help trace\" for more info");
        this.commandsPostSetMetadata[8] = new Command("dis", "jitm", this.mySelf, true, true, true, "display jitted methods");
    }

    public String go(String string, String string2) {
        String string3 = null;
        CommandDetails commandDetails = new CommandDetails(string);
        String string4 = commandDetails.getVerb();
        String string5 = commandDetails.getNoun();
        if (string4.equals("SET") && string5.equals("METADATA")) {
            string3 = this.doSetMetadata(commandDetails.getRest());
        } else if (string4.equals("DIS") && string5.equals("CLASS")) {
            string3 = this.doDisplayClass(commandDetails.getRest());
        } else if (string4.equals("DIS") && string5.equals("CLS")) {
            string3 = this.doDisplayClassSummary(commandDetails.getRest());
        } else if (string4.equals("DIS") && string5.equals("OBJECT")) {
            string3 = this.doDisplayObject(commandDetails.getRest());
        } else if (string4.equals("DIS") && string5.equals("OS")) {
            string3 = null == commandDetails.getRest() || commandDetails.getRest().equals("") ? this.doDisplayObjectSummary() : this.doDisplayObjectSummary(commandDetails.getRest());
        } else if (string4.equals("DIS") && string5.equals("LS")) {
            string3 = this.doDisplayMonitorSummary();
        } else if (string4.equals("DIS") && string5.equals("JITM")) {
            string3 = this.doDisplayJittedMethods();
        } else if (string4.equals("DEADLOCK")) {
            string3 = this.doDeadlock();
        } else if (string4.equals("DIS") && string5.equals("LO")) {
            string3 = this.doDisplayMonitorDetail(commandDetails.getRest());
        } else if (string4.equals("TRACE")) {
            string3 = this.doTrace(commandDetails);
        }
        return string3;
    }

    public Command[] getCommandSet() {
        return this.myCommands;
    }

    private String doSetMetadata(String string) {
        Object object;
        Object object2;
        String string2 = null;
        if (setMetaDataDone) {
            return "\"set metadata\" has already been done for this session";
        }
        try {
            object2 = new File(string);
            if (J9JVMBaseCmds.checkXML((File)object2)) {
                object = new GenericSaxHandler((File)object2, new J9XMLHandler(), this);
                Console.setProperty("metadata", string);
                setMetaDataDone = true;
            } else {
                string2 = " File not valid xml - needs to exist and start \"<?xml version=\"";
            }
        }
        catch (SAXException sAXException) {
            string2 = "*** Fatal SAXException detected\n    This may affect the viability of commands that depend on xml (such as \"dis os\").";
            setMetaDataDone = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = Console.getProperty("WORKDIR");
            string2 = null != object && !string.startsWith((String)object) ? this.doSetMetadata((String)object + File.separator + string) : "File \"" + string + "\" not found";
        }
        if (setMetaDataDone) {
            Vector vector;
            object2 = DumpConsole.getTheDump();
            object = ((Dump)object2).getCurrentJvm();
            if (null != object && (vector = ((J9Jvm)object).getThreads()).size() > 0) {
                String string3 = J9JVMConsole.getFailingThreadId();
                GenericThread genericThread = null;
                if (null != string3) {
                    for (GenericThread genericThread2 : vector) {
                        String string4 = genericThread2.getThreadId().toUpperCase();
                        if (!string4.equals(string3)) continue;
                        genericThread = genericThread2;
                        break;
                    }
                } else {
                    genericThread = (GenericThread)vector.get(0);
                }
                DumpBaseCmds.setCurrentThread(genericThread);
            }
            if (null != GenericSaxHandler.getGpfSb()) {
                this.notifyObservers("\n\nGPF details\n=====================\n\n");
                this.notifyObservers(GenericSaxHandler.getGpfSb());
                this.notifyObservers("\n\n!!!! WARNING - WARNING - WARNING !!!!\n");
                this.notifyObservers("As this dump was produced due to a General protection Fault (gpf)");
                this.notifyObservers("it is possible that there will have been errors found when analysing");
                this.notifyObservers("the dump with jextract. Jdmpview may also encounter errors in its analyis.");
                this.notifyObservers("You may observe other error messages being issued within this session");
                this.notifyObservers("\n!!!! WARNING - WARNING - WARNING !!!!\n");
            }
            DumpConsole.addInAdditionalCommands(this.commandsPostSetMetadata, this);
        }
        return string2;
    }

    private String doDisplayClass(String string) {
        String string2 = null;
        J9Class j9Class = J9JVMConsole.getClass(string);
        if (null == j9Class) {
            string2 = " Cannot find a class called \"" + string + "\"";
        } else {
            String string3 = j9Class.toString();
            this.notifyObservers(string3);
        }
        return string2;
    }

    private String doDisplayObject(String string) {
        String string2 = null;
        long[] lArray = null;
        String string3 = string.trim().toUpperCase();
        boolean bl = false;
        long l = 0L;
        if (string3.startsWith("0X")) {
            string3 = DumpUtils.stripOff0x(string3);
            try {
                l = DumpUtils.parseLongHex(string3);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyObservers(" " + string + " is invalid");
                return string2;
            }
        }
        Object object = string.trim();
        lArray = J9JVMConsole.getNamesFile().getInstancesForClass((String)object);
        if (null != lArray) {
            bl = false;
        } else {
            try {
                l = DumpUtils.parseLongHex((String)object);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyObservers(" " + string + " is invalid");
                return string2;
            }
        }
        if (bl) {
            object = J9Heap.checkForObject(l);
            if (null != object) {
                this.notifyObservers(((J9Object)object).toString());
            } else {
                this.notifyObservers("\n 0x" + Long.toHexString(l) + " not recognized as a valid object");
            }
        } else {
            for (int i = 0; i < lArray.length; ++i) {
                J9Object j9Object = J9Heap.checkForObject(lArray[i]);
                if (null != j9Object) {
                    this.notifyObservers(j9Object.toString());
                } else {
                    this.notifyObservers("\n 0x" + Long.toHexString(l) + " not recognized as a valid object");
                }
                this.notifyObservers("\n====================================================");
            }
        }
        return string2;
    }

    private String doDisplayMonitorSummary() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Monitor Summary\n ==============");
        Vector vector = J9JVMConsole.getKnownMonitors();
        Iterator<Object> iterator = vector.iterator();
        this.notifyObservers("\n Known Monitors....\n");
        while (iterator.hasNext()) {
            J9Monitor j9Monitor = (J9Monitor)iterator.next();
            this.notifyObservers(j9Monitor.toString());
        }
        this.notifyObservers("\n\n Locked Objects.....\n");
        iterator = J9JVMConsole.getLockedObjectsByAddress().keySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            J9Object j9Object = new J9Object(l, -1);
            this.notifyObservers(j9Object.getClassForObject().getName() + "@0x" + Long.toHexString(j9Object.getObjectAddress()) + " is Locked by thread with id 0x" + Long.toHexString(j9Object.getLockInfo() >>> 4 << 4));
        }
        this.notifyObservers("\n Finished lock summary");
        return string;
    }

    private String doDisplayMonitorDetail(String string) {
        String string2 = null;
        return string2;
    }

    private String doDisplayJittedMethods() {
        Set set = J9JVMConsole.getKnownClassesByName().keySet();
        Object[] objectArray = new String[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = (String)iterator.next();
            ++n;
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            J9Class j9Class = (J9Class)J9JVMConsole.getKnownClassesByName().get(objectArray[n]);
            Vector vector = j9Class.getMethods();
            if (vector == null) continue;
            for (J9Method j9Method : vector) {
                if (j9Method.getJitStart() == 0L) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\t" + (String)objectArray[n] + "::" + j9Method.getMethodName() + j9Method.getSignature() + "  start=0x");
                stringBuffer.append(Long.toHexString(j9Method.getJitStart()) + "  end=0x");
                stringBuffer.append(Long.toHexString(j9Method.getJitEnd()));
                this.notifyObservers(stringBuffer.toString());
            }
        }
        return "finished \"dis jitm\"";
    }

    private String doTrace(CommandDetails commandDetails) {
        String string = null;
        String[] stringArray = new String[]{"FORMAT", "EXTRACT", "SUMMARY", "HELP", "DISPLAY", "THREADS", "ENTRIES", "INDENT", "VERBOSE", "SYMBOLIC", "DATADIR", "SET", "OUTFILENAME", "DIS"};
        String string2 = commandDetails.getNoun();
        if (null == string2) {
            string2 = "HELP";
        }
        int n = -1;
        for (int i = 0; i < stringArray.length && n == -1; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            n = i;
        }
        if (-1 != n && null == traceProcessor) {
            traceProcessor = new J9JVMBaseTraceCommands(this);
        }
        switch (n) {
            case 0: {
                string = traceProcessor.traceFormat(commandDetails.getRest());
                break;
            }
            case 1: {
                string = traceProcessor.traceExtract(commandDetails.getRest());
                break;
            }
            case 2: {
                string = traceProcessor.traceSummary(commandDetails.getRest());
                break;
            }
            case 3: {
                string = "\n\n" + Console.getHelp("TRACE");
                break;
            }
            case 4: 
            case 13: {
                string = traceProcessor.traceDisplay(commandDetails.getRest());
                break;
            }
            case 5: {
                string = traceProcessor.traceThreads(commandDetails.getRest());
                break;
            }
            case 6: {
                string = traceProcessor.traceEntries(commandDetails.getRest());
                break;
            }
            case 7: {
                string = traceProcessor.traceIVS(string2, commandDetails.getRest());
                break;
            }
            case 8: {
                string = traceProcessor.traceIVS(string2, commandDetails.getRest());
                break;
            }
            case 9: {
                string = traceProcessor.traceIVS(string2, commandDetails.getRest());
                break;
            }
            case 10: {
                string = traceProcessor.traceDatadir(commandDetails.getRest());
                break;
            }
            case 11: {
                string = traceProcessor.traceSet(commandDetails.getRest());
                break;
            }
            case 12: {
                string = traceProcessor.traceOutfilename(commandDetails.getRest());
                break;
            }
            default: {
                string = " Unrecognised TRACE subcommand \"" + string2 + "\"\n\n";
                string = string + Console.getHelp("TRACE");
            }
        }
        return string;
    }

    private String doDeadlock() {
        String string;
        int n;
        String string2 = null;
        Vector<GenericThread> vector = new Vector<GenericThread>();
        J9Jvm j9Jvm = DumpConsole.getTheDump().getCurrentJvm();
        Vector vector2 = j9Jvm.getThreads();
        for (n = 0; n < vector2.size(); ++n) {
            long l;
            J9Monitor j9Monitor;
            GenericThread genericThread = (GenericThread)vector2.get(n);
            if (!genericThread.getState().equals("Blocked")) continue;
            string = genericThread.getMonitorId();
            if (null == genericThread.getMonitorId() || 0L == (j9Monitor = J9JVMConsole.getMonitor(l = DumpUtils.parseLongHex(string))).getOwner()) continue;
            vector.add(genericThread);
        }
        if (vector.size() == 0) {
            this.notifyObservers("\n\tNo deadlocks detected\n");
        } else {
            n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                string = this.checkDeadlockCandidate((GenericThread)vector.get(i));
                if (null == string) continue;
                this.notifyObservers(string);
                n = 1;
            }
            if (0 == n) {
                this.notifyObservers("\n\tNo deadlocks detected\n");
            }
        }
        return string2;
    }

    private String checkDeadlockCandidate(GenericThread genericThread) {
        String string = null;
        Vector<GenericThread> vector = new Vector<GenericThread>();
        Vector vector2 = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = genericThread.getMonitorId();
        long l = DumpUtils.parseLongHex(string2);
        J9Monitor j9Monitor = J9JVMConsole.getMonitor(l);
        vector.add(genericThread);
        int n = 0;
        while (!bl) {
            long l2 = j9Monitor.getOwner();
            if (l2 == 0L) continue;
            GenericThread genericThread2 = J9JVMConsole.getKnownThread(l2);
            if (null == genericThread2.getMonitorId()) {
                bl = true;
                continue;
            }
            for (int i = 0; i < vector.size(); ++i) {
                if (genericThread2 != (GenericThread)vector.get(i)) continue;
                bl2 = true;
                bl = true;
                n = i;
                i = 0x7FFFFFFE;
            }
            if (bl2) {
                string = this.formulateDeadlockOutput(vector, n);
                continue;
            }
            if (bl) continue;
            vector.add(genericThread2);
            l = DumpUtils.parseLongHex(genericThread2.getMonitorId());
            j9Monitor = J9JVMConsole.getMonitor(l);
        }
        return string;
    }

    private String formulateDeadlockOutput(Vector vector, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        GenericThread genericThread = (GenericThread)vector.get(0);
        String string = genericThread.getMonitorId();
        long l = DumpUtils.parseLongHex(string);
        J9Monitor j9Monitor = J9JVMConsole.getMonitor(l);
        String string2 = j9Monitor.getObjectAddrAsString();
        String string3 = genericThread.getThreadName();
        string3 = null == string3 ? "" : " (" + string3 + ")";
        if (n != 0) {
            stringBuffer.append("\nThread " + genericThread.getThreadId() + string3 + " \n\t has become hung on a deadlock between two (or more) other threads.");
            stringBuffer.append("\n It is trying to obtain a lock on object " + string2 + " using monitor " + string);
            Vector vector2 = J9JVMConsole.getLockedObjectsByThread(genericThread);
            if (vector2 != null) {
                stringBuffer.append("\n\nThread " + genericThread.getThreadId() + " has locks on the following objects:");
                for (int i = 0; i < vector2.size(); ++i) {
                    J9Object j9Object = (J9Object)vector2.get(i);
                    stringBuffer.append("\n\t" + j9Object.getClassForObject().getName() + "@0x" + Long.toHexString(j9Object.getObjectAddress()));
                }
            }
        } else {
            Object object;
            stringBuffer.append("\nThread " + genericThread.getThreadId() + string3 + " is participating in a deadlock with " + (vector.size() - 1) + " other thread(s).");
            stringBuffer.append("\n It is trying to obtain a lock on object " + string2 + " using monitor " + string);
            stringBuffer.append("\n\nThe other participating thread(s): ");
            for (int i = 1; i < vector.size(); ++i) {
                GenericThread genericThread2 = (GenericThread)vector.get(i);
                object = genericThread2.getThreadName();
                object = object == null ? "" : " (" + (String)object + ")";
                stringBuffer.append("\n\t\t" + genericThread2.getThreadId() + "  " + (String)object);
            }
            Vector vector3 = J9JVMConsole.getLockedObjectsByThread(genericThread);
            if (vector3 != null) {
                stringBuffer.append("\n\nThread " + genericThread.getThreadId() + " has locks on the following objects:");
                for (int i = 0; i < vector3.size(); ++i) {
                    object = (J9Object)vector3.get(i);
                    stringBuffer.append("\n\t" + ((J9Object)object).getClassForObject().getName() + "@0x" + Long.toHexString(((J9Object)object).getObjectAddress()));
                }
            }
            stringBuffer.append("\n======================================================");
        }
        return stringBuffer.toString();
    }

    private String doDisplayObjectSummary(String string) {
        String string2 = null;
        int n = 10;
        if (!J9JVMConsole.getTheDump().is32bit()) {
            n = 5;
        }
        String string3 = J9JVMConsole.getTheDump().getDumpName();
        DvNamesIndexFile dvNamesIndexFile = J9JVMConsole.getNamesFile();
        if (null != dvNamesIndexFile && dvNamesIndexFile.isComplete) {
            int n2 = dvNamesIndexFile.getInstanceCountForClass(string);
            if (0 == n2) {
                string2 = "0 object instances for class \"" + string + "\"";
            } else {
                this.notifyObservers("\nThere are " + n2 + " instances of " + string + " ....\n");
                long[] lArray = dvNamesIndexFile.getInstancesForClass(string);
                StringBuffer stringBuffer = null;
                int n3 = 0;
                for (int i = 0; i < lArray.length; ++i) {
                    if (null == stringBuffer) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append("  0x" + Long.toHexString(lArray[i]));
                    if (n != ++n3) continue;
                    this.notifyObservers(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.notifyObservers(stringBuffer.toString());
                }
            }
        } else {
            string2 = "\"dis os\" needs to be run first ";
        }
        return string2;
    }

    private String doDisplayObjectSummary() {
        Object object;
        String string = null;
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        J9Heap[] j9HeapArray = J9Heap.getTheHeaps();
        if (null == j9HeapArray) {
            return "\n!!! Error !!! \n   No heaps available to scan. This suggests a problem with the xml file\n   generated by jextract (i.e. no <objects> elements within the xml).\n!!! Error !!! \n";
        }
        String string2 = J9JVMConsole.getTheDump().getDumpName();
        DvNamesIndexFile dvNamesIndexFile = J9JVMConsole.getNamesFile();
        if (null == dvNamesIndexFile || !dvNamesIndexFile.isComplete) {
            try {
                dvNamesIndexFile = new DvNamesIndexFile(string2, 123456L);
            }
            catch (IOException iOException) {
                Console.reportError("Unable to create names index file", null);
            }
        }
        J9JVMConsole.setNamesFile(dvNamesIndexFile);
        this.notifyObservers("\n Names index file in use is: " + J9JVMConsole.getNamesFile().getName() + "\n\n");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Heap Summary\n ============");
        stringBuffer.append("\n\n  WARNING: It can take a long time to traverse the heaps!!!! - Please be patient");
        this.notifyObservers(stringBuffer.toString());
        J9ObjectIterator j9ObjectIterator = J9ObjectIterator.getObjectIterator(this);
        while (j9ObjectIterator.hasNext()) {
            long l3;
            long l4;
            object = (J9Object)j9ObjectIterator.next();
            ++l;
            l2 += (long)((J9Object)object).getInstanceSize();
            if (!dvNamesIndexFile.isComplete) {
                dvNamesIndexFile.write((J9Object)object);
            }
            if (!allocBitsDone && ((J9Object)object).getHeapId() != -1) {
                j9HeapArray[((J9Object)object).getHeapId()].recordObjectPosition(((J9Object)object).getObjectAddress());
            }
            if ((l4 = (l3 = ((J9Object)object).getLockInfo()) >>> 8 << 8) == 0L) continue;
            J9JVMConsole.addLockedObject((J9Object)object);
            ++n;
        }
        allocBitsDone = true;
        dvNamesIndexFile.commit();
        object = dvNamesIndexFile.getAllClassNames();
        this.notifyObservers("\n\nObject Summary");
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            String string3 = (String)((Vector)object).get(i);
            int n2 = dvNamesIndexFile.getInstanceCountForClass(string3);
            long l5 = dvNamesIndexFile.getInstanceSizeForClass(string3);
            string3 = J9JVMBaseCmds.convertArrayName(string3);
            this.notifyObservers("  " + string3 + "  has " + n2 + " instances (total size= " + (long)n2 * l5 + ")");
        }
        this.notifyObservers("\n\n\tTotal number of objects = " + l);
        this.notifyObservers("\tTotal size of objects   = " + l2 + " bytes");
        this.notifyObservers("\n\tTotal locked objects    = " + n);
        dvNamesIndexFile.isComplete = true;
        HeapDumpBaseCmds heapDumpBaseCmds = new HeapDumpBaseCmds();
        DumpConsole.addInAdditionalCommands(heapDumpBaseCmds.getCommandSet(), heapDumpBaseCmds);
        return string;
    }

    private String doDisplayClassSummary(String string) {
        String string2 = null;
        Set set = J9JVMConsole.getKnownClassesByName().keySet();
        Object[] objectArray = new String[set.size()];
        DvNamesIndexFile dvNamesIndexFile = J9JVMConsole.getNamesFile();
        boolean bl = false;
        if (dvNamesIndexFile != null && dvNamesIndexFile.isComplete) {
            bl = true;
        }
        if (string == null || string.equals("*") || string.equals("")) {
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = (String)iterator.next();
                ++n;
            }
            Arrays.sort(objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                J9Class j9Class = (J9Class)J9JVMConsole.getKnownClassesByName().get(objectArray[n]);
                String string3 = j9Class.getName();
                long l = j9Class.getInstanceSize();
                string3 = string3 + "    instance size=" + l;
                if (bl) {
                    int n2 = dvNamesIndexFile.getInstanceCountForClass(j9Class.getName());
                    string3 = string3 + "    object count=" + n2;
                }
                this.notifyObservers(string3);
            }
        } else {
            J9Class j9Class = J9JVMConsole.getClass(string);
            if (j9Class != null) {
                long l = j9Class.getInstanceSize();
                String string4 = string + "    instance size=" + l;
                if (bl) {
                    int n = dvNamesIndexFile.getInstanceCountForClass(string);
                    string4 = string4 + "    object count=" + n;
                }
                this.notifyObservers(string4);
                if (bl) {
                    string4 = "  ";
                    long[] lArray = J9JVMConsole.getNamesFile().getInstancesForClass(string);
                    if (lArray != null) {
                        for (int i = 0; i < lArray.length; ++i) {
                            if (i % 6 == 0) {
                                this.notifyObservers(string4);
                                string4 = "  ";
                            }
                            string4 = string4 + "  0x" + Long.toHexString(lArray[i]);
                        }
                    } else {
                        string4 = "\n No objects instances for this class";
                    }
                    this.notifyObservers(string4);
                }
            } else {
                string2 = "Cannot find specified class (\"" + string + "\")";
            }
        }
        return string2;
    }

    public String checkCommandValidity(Command command) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (command.isSetDumpRun() && null == DumpConsole.getTheDump()) {
            stringBuffer.append("\n \"Set dump\" needs to be run before this command! (no dump file established)");
        }
        if (command.isSetMetadataRun() && null == J9JVMConsole.getKnownHeaps()) {
            stringBuffer.append("\n \"Set metadata\" needs to be run before this command! (no known heaps)");
        }
        if (command.isDisOsRun() && null == J9JVMConsole.getNamesFile()) {
            stringBuffer.append("\n \"Dis os\" needs to be run before this command! (no names index file)");
        }
        if ((string = stringBuffer.toString()).equals("")) {
            string = null;
        }
        return string;
    }

    public static String whatis(String string, long l, CommandPlugin commandPlugin) {
        J9Class j9Class;
        Object object;
        String string2 = null;
        int n = J9Heap.whatHeap(l);
        if (-1 == n) {
            commandPlugin.notifyObservers("\t\"" + string + " is NOT within any known heap segment (heapId = " + n + ")");
            int n2 = 24;
            if (DumpConsole.getTheDump().is32bit()) {
                n2 = 12;
            }
            object = J9JVMConsole.getKnownClassesByName();
            Iterator iterator = ((HashMap)object).keySet().iterator();
            while (iterator.hasNext()) {
                j9Class = (J9Class)((HashMap)object).get(iterator.next());
                long l2 = j9Class.getClassAddress();
                if (l2 - l > (long)n2 || l2 - l < 0L) continue;
                if (l2 == l) {
                    commandPlugin.notifyObservers("\t\"" + string + " is the address of the java/lang/Class object ....");
                } else {
                    commandPlugin.notifyObservers("\t\"" + string + " is within the java/lang/Class object ....");
                }
                commandPlugin.notifyObservers("\t\t .... for: " + j9Class.getName());
            }
        } else {
            J9Heap j9Heap = J9Heap.getAHeap(n);
            commandPlugin.notifyObservers("\t\"" + string + " is within a heap segment (heapId=" + n + " which starts at 0x" + Long.toHexString(j9Heap.getStart()) + ")");
            object = J9Heap.checkForObject(l);
            if (null != object) {
                String string3 = J9JVMBaseCmds.convertArrayName(((J9Object)object).getClassForObject().getName());
                commandPlugin.notifyObservers("\t\"" + string + " is start of an object - an instance of " + string3);
            } else {
                object = J9Heap.checkForObjectBeforeAddress(l);
                if (null != object) {
                    long l3 = ((J9Object)object).getObjectAddress();
                    int n3 = ((J9Object)object).getInstanceSize();
                    Object object2 = ((J9Object)object).getClassForObject().getName();
                    String string4 = J9JVMBaseCmds.convertArrayName(((J9Object)object).getClassForObject().getName());
                    if (l3 + (long)n3 >= l) {
                        commandPlugin.notifyObservers("\t\"" + string + " is within an object on the heap.  " + "Offset " + (l - l3) + " within " + string4 + "instance @ 0x" + Long.toHexString(l3));
                    } else {
                        commandPlugin.notifyObservers("\t\"" + string + " is ORPHANED on the heap.  " + "Offset " + (l - l3) + " from " + string4 + "instance @ 0x" + Long.toHexString(l3));
                    }
                }
            }
        }
        Object object3 = J9JVMConsole.isThisAMonitor(l);
        if (null != object3) {
            if (object3 instanceof String) {
                commandPlugin.notifyObservers("\t\"" + string + "\": " + (String)object3);
            } else {
                commandPlugin.notifyObservers("\t\"" + string + "\" is a monitor: " + ((J9Monitor)object3).getName());
            }
        }
        object = J9JVMConsole.getKnownClassesByName();
        Iterator iterator = ((HashMap)object).keySet().iterator();
        while (iterator.hasNext()) {
            j9Class = (J9Class)((HashMap)object).get(iterator.next());
            Iterator iterator2 = null;
            if (j9Class.getMethods() == null) continue;
            for (Object object2 : j9Class.getMethods()) {
                long l4 = ((J9Method)object2).getBcStart();
                long l5 = ((J9Method)object2).getJitStart();
                if (l4 != 0L && l >= l4 && l <= ((J9Method)object2).getBcEnd()) {
                    commandPlugin.notifyObservers("\t\"" + string + "\" is within the byte code range (0x" + Long.toHexString(l4) + " thru 0x" + Long.toHexString(((J9Method)object2).getBcEnd()) + ")...\n\t\tfor method \"" + ((J9Method)object2).getMethodName() + "\"...\n\t\twith signature \"" + ((J9Method)object2).getSignature() + "\"... \n\t\tin class \"" + j9Class.getName() + "\"");
                }
                if (l5 == 0L || l < l5 || l > ((J9Method)object2).getJitEnd()) continue;
                commandPlugin.notifyObservers("\t\"" + string + "\" is within the jitted code range (0x" + Long.toHexString(l5) + " thru 0x" + Long.toHexString(((J9Method)object2).getJitEnd()) + ") for method \"" + ((J9Method)object2).getMethodName() + "\" with signature \"" + ((J9Method)object2).getSignature() + "\" in class \"" + j9Class.getName() + "\"");
            }
        }
        return string2;
    }

    public static boolean isSetMetaDataDone() {
        return setMetaDataDone;
    }

    private static String convertArrayName(String string) {
        int n;
        String string2;
        String string3 = string;
        if (string.startsWith("[") && (string2 = string.substring((n = string.lastIndexOf("[")) + 1)).startsWith("0x")) {
            J9Class j9Class = J9JVMConsole.getClass(DumpUtils.parseLongHex(string2));
            string3 = string.substring(0, n + 1) + j9Class.getName();
        }
        return string3;
    }

    private static String reConvertArrayName(String string) {
        int n;
        String string2;
        J9Class j9Class;
        String string3 = string;
        if (string.startsWith("[") && (j9Class = J9JVMConsole.getClass(string2 = string.substring((n = string.lastIndexOf("[")) + 1))) != null) {
            string3 = string.substring(0, n + 1) + j9Class.getId();
        }
        return string3;
    }

    private static boolean checkXML(File file) {
        boolean bl = false;
        char[] cArray = new char[]{'<', '?', 'x', 'm', 'l'};
        char[] cArray2 = new char[]{'\u0014', '\u001a', '\u00cc', '_', '%'};
        Object var4_4 = null;
        try {
            FileReader fileReader = new FileReader(file);
            try {
                int n;
                char[] cArray3 = new char[100];
                fileReader.read(cArray3);
                boolean bl2 = true;
                for (n = 0; n < cArray.length; ++n) {
                    if (cArray3[n] == cArray[n]) continue;
                    bl2 = false;
                }
                if (!bl2) {
                    bl2 = true;
                    for (n = 0; n < cArray2.length; ++n) {
                        if (cArray3[n] == cArray2[n]) continue;
                        bl2 = false;
                    }
                }
                bl = bl2;
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bl;
    }

    static {
        traceProcessor = null;
    }
}

