/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleOutput;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleOutputToFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;

public class BaseCommands
extends CommandPlugin {
    private Observer observer;
    private BaseCommands mySelf = this;
    private Command[] myCommands;

    public BaseCommands() {
        int n = 11;
        this.myCommands = new Command[n];
        this.myCommands[0] = new Command("quit", null, this.mySelf, false, false, false, "Terminates jdmpview session");
        this.myCommands[1] = new Command("help", "*", this.mySelf, false, false, false, "Provides generic and specific help");
        this.myCommands[2] = new Command("cmds", "*", this.mySelf, false, false, false, "Shows available commands");
        this.myCommands[3] = new Command("synonyms", "*", this.mySelf, false, false, false, "Shows substitutions and short forms for commands");
        this.myCommands[4] = new Command("set", "out", this.mySelf, false, false, false, "Sets the output destination (terminal or file)");
        this.myCommands[5] = new Command("add", "out", this.mySelf, false, false, false, "Appends additional output destination");
        this.myCommands[6] = new Command("rem", "out", this.mySelf, false, false, false, "Removes an output destination");
        this.myCommands[7] = new Command("dis", "out", this.mySelf, false, false, false, "Displays output destinations");
        this.myCommands[8] = new Command("set", "workdir", this.mySelf, false, false, false, "Defines a writeable location for work files");
        this.myCommands[9] = new Command("set", "*", this.mySelf, false, false, false, "Generic command - use \"help set\" for more details");
        this.myCommands[10] = new Command("ex", "*", this.mySelf, false, false, false, "Execute commands from a file");
    }

    public String go(String string, String string2) {
        String string3 = null;
        CommandDetails commandDetails = new CommandDetails(string);
        if (null == string2) {
            string2 = new String(string);
        }
        commandDetails.equalFound = BaseCommands.analyseOriginalInput(string2, commandDetails.getNoun());
        String string4 = commandDetails.getVerb();
        String string5 = commandDetails.getNoun();
        if (string4.equals("SET")) {
            string3 = this.goSet(string5, commandDetails);
        }
        if (string4.equals("HELP")) {
            String string6 = commandDetails.getRest().toUpperCase().trim();
            if (!string6.equals("")) {
                String string7 = commandDetails.getRest().toUpperCase();
                String string8 = (String)Console.getCmdConversions().get(string7);
                if (string8 != null) {
                    string7 = string8;
                }
                string3 = this.doHelpCmd(string5 + "_" + string7);
            } else {
                string3 = this.doHelpCmd(string5);
            }
        }
        if (string4.equals("QUIT") || string4.equals("Q")) {
            string3 = this.doQuitCmd();
        }
        if (string4.equals("REGCP")) {
            string3 = this.doRegisterCommandPlugin(commandDetails.getNounOriginal());
        }
        if (string4.equals("CMDS")) {
            this.doListAvailableCommands();
        }
        if (string4.equals("SYNONYMS")) {
            this.doShowSynonyms();
        }
        if (string4.equals("ADD") && string5.equals("OUT")) {
            string3 = this.doSetOut(commandDetails.getRest(), true);
        }
        if (string4.equals("DIS") && string5.equals("OUT")) {
            string3 = this.doDisOut();
        }
        if (string4.equals("EX")) {
            string3 = this.doExecute(commandDetails);
        }
        return string3;
    }

    private String goSet(String string, CommandDetails commandDetails) {
        String string2 = null;
        String string3 = commandDetails.getRest();
        if (null == string || string.equals("")) {
            string2 = Console.getProperty(null);
        } else if (string.equals("OUT")) {
            string2 = this.doSetOut(string3, false);
        } else if (!string.equals("IN")) {
            if (string.equals("WORKDIR")) {
                string2 = this.doSetWorkdir(string3, commandDetails);
            } else if (null != string3 && !string3.equals("")) {
                string2 = Console.setProperty(string, string3);
            } else if (commandDetails.equalFound && (string3.equals("") || null == string3)) {
                string2 = Console.removeProperty(string);
            } else {
                string2 = Console.getProperty(string);
                if (string2 == null) {
                    string2 = string + " is not set";
                }
            }
        }
        return string2;
    }

    public Command[] getCommandSet() {
        return this.myCommands;
    }

    private String doQuitCmd() {
        Console.quitConsole();
        return null;
    }

    private String doExecute(CommandDetails commandDetails) {
        String string = null;
        String string2 = (commandDetails.getNounOriginal() + " " + commandDetails.getRest()).trim();
        if (string2 == "") {
            string = "No filename specified";
        } else {
            File file = new File(string2);
            if (file.isFile() && file.exists() && file.canRead()) {
                try {
                    int n = 0;
                    this.notifyObservers("Starting execution of \"" + string2 + "\"\n");
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        if (!string3.startsWith("#")) {
                            if (string3.startsWith("!")) {
                                this.notifyObservers(string3);
                            } else {
                                this.notifyObservers("Attempting execution of: " + string3);
                                Console.handleInput(string3, true);
                                ++n;
                            }
                        }
                        string3 = bufferedReader.readLine();
                    }
                    this.notifyObservers("\nEnding execution of \"" + string2 + "\" (" + n + " command lines processed)\n");
                }
                catch (Exception exception) {}
            } else {
                string = "File \"" + string2 + "\" not found , not readable, or directory";
            }
        }
        return string;
    }

    private String doHelpCmd(String string) {
        String string2 = null;
        String string3 = null;
        if (null == string) {
            string3 = Console.getHelp("GENERAL");
            this.notifyObservers(string3);
        } else {
            string3 = Console.getHelp(string);
            this.notifyObservers(string3);
        }
        return string2;
    }

    private String doListAvailableCommands() {
        StringBuffer stringBuffer = new StringBuffer();
        this.notifyObservers("Known Commands\n==============\n");
        Vector vector = Console.getCommandList();
        for (int i = 0; i < vector.size(); ++i) {
            Command command = (Command)vector.get(i);
            stringBuffer.append(command.toString() + "\n");
        }
        stringBuffer.append("\n\n\t\"help command\" shows details of each command");
        stringBuffer.append("\n\n\tNote: some supported commands may not be shown in the above\n\t");
        stringBuffer.append("list as they only become available after successful issuance\n\t");
        stringBuffer.append("of other commands (such as \"set dump\" or \"dis os\")");
        this.notifyObservers(stringBuffer);
        return null;
    }

    private String doRegisterCommandPlugin(String string) {
        this.notifyObservers("Registering " + string);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(string);
            CommandPlugin commandPlugin = (CommandPlugin)clazz.newInstance();
            Command[] commandArray = commandPlugin.getCommandSet();
            Console.registerCommandSet(commandArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Console.reportError("doRegisterCommandPlugin caught exception", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Console.reportError("doRegisterCommandPlugin caught exception", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Console.reportError("doRegisterCommandPlugin caught exception", instantiationException);
        }
        this.notifyObservers("Finished registering ........");
        return null;
    }

    private void doShowSynonyms() {
        Set set = Console.getCmdConversions().keySet();
        for (String string : set) {
            String string2 = (String)Console.getCmdConversions().get(string);
            this.notifyObservers(string + " ==> " + string2);
        }
    }

    private String doSetWorkdir(String string, CommandDetails commandDetails) {
        String string2;
        block9: {
            string2 = null;
            if (null == string && commandDetails.equalFound) {
                Console.removeProperty("WORKDIR");
            } else if (null == string) {
                this.notifyObservers(Console.getProperty("WORKDIR"));
            } else {
                File file = new File(string);
                if (file.isDirectory()) {
                    try {
                        File file2 = File.createTempFile("jformat", "tmp", file);
                        file2.delete();
                        String string3 = Console.getProperty("WORKDIR");
                        Console.setProperty("WORKDIR", string);
                        if (null == string3) {
                            this.notifyObservers("WORKDIR set to " + string);
                            break block9;
                        }
                        this.notifyObservers("WORKDIR changed from " + string3 + " to " + string);
                    }
                    catch (IOException iOException) {
                        string2 = "\"" + string + "\" is not an existing valid directory or cannot be written to";
                    }
                } else {
                    string2 = "\"" + string + "\" is not an existing valid directory or cannot be written to";
                }
            }
        }
        return string2;
    }

    private String doSetOut(String string, boolean bl) {
        Object object;
        String string2 = null;
        if (string.equals("*")) {
            if (bl) {
                this.notifyObservers(" output being directed to console");
            } else {
                this.notifyObservers(" output being re-directed to console only");
            }
            Console.setOutput(null, bl);
            Console.setBCommandEcho(false);
            return string2;
        }
        if (!string.toUpperCase().startsWith("FILE:") && null != (object = new File(string))) {
            string = "FILE:" + string;
        }
        if (string.toUpperCase().startsWith("FILE:")) {
            if (bl) {
                this.notifyObservers(" output being  directed to \"" + string + "\"");
            } else {
                this.notifyObservers(" output being  re-directed to \"" + string + "\" only");
            }
            object = new ConsoleOutputToFile();
            if (((ConsoleOutputToFile)object).init(string)) {
                Console.setOutput((ConsoleOutput)object, bl);
                Console.setBCommandEcho(true);
            } else {
                string2 = " set output failure: is \"" + string + "\" a valid location?";
            }
        } else {
            string2 = " set output failure: \"" + string + "\" not recognised as valid location";
        }
        return string2;
    }

    private String doDisOut() {
        ConsoleOutput[] consoleOutputArray = Console.getOutput();
        for (int i = 0; i < consoleOutputArray.length; ++i) {
            this.notifyObservers("#" + i + "  " + consoleOutputArray[i].toString());
        }
        return null;
    }

    public String checkCommandValidity(Command command) {
        String string = null;
        return string;
    }

    private static boolean analyseOriginalInput(String string, String string2) {
        boolean bl = false;
        if (string2 != null) {
            String string3 = string2.toUpperCase() + "=";
            if (-1 != string.toUpperCase().indexOf(string3)) {
                bl = true;
            }
        }
        return bl;
    }
}

