/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.NBAccept;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPChannelMessageConstants;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPPort;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConfigConstants;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class NBAcceptChannelSelector
extends ChannelSelector
implements TCPConfigConstants,
TCPChannelMessageConstants {
    static final TraceComponent tc = Tr.register(NBAcceptChannelSelector.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    int numExceptions = 0;
    int usageCount = 0;
    private int selectorTimeout = TCPFactoryConfiguration.getChannelSelectorIdleTimeout();

    public NBAcceptChannelSelector(boolean bl) throws IOException {
        super(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWork(Object object) {
        TCPChannelLinkedList tCPChannelLinkedList = this.ourWorkQueue;
        synchronized (tCPChannelLinkedList) {
            this.ourWorkQueue.add(object);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelector() {
        boolean bl = true;
        NBAccept.EndPointActionInfo endPointActionInfo = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updateSelector - processing " + this.ourWorkQueue.size() + " items");
        }
        while (bl) {
            Object object;
            block23: {
                object = this.ourWorkQueue;
                synchronized (object) {
                    if (this.ourWorkQueue.isEmpty()) {
                        break;
                    }
                    endPointActionInfo = (NBAccept.EndPointActionInfo)this.ourWorkQueue.removeFirst();
                }
                if (endPointActionInfo.action == 1) {
                    block22: {
                        try {
                            object = endPointActionInfo.endPoint.getServerSocket();
                            ((ServerSocket)object).getChannel().configureBlocking(false);
                            try {
                                ((ServerSocket)object).getChannel().register(this.selector, 16, endPointActionInfo.endPoint);
                                ++this.usageCount;
                            }
                            catch (ClosedChannelException closedChannelException) {
                                FFDCFilter.processException((Throwable)closedChannelException, "com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", "100", this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Caught ClosedChannelException while registering a TCPPort, port number: " + endPointActionInfo.endPoint.getListenPort());
                                }
                            }
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", "101", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block22;
                            Tr.event(tc, "Caught IOException while registering a TCPPort.");
                        }
                    }
                    object = endPointActionInfo.syncObject;
                    synchronized (object) {
                        endPointActionInfo.syncObject.notify();
                        continue;
                    }
                }
                if (endPointActionInfo.action != 0) continue;
                try {
                    object = endPointActionInfo.endPoint.getServerSocket();
                    ((ServerSocket)object).getChannel().keyFor(this.selector).cancel();
                    this.selector.selectNow();
                    --this.usageCount;
                    if (this.usageCount <= 0) {
                        this.shutDown();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", "102", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                    Tr.event(tc, "Caught IOException while removing a TCPPort.");
                }
            }
            object = endPointActionInfo.syncObject;
            synchronized (object) {
                endPointActionInfo.syncObject.notify();
            }
        }
        if (endPointActionInfo != null) {
            this.selector.wakeup();
        }
    }

    protected int getUsageCount() {
        return this.usageCount;
    }

    protected void channelSelectorClose() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean performRequest() {
        SocketChannel socketChannel = null;
        Set<SelectionKey> set = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = set.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "performRequest - processing " + set.size() + " items");
        }
        if (!set.isEmpty()) {
            while (iterator.hasNext()) {
                Object object;
                if (this.numExceptions >= 200) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.numExceptions >= 3100) {
                    object = new ChannelException("TCP Channel detected continuous exceptions while trying to accept connections and is terminating on thread: " + Thread.currentThread().getName());
                    FFDCFilter.processException((Throwable)object, "com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", "207", this);
                    System.exit(10);
                }
                object = iterator.next();
                try {
                    boolean bl;
                    TCPChannel tCPChannel;
                    TCPPort tCPPort;
                    block19: {
                        iterator.remove();
                        tCPPort = (TCPPort)((SelectionKey)object).attachment();
                        tCPChannel = tCPPort.getTCPChannel();
                        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)((SelectionKey)object).channel();
                        try {
                            socketChannel = serverSocketChannel.accept();
                            if (socketChannel == null) break block19;
                            socketChannel.configureBlocking(false);
                        }
                        catch (IOException iOException) {
                            ++this.numExceptions;
                            if (this.numExceptions > 5 && this.numExceptions % 100 != 0) continue;
                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", "103", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "TCP Channel: " + tCPChannel.getExternalName() + " caught IOException doing accept: " + iOException + " iteration number: " + this.numExceptions);
                            }
                            Tr.audit(tc, "PORT_NOT_ACCEPTING", new Object[]{tCPChannel.getExternalName(), tCPChannel.getDisplayableHostName(), String.valueOf(tCPPort.getListenPort())});
                            continue;
                        }
                    }
                    if (socketChannel == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                        Tr.event(tc, "SocketChannel tried to accept connection, but got null ");
                        continue;
                    }
                    Socket socket = socketChannel.socket();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "SocketChannel accepted, local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
                    }
                    if (!(bl = tCPChannel.verifyConnection(socket))) {
                        this.closeSocketChannel(socketChannel);
                        this.numExceptions = 0;
                        continue;
                    }
                    SocketIOChannel socketIOChannel = null;
                    try {
                        socketIOChannel = tCPChannel.createInboundSocketIOChannel(socketChannel);
                    }
                    catch (IOException iOException) {
                        ++this.numExceptions;
                        if (this.numExceptions <= 5 || this.numExceptions % 100 == 0) {
                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", "265", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "TCP Channel: " + tCPChannel.getExternalName() + " caught IOException creating inbound socket: " + iOException + " iteration number: " + this.numExceptions);
                            }
                        }
                        this.closeSocketChannel(socketChannel);
                        continue;
                    }
                    tCPPort.processNewConnection(socketIOChannel);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    ++this.numExceptions;
                    continue;
                }
                this.numExceptions = 0;
            }
        }
        return false;
    }

    private void closeSocketChannel(SocketChannel socketChannel) {
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Closing connection, local: " + socketChannel.socket().getLocalSocketAddress() + " remote: " + socketChannel.socket().getRemoteSocketAddress());
            }
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event(tc, "IOException caught while closing connection " + iOException);
            }
        }
    }

    protected void checkForTimeouts() {
        this.nextTimeoutTime = this.currentTime + (long)this.selectorTimeout;
    }

    void updateCount() {
    }
}

