/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.compression;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.compression.DeflaterPool;
import com.ibm.ws.compression.InflaterPool;
import com.ibm.ws.compression.WsDeflater;
import com.ibm.ws.compression.WsInflater;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;

public class WsByteBufferCompression {
    private static final String CLASS_NAME = "com.ibm.ws.compression.WsByteBufferCompression";
    private static final TraceComponent tc = Tr.register(WsByteBufferCompression.class, "Compression", "com.ibm.ws.compression");
    private static final byte[] GZIP_Header = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};

    private WsByteBufferCompression() {
    }

    private static final byte[] asByteArray(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            throw new NullPointerException("Input buffers");
        }
        int n = 0;
        int n2 = wsByteBufferArray.length;
        int[] nArray = new int[wsByteBufferArray.length];
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (null == wsByteBufferArray[i]) {
                n2 = i;
                break;
            }
            nArray[i] = wsByteBufferArray[i].limit();
            n += nArray[i];
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            wsByteBufferArray[i].get(byArray, n3, nArray[i]);
            n3 += nArray[i];
            wsByteBufferArray[i].position(0);
        }
        return byArray;
    }

    public static final WsByteBuffer[] deflateCompress(WsByteBuffer[] wsByteBufferArray) {
        return WsByteBufferCompression.compressBuffers(wsByteBufferArray, 0);
    }

    public static final WsByteBuffer[] gzipCompress(WsByteBuffer[] wsByteBufferArray) {
        return WsByteBufferCompression.compressBuffers(wsByteBufferArray, 1);
    }

    static final WsByteBuffer[] compressBuffers(WsByteBuffer[] wsByteBufferArray, int n) {
        WsByteBuffer[] wsByteBufferArray2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Compressing " + wsByteBufferArray + " type: " + n);
        }
        if (null == wsByteBufferArray || 1 > wsByteBufferArray.length) {
            return wsByteBufferArray;
        }
        byte[] byArray = WsByteBufferCompression.asByteArray(wsByteBufferArray);
        if (1 > byArray.length) {
            return wsByteBufferArray;
        }
        int n2 = byArray.length > 75000 ? 16384 : 8192;
        WsDeflater wsDeflater = DeflaterPool.getInstance().getEntry();
        wsDeflater.setInput(byArray, 0, byArray.length);
        wsDeflater.finish();
        ArrayList<WsByteBuffer> arrayList = new ArrayList<WsByteBuffer>();
        byte[] byArray2 = new byte[n2];
        WsByteBuffer wsByteBuffer = null;
        boolean bl = false;
        int n3 = 0;
        if (1 == n) {
            n3 = WsByteBufferCompression.writeGzipHeader(byArray2);
        }
        while (!wsDeflater.finished()) {
            n3 += wsDeflater.deflate(byArray2, n3, byArray2.length - n3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Compressed amount->" + n3);
            }
            if (0 == n3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error: Ran out of data unexpectedly");
                }
                bl = true;
                break;
            }
            wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(n3);
            wsByteBuffer.put(byArray2, 0, n3);
            wsByteBuffer.flip();
            arrayList.add(wsByteBuffer);
            n3 = 0;
        }
        wsDeflater.end();
        if (bl) {
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                ((WsByteBuffer)arrayList.get(i)).release();
            }
            return wsByteBufferArray;
        }
        if (1 == n) {
            wsByteBufferArray2 = new CRC32();
            wsByteBufferArray2.update(byArray);
            wsByteBuffer = WsByteBufferCompression.writeGzipTrailer((int)wsByteBufferArray2.getValue(), byArray.length);
            arrayList.add(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added gzip trailer buffer");
            }
        }
        wsByteBufferArray2 = new WsByteBuffer[arrayList.size()];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Compressed into " + wsByteBufferArray2.length + " size=" + n2 + " buffers.");
        }
        arrayList.toArray(wsByteBufferArray2);
        return wsByteBufferArray2;
    }

    public static final WsByteBuffer[] deflateDecompress(WsByteBuffer[] wsByteBufferArray) throws Exception {
        return WsByteBufferCompression.decompressBuffers(wsByteBufferArray, 0);
    }

    public static final WsByteBuffer[] gzipDecompress(WsByteBuffer[] wsByteBufferArray) throws Exception {
        return WsByteBufferCompression.decompressBuffers(wsByteBufferArray, 1);
    }

    static final WsByteBuffer[] decompressBuffers(WsByteBuffer[] wsByteBufferArray, int n) throws Exception {
        int n2;
        Object[] objectArray;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Decompressing " + wsByteBufferArray + " type: " + n);
        }
        if (null == wsByteBufferArray || 1 > wsByteBufferArray.length) {
            return wsByteBufferArray;
        }
        byte[] byArray = WsByteBufferCompression.asByteArray(wsByteBufferArray);
        if (1 > byArray.length) {
            return wsByteBufferArray;
        }
        int n3 = 0;
        if (1 == n) {
            n3 = WsByteBufferCompression.readGzipHeader(byArray);
        }
        WsInflater wsInflater = InflaterPool.getInstance().getEntry();
        int n4 = byArray.length > 10000 ? 16384 : 8192;
        ArrayList<WsByteBuffer> arrayList = new ArrayList<WsByteBuffer>();
        DataFormatException dataFormatException = null;
        boolean bl = false;
        try {
            wsInflater.setInput(byArray, n3, byArray.length - n3);
            objectArray = new byte[n4];
            while (!wsInflater.finished()) {
                n2 = wsInflater.inflate((byte[])objectArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decompressed amount->" + n2);
                }
                if (0 == n2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error: Ran out of data unexpectedly,");
                    }
                    bl = true;
                    break;
                }
                WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(n2);
                wsByteBuffer.put((byte[])objectArray, 0, n2);
                wsByteBuffer.flip();
                arrayList.add(wsByteBuffer);
            }
        }
        catch (DataFormatException dataFormatException2) {
            FFDCFilter.processException(dataFormatException2, "com.ibm.ws.compression.WsByteBufferCompression.decompressBuffers", "293");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "decompressBuffers received: " + dataFormatException2);
            }
            bl = true;
            dataFormatException = dataFormatException2;
        }
        wsInflater.end();
        if (bl) {
            n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                ((WsByteBuffer)arrayList.get(i)).release();
            }
            if (null != dataFormatException) {
                throw dataFormatException;
            }
            return wsByteBufferArray;
        }
        objectArray = new WsByteBuffer[arrayList.size()];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Decompressed into " + objectArray.length + " size=" + n4 + " buffers.");
        }
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private static final int writeGzipHeader(byte[] byArray) {
        System.arraycopy((Object)GZIP_Header, 0, (Object)byArray, 0, GZIP_Header.length);
        return GZIP_Header.length;
    }

    private static final WsByteBuffer writeGzipTrailer(int n, int n2) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24), (byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(8);
        wsByteBuffer.put(byArray);
        wsByteBuffer.flip();
        return wsByteBuffer;
    }

    private static final int readGzipHeader(byte[] byArray) throws Exception {
        if (null == byArray || 10 > byArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid gzip header: " + byArray);
            }
            throw new Exception("Invalid gzip header input");
        }
        int n = 0;
        if (byArray[n++] != 31 || byArray[n++] != -117) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid GZIP header id bytes");
            }
            throw new Exception("Invalid gzip header id");
        }
        if (byArray[n] != 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Non-deflate method, not supported");
            }
            throw new Exception("Unsupported compression: " + byArray[n]);
        }
        byte by = byArray[++n];
        n = 10;
        if ((by & 4) == 4) {
            int n2 = byArray[n++] | byArray[n] << 8;
            n += n2;
        }
        if ((by & 8) == 8) {
            while (0 != byArray[n]) {
                ++n;
            }
            ++n;
        }
        if ((by & 0x10) == 16) {
            while (0 != byArray[n]) {
                ++n;
            }
            ++n;
        }
        if ((by & 1) == 1) {
            n += 2;
        }
        return n;
    }
}

