/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.AboutDialog;
import com.sun.deploy.util.DefaultActionListener;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class DialogFactory {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    public static final int PLAIN_MESSAGE = 5;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    private static String confirmDialogTitle;
    private static String inputDialogTitle;
    private static String messageDialogTitle;
    private static String exceptionDialogTitle;
    private static String optionDialogTitle;
    private static String aboutDialogTitle;
    private static String javaHomeLink;
    private static DialogListener dialogListener;
    private static Icon _warningIcon;
    public static Icon _infoIcon;
    static Icon _javaIcon;
    static Icon _javaIcon48;
    private static long tsLastActive;

    public static void addDialogListener(DialogListener dialogListener) {
        if (DialogFactory.dialogListener == null) {
            UIFactory.setDialogListener(dialogListener);
            DialogFactory.dialogListener = dialogListener;
        }
    }

    public static Icon getWarningIcon() {
        if (_warningIcon == null) {
            Object object = UIManager.get("OptionPane.warningIcon");
            if (object instanceof Icon) {
                _warningIcon = (Icon)object;
            } else {
                URL uRL = ClassLoader.getSystemResource("javax/swing/plaf/metal/icons/Warn.gif");
                _warningIcon = DialogFactory.loadIcon(uRL);
            }
        }
        return _warningIcon;
    }

    public static Icon getInfoIcon() {
        if (_infoIcon == null) {
            Object object = UIManager.get("OptionPane.informationIcon");
            if (object instanceof Icon) {
                _infoIcon = (Icon)object;
            } else {
                URL uRL = ClassLoader.getSystemResource("javax/swing/plaf/metal/icons/Inform.gif");
                _infoIcon = DialogFactory.loadIcon(uRL);
            }
        }
        return _infoIcon;
    }

    public static Icon loadIcon() {
        if (_javaIcon == null) {
            _javaIcon = DialogFactory.loadIcon(ResourceManager.class.getResource("images/java32.png"));
        }
        return _javaIcon;
    }

    public static Icon loadIcon48() {
        if (_javaIcon48 == null) {
            _javaIcon = DialogFactory.loadIcon(ResourceManager.class.getResource("images/java32.png"));
        }
        return _javaIcon;
    }

    public static Icon loadIcon(final URL uRL) {
        Icon icon = null;
        try {
            icon = (Icon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ImageIcon(uRL);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return icon;
    }

    public static void showAboutJavaDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            DialogFactory.internalShowAboutJavaDialog();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DialogFactory.internalShowAboutJavaDialog();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void internalShowAboutJavaDialog() {
        LookAndFeel lookAndFeel = null;
        try {
            if (System.currentTimeMillis() - tsLastActive > 500L && AboutDialog.shouldStartNewInstance()) {
                lookAndFeel = DeployUIManager.setLookAndFeel();
                JFrame jFrame = new JFrame(ResourceManager.getMessage("about.dialog.title"));
                AboutDialog aboutDialog = new AboutDialog(jFrame, true, true);
                aboutDialog.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dimension2 = aboutDialog.getSize();
                Dimension dimension3 = jFrame.getSize();
                jFrame.setLocation(-dimension3.width + 1, -dimension3.height + 1);
                jFrame.setVisible(true);
                aboutDialog.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
                aboutDialog.setVisible(true);
                jFrame.setVisible(false);
                jFrame.dispose();
                tsLastActive = System.currentTimeMillis();
            }
            if (lookAndFeel == null) return;
        }
        catch (Exception exception) {
            if (lookAndFeel == null) return;
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
            return;
            catch (Throwable throwable) {
                if (lookAndFeel == null) throw throwable;
                DeployUIManager.restoreLookAndFeel(lookAndFeel);
                throw throwable;
            }
        }
        DeployUIManager.restoreLookAndFeel(lookAndFeel);
        return;
    }

    public static int showConfirmDialog(Object object) {
        return DialogFactory.showConfirmDialog(null, object, confirmDialogTitle);
    }

    public static int showConfirmDialog(Component component, Object object) {
        return DialogFactory.showConfirmDialog(component, object, confirmDialogTitle);
    }

    public static String showInputDialog(Object object) {
        return DialogFactory.showInputDialog(null, object, inputDialogTitle);
    }

    public static String showInputDialog(Component component, Object object) {
        return DialogFactory.showInputDialog(component, object, inputDialogTitle);
    }

    public static void showInformationDialog(Object object) {
        DialogFactory.showInformationDialog(null, object, messageDialogTitle);
    }

    public static void showInformationDialog(Component component, Object object) {
        DialogFactory.showInformationDialog(component, object, messageDialogTitle);
    }

    public static void showErrorDialog(String string) {
        DialogFactory.showErrorDialog(null, string, messageDialogTitle);
    }

    public static void showErrorDialog(Component component, String string) {
        DialogFactory.showErrorDialog(component, string, messageDialogTitle);
    }

    public static void showExceptionDialog(Throwable throwable) {
        DialogFactory.showExceptionDialog(null, throwable, throwable.toString(), exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component component, Throwable throwable) {
        DialogFactory.showExceptionDialog(component, throwable, throwable.toString(), exceptionDialogTitle);
    }

    public static int showConfirmDialog(Object object, String string) {
        return DialogFactory.showConfirmDialog(null, object, string);
    }

    public static int showConfirmDialog(final Component component, final Object object, final String string) {
        try {
            return (Integer)DeploySysRun.execute(new DeploySysAction(){

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.showConfirmDialogImpl(component, object, string));
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showConfirmDialogImpl(Component component, Object object, String string) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            JButton jButton = new JButton(ResourceManager.getMessage("dialogfactory.confirm.yes"));
            JButton jButton2 = new JButton(ResourceManager.getMessage("dialogfactory.confirm.no"));
            jButton.setMnemonic(ResourceManager.getAcceleratorKey("dialogfactory.confirm.yes"));
            jButton2.setMnemonic(ResourceManager.getAcceleratorKey("dialogfactory.confirm.no"));
            Object[] objectArray = new Object[]{jButton, jButton2};
            if (string == null) {
                string = confirmDialogTitle;
            }
            int n = DialogFactory.showOptionDialogImpl(component, 4, object, string, objectArray, objectArray[0], false);
            return n;
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    public static int showOptionDialog(Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, object, string, objectArray, object2);
    }

    public static int showOptionDialog(Component component, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(component, 5, object, string, objectArray, object2);
    }

    public static int showDownloadDialog(final int n, final String string) {
        try {
            return (Integer)DeploySysRun.execute(new DeploySysAction(){

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.showDownloadDialogImpl(n, string));
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showDownloadDialogImpl(int n, String string) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            String string2 = ResourceManager.getMessage("security.dialog.caption");
            JButton jButton = new JButton(ResourceManager.getMessage("security.dialog.buttonYes"));
            JButton jButton2 = new JButton(ResourceManager.getMessage("security.dialog.buttonNo"));
            jButton.setMnemonic(ResourceManager.getAcceleratorKey("security.dialog.buttonYes"));
            jButton2.setMnemonic(ResourceManager.getAcceleratorKey("security.dialog.buttonNo"));
            Object[] objectArray = new Object[]{jButton, jButton2};
            int n2 = DialogFactory.showOptionDialogImpl(null, n, string, string2, objectArray, objectArray[0], false);
            return n2;
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    static int showUpdateCheckDialog() {
        String string = ResourceManager.getMessage("autoupdatecheck.buttonYes");
        String string2 = ResourceManager.getMessage("autoupdatecheck.buttonNo");
        String string3 = ResourceManager.getMessage("autoupdatecheck.buttonAskLater");
        String string4 = ResourceManager.getMessage("autoupdatecheck.caption");
        String string5 = ResourceManager.getMessage("autoupdatecheck.message");
        JButton jButton = new JButton(string);
        JButton jButton2 = new JButton(string2);
        JButton jButton3 = new JButton(string3);
        jButton.setMnemonic(ResourceManager.getAcceleratorKey("autoupdatecheck.buttonYes"));
        jButton2.setMnemonic(ResourceManager.getAcceleratorKey("autoupdatecheck.buttonNo"));
        jButton3.setMnemonic(ResourceManager.getAcceleratorKey("autoupdatecheck.buttonAskLater"));
        Object[] objectArray = new Object[]{jButton, jButton2, jButton3};
        return DialogFactory.showOptionDialogImpl(null, 3, string5, string4, objectArray, objectArray[0], false);
    }

    public static int showOptionDialog(int n, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, n, object, string, objectArray, object2);
    }

    public static int showOptionDialog(final Component component, final int n, final Object object, final String string, final Object[] objectArray, final Object object2) {
        try {
            return (Integer)DeploySysRun.execute(new DeploySysAction(){

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.showOptionDialogImpl(component, n, object, string, objectArray, object2, false));
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return 1;
        }
    }

    public static void preLoadDialog(int n, Object object, String string, Object[] objectArray, Object object2) {
        DialogFactory.showOptionDialogImpl(null, n, object, string, objectArray, objectArray[0], true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showOptionDialogImpl(Component component, int n, Object object, String string, Object[] objectArray, Object object2, boolean bl) {
        LookAndFeel lookAndFeel = null;
        try {
            Object object3;
            lookAndFeel = DeployUIManager.setLookAndFeel();
            int n2 = -1;
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(2);
                    break;
                }
            }
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(object2);
            jOptionPane.setWantsInput(false);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = optionDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4, true, bl) && (object3 = jOptionPane.getValue()) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].equals(object3)) continue;
                    n2 = i;
                    break;
                }
                Trace.msgPrintln("dialogfactory.user.selected", new Object[]{new Integer(n2)}, TraceLevel.BASIC);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    public static String showInputDialog(Object object, String string) {
        return DialogFactory.showInputDialog(null, object, string);
    }

    public static String showInputDialog(final Component component, final Object object, final String string) {
        try {
            return (String)DeploySysRun.execute(new DeploySysAction(){

                public Object execute() throws Exception {
                    return DialogFactory.showInputDialogImpl(component, object, string);
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String showInputDialogImpl(Component component, Object object, String string) {
        LookAndFeel lookAndFeel = null;
        try {
            Object object2;
            lookAndFeel = DeployUIManager.setLookAndFeel();
            Object object3 = null;
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(3);
            jOptionPane.setOptionType(2);
            jOptionPane.setWantsInput(true);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = inputDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4) && (object2 = jOptionPane.getInputValue()) != null) {
                if (object2 instanceof String) {
                    object3 = object2.toString();
                }
                Trace.msgPrintln("dialogfactory.user.typed", new Object[]{object3});
            }
            object2 = object3;
            return object2;
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    public static void showMessageDialog(int n, Object object, String string, boolean bl) {
        DialogFactory.showMessageDialog(null, n, object, string, bl);
    }

    public static void showMessageDialog(final Component component, final int n, final Object object, final String string, final boolean bl) {
        try {
            DeploySysRun.execute(new DeploySysAction(){

                public Object execute() throws Exception {
                    DialogFactory.showMessageDialogImpl(component, n, object, string, bl);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showMessageDialogImpl(Component component, int n, Object object, String string, boolean bl) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(3);
                    break;
                }
            }
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Object object2 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = messageDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string, object2, bl);
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    public static void showInformationDialog(Object object, String string) {
        DialogFactory.showInformationDialog(null, object, string);
    }

    public static void showInformationDialog(Component component, Object object, String string) {
        DialogFactory.showMessageDialog(component, 2, object, string, true);
    }

    public static void showErrorDialog(String string, String string2) {
        DialogFactory.showErrorDialog(null, string, string2);
    }

    public static void showErrorDialog(Component component, String string, String string2) {
        DialogFactory.showMessageDialog(component, 1, string, string2, true);
    }

    public static void showExceptionDialog(Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(throwable, string, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component component, Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(component, throwable, string, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Throwable throwable, String string, String string2) {
        DialogFactory.showExceptionDialog(null, throwable, string, string2);
    }

    public static void showExceptionDialog(final Component component, final Throwable throwable, final String string, final String string2) {
        try {
            DeploySysRun.execute(new DeploySysAction(){

                public Object execute() throws Exception {
                    DialogFactory.showExceptionDialogImpl(component, throwable, string, string2);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    public static void showProxyDialog() {
        Trace.println("ProxyDialogNotImplemented !!!! XXX", TraceLevel.NETWORK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showExceptionDialogImpl(Component component, Throwable throwable, String string, String string2) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(0);
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Component component2 = (Component)DialogFactory.extractMessage(jOptionPane, throwable);
            final JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ResourceManager.getMessage("dialogfactory.moreInfo"));
            jButton.setMnemonic(ResourceManager.getAcceleratorKey("dialogfactory.moreInfo"));
            jPanel.setLayout(new FlowLayout(2));
            jPanel.add(jButton);
            final JPanel jPanel2 = new JPanel();
            JButton jButton2 = new JButton(ResourceManager.getMessage("dialogfactory.lessInfo"));
            jButton2.setMnemonic(ResourceManager.getAcceleratorKey("dialogfactory.lessInfo"));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            jPanel3.add(jButton2);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel3, "Center");
            jPanel2.add(component2, "South");
            final JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel, "Center");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        jPanel4.remove(jPanel);
                        jPanel4.add((Component)jPanel2, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        jPanel4.remove(jPanel2);
                        jPanel4.add((Component)jPanel, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
            });
            Object[] objectArray = new Object[]{DialogFactory.extractMessage(jOptionPane, string), jPanel4};
            if (string2 == null) {
                string2 = exceptionDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string2, objectArray);
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, true, false);
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object, boolean bl) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, bl, false);
    }

    private static boolean showDialog(final JOptionPane jOptionPane, final Component component, final String string, final Object object, final boolean bl, final boolean bl2) {
        boolean bl3 = true;
        try {
            jOptionPane.setValue(null);
            Runnable runnable = new Runnable(){

                public void run() {
                    JFrame jFrame = DialogFactory.getFrameOwner(component, string, bl);
                    JDialog jDialog = jOptionPane.createDialog(jFrame != null ? jFrame : component, string);
                    Object[] objectArray = jOptionPane.getOptions();
                    if (null != objectArray) {
                        DefaultActionListener defaultActionListener = new DefaultActionListener(jDialog, jOptionPane);
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (!(objectArray[i] instanceof JButton)) continue;
                            JButton jButton = (JButton)objectArray[i];
                            jButton.addActionListener(defaultActionListener);
                        }
                    }
                    jOptionPane.setMessage(object);
                    jDialog.pack();
                    DialogFactory.fixSwingLayoutBug(object);
                    jDialog.pack();
                    jDialog.setResizable(false);
                    jDialog.setModal(bl);
                    DialogFactory.positionDialog(jDialog);
                    if (!bl2) {
                        if (dialogListener != null) {
                            dialogListener.beforeShow();
                        }
                        if (jFrame != null) {
                            jFrame.setVisible(true);
                        }
                        jDialog.setVisible(true);
                    }
                    if (jFrame != null) {
                        jFrame.setVisible(false);
                        jFrame.dispose();
                    }
                }
            };
            String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("javaplugin.version");
                }
            });
            if (string2 == null || bl2 || SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else if (bl) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl3 = false;
        }
        return bl3;
    }

    private static JFrame getFrameOwner(Component component, String string, boolean bl) {
        if (component != null || !bl || !Config.getOSName().equals("Windows")) {
            return null;
        }
        JFrame jFrame = new JFrame(string);
        jFrame.setLocation(-200, -200);
        return jFrame;
    }

    public static void placeWindow(Window window) {
        Window window2 = window.getOwner();
        Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle rectangle2 = window.getBounds();
        Rectangle rectangle3 = window2 == null || !window2.isVisible() ? rectangle : window2.getBounds();
        double d = (double)rectangle3.height - (double)rectangle3.height / 1.618;
        rectangle2.x = rectangle3.x + (rectangle3.width - rectangle2.width) / 2;
        int n = (int)(d - (double)(rectangle2.height / 2));
        int n2 = window2 == null ? 0 : window2.getInsets().top;
        rectangle2.y = rectangle3.y + Math.max(n, n2);
        if (rectangle2.x + rectangle2.width > rectangle.width) {
            rectangle2.x = Math.max(rectangle.width - rectangle2.width, 0);
        }
        if (rectangle2.y + rectangle2.height > rectangle.height) {
            rectangle2.y = Math.max(rectangle.height - rectangle2.height, 0);
        }
        window.setBounds(rectangle2);
    }

    public static void positionDialog(Dialog dialog) {
        Window window = dialog.getOwner();
        if (window != null && window.isVisible()) {
            DialogFactory.placeWindow(dialog);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            dialog.setLocation((dimension.width - dialog.getWidth()) / 2, (dimension.height - dialog.getHeight()) / 2);
        }
    }

    private static Object extractMessage(JOptionPane jOptionPane, Throwable throwable) {
        return DialogFactory.formatExceptionMessage(jOptionPane, throwable);
    }

    private static Object extractMessage(JOptionPane jOptionPane, String string) {
        return DialogFactory.formatStringMessage(jOptionPane, string);
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = DialogFactory.extractMessage(jOptionPane, objectArray[i]);
            }
        }
        return objectArray2;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object object) {
        if (object instanceof Object[]) {
            return DialogFactory.extractMessage(jOptionPane, (Object[])object);
        }
        if (object instanceof String) {
            return DialogFactory.extractMessage(jOptionPane, (String)object);
        }
        if (object instanceof Exception) {
            return DialogFactory.extractMessage(jOptionPane, (Exception)object);
        }
        return object;
    }

    private static Object formatStringMessage(JOptionPane jOptionPane, String string) {
        int n;
        if (string == null) {
            string = "null";
        }
        if ((n = string.indexOf("</html>")) == -1) {
            JTextArea jTextArea = new JTextArea(){

                public void paintComponent(Graphics graphics) {
                    this.setBackground(new Color(this.getParent().getBackground().getRGB()));
                    super.paintComponent(graphics);
                }
            };
            jTextArea.setFont(ResourceManager.getUIFont());
            jTextArea.setColumns(40);
            jTextArea.setAutoscrolls(true);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setText(string);
            jTextArea.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    ((JTextArea)focusEvent.getSource()).transferFocus();
                }
            });
            return jTextArea;
        }
        if (n + 7 == string.length()) {
            return new JLabel(string);
        }
        Object[] objectArray = new Object[]{new JLabel(string.substring(0, n + 7)), DialogFactory.formatStringMessage(jOptionPane, string.substring(n + 7))};
        return objectArray;
    }

    private static Object formatExceptionMessage(JOptionPane jOptionPane, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        JTextArea jTextArea = new JTextArea(){

            public void paintComponent(Graphics graphics) {
                this.setBackground(new Color(this.getParent().getBackground().getRGB()));
                super.paintComponent(graphics);
            }
        };
        jTextArea.setText("" + stringWriter.toString());
        jTextArea.setFont(ResourceManager.getUIFont());
        jTextArea.setColumns(40);
        jTextArea.setRows(10);
        jTextArea.setEditable(false);
        jTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((JTextArea)focusEvent.getSource()).transferFocus();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setBackground(jOptionPane.getBackground());
        return jScrollPane;
    }

    private static void fixSwingLayoutBug(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)object;
            jTextArea.getUI().getPreferredSize(jTextArea);
            return;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                DialogFactory.fixSwingLayoutBug(Array.get(object, i));
            }
        }
    }

    static {
        dialogListener = null;
        confirmDialogTitle = ResourceManager.getMessage("dialogfactory.confirmDialogTitle");
        inputDialogTitle = ResourceManager.getMessage("dialogfactory.inputDialogTitle");
        messageDialogTitle = ResourceManager.getMessage("dialogfactory.messageDialogTitle");
        exceptionDialogTitle = ResourceManager.getMessage("dialogfactory.exceptionDialogTitle");
        optionDialogTitle = ResourceManager.getMessage("dialogfactory.optionDialogTitle");
        aboutDialogTitle = ResourceManager.getMessage("dialogfactory.aboutDialogTitle");
        javaHomeLink = ResourceManager.getMessage("dialogfactory.java.home.link");
        _warningIcon = null;
        _infoIcon = null;
        _javaIcon = null;
        _javaIcon48 = null;
        tsLastActive = 0L;
    }
}

