/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

abstract class MozillaCertStore
implements CertStore {
    protected static final int VALID_PEER = 1;
    protected static final int TRUSTED_PEER = 2;
    protected static final int VALID_CA = 8;
    protected static final int TRUSTED_CA = 16;
    protected static final int USER = 64;
    protected static final int TRUSTED_CLIENT_CA = 128;
    private Collection certs = new ArrayList();

    MozillaCertStore() {
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("mozilla.cert.loading", new Object[]{this.getName()});
        this.certs.clear();
        try {
            Class<?> clazz = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
            Object object = BrowserKeystore.getJSSCryptoManager();
            Method method = clazz.getMethod("getCACerts", null);
            Object[] objectArray = (Object[])method.invoke(object, (Object[])null);
            for (int i = 0; i < objectArray.length; ++i) {
                Boolean bl;
                Object[] objectArray2;
                AccessibleObject accessibleObject;
                Class<?> clazz2 = Class.forName("org.mozilla.jss.crypto.X509Certificate", true, ClassLoader.getSystemClassLoader());
                Method method2 = clazz2.getMethod("getNickname", null);
                String string = (String)method2.invoke(objectArray[i], (Object[])null);
                Class<?> clazz3 = Class.forName("org.mozilla.jss.CryptoManager$CertUsage", true, ClassLoader.getSystemClassLoader());
                Class[] classArray = new Class[]{String.class, Boolean.TYPE, clazz3};
                Method method3 = clazz.getMethod("isCertValid", classArray);
                if (this.isTrustedSigningCACertStore()) {
                    accessibleObject = clazz3.getField("ObjectSigner");
                    objectArray2 = new Object[]{string, Boolean.FALSE, ((Field)accessibleObject).get(objectArray[i])};
                    bl = (Boolean)method3.invoke(object, objectArray2);
                    Field field = clazz3.getField("EmailSigner");
                    objectArray2[2] = field.get(objectArray[i]);
                    Boolean bl2 = (Boolean)method3.invoke(object, objectArray2);
                    if (!bl.booleanValue() && !bl2.booleanValue()) continue;
                }
                if (this.isTrustedSSLCACertStore() && !(bl = (Boolean)method3.invoke(object, objectArray2 = new Object[]{string, Boolean.FALSE, ((Field)(accessibleObject = clazz3.getField("SSLCA"))).get(objectArray[i])})).booleanValue()) continue;
                accessibleObject = clazz2.getMethod("getEncoded", null);
                objectArray2 = (byte[])((Method)accessibleObject).invoke(objectArray[i], null);
                this.generateCertificate((byte[])objectArray2, this.certs);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Trace.msgSecurityPrintln("mozilla.cert.loaded", new Object[]{this.getName()});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        throw new KeyStoreException("Cannot store certificate in Mozilla \"" + this.getName() + "\" certificate store.");
    }

    public void add(Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Cannot add certificate in Mozilla \"" + this.getName() + "\" certificate store.");
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        throw new KeyStoreException("Cannot remove certificate from Mozilla \"" + this.getName() + "\" certificate store.");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("mozilla.cert.instore", new Object[]{this.getName()});
        return this.certs.contains(certificate);
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("mozilla.cert.canverify", new Object[]{this.getName()});
        Trace.msgSecurityPrintln("mozilla.cert.tobeverified", new Object[]{certificate});
        Iterator iterator = this.iterator(0);
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            Trace.msgSecurityPrintln("mozilla.cert.tobecompared", new Object[]{this.getName(), x509Certificate});
            try {
                certificate.verify(x509Certificate.getPublicKey());
                Trace.msgSecurityPrintln("mozilla.cert.verify.ok", new Object[]{this.getName()});
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("mozilla.cert.verify.fail", new Object[]{this.getName()});
        return false;
    }

    public Iterator iterator(int n) {
        return this.certs.iterator();
    }

    private void generateCertificate(byte[] byArray, Collection collection) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection2 = certificateFactory.generateCertificates(byteArrayInputStream);
            for (X509Certificate x509Certificate : collection2) {
                collection.add(x509Certificate);
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected abstract String getName();

    protected abstract boolean isTrustedSigningCACertStore();

    protected abstract boolean isTrustedSSLCACertStore();
}

