/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.panel.NumberDocument;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.AdvancedNetworkSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class NetworkSettingsDialog
extends JDialog
implements ActionListener {
    private ButtonGroup proxySettingsButtonGroup;
    private JSmartTextArea descriptionTextArea;
    private JLabel addressLabel;
    private JLabel portLabel;
    private JLabel locationLabel;
    private JRadioButton browserRbutton;
    private JRadioButton manualRbutton;
    private JRadioButton autoConfigRbutton;
    private JRadioButton directRbutton;
    private JTextField addressTextField;
    private JTextField portTextField;
    private JTextField locationTextField;
    private JCheckBox bypassProxyChbox;
    private JButton advancedBtn;
    private JButton okButton;
    private JButton cancelButton;

    NetworkSettingsDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.proxySettingsButtonGroup = new ButtonGroup();
        this.browserRbutton = new JRadioButton();
        this.manualRbutton = new JRadioButton();
        this.bypassProxyChbox = new JCheckBox();
        this.autoConfigRbutton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getMessage("network.settings.dlg.title"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NetworkSettingsDialog.this.closeDialog(windowEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new TitledBorder(new EtchedBorder()), this.getMessage("network.settings.dlg.border_title"), 0, 0));
        this.descriptionTextArea = new JSmartTextArea();
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(this.getMessage("network.settings.dlg.border_title"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(this.getMessage("network.settings.dlg.browser_text"));
        this.descriptionTextArea.setRows(2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.descriptionTextArea, "North");
        jPanel2.add((Component)new JLabel(" "), "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        this.browserRbutton.setText(this.getMessage("network.settings.dlg.browser_rbtn"));
        this.browserRbutton.setMnemonic(ResourceManager.getVKCode("browser_rbtn.mnemonic"));
        this.proxySettingsButtonGroup.add(this.browserRbutton);
        jPanel4.add((Component)this.browserRbutton, "North");
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        this.manualRbutton.setText(this.getMessage("network.settings.dlg.manual_rbtn"));
        this.manualRbutton.setMnemonic(ResourceManager.getVKCode("manual_rbtn.mnemonic"));
        this.proxySettingsButtonGroup.add(this.manualRbutton);
        jPanel5.add((Component)this.manualRbutton, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.add(Box.createRigidArea(new Dimension(20, 1)));
        this.addressLabel = new JLabel(this.getMessage("network.settings.dlg.address_lbl"));
        jPanel6.add(this.addressLabel);
        this.addressTextField = new JTextField("");
        this.addressTextField.setColumns(10);
        this.addressTextField.getAccessibleContext().setAccessibleName(this.getMessage("network.settings.dlg.address_lbl"));
        jPanel6.add(this.addressTextField);
        jPanel6.add(Box.createGlue());
        this.portLabel = new JLabel(this.getMessage("network.settings.dlg.port_lbl"));
        jPanel6.add(this.portLabel);
        this.portTextField = new JTextField("");
        this.portTextField.setColumns(3);
        this.portTextField.setDocument(new NumberDocument());
        this.portTextField.getAccessibleContext().setAccessibleName(this.getMessage("network.settings.dlg.port_lbl"));
        jPanel6.add(this.portTextField);
        jPanel6.add(Box.createGlue());
        jPanel5.add((Component)jPanel6, "West");
        JPanel jPanel7 = new JPanel();
        this.advancedBtn = this.makeButton("network.settings.dlg.advanced_btn");
        this.advancedBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsDialog.this.advancedBtnActionPerformed(actionEvent);
            }
        });
        this.advancedBtn.setToolTipText(this.getMessage("network.settings.advanced_btn.tooltip"));
        jPanel7.add(this.advancedBtn);
        jPanel5.add((Component)jPanel7, "East");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(Box.createRigidArea(new Dimension(20, 1)));
        this.bypassProxyChbox.setText(this.getMessage("network.settings.dlg.bypass_text"));
        this.bypassProxyChbox.setMnemonic(ResourceManager.getVKCode("network.settings.dlg.bypass.mnemonic"));
        jPanel8.add(this.bypassProxyChbox);
        jPanel8.add(Box.createGlue());
        jPanel5.add((Component)jPanel8, "South");
        jPanel3.add(jPanel5);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        this.autoConfigRbutton.setText(this.getMessage("network.settings.dlg.autoconfig_rbtn"));
        this.autoConfigRbutton.setMnemonic(ResourceManager.getVKCode("autoconfig_rbtn.mnemonic"));
        this.proxySettingsButtonGroup.add(this.autoConfigRbutton);
        jPanel9.add((Component)this.autoConfigRbutton, "North");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout(0));
        this.locationLabel = new JLabel(this.getMessage("network.settings.dlg.location_lbl"));
        jPanel10.add(Box.createHorizontalStrut(20));
        jPanel10.add(this.locationLabel);
        this.locationTextField = new JTextField("");
        this.locationTextField.setColumns(20);
        this.locationTextField.getAccessibleContext().setAccessibleName(this.getMessage("network.settings.dlg.location_lbl"));
        jPanel10.add(this.locationTextField);
        jPanel9.add((Component)jPanel10, "Center");
        jPanel3.add(jPanel9);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        this.directRbutton = new JRadioButton(this.getMessage("network.settings.dlg.direct_rbtn"));
        this.directRbutton.setMnemonic(ResourceManager.getVKCode("direct_rbtn.mnemonic"));
        this.proxySettingsButtonGroup.add(this.directRbutton);
        jPanel11.add((Component)this.directRbutton, "North");
        jPanel3.add(jPanel11);
        jPanel.add((Component)jPanel3, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new FlowLayout(2));
        this.okButton = this.makeButton("common.ok_btn");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel12.add(this.okButton);
        this.cancelButton = this.makeButton("common.cancel_btn");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        this.cancelButton.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke('\u001b'), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        jPanel12.add(this.cancelButton);
        this.getContentPane().add((Component)jPanel12, "South");
        this.browserRbutton.addActionListener(this);
        this.browserRbutton.setActionCommand("useBrowser");
        this.manualRbutton.addActionListener(this);
        this.manualRbutton.setActionCommand("useProxy");
        this.autoConfigRbutton.addActionListener(this);
        this.autoConfigRbutton.setActionCommand("useScript");
        this.directRbutton.addActionListener(this);
        this.directRbutton.setActionCommand("noProxy");
        this.getRootPane().setDefaultButton(this.okButton);
        this.setValues();
        this.pack();
        this.setResizable(false);
    }

    private void setValues() {
        this.addressTextField.setText(Config.getProperty("deployment.proxy.http.host"));
        this.portTextField.setText(Config.getProperty("deployment.proxy.http.port"));
        this.locationTextField.setText(Config.getProperty("deployment.proxy.auto.config.url"));
        this.bypassProxyChbox.setSelected(Config.getBooleanProperty("deployment.proxy.bypass.local"));
        int n = Config.getIntProperty("deployment.proxy.type");
        boolean bl = !Config.isLocked("deployment.proxy.type");
        switch (n) {
            case 1: {
                this.manualRbutton.setSelected(true);
                this.useProxy();
                break;
            }
            case 2: {
                this.autoConfigRbutton.setSelected(true);
                this.useScript();
                break;
            }
            case 0: {
                this.directRbutton.setSelected(true);
                this.noProxy();
                break;
            }
            default: {
                this.browserRbutton.setSelected(true);
                this.useBrowser();
            }
        }
        this.manualRbutton.setEnabled(bl);
        this.autoConfigRbutton.setEnabled(bl);
        this.directRbutton.setEnabled(bl);
        this.browserRbutton.setEnabled(bl);
    }

    public void updateProxyInfo() {
        this.addressTextField.setText(Config.getProperty("deployment.proxy.http.host"));
        this.portTextField.setText(Config.getProperty("deployment.proxy.http.port"));
    }

    public String getProxyAddressField() {
        return this.addressTextField.getText();
    }

    public String getProxyPortField() {
        return this.portTextField.getText();
    }

    private void disableAll() {
        this.addressLabel.setEnabled(false);
        this.addressTextField.setEnabled(false);
        this.portLabel.setEnabled(false);
        this.portTextField.setEnabled(false);
        this.advancedBtn.setEnabled(false);
        this.bypassProxyChbox.setEnabled(false);
        this.locationLabel.setEnabled(false);
        this.locationTextField.setEnabled(false);
        this.addressTextField.setEditable(false);
        this.locationTextField.setEditable(false);
        this.portTextField.setEditable(false);
    }

    private void useBrowser() {
        this.descriptionTextArea.setText(this.getMessage("network.settings.dlg.browser_text"));
        this.disableAll();
    }

    private void useProxy() {
        this.descriptionTextArea.setText(this.getMessage("network.settings.dlg.proxy_text"));
        this.disableAll();
        if (!Config.isLocked("deployment.proxy.http.host")) {
            this.addressLabel.setEnabled(true);
            this.addressTextField.setEnabled(true);
            this.addressTextField.setEditable(true);
        }
        if (!Config.isLocked("deployment.proxy.http.port")) {
            this.portLabel.setEnabled(true);
            this.portTextField.setEnabled(true);
            this.portTextField.setEditable(true);
        }
        this.advancedBtn.setEnabled(true);
        if (!Config.isLocked("deployment.proxy.bypass.local")) {
            this.bypassProxyChbox.setEnabled(true);
        }
    }

    private void useScript() {
        this.descriptionTextArea.setText(this.getMessage("network.settings.dlg.auto_text"));
        this.disableAll();
        if (!Config.isLocked("deployment.proxy.auto.config.url")) {
            this.locationLabel.setEnabled(true);
            this.locationTextField.setEnabled(true);
            this.locationTextField.setEditable(true);
        }
    }

    private void noProxy() {
        this.descriptionTextArea.setText(this.getMessage("network.settings.dlg.none_text"));
        this.disableAll();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("useBrowser")) {
            this.useBrowser();
        } else if (string.equalsIgnoreCase("useProxy")) {
            this.useProxy();
        } else if (string.equalsIgnoreCase("useScript")) {
            this.useScript();
        } else if (string.equalsIgnoreCase("noProxy")) {
            this.noProxy();
        }
    }

    private void advancedBtnActionPerformed(ActionEvent actionEvent) {
        AdvancedNetworkSettingsDialog advancedNetworkSettingsDialog = new AdvancedNetworkSettingsDialog((Dialog)this, true);
        advancedNetworkSettingsDialog.setLocationRelativeTo(this);
        advancedNetworkSettingsDialog.setVisible(true);
        this.updateProxyInfo();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.browserRbutton.isSelected()) {
            Config.setIntProperty("deployment.proxy.type", 3);
        } else if (this.manualRbutton.isSelected()) {
            Config.setIntProperty("deployment.proxy.type", 1);
        } else if (this.autoConfigRbutton.isSelected()) {
            Config.setIntProperty("deployment.proxy.type", 2);
        } else if (this.directRbutton.isSelected()) {
            Config.setIntProperty("deployment.proxy.type", 0);
        }
        String string = this.addressTextField.getText();
        if (string != null && !string.trim().equals("")) {
            Config.setProperty("deployment.proxy.http.host", string);
        }
        if ((string = this.portTextField.getText()) != null && !string.trim().equals("")) {
            Config.setProperty("deployment.proxy.http.port", string);
        }
        if ((string = this.locationTextField.getText()) != null && !string.trim().equals("")) {
            Config.setProperty("deployment.proxy.auto.config.url", string);
        }
        Config.setBooleanProperty("deployment.proxy.bypass.local", this.bypassProxyChbox.isSelected());
        this.setVisible(false);
        this.dispose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getVKCode(string + ".mnemonic"));
        return jButton;
    }
}

