/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.PureReflectField;
import com.ibm.rmi.io.ReflectField;
import java.lang.reflect.Field;

public class ObjectStreamField
implements Comparable {
    private String name;
    private String signature;
    private char type;
    private Field field;
    private String typeString;
    private Class clazz;
    private ObjectStreamClass osc;
    private int isAny = -1;
    private ReflectField reflectField;

    public ObjectStreamField(String string, Class clazz) {
        this.name = string;
        this.clazz = clazz;
        this.osc = ObjectStreamClass.lookup(clazz);
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.type = (char)73;
            } else if (clazz == Byte.TYPE) {
                this.type = (char)66;
            } else if (clazz == Long.TYPE) {
                this.type = (char)74;
            } else if (clazz == Float.TYPE) {
                this.type = (char)70;
            } else if (clazz == Double.TYPE) {
                this.type = (char)68;
            } else if (clazz == Short.TYPE) {
                this.type = (char)83;
            } else if (clazz == Character.TYPE) {
                this.type = (char)67;
            } else if (clazz == Boolean.TYPE) {
                this.type = (char)90;
            }
        } else if (clazz.isArray()) {
            this.type = (char)91;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        } else {
            this.type = (char)76;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        }
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    ObjectStreamField(Field field) {
        this.field = field;
        this.reflectField = this.newReflectField(field);
        this.name = field.getName();
        this.clazz = field.getType();
        if (this.clazz.isPrimitive()) {
            if (this.clazz == Integer.TYPE) {
                this.type = (char)73;
            } else if (this.clazz == Byte.TYPE) {
                this.type = (char)66;
            } else if (this.clazz == Long.TYPE) {
                this.type = (char)74;
            } else if (this.clazz == Float.TYPE) {
                this.type = (char)70;
            } else if (this.clazz == Double.TYPE) {
                this.type = (char)68;
            } else if (this.clazz == Short.TYPE) {
                this.type = (char)83;
            } else if (this.clazz == Character.TYPE) {
                this.type = (char)67;
            } else if (this.clazz == Boolean.TYPE) {
                this.type = (char)90;
            }
        } else if (this.clazz.isArray()) {
            this.type = (char)91;
            this.typeString = ObjectStreamClass.getSignature(this.clazz);
        } else {
            this.type = (char)76;
            this.typeString = ObjectStreamClass.getSignature(this.clazz);
        }
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    public String getName() {
        return this.name;
    }

    public ObjectStreamClass getObjectStreamClass() {
        if (this.osc == null) {
            this.osc = ObjectStreamClass.lookup(this.clazz);
        }
        return this.osc;
    }

    public Class getType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        switch (this.type) {
            case 'B': {
                this.clazz = Byte.TYPE;
                break;
            }
            case 'C': {
                this.clazz = Character.TYPE;
                break;
            }
            case 'S': {
                this.clazz = Short.TYPE;
                break;
            }
            case 'I': {
                this.clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                this.clazz = Long.TYPE;
                break;
            }
            case 'F': {
                this.clazz = Float.TYPE;
                break;
            }
            case 'D': {
                this.clazz = Double.TYPE;
                break;
            }
            case 'Z': {
                this.clazz = Boolean.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.clazz = Object.class;
            }
        }
        return this.clazz;
    }

    public char getTypeCode() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    Field getField() {
        return this.field;
    }

    void setField(Field field) {
        this.field = field;
        this.reflectField = this.newReflectField(field);
    }

    ObjectStreamField() {
    }

    public boolean isPrimitive() {
        return this.type != '[' && this.type != 'L';
    }

    public int compareTo(Object object) {
        boolean bl;
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl2 = this.typeString == null;
        boolean bl3 = bl = objectStreamField.typeString == null;
        if (bl2 != bl) {
            return bl2 ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public boolean typeEquals(ObjectStreamField objectStreamField) {
        if (objectStreamField == null || this.type != objectStreamField.type) {
            return false;
        }
        if (this.typeString == null && objectStreamField.typeString == null) {
            return true;
        }
        return ObjectStreamClass.compareClassNames(this.typeString, objectStreamField.typeString, '/');
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.typeString != null) {
            return this.typeString + " " + this.name;
        }
        return this.type + " " + this.name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public boolean isAny() {
        if (this.isAny == -1) {
            this.isAny = this.typeString != null && (this.typeString.equals("Ljava/lang/Object;") || this.typeString.equals("Ljava/io/Serializable;") || this.typeString.equals("Ljava/io/Externalizable;")) ? 1 : 0;
        }
        return this.isAny == 1;
    }

    public ReflectField getReflectField() {
        return this.reflectField;
    }

    private ReflectField newReflectField(Field field) {
        return new PureReflectField(field);
    }
}

