/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.io.ClassDescription;
import com.ibm.rmi.io.InputStreamHook;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass
implements ClassDescription,
Serializable {
    public static final long kDefaultUID = -1L;
    private static final java.lang.Object[] noArgsList = new java.lang.Object[0];
    private static final Class[] noTypesList = new Class[0];
    private static final ObjectStreamField[] noFields = new ObjectStreamField[0];
    private byte isAbstractInterface = 0;
    private static final byte ORIGINAL_IBM_ABSTRACT = 1;
    private static final byte PRE_50_IBM_ABSTRACT = 2;
    private static final byte SPEC_COMPLIANT_ABSTRACT = 4;
    private static final byte CACHE_SHIFT = 4;
    private int isRemoteInterface = -1;
    private int isAny = -1;
    private boolean hasSerialVersionUIDField = false;
    private boolean mayNeedOldSUID = false;
    private static Method methodHasStaticInitializer = null;
    private static final String thisClassName = "com.ibm.rmi.io.ObjectStreamClass";
    private static ObjectStreamClassEntry[] descriptorFor;
    private static Map descTable;
    private final String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private ObjectStreamField[] localFields;
    private Class ofClass;
    private long suid = -1L;
    private long computedSuid = -1L;
    private long computedHashCode = -1L;
    private long oldComputedHashCode = -1L;
    private boolean hasWriteObjectMethod;
    private boolean hasReadResolveMethod;
    private boolean hasSerialPersistentFields;
    Method writeObjectMethod;
    Method readObjectMethod;
    Method writeReplaceObjectMethod;
    Method readResolveObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static final long serialVersionUID = -6120832682080437368L;
    private static Comparator compareClassByName;
    private static Comparator compareMemberByName;

    public final boolean isAbstractInterface(PartnerVersion partnerVersion) {
        int n = 4;
        boolean bl = true;
        if (partnerVersion != null) {
            short s;
            short s2 = partnerVersion.getPartnerMajor();
            if (PartnerVersionUtil.useSmartMarshaling(s2, s = partnerVersion.getPartnerMinor())) {
                bl = false;
                n = PartnerVersionUtil.useInheritedMethods(s2, s) ? 4 : 2;
            } else {
                n = 1;
            }
        }
        if (bl && this.isAny()) {
            return false;
        }
        return this.isAbstractInterface((byte)n);
    }

    private final boolean isAbstractInterface(byte by) {
        boolean bl;
        String string = "isAbstractInterface";
        Trc.vals("Style", Trc.hex(by), "cacheStatus", Trc.hex(this.isAbstractInterface), "ofClass", this.ofClass.getName(), "name", this.name, thisClassName, string + ":237");
        byte by2 = (byte)(by << 4);
        if ((by2 & this.isAbstractInterface) == 0) {
            bl = this.isRMIAbstractInterface(by) || RepositoryId.isAbstractBase(this.ofClass);
            this.isAbstractInterface = (byte)(this.isAbstractInterface | by2);
            this.isAbstractInterface = bl ? (byte)(this.isAbstractInterface | by) : (byte)(this.isAbstractInterface & ~by);
        } else {
            bl = (this.isAbstractInterface & by) != 0;
        }
        return bl;
    }

    public boolean isRemoteInterface() {
        if (this.isRemoteInterface == -1) {
            this.isRemoteInterface = !this.ofClass.isInterface() ? 0 : (Remote.class.isAssignableFrom(this.ofClass) ? 1 : (Object.class.isAssignableFrom(this.ofClass) ? 1 : 0));
        }
        return this.isRemoteInterface == 1;
    }

    public boolean isValueType(PartnerVersion partnerVersion) {
        return !this.isAny() && !this.isRemoteInterface() && !this.isAbstractInterface(partnerVersion);
    }

    public boolean isAny() {
        if (this.isAny == -1) {
            this.isAny = this.ofClass == java.lang.Object.class || this.ofClass == Serializable.class || this.ofClass == Externalizable.class ? 1 : 0;
        }
        return this.isAny == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectStreamClass lookup(Class clazz) {
        WeakReference weakReference = (WeakReference)descTable.get(clazz);
        ObjectStreamClass objectStreamClass = null;
        if (weakReference != null) {
            objectStreamClass = (ObjectStreamClass)weakReference.get();
        }
        if (objectStreamClass != null) return objectStreamClass;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass == null) {
                Class clazz2;
                boolean bl = Serializable.class.isAssignableFrom(clazz);
                boolean bl2 = Externalizable.class.isAssignableFrom(clazz);
                if (bl2) {
                    bl = false;
                }
                ObjectStreamClass objectStreamClass2 = null;
                if (clazz.getSuperclass() != Class.class && (clazz2 = clazz.getSuperclass()) != null) {
                    objectStreamClass2 = ObjectStreamClass.lookup(clazz2);
                }
                objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass2, bl, bl2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            objectStreamClass.init();
            descTable.put(clazz, new WeakReference<ObjectStreamClass>(objectStreamClass));
            return objectStreamClass;
        }
    }

    public final String getName() {
        return this.name;
    }

    private final long getSerialVersionUID() {
        if (this.hasSerialVersionUIDField) {
            return this.suid;
        }
        return this.computedSuid;
    }

    public final long getSerialVersionUID(boolean bl) {
        if (bl && this.mayNeedOldSUID) {
            return this.computedSuid;
        }
        return this.getSerialVersionUID();
    }

    public final long getRMIHashCode(boolean bl) {
        if (bl) {
            return this.oldComputedHashCode;
        }
        return this.computedHashCode;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public Class getType() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    public ObjectStreamField[] getLocalFields() {
        if (this.localFields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.localFields.length];
            System.arraycopy(this.localFields, 0, objectStreamFieldArray, 0, this.localFields.length);
            return objectStreamFieldArray;
        }
        return this.localFields;
    }

    ObjectStreamField getField(ValueMember valueMember) throws InvalidClassException {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equals(valueMember.name)) continue;
            Class clazz = this.fields[i].getType();
            Class clazz2 = ValueUtility.getType(valueMember);
            if (clazz.isPrimitive() || clazz2.isPrimitive()) {
                if (clazz == clazz2) {
                    return this.fields[i];
                }
                throw new InvalidClassException(this.getName(), "The type of field " + valueMember.name + " is incompatible");
            }
            return this.fields[i];
        }
        return null;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String string) {
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (!string.equals(this.fields[i].getName())) continue;
            return this.fields[i];
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "writeReplace:522", this.name);
        }
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke((java.lang.Object)serializable, noArgsList);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "writeReplace:533", throwable.toString(), (java.lang.Object)throwable);
                RuntimeException runtimeException = new RuntimeException(this.name + "." + "writeReplace");
                runtimeException.initCause(throwable);
                throw runtimeException;
            }
        }
        return serializable;
    }

    public java.lang.Object readResolve(java.lang.Object object) {
        java.lang.Object object2;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "readResolve:549", this.name);
        }
        if (this.readResolveObjectMethod == null) {
            return object;
        }
        try {
            object2 = this.readResolveObjectMethod.invoke(object, noArgsList);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, this, "readResolve:561", object2 == null ? "null" : object2.getClass().getName());
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "readResolve:569", throwable.toString(), (java.lang.Object)throwable);
            RuntimeException runtimeException = new RuntimeException(this.name + "." + "readResolve");
            runtimeException.initCause(throwable);
            throw runtimeException;
        }
        return object2;
    }

    public final String toString() {
        return this.name + ": static final long serialVersionUID = " + this.suid + "L;";
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl, boolean bl2) {
        this.ofClass = clazz;
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl;
        this.externalizable = bl2;
        ObjectStreamClass.insertDescriptorFor(this);
    }

    private synchronized void init() {
        Class[] classArray;
        block48: {
            block47: {
                block46: {
                    if (this.fields != null) {
                        return;
                    }
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "init:624", (java.lang.Object)this.name);
                    }
                    if (!this.serializable || this.externalizable || this.name.equals("java.lang.String")) {
                        this.fields = noFields;
                        this.localFields = noFields;
                    } else if (this.serializable) {
                        int n;
                        java.lang.Object object;
                        try {
                            object = new Class[]{ObjectOutputStream.class};
                            this.writeObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "writeObject", (Class[])object);
                            this.hasWriteObjectMethod = true;
                            n = this.writeObjectMethod.getModifiers();
                            if (!Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                                this.writeObjectMethod = null;
                                this.hasWriteObjectMethod = false;
                            } else {
                                ObjectStreamClass.setAccessible(this.writeObjectMethod);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        try {
                            object = ObjectStreamClass.getDeclaredField(this.ofClass, "serialPersistentFields");
                            n = ((Field)object).getModifiers();
                            if (Modifier.isPrivate(n) && Modifier.isStatic(n) && Modifier.isFinal(n) && ((Field)object).getType().isAssignableFrom(java.io.ObjectStreamField[].class)) {
                                ObjectStreamClass.setAccessible((AccessibleObject)object);
                                this.hasSerialPersistentFields = true;
                                this.fields = (ObjectStreamField[])InputStreamHook.translateFields((java.lang.Object[])((Field)object).get(this.ofClass));
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            this.fields = null;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, this, "init:687", this.name + ".serialPersistentFields:" + illegalAccessException.toString());
                            }
                            this.fields = null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, this, "init:694", this.name + ".serialPersistentFields:" + illegalArgumentException.toString());
                            }
                            this.fields = null;
                        }
                        catch (SecurityException securityException) {
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, this, "init:701", this.name + ".serialPersistentFields:" + securityException.toString());
                            }
                            this.fields = null;
                        }
                        if (this.fields == null) {
                            this.fields = this.getSerialFields();
                            if (this.localFields == null) {
                                this.localFields = this.fields;
                            }
                        } else {
                            for (int i = this.fields.length - 1; i >= 0; --i) {
                                try {
                                    Field field = ObjectStreamClass.getDeclaredField(this.ofClass, this.fields[i].getName());
                                    if (this.fields[i].getType() == field.getType()) {
                                        this.fields[i].setField(field);
                                        continue;
                                    }
                                    if (!ORBRas.isTrcLogging) continue;
                                    ORBRas.orbTrcLogger.trace(4112L, this, "init:730", this.ofClass.getName() + "." + this.fields[i].getName() + " type inconsistency");
                                    continue;
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    if (this.hasWriteObjectMethod) continue;
                                    ORBRas.orbTrcLogger.exception(4104L, this, "init:747", (Exception)noSuchFieldException);
                                    throw new MARSHAL(this.name + ":serialPersistentFields member " + this.fields[i].getName() + " has superset of fields in local version of class and no writeObject() method defined.", 1229125822, CompletionStatus.COMPLETED_NO);
                                }
                            }
                            if (this.fields.length > 1) {
                                Arrays.sort(this.fields);
                            }
                            if (this.localFields == null) {
                                this.localFields = this.getSerialFields();
                            }
                        }
                    }
                    try {
                        classArray = ObjectStreamClass.getDeclaredField(this.ofClass, "serialVersionUID");
                        int n = classArray.getModifiers();
                        if (Modifier.isStatic(n) && Modifier.isFinal(n)) {
                            this.hasSerialVersionUIDField = true;
                            ObjectStreamClass.setAccessible((AccessibleObject)classArray);
                            try {
                                this.suid = classArray.getLong(null);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                ORBRas.orbTrcLogger.exception(4104L, this, "init:787", (Exception)illegalAccessException);
                                NoSuchFieldException noSuchFieldException = new NoSuchFieldException(this.name + ".serialVersionUID");
                                noSuchFieldException.initCause(illegalAccessException);
                                throw noSuchFieldException;
                            }
                            this.computedHashCode = this.computeHashCode(false);
                            this.oldComputedHashCode = this.computeHashCode(true);
                            if (!Modifier.isPrivate(n)) {
                                this.mayNeedOldSUID = true;
                            }
                            break block46;
                        }
                        this.hasSerialVersionUIDField = false;
                        this.suid = 0L;
                        this.computedHashCode = this.computeHashCode(false);
                        this.oldComputedHashCode = this.computeHashCode(true);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        this.hasSerialVersionUIDField = false;
                        this.suid = 0L;
                        this.computedHashCode = this.computeHashCode(false);
                        this.oldComputedHashCode = this.computeHashCode(true);
                    }
                }
                this.computedSuid = ObjectStreamClass._computeSerialVersionUID(this.ofClass);
                try {
                    this.writeReplaceObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "writeReplace", noTypesList);
                    if (Modifier.isStatic(this.writeReplaceObjectMethod.getModifiers())) {
                        this.writeReplaceObjectMethod = null;
                    } else {
                        ObjectStreamClass.setAccessible(this.writeReplaceObjectMethod);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (this.superclass == null || !this.checkSuperMethodAccess(this.superclass.writeReplaceObjectMethod)) break block47;
                    this.writeReplaceObjectMethod = this.superclass.writeReplaceObjectMethod;
                }
            }
            try {
                this.readResolveObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "readResolve", noTypesList);
                if (Modifier.isStatic(this.readResolveObjectMethod.getModifiers())) {
                    this.readResolveObjectMethod = null;
                } else {
                    ObjectStreamClass.setAccessible(this.readResolveObjectMethod);
                    this.hasReadResolveMethod = true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.superclass == null || !this.checkSuperMethodAccess(this.superclass.readResolveObjectMethod)) break block48;
                this.readResolveObjectMethod = this.superclass.readResolveObjectMethod;
                this.hasReadResolveMethod = true;
            }
        }
        try {
            classArray = new Class[]{ObjectInputStream.class};
            this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(this.ofClass, "readObject", classArray);
            int n = this.readObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                this.readObjectMethod = null;
            } else {
                ObjectStreamClass.setAccessible(this.readObjectMethod);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "init:867", (java.lang.Object)this.name);
        }
    }

    private ObjectStreamField[] getSerialFields() {
        Field[] fieldArray = ObjectStreamClass.getDeclaredFields(this.ofClass, true);
        int n = 0;
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            int n2 = fieldArray[i].getModifiers();
            if (Modifier.isStatic(n2) || Modifier.isTransient(n2)) continue;
            objectStreamFieldArray[n++] = new ObjectStreamField(fieldArray[i]);
        }
        if (n == 0) {
            return noFields;
        }
        java.lang.Object[] objectArray = new ObjectStreamField[n];
        System.arraycopy(objectStreamFieldArray, 0, objectArray, 0, n);
        if (n > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    static boolean compareClassNames(String string, String string2, char c) {
        int n;
        int n2 = string.lastIndexOf(c);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string2.lastIndexOf(c)) < 0) {
            n = 0;
        }
        return string.regionMatches(false, n2, string2, n, string.length() - n2);
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    public final boolean hasReadResolve() {
        return this.hasReadResolveMethod;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    public final boolean isCustomIDL() {
        return this.isCustomMarshaled() || this.superclass != null && this.superclass.isCustomIDL();
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    private boolean isRMIAbstractInterface(byte by) {
        if (!this.ofClass.isInterface()) {
            return false;
        }
        if (Remote.class.isAssignableFrom(this.ofClass)) {
            return false;
        }
        switch (by) {
            case 1: {
                Method[] methodArray = ObjectStreamClass.getDeclaredMethods(this.ofClass);
                if (methodArray.length == 0 || this.arrayHasNonRemoteMethod(methodArray)) {
                    return false;
                }
                return this.superclass == null || this.superclass.isAbstractInterface(by);
            }
            case 2: {
                Method[] methodArray = ObjectStreamClass.getDeclaredMethods(this.ofClass);
                if (this.arrayHasNonRemoteMethod(methodArray)) {
                    return false;
                }
                return this.superclass == null || this.superclass.isAbstractInterface(by);
            }
            case 4: {
                Method[] methodArray = ObjectStreamClass.getMethods(this.ofClass);
                return !this.arrayHasNonRemoteMethod(methodArray);
            }
        }
        throw new INTERNAL("Unable to determine abstractness of " + this.ofClass);
    }

    private boolean arrayHasNonRemoteMethod(Method[] methodArray) {
        if (methodArray != null && methodArray.length > 0) {
            for (int i = methodArray.length - 1; i > -1; --i) {
                boolean bl = false;
                Class<?>[] classArray = methodArray[i].getExceptionTypes();
                for (int j = classArray.length - 1; j > -1; --j) {
                    if (!classArray[j].isAssignableFrom(RemoteException.class)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return true;
            }
        }
        return false;
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            java.lang.Object object;
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n2 = clazz.getModifiers();
            Member[] memberArray = ObjectStreamClass.getDeclaredMethods(clazz);
            if (((n2 &= 0x611) & 0x200) != 0) {
                n2 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n2 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n2);
            Class<?>[] classArray = clazz.getInterfaces();
            Arrays.sort(classArray, compareClassByName);
            for (int i = 0; i < classArray.length; ++i) {
                dataOutputStream.writeUTF(classArray[i].getName());
            }
            Field[] fieldArray = ObjectStreamClass.getDeclaredFields(clazz);
            Arrays.sort(fieldArray, compareMemberByName);
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                n = field.getModifiers();
                if (Modifier.isPrivate(n) && (Modifier.isTransient(n) || Modifier.isStatic(n))) continue;
                dataOutputStream.writeUTF(field.getName());
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(ObjectStreamClass.getSignature(field.getType()));
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            MethodSignature[] methodSignatureArray = MethodSignature.removePrivateAndSort(ObjectStreamClass.getDeclaredConstructors(clazz));
            for (n = 0; n < methodSignatureArray.length; ++n) {
                MethodSignature methodSignature = methodSignatureArray[n];
                object = methodSignature.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(methodSignature.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                methodSignature.clearMember();
            }
            MethodSignature[] methodSignatureArray2 = MethodSignature.removePrivateAndSort(memberArray);
            for (int i = 0; i < methodSignatureArray2.length; ++i) {
                object = methodSignatureArray2[i];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ((MethodSignature)object).clearMember();
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "_computeSerialVersionUID:1192", (Exception)noSuchAlgorithmException);
            SecurityException securityException = new SecurityException(clazz.getName() + ":" + noSuchAlgorithmException.toString());
            securityException.initCause(noSuchAlgorithmException);
            throw securityException;
        }
        return l;
    }

    private long computeHashCode(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            java.lang.Object[] objectArray;
            java.lang.Object[] objectArray2;
            if (!Serializable.class.isAssignableFrom(this.ofClass) || this.ofClass.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(this.ofClass)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz = this.ofClass.getSuperclass();
            if (!(clazz == null || bl && clazz == java.lang.Object.class)) {
                dataOutputStream.writeLong(ObjectStreamClass.lookup(clazz).computeHashCode(bl));
            }
            if (this.hasWriteObject() && !bl) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            if (bl) {
                objectArray2 = this.getLocalFields();
                objectArray = new Field[objectArray2.length];
                for (n = 0; n < objectArray2.length; ++n) {
                    objectArray[n] = objectArray2[n].getField();
                }
                Arrays.sort(objectArray, compareMemberByName);
                for (n = 0; n < objectArray.length; ++n) {
                    java.lang.Object object = objectArray[n];
                    int n2 = ((Field)object).getModifiers();
                    if (Modifier.isTransient(n2) || Modifier.isStatic(n2)) continue;
                    dataOutputStream.writeUTF(((Field)object).getName());
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(((Field)object).getType()));
                }
            } else {
                objectArray2 = this.getFields();
                objectArray = new PersistentField[objectArray2.length];
                for (n = 0; n < objectArray2.length; ++n) {
                    objectArray[n] = new PersistentField(objectArray2[n].getName(), objectArray2[n].getSignature());
                }
                Arrays.sort(objectArray);
                for (n = 0; n < objectArray.length; ++n) {
                    dataOutputStream.writeUTF(((PersistentField)objectArray[n]).getName());
                    dataOutputStream.writeUTF(((PersistentField)objectArray[n]).getSignature());
                }
            }
            dataOutputStream.flush();
            objectArray2 = messageDigest.digest();
            if (bl) {
                int n3;
                for (n = n3 = Math.min(8, objectArray2.length); n > 0; --n) {
                    l += (long)(objectArray2[n] & 0xFF) << n * 8;
                }
            } else {
                for (int i = 0; i < Math.min(8, objectArray2.length); ++i) {
                    l += (long)(objectArray2[i] & 0xFF) << i * 8;
                }
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "computeHashCode:1329", (Exception)noSuchAlgorithmException);
            SecurityException securityException = new SecurityException(this.name + ":" + noSuchAlgorithmException.toString());
            securityException.initCause(noSuchAlgorithmException);
            throw securityException;
        }
        return l;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[");
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[i]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[i]));
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n = clazz.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n2]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n = objectStreamClass.ofClass.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n2];
        ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry;
    }

    private static Field getDeclaredField(final Class clazz, final String string) throws NoSuchFieldException {
        try {
            return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchFieldException {
                    return clazz.getDeclaredField(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)exception;
            }
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getDeclaredField:1492", exception);
            throw (RuntimeException)exception;
        }
    }

    private static Field[] getDeclaredFields(Class clazz) {
        return ObjectStreamClass.getDeclaredFields(clazz, false);
    }

    private static Field[] getDeclaredFields(final Class clazz, final boolean bl) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
                if (bl) {
                    AccessibleObject.setAccessible(accessibleObjectArray, true);
                }
                return accessibleObjectArray;
            }
        });
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray) throws NoSuchMethodException {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz.getDeclaredMethod(string, classArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)exception;
            }
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getDeclaredMethod:1538", exception);
            throw (RuntimeException)exception;
        }
    }

    private static Method[] getDeclaredMethods(final Class clazz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    private static Method[] getMethods(final Class clazz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return clazz.getMethods();
            }
        });
    }

    private static Constructor[] getDeclaredConstructors(final Class clazz) {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return clazz.getDeclaredConstructors();
            }
        });
    }

    private static void setAccessible(final AccessibleObject accessibleObject) throws SecurityException {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    accessibleObject.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static boolean hasStaticInitializer(Class clazz) {
        try {
            return (Boolean)methodHasStaticInitializer.invoke(null, clazz);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "hasStaticInitializer:1667", exception);
            RuntimeException runtimeException = new RuntimeException(clazz.getName());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    private boolean checkSuperMethodAccess(Method method) {
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return ObjectStreamClass.isSameClassPackage(method.getDeclaringClass(), this.ofClass);
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        if (clazz.getClassLoader() != clazz2.getClassLoader()) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        int n2 = string2.lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            return n == n2;
        }
        return string.regionMatches(false, 0, string2, 0, n - 1);
    }

    static {
        try {
            methodHasStaticInitializer = ObjectStreamClass.getDeclaredMethod(java.io.ObjectStreamClass.class, "hasStaticInitializer", new Class[]{Class.class});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "<clinit>:183", (Exception)noSuchMethodException);
            RuntimeException runtimeException = new RuntimeException("java.io.ObjectStreamClass.hasStaticInitializer");
            runtimeException.initCause(noSuchMethodException);
            throw runtimeException;
        }
        ObjectStreamClass.setAccessible(methodHasStaticInitializer);
        descriptorFor = new ObjectStreamClassEntry[61];
        descTable = Collections.synchronizedMap(new WeakHashMap());
        compareClassByName = new CompareClassByName();
        compareMemberByName = new CompareMemberByName();
    }

    private static class PersistentField
    implements Comparable {
        String name;
        String signature;

        public PersistentField(String string, String string2) {
            int n;
            this.name = string;
            this.signature = string2;
            for (n = 0; n < string2.length() && string2.charAt(n) == '['; ++n) {
            }
            if (string2.charAt(n) == 'L' && !string2.endsWith(";")) {
                this.signature = string2 + ";";
            }
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return this.signature;
        }

        public int compareTo(java.lang.Object object) {
            return this.name.compareTo(((PersistentField)object).getName());
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            for (int i = 0; i < memberArray.length; ++i) {
                if (Modifier.isPrivate(memberArray[i].getModifiers())) continue;
                ++n;
            }
            MethodSignature[] methodSignatureArray = new MethodSignature[n];
            int n2 = 0;
            for (int i = 0; i < memberArray.length; ++i) {
                if (Modifier.isPrivate(memberArray[i].getModifiers())) continue;
                methodSignatureArray[n2] = new MethodSignature(memberArray[i]);
                ++n2;
            }
            if (n2 > 0) {
                Arrays.sort(methodSignatureArray, methodSignatureArray[0]);
            }
            return methodSignatureArray;
        }

        public int compare(java.lang.Object object, java.lang.Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }

        void clearMember() {
            this.member = null;
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(java.lang.Object object, java.lang.Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(java.lang.Object object, java.lang.Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public java.lang.Object get() {
            return this.c;
        }
    }
}

