/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.iiop.IOInputStream;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.ibm.org.omg.SendingContext.CodeBase;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.io.ClassDescription;
import com.ibm.rmi.io.InputStreamHook;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.io.ReflectField;
import com.ibm.rmi.io.ValueMemberWrapper;
import com.ibm.rmi.util.Interop;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;

public class IIOPInputStream
extends InputStreamHook
implements IOInputStream {
    private static final String thisClassName = "com.ibm.rmi.io.IIOPInputStream";
    public static boolean usePortableInterface = false;
    private static boolean useFVDOnly = false;
    private final Object[] readObjectArglist = new Object[]{this};
    private InputStream orbStream;
    private byte formatVersion;
    private CDRInputStream orbStream2;
    private ValueInputStream vStream;
    protected Hashtable marshalledObjectTable = null;
    private CodeBase cbSender;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private ObjectStreamClass readResolveClassDesc = null;
    private int currentOffset;
    private FullValueDescription currentFVD = null;
    private PendingReadStack pendingReadStack = new PendingReadStack();
    private ValueMemberWrapper wrapper = new ValueMemberWrapper();
    private static final int ENCLOSE_NONE = 0;
    private static final int ENCLOSE_START = 1;
    private static final int ENCLOSE_END = 2;
    private static final int ENCLOSE_EMPTY = 3;
    private int currentEnclose = 0;
    private Vector callbacks = null;
    private boolean inUse = false;
    private Interop interop = Interop.NO_IBM_ORB;
    private static Hashtable classToCtorCache = new Hashtable();
    private static final Method methodGetSerializableConstructor;
    private static final Method methodGetExternalizableConstructor;

    public static void setTestFVDFlag(boolean bl) {
        useFVDOnly = bl;
    }

    public final void setOrbStream(InputStream inputStream) {
        this.orbStream = inputStream;
        if (inputStream instanceof CDRInputStream) {
            this.orbStream2 = (CDRInputStream)inputStream;
            this.vStream = (ValueInputStream)inputStream;
            this.interop = this.orbStream2.interop;
        } else if (inputStream instanceof ValueInputStream) {
            this.vStream = (ValueInputStream)inputStream;
        }
        if (usePortableInterface) {
            this.orbStream2 = null;
        }
    }

    public final void setSender(CodeBase codeBase) {
        this.cbSender = codeBase;
    }

    private void setFormatVersion(byte by) {
        this.formatVersion = by;
        if (by > 2) {
            throw new MARSHAL("Requested stream format not supported", 1330446343, CompletionStatus.COMPLETED_MAYBE);
        }
        if (by > 1 && this.vStream == null) {
            throw new BAD_PARAM("ORB stream does not support format version", 1330446377, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected HashMap readClassFields() throws IOException, ClassNotFoundException {
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        HashMap hashMap = this.currentFVD != null ? this.readClassFields(this.currentFVD.members) : this.readClassFields(this.currentClassDesc.getFieldsNoCopy());
        this.currentEnclose = n;
        return hashMap;
    }

    public final Object readObjectDelegate() throws IOException, ClassNotFoundException {
        this.startEnclosure();
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        Object object = null;
        try {
            if (this.orbStream2 == null) {
                try {
                    object = this.orbStream.read_abstract_interface();
                }
                catch (IndirectionException indirectionException) {
                    Integer n2 = new Integer(indirectionException.offset);
                    object = this.marshalledObjectTable.get(n2);
                }
            } else {
                object = this.orbStream2.fast_read_abstract_interface();
                if (object == CDRInputStream.PENDING_READ) {
                    boolean bl = this.orbStream2.getPrevIsChunked();
                    int n3 = this.currentOffset = this.orbStream2.getValueIndirection();
                    if (!this.pendingReadStack.isEmpty()) {
                        this.pendingReadStack.addRecursionBreak();
                    }
                    object = this.simpleReadObjectLoop(object);
                    object = this.doPostReadProcessing(object, bl, n3);
                }
            }
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                this.currentEnclose = n;
                OptionalDataException optionalDataException = IIOPInputStream.getOptionalDataException(true);
                optionalDataException.initCause(mARSHAL);
                throw optionalDataException;
            }
            throw mARSHAL;
        }
        this.currentEnclose = n;
        return object;
    }

    private Object simpleReadObjectInternal(Class clazz, String string) throws ClassNotFoundException, IOException {
        if (clazz == null) {
            if (RepositoryId.cache.getId(string).isSequence()) {
                return this.readArray(clazz);
            }
            return this.inputObjectFVD(null, string, null);
        }
        if (clazz.isArray()) {
            return this.readArray(clazz);
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass.isExternalizable()) {
            return this.readExternalizable(objectStreamClass, clazz);
        }
        return this.readSerializable(objectStreamClass, string);
    }

    public final Object simpleReadObject(Class clazz, String string, int n) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "simpleReadObject:336", (Object)clazz);
        }
        this.currentOffset = n;
        boolean bl = false;
        if (!this.inUse) {
            bl = true;
            this.inUse = true;
        }
        Object object = null;
        try {
            if (!this.pendingReadStack.isEmpty()) {
                this.pendingReadStack.addRecursionBreak();
            }
            object = this.simpleReadObjectInternal(clazz, string);
            object = this.simpleReadObjectLoop(object);
            if (this.readResolveClassDesc != null) {
                object = this.readResolveClassDesc.readResolve(object);
            }
            if (bl) {
                this.doValidation();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "simpleReadObject:368", (Exception)classNotFoundException);
            throw new MARSHAL(classNotFoundException.getMessage(), 1229125808, CompletionStatus.COMPLETED_NO);
        }
        catch (IOException iOException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "simpleReadObject:376", (Exception)iOException);
            throw new MARSHAL(iOException.getMessage(), 1229125809, CompletionStatus.COMPLETED_NO);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "simpleReadObject:386", object == null ? null : object.getClass());
        }
        return object;
    }

    private Object simpleReadObjectLoop(Object object) throws ClassNotFoundException, IOException {
        while (true) {
            Object object2;
            if (object == CDRInputStream.PENDING_READ) {
                object2 = this.orbStream2.getRepositoryIDString();
                Class clazz = this.orbStream2.getValueClass();
                object = this.simpleReadObjectInternal(clazz, (String)object2);
                continue;
            }
            object2 = this.pendingReadStack.getNextPendingRead();
            if (object2 == null || ((PendingRead)object2).isRecursionBreak()) {
                return object;
            }
            object = this.continueSimpleReadObject(object, (PendingRead)object2);
        }
    }

    private final Object continueSimpleReadObject(Object object, PendingRead pendingRead) throws IOException, ClassNotFoundException {
        Object object2 = pendingRead.obj;
        ObjectStreamClass objectStreamClass = pendingRead.classDesc;
        FullValueDescription fullValueDescription = pendingRead.fvd;
        if (pendingRead.isSubclass()) {
            if (fullValueDescription == null) {
                return this.inputObjectUsingClassDesc(object2, objectStreamClass);
            }
            return this.inputObjectUsingFVD(object2, fullValueDescription, objectStreamClass);
        }
        if (pendingRead.isBeginFields()) {
            if (fullValueDescription == null) {
                return this.inputClassFields(object2, objectStreamClass, 0);
            }
            return this.inputClassFields(object2, objectStreamClass, fullValueDescription, 0);
        }
        object = this.doPostReadProcessing(object, pendingRead.isChunked, pendingRead.offset);
        int n = pendingRead.index;
        if (pendingRead.isResumeFields()) {
            ObjectStreamField objectStreamField = objectStreamClass.getFieldsNoCopy()[n];
            this.inputObjectField(object2, object, objectStreamField);
            if (fullValueDescription == null) {
                return this.inputClassFields(object2, objectStreamClass, ++n);
            }
            n = pendingRead.fvdIndex;
            return this.inputClassFields(object2, objectStreamClass, fullValueDescription, ++n);
        }
        if (pendingRead.isResumeArray()) {
            Object[] objectArray = (Object[])object2;
            if (objectArray != null) {
                objectArray[n] = object;
                return this.inputArray(objectArray, objectStreamClass, ++n);
            }
            return this.inputArray(objectArray, objectStreamClass, --n);
        }
        throw new MARSHAL("Unknown PendingRead type", 1229125826, CompletionStatus.COMPLETED_NO);
    }

    private void doValidation() throws InvalidObjectException {
        ObjectValidation objectValidation2 = null;
        if (this.callbacks != null && this.callbacks.size() > 0) {
            Comparator comparator = (Comparator)this.callbacks.firstElement();
            Collections.sort(this.callbacks, comparator);
            for (ObjectValidation objectValidation2 : this.callbacks) {
                try {
                    objectValidation2.obj.validateObject();
                }
                catch (InvalidObjectException invalidObjectException) {
                    throw invalidObjectException;
                }
                catch (Throwable throwable) {
                    InvalidObjectException invalidObjectException = new InvalidObjectException(throwable.toString());
                    invalidObjectException.initCause(throwable);
                    throw invalidObjectException;
                }
            }
        }
    }

    protected final Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return this.readObjectDelegate();
    }

    public final void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        if (this.orbStream2 == null) {
            if (this.currentFVD == null) {
                this.inputClassFields(this.currentObject, this.currentClassDesc, 0);
            } else {
                this.inputClassFields(this.currentObject, this.currentClassDesc, this.currentFVD, 0);
            }
        } else {
            if (!this.pendingReadStack.isEmpty()) {
                this.pendingReadStack.addRecursionBreak();
            }
            if (this.currentFVD == null) {
                this.pendingReadStack.addBeginFields(this.currentObject, this.currentClassDesc, null);
            } else {
                this.pendingReadStack.addBeginFields(this.currentObject, this.currentClassDesc, this.currentFVD);
            }
            this.simpleReadObjectLoop(this.currentObject);
        }
        this.currentEnclose = n;
    }

    public final int available() throws IOException {
        return 0;
    }

    public final void close() throws IOException {
    }

    public final int read() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_octet() << 0 & 0xFF;
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                return -1;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "read:594", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.read_octet_array(byArray, n, n2);
            return n2;
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                return -1;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "read:615", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final boolean readBoolean() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_boolean();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readBoolean:638", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final byte readByte() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_octet();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readByte:660", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final char readChar() throws IOException {
        try {
            this.startEnclosure();
            if (this.interop.omg4591.inUse()) {
                return (char)(this.orbStream.read_octet() << 8 | this.orbStream.read_octet() & 0xFF);
            }
            return this.orbStream.read_wchar();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readChar:689", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final double readDouble() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_double();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readDouble:711", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final float readFloat() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_float();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readFloat:733", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.read_octet_array(byArray, n, n2);
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readFully:763", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final int readInt() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_long();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readInt:785", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final String readLine() throws IOException {
        throw new IOException("Method readLine not supported");
    }

    public final long readLong() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_longlong();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readLong:812", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final short readShort() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_short();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readShort:834", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    protected final void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    public final int readUnsignedByte() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_octet() << 0 & 0xFF;
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readUnsignedByte:862", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final int readUnsignedShort() throws IOException {
        try {
            this.startEnclosure();
            return this.orbStream.read_ushort() << 0 & 0xFFFF;
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readUnsignedShort:884", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final String readUTF() throws IOException {
        try {
            short s;
            short s2;
            this.startEnclosure();
            if (this.orbStream instanceof PartnerVersion && PartnerVersionUtil.sendJavaCharAsIDLChar(s2 = ((PartnerVersion)this.orbStream).getPartnerMajor(), s = ((PartnerVersion)this.orbStream).getPartnerMinor())) {
                return this.orbStream.read_string();
            }
            return this.orbStream.read_wstring();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readUTF:913", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("registerValidation");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("object is null");
        }
        if (this.callbacks == null) {
            this.callbacks = new Vector();
        }
        ObjectValidation objectValidation = new ObjectValidation(objectInputValidation, n);
        this.callbacks.add(objectValidation);
    }

    protected final Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        throw new IOException("Method resolveClass not supported");
    }

    protected final Object resolveObject(Object object) throws IOException {
        throw new IOException("Method resolveObject not supported");
    }

    public final int skipBytes(int n) throws IOException {
        try {
            this.startEnclosure();
            byte[] byArray = new byte[n];
            this.orbStream.read_octet_array(byArray, 0, n);
            return n;
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                EOFException eOFException = new EOFException();
                eOFException.initCause(mARSHAL);
                throw eOFException;
            }
            throw mARSHAL;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "skipBytes:963", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    private Object readExternalizable(ObjectStreamClass objectStreamClass, Class clazz) throws IOException, ClassNotFoundException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "readExternalizable:980", (Object)clazz);
        }
        Object object = null;
        try {
            object = IIOPInputStream.allocateNewExternalizableObject(clazz);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readExternalizable:989", noSuchMethodError.toString(), (Object)noSuchMethodError);
            throw new InvalidClassException(clazz.getName(), "NoSuchMethodError accessing no-arg constructor");
        }
        this.addToCache(object);
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        this.readByte();
        Externalizable externalizable = (Externalizable)object;
        externalizable.readExternal(this);
        this.currentEnclose = n;
        this.readResolveClassDesc = objectStreamClass;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "readExternalizable:1013", object == null ? null : object.getClass());
        }
        return object;
    }

    private Object readSerializable(ObjectStreamClass objectStreamClass, String string) throws IOException, ClassNotFoundException {
        Object object = null;
        Class clazz = objectStreamClass.forClass();
        try {
            object = IIOPInputStream.allocateNewSerializableObject(clazz);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "readSerializable:1036", noSuchMethodError.toString(), (Object)noSuchMethodError);
            throw new InvalidClassException(clazz.getName(), "NoSuchMethodError accessing no-arg constructor");
        }
        this.addToCache(object);
        String string2 = RepositoryId.createForAnyType(clazz);
        boolean bl = string2.equals(string);
        if (this.useFullValueDescription(clazz, bl, string)) {
            return this.inputObjectFVD(object, string, objectStreamClass);
        }
        return this.inputObjectClassDesc(object, objectStreamClass);
    }

    private Object readArray(Class clazz) throws InvalidClassException {
        int n = this.orbStream.read_ulong();
        if (clazz == null) {
            return this.inputArray(null, null, n);
        }
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            Object object = this.readPrimArray(clazz2, n);
            this.addToCache(object);
            this.readResolveClassDesc = null;
            return object;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz2, n);
        this.addToCache(objectArray);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz2);
        return this.inputArray(objectArray, objectStreamClass, 0);
    }

    private Object inputArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) throws InvalidClassException {
        if (objectArray == null) {
            return this.skipArray(n);
        }
        if (objectStreamClass.isValueType(this.orbStream2)) {
            return this.readValueArray(objectArray, objectStreamClass, n);
        }
        if (objectStreamClass.isAny()) {
            return this.readObjectArray(objectArray, objectStreamClass, n);
        }
        if (objectStreamClass.isRemoteInterface()) {
            return this.readRemoteInterfaceArray(objectArray, objectStreamClass, n);
        }
        if (objectStreamClass.isAbstractInterface(this.orbStream2)) {
            return this.readAbstractInterfaceArray(objectArray, objectStreamClass, n);
        }
        throw new MARSHAL("Unknown array type " + objectStreamClass.forClass().getName(), 1229125771, CompletionStatus.COMPLETED_NO);
    }

    private void addToCache(Object object) {
        if (this.orbStream2 == null) {
            if (this.marshalledObjectTable == null) {
                this.marshalledObjectTable = new Hashtable();
            }
            Integer n = new Integer(this.currentOffset);
            this.marshalledObjectTable.put(n, object);
        } else {
            this.orbStream2.addToValueCache(object);
        }
    }

    private Object skipArray(int n) {
        Serializable serializable = null;
        for (int i = n; i > 0; --i) {
            if (this.orbStream2 == null) {
                try {
                    this.orbStream.read_value((Class)null);
                }
                catch (IndirectionException indirectionException) {}
                continue;
            }
            try {
                serializable = this.orbStream2.fast_read_value(null);
                if (serializable != CDRInputStream.PENDING_READ) continue;
                boolean bl = this.orbStream2.getPrevIsChunked();
                this.pendingReadStack.addResumeArray(null, null, i, bl, -1);
                return serializable;
            }
            catch (IndirectionException indirectionException) {
                // empty catch block
            }
        }
        this.readResolveClassDesc = null;
        return null;
    }

    private Object readValueArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) throws InvalidClassException {
        Class clazz = objectStreamClass.forClass();
        Object object = null;
        for (int i = n; i < objectArray.length; ++i) {
            object = this.readValueType(clazz);
            if (object == CDRInputStream.PENDING_READ) {
                boolean bl = this.orbStream2.getPrevIsChunked();
                this.currentOffset = this.orbStream2.getValueIndirection();
                this.pendingReadStack.addResumeArray(objectArray, objectStreamClass, i, bl, this.currentOffset);
                return object;
            }
            objectArray[i] = object;
        }
        this.readResolveClassDesc = null;
        return objectArray;
    }

    private Object readObjectArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        Object object = null;
        for (int i = n; i < objectArray.length; ++i) {
            object = this.readAny();
            if (object == CDRInputStream.PENDING_READ) {
                boolean bl = this.orbStream2.getPrevIsChunked();
                this.currentOffset = this.orbStream2.getValueIndirection();
                this.pendingReadStack.addResumeArray(objectArray, objectStreamClass, i, bl, this.currentOffset);
                return object;
            }
            objectArray[i] = object;
        }
        this.readResolveClassDesc = null;
        return objectArray;
    }

    private Object readAbstractInterfaceArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        Class clazz = objectStreamClass.forClass();
        for (int i = n; i < objectArray.length; ++i) {
            Object object = this.readAbstractInterface(clazz);
            if (object == CDRInputStream.PENDING_READ) {
                boolean bl = this.orbStream2.getPrevIsChunked();
                this.currentOffset = this.orbStream2.getValueIndirection();
                this.pendingReadStack.addResumeArray(objectArray, objectStreamClass, i, bl, this.currentOffset);
                return object;
            }
            objectArray[i] = object;
        }
        this.readResolveClassDesc = null;
        return objectArray;
    }

    private Object readRemoteInterfaceArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        Class clazz = objectStreamClass.forClass();
        Class clazz2 = this.getStubClass(clazz);
        for (int i = n; i < objectArray.length; ++i) {
            Object object;
            objectArray[i] = object = this.readRemoteInterface(clazz, clazz2);
        }
        this.readResolveClassDesc = null;
        return objectArray;
    }

    private Object readPrimArray(Class clazz, int n) {
        if (clazz == Integer.TYPE) {
            int[] nArray = new int[n];
            this.orbStream.read_long_array(nArray, 0, n);
            return nArray;
        }
        if (clazz == Byte.TYPE) {
            byte[] byArray = new byte[n];
            this.orbStream.read_octet_array(byArray, 0, n);
            return byArray;
        }
        if (clazz == Boolean.TYPE) {
            boolean[] blArray = new boolean[n];
            this.orbStream.read_boolean_array(blArray, 0, n);
            return blArray;
        }
        if (clazz == Long.TYPE) {
            long[] lArray = new long[n];
            this.orbStream.read_longlong_array(lArray, 0, n);
            return lArray;
        }
        if (clazz == Float.TYPE) {
            float[] fArray = new float[n];
            this.orbStream.read_float_array(fArray, 0, n);
            return fArray;
        }
        if (clazz == Double.TYPE) {
            double[] dArray = new double[n];
            this.orbStream.read_double_array(dArray, 0, n);
            return dArray;
        }
        if (clazz == Short.TYPE) {
            short[] sArray = new short[n];
            this.orbStream.read_short_array(sArray, 0, n);
            return sArray;
        }
        if (clazz != Character.TYPE) {
            throw new Error("Invalid primitive type: " + clazz.getName());
        }
        boolean bl = false;
        if (this.orbStream instanceof PartnerVersion) {
            short s = ((PartnerVersion)this.orbStream).getPartnerMajor();
            short s2 = ((PartnerVersion)this.orbStream).getPartnerMinor();
            bl = PartnerVersionUtil.useOldChar(s, s2);
        }
        char[] cArray = new char[n];
        if (bl) {
            this.orbStream.read_char_array(cArray, 0, n);
        } else {
            this.orbStream.read_wchar_array(cArray, 0, n);
        }
        return cArray;
    }

    private boolean useFullValueDescription(Class clazz, boolean bl, String string) throws IOException {
        if (useFVDOnly) {
            return true;
        }
        boolean bl2 = false;
        if (this.orbStream2 != null) {
            bl2 = this.orbStream2.getOldSUID();
        }
        if (bl && !bl2) {
            return false;
        }
        return RepositoryId.useFullValueDescription(clazz, string, bl2);
    }

    private Object inputObjectClassDesc(Object object, ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass2 = objectStreamClass;
        for (objectStreamClass = objectStreamClass.getSuperclass(); objectStreamClass != null && objectStreamClass.isSerializable(); objectStreamClass = objectStreamClass.getSuperclass()) {
            this.pendingReadStack.addSubclass(object, objectStreamClass2, null);
            objectStreamClass2 = objectStreamClass;
        }
        return this.inputObjectUsingClassDesc(object, objectStreamClass2);
    }

    private Object inputObjectUsingClassDesc(Object object, ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        boolean bl = true;
        this.currentEnclose = 0;
        if (objectStreamClass.hasWriteObject()) {
            this.setFormatVersion(this.readByte());
            bl = this.readBoolean();
            if (this.formatVersion >= 2) {
                this.currentEnclose = 1;
            }
        }
        this.currentFVD = null;
        this.currentObject = object;
        this.currentClassDesc = objectStreamClass;
        if (this.invokeObjectReader(objectStreamClass, object, objectStreamClass.hasWriteObject())) {
            this.readResolveClassDesc = objectStreamClass;
        } else if (this.orbStream2 != null && !PartnerVersionUtil.consumeDefaultFields(this.orbStream2.getPartnerMajor(), this.orbStream2.getPartnerMinor()) && !bl) {
            this.readResolveClassDesc = objectStreamClass;
        } else if (this.currentEnclose != 0) {
            int n = this.currentEnclose;
            if (!this.pendingReadStack.isEmpty()) {
                this.pendingReadStack.addRecursionBreak();
            }
            this.pendingReadStack.addBeginFields(object, objectStreamClass, null);
            this.simpleReadObjectLoop(object);
            this.currentEnclose = n;
        } else {
            object = this.inputClassFields(object, objectStreamClass, 0);
        }
        if (this.currentEnclose != 0) {
            this.endEnclosure();
        }
        return object;
    }

    private Object inputObjectFVD(Object object, String string, ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (this.cbSender == null) {
            if (this.orbStream2 != null) {
                this.cbSender = this.orbStream2.getFVDCodeBase();
            }
            if (this.cbSender == null) {
                IOException iOException = new IOException("No sending context");
                ORBRas.orbTrcLogger.trace(4104L, (Object)this, "inputObjectFVD:1424", iOException.toString() + " " + string + " " + objectStreamClass.getName(), (Object)iOException);
                throw iOException;
            }
        }
        FullValueDescription fullValueDescription = this.cbSender.meta(string);
        FullValueDescription fullValueDescription2 = null;
        ObjectStreamClass objectStreamClass2 = null;
        if (objectStreamClass == null && !fullValueDescription.is_truncatable) {
            String string2 = "The sender's class " + string + " is not present on the " + "local classpath, and the class is not marked as " + "truncatable, so it cannot be unmarshaled.";
            throw new NO_IMPLEMENT(string2, 1330446337, CompletionStatus.COMPLETED_NO);
        }
        while (true) {
            Object object2;
            fullValueDescription2 = fullValueDescription;
            RepositoryId repositoryId = RepositoryId.cache.getId(fullValueDescription.id);
            for (objectStreamClass2 = objectStreamClass; objectStreamClass2 != null; objectStreamClass2 = objectStreamClass2.getSuperclass()) {
                if (!objectStreamClass2.isSerializable()) {
                    objectStreamClass2 = null;
                    break;
                }
                object2 = objectStreamClass2.forClass();
                if (!((Class)object2).getName().equals(repositoryId.getClassName())) continue;
                objectStreamClass = objectStreamClass2;
                break;
            }
            if (objectStreamClass2 == null && fullValueDescription.is_custom) {
                object2 = "The sender's class " + string + " is not present on the local classpath, and the class " + "is marked as custom marshalled, so it cannot be " + "unmarshaled.";
                throw new NO_IMPLEMENT((String)object2, 1330446337, CompletionStatus.COMPLETED_NO);
            }
            if (fullValueDescription.base_value == null || fullValueDescription.base_value.length() == 0 || (fullValueDescription = this.cbSender.meta(fullValueDescription.base_value)) == null) break;
            this.pendingReadStack.addSubclass(object, objectStreamClass2, fullValueDescription2);
        }
        return this.inputObjectUsingFVD(object, fullValueDescription2, objectStreamClass2);
    }

    private Object inputObjectUsingFVD(Object object, FullValueDescription fullValueDescription, ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (objectStreamClass == null) {
            this.skipFields(fullValueDescription.members);
            return object;
        }
        boolean bl = true;
        this.currentEnclose = 0;
        if (fullValueDescription.is_custom) {
            this.setFormatVersion(this.readByte());
            bl = this.readBoolean();
            if (this.formatVersion >= 2) {
                this.currentEnclose = 1;
            }
        }
        this.currentFVD = fullValueDescription;
        this.currentObject = object;
        this.currentClassDesc = objectStreamClass;
        if (this.invokeObjectReader(objectStreamClass, object, fullValueDescription.is_custom)) {
            this.readResolveClassDesc = objectStreamClass;
        } else {
            if (this.currentEnclose != 0) {
                int n = this.currentEnclose;
                if (!this.pendingReadStack.isEmpty()) {
                    this.pendingReadStack.addRecursionBreak();
                }
                this.pendingReadStack.addBeginFields(object, objectStreamClass, fullValueDescription);
                this.simpleReadObjectLoop(object);
                this.currentEnclose = n;
            } else {
                object = this.inputClassFields(object, objectStreamClass, fullValueDescription, 0);
            }
            if (fullValueDescription.is_custom && ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "inputObjectUsingFVD:1548", "Local class for " + RepositoryId.cache.getId(fullValueDescription.id) + " not custom marshal capable whereas remote class is.");
            }
        }
        if (this.currentEnclose != 0) {
            this.endEnclosure();
        }
        return object;
    }

    private boolean invokeObjectReader(ObjectStreamClass objectStreamClass, Object object, boolean bl) throws ClassNotFoundException, IOException {
        if (objectStreamClass.readObjectMethod == null) {
            return false;
        }
        try {
            short s;
            short s2;
            if (!bl) {
                this.currentEnclose = 3;
            }
            if (objectStreamClass.getName().equals("java.util.Calendar") && this.orbStream != null && PartnerVersionUtil.needAnOldCalendar(s2 = ((PartnerVersion)this.orbStream).getPartnerMajor(), s = ((PartnerVersion)this.orbStream).getPartnerMinor())) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "invokeObjectReader:1601", "WARNING: IBM partner version major=" + s2 + " and minor=" + s + ": Only default fields of java.util.Calendar were read");
                }
                this.defaultReadObject();
                return true;
            }
            objectStreamClass.readObjectMethod.invoke(object, this.readObjectArglist);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectReader:1616", (Exception)invocationTargetException);
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("internal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectReader:1631", (Exception)illegalAccessException);
            return false;
        }
    }

    protected void clearStream() {
        if (this.marshalledObjectTable != null) {
            this.marshalledObjectTable.clear();
        }
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
        this.pendingReadStack.reset();
        this.wrapper.reset();
        this.cbSender = null;
        this.orbStream = null;
        this.orbStream2 = null;
        this.currentObject = null;
        this.currentClassDesc = null;
        this.readResolveClassDesc = null;
        this.currentFVD = null;
        this.inUse = false;
        this.currentEnclose = 0;
    }

    private Object readPrimGetField(ObjectStreamField objectStreamField) throws IOException {
        switch (objectStreamField.getTypeCode()) {
            case 'I': {
                int n = this.orbStream.read_long();
                return new Integer(n);
            }
            case 'Z': {
                boolean bl = this.orbStream.read_boolean();
                return new Boolean(bl);
            }
            case 'B': {
                byte by = this.orbStream.read_octet();
                return new Byte(by);
            }
            case 'F': {
                float f = this.orbStream.read_float();
                return new Float(f);
            }
            case 'J': {
                long l = this.orbStream.read_longlong();
                return new Long(l);
            }
            case 'S': {
                short s = this.orbStream.read_short();
                return new Short(s);
            }
            case 'C': {
                char c = this.orbStream.read_wchar();
                return new Character(c);
            }
            case 'D': {
                double d = this.orbStream.read_double();
                return new Double(d);
            }
        }
        throw new InvalidClassException(objectStreamField.getObjectStreamClass().getName());
    }

    private HashMap readClassFields(ObjectStreamField[] objectStreamFieldArray) throws IOException, ClassNotFoundException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = null;
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            if (objectStreamField.isPrimitive()) {
                object = this.readPrimGetField(objectStreamField);
            } else {
                ObjectStreamClass objectStreamClass = objectStreamField.getObjectStreamClass();
                object = this.readObjectField(objectStreamClass);
                if (object == CDRInputStream.PENDING_READ) {
                    boolean bl = this.orbStream2.getPrevIsChunked();
                    int n = this.currentOffset = this.orbStream2.getValueIndirection();
                    if (!this.pendingReadStack.isEmpty()) {
                        this.pendingReadStack.addRecursionBreak();
                    }
                    object = this.simpleReadObjectLoop(object);
                    object = this.doPostReadProcessing(object, bl, n);
                }
            }
            hashMap.put(objectStreamField.getName(), object);
        }
        return hashMap;
    }

    private HashMap readClassFields(ValueMember[] valueMemberArray) throws IOException, ClassNotFoundException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = null;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        for (int i = 0; i < valueMemberArray.length; ++i) {
            ValueMember valueMember = valueMemberArray[i];
            ObjectStreamField objectStreamField = objectStreamClass.getField(valueMember);
            if (objectStreamField == null) {
                this.skipField(valueMember);
                continue;
            }
            if (objectStreamField.isPrimitive()) {
                object = this.readPrimGetField(objectStreamField);
            } else {
                this.wrapper.setValueMember(valueMember);
                object = this.readObjectField(this.wrapper);
                if (object == CDRInputStream.PENDING_READ) {
                    boolean bl = this.orbStream2.getPrevIsChunked();
                    int n = this.currentOffset = this.orbStream2.getValueIndirection();
                    if (!this.pendingReadStack.isEmpty()) {
                        this.pendingReadStack.addRecursionBreak();
                    }
                    object = this.simpleReadObjectLoop(object);
                    object = this.doPostReadProcessing(object, bl, n);
                }
            }
            hashMap.put(objectStreamField.getName(), object);
        }
        return hashMap;
    }

    private Object inputClassFields(Object object, ObjectStreamClass objectStreamClass, int n) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
        for (int i = n; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            if (objectStreamField.isPrimitive()) {
                this.inputPrimitiveField(object, objectStreamField);
                continue;
            }
            ObjectStreamClass objectStreamClass2 = objectStreamField.getObjectStreamClass();
            Object object2 = this.readObjectField(objectStreamClass2);
            if (object2 == CDRInputStream.PENDING_READ) {
                boolean bl = this.orbStream2.getPrevIsChunked();
                this.currentOffset = this.orbStream2.getValueIndirection();
                this.pendingReadStack.addResumeFields(object, objectStreamClass, i, bl, this.currentOffset);
                return object2;
            }
            this.inputObjectField(object, object2, objectStreamField);
        }
        this.readResolveClassDesc = objectStreamClass;
        return object;
    }

    private void inputObjectField(Object object, Object object2, ObjectStreamField objectStreamField) throws InvalidClassException {
        ReflectField reflectField = objectStreamField.getReflectField();
        if (object == null || reflectField == null || object2 == null) {
            return;
        }
        try {
            reflectField.set(object, object2);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "inputObjectField:1847", exception);
            InvalidClassException invalidClassException = new InvalidClassException(object2.getClass().getName(), "Assigning instance to field " + objectStreamField.getField().getName() + " of type " + objectStreamField.getType().getName());
            invalidClassException.initCause(exception);
            throw invalidClassException;
        }
    }

    private Object inputClassFields(Object object, ObjectStreamClass objectStreamClass, FullValueDescription fullValueDescription, int n) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        ValueMember[] valueMemberArray = fullValueDescription.members;
        ObjectStreamField objectStreamField = null;
        for (int i = n; i < valueMemberArray.length; ++i) {
            ValueMember valueMember = valueMemberArray[i];
            objectStreamField = objectStreamClass.getField(valueMember);
            if (objectStreamField == null) {
                this.skipField(valueMember);
                continue;
            }
            if (objectStreamField.isPrimitive()) {
                this.inputPrimitiveField(object, objectStreamField);
                continue;
            }
            this.wrapper.setValueMember(valueMember);
            Object object2 = this.readObjectField(this.wrapper);
            if (object2 == CDRInputStream.PENDING_READ) {
                boolean bl = this.orbStream2.getPrevIsChunked();
                int n2 = this.getFieldOffset(objectStreamClass, objectStreamField);
                this.currentOffset = this.orbStream2.getValueIndirection();
                this.pendingReadStack.addResumeFields(object, objectStreamClass, n2, fullValueDescription, i, bl, this.currentOffset);
                return object2;
            }
            this.inputObjectField(object, object2, objectStreamField);
        }
        this.readResolveClassDesc = objectStreamClass;
        return object;
    }

    private int getFieldOffset(ObjectStreamClass objectStreamClass, ObjectStreamField objectStreamField) {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            if (objectStreamFieldArray[i] != objectStreamField) continue;
            return i;
        }
        return -1;
    }

    private Object doPostReadProcessing(Object object, boolean bl, int n) {
        this.orbStream2.post_fast_read_value(bl);
        if (this.readResolveClassDesc != null) {
            Object object2 = object;
            if ((object = this.readResolveClassDesc.readResolve(object)) != object2) {
                this.orbStream2.addToValueCache(n, object);
            }
        }
        return object;
    }

    private void skipFields(ValueMember[] valueMemberArray) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        for (int i = 0; i < valueMemberArray.length; ++i) {
            ValueMember valueMember = valueMemberArray[i];
            this.skipField(valueMember);
        }
    }

    private void skipField(ValueMember valueMember) throws IOException, ClassNotFoundException {
        this.wrapper.setValueMember(valueMember);
        if (this.wrapper.isPrimitive()) {
            this.skipPrimField(valueMember);
        } else {
            Object object = this.readObjectField(this.wrapper);
            if (object == CDRInputStream.PENDING_READ) {
                boolean bl = this.orbStream2.getPrevIsChunked();
                int n = this.currentOffset = this.orbStream2.getValueIndirection();
                if (!this.pendingReadStack.isEmpty()) {
                    this.pendingReadStack.addRecursionBreak();
                }
                object = this.simpleReadObjectLoop(object);
                object = this.doPostReadProcessing(object, bl, n);
            }
        }
    }

    private void skipPrimField(ValueMember valueMember) {
        int n = valueMember.type.kind().value();
        switch (n) {
            case 10: {
                this.orbStream.read_octet();
                break;
            }
            case 8: {
                this.orbStream.read_boolean();
                break;
            }
            case 9: 
            case 26: {
                this.orbStream.read_wchar();
                break;
            }
            case 2: {
                this.orbStream.read_short();
                break;
            }
            case 3: {
                this.orbStream.read_long();
                break;
            }
            case 23: {
                this.orbStream.read_longlong();
                break;
            }
            case 6: {
                this.orbStream.read_float();
                break;
            }
            case 7: {
                this.orbStream.read_double();
            }
        }
    }

    private void inputPrimitiveField(Object object, ObjectStreamField objectStreamField) throws InvalidClassException {
        ReflectField reflectField = objectStreamField.getReflectField();
        if (reflectField == null) {
            return;
        }
        try {
            switch (objectStreamField.getTypeCode()) {
                case 'I': {
                    int n = this.orbStream.read_long();
                    reflectField.setInt(object, n);
                    break;
                }
                case 'Z': {
                    boolean bl = this.orbStream.read_boolean();
                    reflectField.setBoolean(object, bl);
                    break;
                }
                case 'B': {
                    byte by = this.orbStream.read_octet();
                    reflectField.setByte(object, by);
                    break;
                }
                case 'J': {
                    long l = this.orbStream.read_longlong();
                    reflectField.setLong(object, l);
                    break;
                }
                case 'F': {
                    float f = this.orbStream.read_float();
                    reflectField.setFloat(object, f);
                    break;
                }
                case 'S': {
                    short s = this.orbStream.read_short();
                    reflectField.setShort(object, s);
                    break;
                }
                case 'C': {
                    char c = this.orbStream.read_wchar();
                    reflectField.setChar(object, c);
                    break;
                }
                case 'D': {
                    double d = this.orbStream.read_double();
                    reflectField.setDouble(object, d);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("field is not a primitive");
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "inputPrimitiveField:2075", (Exception)illegalAccessException);
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "IllegalAccessException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "inputPrimitiveField:2084", (Exception)illegalArgumentException);
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "Assigning instance of class " + objectStreamField.getType().getName() + " to field " + objectStreamField.getField().getName());
        }
    }

    private Object readObjectField(ClassDescription classDescription) {
        Class clazz = classDescription.getType();
        if (classDescription.isValueType(this.orbStream2)) {
            return this.readValueType(clazz);
        }
        if (classDescription.isRemoteInterface()) {
            Class clazz2 = this.getStubClass(clazz);
            return this.readRemoteInterface(clazz, clazz2);
        }
        if (classDescription.isAbstractInterface(this.orbStream2)) {
            return this.readAbstractInterface(clazz);
        }
        if (classDescription.isAny()) {
            return this.readAny();
        }
        throw new MARSHAL("Unknown field type " + clazz.getName(), 1229125815, CompletionStatus.COMPLETED_NO);
    }

    private Object readValueType(Class clazz) {
        if (this.orbStream2 == null) {
            try {
                return this.orbStream.read_value(clazz);
            }
            catch (IndirectionException indirectionException) {
                Integer n = new Integer(indirectionException.offset);
                return this.marshalledObjectTable.get(n);
            }
        }
        return this.orbStream2.fast_read_value(clazz);
    }

    private Object readAny() {
        if (this.orbStream2 == null) {
            try {
                return Util.readAny((org.omg.CORBA.portable.InputStream)this.orbStream);
            }
            catch (IndirectionException indirectionException) {
                Integer n = new Integer(indirectionException.offset);
                return this.marshalledObjectTable.get(n);
            }
        }
        return this.orbStream2.fast_readAnyOpt();
    }

    private Object readAbstractInterface(Class clazz) {
        Object object = null;
        if (this.orbStream2 == null) {
            try {
                object = Utility.readAbstractAndNarrow(this.orbStream, clazz);
            }
            catch (IndirectionException indirectionException) {
                Integer n = new Integer(indirectionException.offset);
                object = this.marshalledObjectTable.get(n);
            }
        } else {
            object = this.orbStream2.fast_read_abstract_interface();
            if (object != null && object != CDRInputStream.PENDING_READ) {
                object = PortableRemoteObject.narrow((Object)object, (Class)clazz);
            }
        }
        return object;
    }

    private Object readRemoteInterface(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return Utility.readObjectAndNarrow((org.omg.CORBA.portable.InputStream)this.orbStream, clazz);
        }
        return this.orbStream.read_Object(clazz2);
    }

    private Class getStubClass(Class clazz) {
        try {
            String string = Util.getCodebase((Class)clazz);
            String string2 = RepositoryId.createForAnyType(clazz);
            ClassLoader classLoader = null;
            if (this.orbStream instanceof CDRInputStream) {
                classLoader = ((CDRInputStream)this.orbStream).getClassLoader();
            }
            return Utility.loadStubClass(string2, string, clazz, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "getStubClass:2196", classNotFoundException.toString());
            }
            return null;
        }
    }

    private static Object allocateNewSerializableObject(Class clazz) throws InvalidClassException {
        return IIOPInputStream.allocateNewObject(clazz, false);
    }

    private static Object allocateNewExternalizableObject(Class clazz) throws InvalidClassException {
        return IIOPInputStream.allocateNewObject(clazz, true);
    }

    private static Object allocateNewObject(final Class clazz, final boolean bl) throws InvalidClassException {
        Constructor constructor = (Constructor)classToCtorCache.get(clazz);
        if (constructor == null) {
            try {
                constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InstantiationException, InvocationTargetException {
                        if (bl) {
                            return (Constructor)methodGetExternalizableConstructor.invoke(null, clazz);
                        }
                        return (Constructor)methodGetSerializableConstructor.invoke(null, clazz);
                    }
                });
                classToCtorCache.put(clazz, constructor);
            }
            catch (PrivilegedActionException privilegedActionException) {
                ORBRas.orbTrcLogger.trace(4104L, thisClassName, "allocateNewObject:2254", clazz.getName(), (Object)privilegedActionException.getCause());
                InvalidClassException invalidClassException = new InvalidClassException(clazz.getName(), privilegedActionException.getMessage());
                invalidClassException.initCause(privilegedActionException.getCause());
                throw invalidClassException;
            }
        }
        return IIOPInputStream.allocateNewObject(constructor);
    }

    private static boolean ibmJVMTidyUp() {
        classToCtorCache.clear();
        return true;
    }

    private static Object allocateNewObject(Constructor constructor) throws InvalidClassException {
        try {
            return constructor.newInstance(null);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.trace(4104L, thisClassName, "allocateNewObject:2286", constructor.getName(), (Object)exception);
            InvalidClassException invalidClassException = new InvalidClassException(constructor.getName(), exception.getMessage());
            invalidClassException.initCause(exception);
            throw invalidClassException;
        }
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray) throws NoSuchMethodException {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return clazz.getDeclaredMethod(string, classArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NoSuchMethodException)privilegedActionException.getCause();
        }
    }

    private static void setAccessible(final AccessibleObject accessibleObject) {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    accessibleObject.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private void startEnclosure() {
        if (this.currentEnclose == 1) {
            this.vStream.start_value();
            this.currentEnclose = 2;
        } else if (this.currentEnclose == 3) {
            throw new MARSHAL("No custom marshaled data present", 1330446344, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    private void endEnclosure() {
        if (this.currentEnclose == 1) {
            this.startEnclosure();
        }
        if (this.currentEnclose == 2) {
            this.vStream.end_value();
        }
    }

    private static OptionalDataException getOptionalDataException(final boolean bl) {
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Constructor constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
                    constructor.setAccessible(true);
                    return constructor.newInstance(new Boolean(bl));
                }
            });
            return (OptionalDataException)t;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getOptionalDataException:2403", exception);
            return null;
        }
    }

    static {
        Class[] classArray = new Class[]{Class.class};
        try {
            methodGetSerializableConstructor = IIOPInputStream.getDeclaredMethod(java.io.ObjectStreamClass.class, "getSerializableConstructor", classArray);
            IIOPInputStream.setAccessible(methodGetSerializableConstructor);
            methodGetExternalizableConstructor = IIOPInputStream.getDeclaredMethod(java.io.ObjectStreamClass.class, "getExternalizableConstructor", classArray);
            IIOPInputStream.setAccessible(methodGetExternalizableConstructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "<clinit>:2321", (Exception)noSuchMethodException);
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
    }

    private class PendingRead {
        protected static final byte RECURSION_BREAK = 0;
        protected static final byte SUBCLASS = 1;
        protected static final byte BEGIN_FIELDS = 2;
        protected static final byte RESUME_FIELDS = 3;
        protected static final byte RESUME_ARRAY = 4;
        protected byte type;
        protected Object obj;
        protected ObjectStreamClass classDesc;
        protected int index;
        protected FullValueDescription fvd;
        protected short fvdIndex;
        protected boolean isChunked;
        protected int offset;

        private PendingRead() {
        }

        protected boolean isRecursionBreak() {
            return this.type == 0;
        }

        protected boolean isSubclass() {
            return this.type == 1;
        }

        protected boolean isBeginFields() {
            return this.type == 2;
        }

        protected boolean isResumeFields() {
            return this.type == 3;
        }

        protected boolean isResumeArray() {
            return this.type == 4;
        }

        protected void reset() {
            this.obj = null;
            this.classDesc = null;
            this.fvd = null;
        }
    }

    private class PendingReadStack {
        private static final int INIT_SIZE = 8;
        private PendingRead[] pendingReads = new PendingRead[8];
        private int size = 0;
        private int maxDepth = 0;

        private PendingReadStack() {
        }

        protected void reset() {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "reset:2458", "max recursion was " + this.maxDepth);
            }
            for (int i = 0; i < this.maxDepth; ++i) {
                this.pendingReads[i].reset();
            }
            if (this.maxDepth > 8) {
                PendingRead[] pendingReadArray = this.pendingReads;
                this.pendingReads = new PendingRead[8];
                System.arraycopy(pendingReadArray, 0, this.pendingReads, 0, 8);
            }
            this.size = 0;
            this.maxDepth = 0;
        }

        protected boolean isEmpty() {
            return this.size == 0;
        }

        protected void addRecursionBreak() {
            PendingRead pendingRead = this.createPendingRead();
            pendingRead.reset();
            pendingRead.type = 0;
        }

        protected void addSubclass(Object object, ObjectStreamClass objectStreamClass, FullValueDescription fullValueDescription) {
            PendingRead pendingRead = this.createPendingRead();
            pendingRead.type = 1;
            pendingRead.obj = object;
            pendingRead.classDesc = objectStreamClass;
            pendingRead.fvd = fullValueDescription;
        }

        protected void addBeginFields(Object object, ObjectStreamClass objectStreamClass, FullValueDescription fullValueDescription) {
            PendingRead pendingRead = this.createPendingRead();
            pendingRead.type = (byte)2;
            pendingRead.obj = object;
            pendingRead.classDesc = objectStreamClass;
            pendingRead.fvd = fullValueDescription;
        }

        protected void addResumeFields(Object object, ObjectStreamClass objectStreamClass, int n, boolean bl, int n2) {
            PendingRead pendingRead = this.createPendingRead();
            pendingRead.type = (byte)3;
            pendingRead.obj = object;
            pendingRead.classDesc = objectStreamClass;
            pendingRead.index = n;
            pendingRead.fvd = null;
            pendingRead.isChunked = bl;
            pendingRead.offset = n2;
        }

        protected void addResumeFields(Object object, ObjectStreamClass objectStreamClass, int n, FullValueDescription fullValueDescription, int n2, boolean bl, int n3) {
            PendingRead pendingRead = this.createPendingRead();
            pendingRead.type = (byte)3;
            pendingRead.obj = object;
            pendingRead.classDesc = objectStreamClass;
            pendingRead.index = n;
            pendingRead.fvd = fullValueDescription;
            pendingRead.fvdIndex = (short)n2;
            pendingRead.isChunked = bl;
            pendingRead.offset = n3;
        }

        protected void addResumeArray(Object object, ObjectStreamClass objectStreamClass, int n, boolean bl, int n2) {
            PendingRead pendingRead = this.createPendingRead();
            pendingRead.type = (byte)4;
            pendingRead.obj = object;
            pendingRead.classDesc = objectStreamClass;
            pendingRead.index = n;
            pendingRead.fvd = null;
            pendingRead.isChunked = bl;
            pendingRead.offset = n2;
        }

        private PendingRead createPendingRead() {
            PendingRead pendingRead;
            if (this.size == this.pendingReads.length) {
                int n = this.pendingReads.length;
                int n2 = Math.min(n * 2, n + 50);
                PendingRead[] pendingReadArray = this.pendingReads;
                this.pendingReads = new PendingRead[n2];
                System.arraycopy(pendingReadArray, 0, this.pendingReads, 0, n);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "createPendingRead:2578", "grew from " + n + " to " + n2);
                }
            }
            if ((pendingRead = this.pendingReads[this.size]) == null) {
                this.pendingReads[this.size] = pendingRead = new PendingRead();
            }
            ++this.size;
            if (this.size > this.maxDepth) {
                this.maxDepth = this.size;
            }
            return pendingRead;
        }

        protected PendingRead getNextPendingRead() {
            if (this.size == 0) {
                return null;
            }
            return this.pendingReads[--this.size];
        }
    }

    private class ObjectValidation
    implements Comparator {
        int priority;
        ObjectInputValidation obj;

        public ObjectValidation(ObjectInputValidation objectInputValidation, int n) {
            this.obj = objectInputValidation;
            this.priority = n;
        }

        public int compare(Object object, Object object2) {
            ObjectValidation objectValidation = (ObjectValidation)object;
            ObjectValidation objectValidation2 = (ObjectValidation)object2;
            if (objectValidation.priority == objectValidation2.priority) {
                return 0;
            }
            if (objectValidation.priority < objectValidation2.priority) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof ObjectValidation) {
                return this.priority == ((ObjectValidation)object).priority;
            }
            return false;
        }

        public int hashCode() {
            return this.priority;
        }
    }
}

